package nashid.verify.sdk.mrtd2.activity.passportNFC.util

import android.graphics.Bitmap
import android.graphics.BitmapFactory
import org.jnbis.WsqDecoder
import java.io.ByteArrayInputStream
import java.io.DataInputStream
import java.io.IOException
import java.io.InputStream

object ImageUtil {
    private val TAG = ImageUtil::class.java.simpleName

    private var jpegMimeType = "image/jpeg"
    private var jpeg2000MimeType = "image/jp2"
    private var jpeg2000AltMimeType = "image/jpeg2000"
    private var wsqMimeType = "image/x-wsq"

    @Throws(IOException::class)
    fun decodeImage(
        inputStream: InputStream,
        imageLength: Int,
        mimeType: String,
    ): Bitmap {
        var inputStream = inputStream
        // DEBUG
        synchronized(inputStream) {
            val dataIn = DataInputStream(inputStream)
            val bytes = ByteArray(imageLength)
            dataIn.readFully(bytes)
            inputStream = ByteArrayInputStream(bytes)
        }
        // END DEBUG

        if (jpegMimeType.equals(mimeType, ignoreCase = true) || jpeg2000MimeType.equals(mimeType, ignoreCase = true) || jpeg2000AltMimeType.equals(mimeType, ignoreCase = true)) {
            val bitmap = org.jmrtd.jj2000.JJ2000Decoder.decode(inputStream)
            return toAndroidBitmap(bitmap)
        } else if (wsqMimeType.equals(mimeType, ignoreCase = true)) {
            // org.jnbis.Bitmap bitmap = WSQDecoder.decode(inputStream);
            val wsqDecoder = WsqDecoder()
            val bitmap = wsqDecoder.decode(inputStream.readBytes())
            val byteData = bitmap.pixels
            val intData = IntArray(byteData.size)
            for (j in byteData.indices) {
                intData[j] = -0x1000000 or ((byteData[j].toInt() and 0xFF) shl 16) or ((byteData[j].toInt() and 0xFF) shl 8) or (byteData[j].toInt() and 0xFF)
            }
            return Bitmap.createBitmap(intData, 0, bitmap.width, bitmap.width, bitmap.height, Bitmap.Config.ARGB_8888)
            // return toAndroidBitmap(bitmap);
        } else {
            return BitmapFactory.decodeStream(inputStream)
        }
    }

    // ONLY PRIVATE METHODS BELOW

    private fun toAndroidBitmap(bitmap: org.jmrtd.jj2000.Bitmap): Bitmap {
        val intData = bitmap.pixels
        return Bitmap.createBitmap(intData, 0, bitmap.width, bitmap.width, bitmap.height, Bitmap.Config.ARGB_8888)
    }
}
