package nashid.verify.sdk.mrtd2.resultcallback.callbackclass;

import android.graphics.Bitmap;

public class LivenessResultData {

    private String matchedValue;
    private Bitmap capturedPhoto;

    public String getMatchedValue() {
        return matchedValue;
    }

    public void setMatchedValue(String matchedValue) {
        this.matchedValue = matchedValue;
    }

    public Bitmap getCapturedPhoto() {
        return capturedPhoto;
    }

    public void setCapturedPhoto(Bitmap capturedPhoto) {
        this.capturedPhoto = capturedPhoto;
    }
    private static volatile LivenessResultData INSTANCE = null;

    @Override
    public String toString() {
        return "LivenessResultData{" +
                "matchedValue='" + matchedValue + '\'' +
                ", capturedPhoto=" + capturedPhoto +
                '}';
    }

    public static LivenessResultData getInstance() {
        // Check if the instance is already created
        if(INSTANCE == null) {
            // synchronize the block to ensure only one thread can execute at a time
            synchronized (LivenessResultData.class) {
                // check again if the instance is already created
                if (INSTANCE == null) {
                    // create the singleton instance
                    INSTANCE = new LivenessResultData();
                }
            }
        }
        // return the singleton instance
        return INSTANCE;
    }
}
