package nashid.verify.sdk.utility;

//import static com.google.android.gms.vision.L.TAG;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.util.DisplayMetrics;

import nashid.verify.sdk.Constant;

//import com.google.mlkit.vision.common.InputImage;


public class DataUtils {

    public static Bitmap getCropImageBitmap(Activity activity, byte[] inputData) {
        Matrix matrix = new Matrix();
//        matrix.postRotate(90);
        Bitmap bmp = BitmapFactory.decodeByteArray(inputData, 0, inputData.length);

        Bitmap scaledBitmap = Bitmap.createScaledBitmap(bmp, bmp.getWidth(), bmp.getHeight(), true);
        Bitmap rotatedBitmap = Bitmap.createBitmap(scaledBitmap, 0, 0, scaledBitmap.getWidth(), scaledBitmap.getHeight(), matrix, true);

        //Getting the values for cropping
        DisplayMetrics displaymetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displaymetrics);
        int height = rotatedBitmap.getHeight();
        int width = rotatedBitmap.getWidth();
        int left, right, top, bottom, diameter;

        diameter = width;
        if (height < width) {
            diameter = height;
        }

        int offset = (int) (Constant.cropOffset * diameter);
        diameter -= offset;

        left = width - diameter;
        top = height / 2 - diameter / 3;
        right = diameter;
        bottom = height / 2 + diameter / 3;

        int boxHeight = bottom - top;
        int boxWidth = right - left;
        Bitmap bitmap = Bitmap.createBitmap(rotatedBitmap, left, top, boxWidth, boxHeight);
        return bitmap;

    }

}
