package nashid.verify.sdk.utility;

import android.content.Context;

import nashid.verify.sdk.R;

public class SharePreferenceUtility {
    public static void savePreferenceValue(Context context, String key, boolean b) {
        SecureSharedPreferences secureSharedPreferences = new SecureSharedPreferences(context);
        secureSharedPreferences.edit().putBoolean(key, b).apply();
    }

    public static boolean getSavePreferenceData(Context context, String key) {
        boolean decryptedBoolean;
        SecureSharedPreferences secureSharedPreferences = new SecureSharedPreferences(context);
        if (key.equals(context.getString(R.string.sharepreference_verification_step))) {
            decryptedBoolean = secureSharedPreferences.getBoolean(key, false);
        } else {
            decryptedBoolean = secureSharedPreferences.getBoolean(key, true);
        }

        return decryptedBoolean;
    }

    public static void saveLocalPreferenceValue(Context context,  String language) {
        SecureSharedPreferences secureSharedPreferences = new SecureSharedPreferences(context);
        secureSharedPreferences.edit().putString("Locale", language).apply();
    }

    public static String getLocalSavePreferenceData(Context context) {
        SecureSharedPreferences secureSharedPreferences = new SecureSharedPreferences(context);
        String languageCode = secureSharedPreferences.getString("Locale", "en");

        return languageCode;
    }
}
