/*
 * Decompiled with CFR 0.152.
 */
package nashid.futuremind.recyclerviewfastscroll;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;
import nashid.futuremind.recyclerviewfastscroll.FastScroller;

public class RecyclerViewScrollListener
extends RecyclerView.OnScrollListener {
    private final FastScroller scroller;
    List<ScrollerListener> listeners = new ArrayList<ScrollerListener>();
    int oldScrollState = 0;

    public RecyclerViewScrollListener(FastScroller scroller) {
        this.scroller = scroller;
    }

    public void addScrollerListener(ScrollerListener listener) {
        this.listeners.add(listener);
    }

    public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newScrollState) {
        super.onScrollStateChanged(recyclerView, newScrollState);
        if (newScrollState == 0 && this.oldScrollState != 0) {
            this.scroller.getViewProvider().onScrollFinished();
        } else if (newScrollState != 0 && this.oldScrollState == 0) {
            this.scroller.getViewProvider().onScrollStarted();
        }
        this.oldScrollState = newScrollState;
    }

    public void onScrolled(@NonNull RecyclerView rv, int dx, int dy) {
        if (this.scroller.shouldUpdateHandlePosition()) {
            this.updateHandlePosition(rv);
        }
    }

    void updateHandlePosition(RecyclerView rv) {
        float relativePos;
        if (this.scroller.isVertical()) {
            int offset = rv.computeVerticalScrollOffset();
            int extent = rv.computeVerticalScrollExtent();
            int range = rv.computeVerticalScrollRange();
            relativePos = (float)offset / (float)(range - extent);
        } else {
            int offset = rv.computeHorizontalScrollOffset();
            int extent = rv.computeHorizontalScrollExtent();
            int range = rv.computeHorizontalScrollRange();
            relativePos = (float)offset / (float)(range - extent);
        }
        this.scroller.setScrollerPosition(relativePos);
        this.notifyListeners(relativePos);
    }

    public void notifyListeners(float relativePos) {
        for (ScrollerListener listener : this.listeners) {
            listener.onScroll(relativePos);
        }
    }

    public static interface ScrollerListener {
        public void onScroll(float var1);
    }
}

