/*
 * Decompiled with CFR 0.152.
 */
package nashid.hbb20;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import nashid.hbb20.CCPCountryGroup;
import nashid.hbb20.CountryCodePicker;
import nashid.verify.sdk.R;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class CCPCountry
implements Comparable<CCPCountry> {
    static int DEFAULT_FLAG_RES = -99;
    static String TAG = "Class Country";
    static CountryCodePicker.Language loadedLibraryMasterListLanguage;
    static String dialogTitle;
    static String searchHintMessage;
    static String noResultFoundAckMessage;
    static List<CCPCountry> loadedLibraryMaterList;
    private static final String ANTIGUA_AND_BARBUDA_AREA_CODES = "268";
    private static final String ANGUILLA_AREA_CODES = "264";
    private static final String BARBADOS_AREA_CODES = "246";
    private static final String BERMUDA_AREA_CODES = "441";
    private static final String BAHAMAS_AREA_CODES = "242";
    private static final String CANADA_AREA_CODES = "204/226/236/249/250/289/306/343/365/403/416/418/431/437/438/450/506/514/519/579/581/587/600/604/613/639/647/705/709/769/778/780/782/807/819/825/867/873/902/905/";
    private static final String DOMINICA_AREA_CODES = "767";
    private static final String DOMINICAN_REPUBLIC_AREA_CODES = "809/829/849";
    private static final String GRENADA_AREA_CODES = "473";
    private static final String JAMAICA_AREA_CODES = "876";
    private static final String SAINT_KITTS_AND_NEVIS_AREA_CODES = "869";
    private static final String CAYMAN_ISLANDS_AREA_CODES = "345";
    private static final String SAINT_LUCIA_AREA_CODES = "758";
    private static final String MONTSERRAT_AREA_CODES = "664";
    private static final String PUERTO_RICO_AREA_CODES = "787";
    private static final String SINT_MAARTEN_AREA_CODES = "721";
    private static final String TURKS_AND_CAICOS_ISLANDS_AREA_CODES = "649";
    private static final String TRINIDAD_AND_TOBAGO_AREA_CODES = "868";
    private static final String SAINT_VINCENT_AND_THE_GRENADINES_AREA_CODES = "784";
    private static final String BRITISH_VIRGIN_ISLANDS_AREA_CODES = "284";
    private static final String US_VIRGIN_ISLANDS_AREA_CODES = "340";
    private static final String ISLE_OF_MAN = "1624";
    String nameCode;
    String phoneCode;
    String name;
    String englishName;
    int flagResID = DEFAULT_FLAG_RES;

    public CCPCountry() {
    }

    public CCPCountry(String nameCode, String phoneCode, String name, int flagResID) {
        this.nameCode = nameCode.toUpperCase(Locale.US);
        this.phoneCode = phoneCode;
        this.name = name;
        this.flagResID = flagResID;
    }

    static CountryCodePicker.Language getLoadedLibraryMasterListLanguage() {
        return loadedLibraryMasterListLanguage;
    }

    static void setLoadedLibraryMasterListLanguage(CountryCodePicker.Language loadedLibraryMasterListLanguage) {
        CCPCountry.loadedLibraryMasterListLanguage = loadedLibraryMasterListLanguage;
    }

    public static List<CCPCountry> getLoadedLibraryMaterList() {
        return loadedLibraryMaterList;
    }

    static void setLoadedLibraryMaterList(List<CCPCountry> loadedLibraryMaterList) {
        CCPCountry.loadedLibraryMaterList = loadedLibraryMaterList;
    }

    static void loadDataFromXML(Context context, CountryCodePicker.Language language) {
        List<Object> countries = new ArrayList();
        String tempDialogTitle = "";
        String tempSearchHint = "";
        String tempNoResultAck = "";
        try {
            XmlPullParserFactory xmlFactoryObject = XmlPullParserFactory.newInstance();
            XmlPullParser xmlPullParser = xmlFactoryObject.newPullParser();
            InputStream ins = context.getResources().openRawResource(context.getResources().getIdentifier("ccp_" + language.toString().toLowerCase(Locale.ROOT), "raw", context.getPackageName()));
            xmlPullParser.setInput(ins, "UTF-8");
            int event = xmlPullParser.getEventType();
            while (event != 1) {
                String name = xmlPullParser.getName();
                switch (event) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (name.equals("country")) {
                            CCPCountry ccpCountry = new CCPCountry();
                            if (!xmlPullParser.getAttributeValue(null, "name").equals("Oman")) break;
                            ccpCountry.setNameCode(xmlPullParser.getAttributeValue(null, "name_code").toUpperCase(Locale.US));
                            ccpCountry.setPhoneCode(xmlPullParser.getAttributeValue(null, "phone_code"));
                            ccpCountry.setEnglishName(xmlPullParser.getAttributeValue(null, "english_name"));
                            ccpCountry.setName(xmlPullParser.getAttributeValue(null, "name"));
                            countries.add(ccpCountry);
                            break;
                        }
                        if (name.equals("ccp_dialog_title")) {
                            tempDialogTitle = xmlPullParser.getAttributeValue(null, "translation");
                            break;
                        }
                        if (name.equals("ccp_dialog_search_hint_message")) {
                            tempSearchHint = xmlPullParser.getAttributeValue(null, "translation");
                            break;
                        }
                        if (!name.equals("ccp_dialog_no_result_ack_message")) break;
                        tempNoResultAck = xmlPullParser.getAttributeValue(null, "translation");
                    }
                }
                event = xmlPullParser.next();
            }
            loadedLibraryMasterListLanguage = language;
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (countries.size() == 0) {
            loadedLibraryMasterListLanguage = CountryCodePicker.Language.ENGLISH;
            countries = CCPCountry.getLibraryMasterCountriesEnglish();
        }
        dialogTitle = tempDialogTitle.length() > 0 ? tempDialogTitle : "Select a country";
        searchHintMessage = tempSearchHint.length() > 0 ? tempSearchHint : "Search...";
        noResultFoundAckMessage = tempNoResultAck.length() > 0 ? tempNoResultAck : "Results not found";
        loadedLibraryMaterList = countries;
        Collections.sort(loadedLibraryMaterList);
    }

    public static String getDialogTitle(Context context, CountryCodePicker.Language language) {
        if (loadedLibraryMasterListLanguage == null || loadedLibraryMasterListLanguage != language || dialogTitle == null || dialogTitle.length() == 0) {
            CCPCountry.loadDataFromXML(context, language);
        }
        return dialogTitle;
    }

    public static String getSearchHintMessage(Context context, CountryCodePicker.Language language) {
        if (loadedLibraryMasterListLanguage == null || loadedLibraryMasterListLanguage != language || searchHintMessage == null || searchHintMessage.length() == 0) {
            CCPCountry.loadDataFromXML(context, language);
        }
        return searchHintMessage;
    }

    public static String getNoResultFoundAckMessage(Context context, CountryCodePicker.Language language) {
        if (loadedLibraryMasterListLanguage == null || loadedLibraryMasterListLanguage != language || noResultFoundAckMessage == null || noResultFoundAckMessage.length() == 0) {
            CCPCountry.loadDataFromXML(context, language);
        }
        return noResultFoundAckMessage;
    }

    public static void setDialogTitle(String dialogTitle) {
        CCPCountry.dialogTitle = dialogTitle;
    }

    public static void setSearchHintMessage(String searchHintMessage) {
        CCPCountry.searchHintMessage = searchHintMessage;
    }

    public static void setNoResultFoundAckMessage(String noResultFoundAckMessage) {
        CCPCountry.noResultFoundAckMessage = noResultFoundAckMessage;
    }

    public static CCPCountry getCountryForCode(Context context, CountryCodePicker.Language language, List<CCPCountry> preferredCountries, String code) {
        if (preferredCountries != null && !preferredCountries.isEmpty()) {
            for (CCPCountry CCPCountry2 : preferredCountries) {
                if (!CCPCountry2.getPhoneCode().equals(code)) continue;
                return CCPCountry2;
            }
        }
        for (CCPCountry CCPCountry2 : CCPCountry.getLibraryMasterCountryList(context, language)) {
            if (!CCPCountry2.getPhoneCode().equals(code)) continue;
            return CCPCountry2;
        }
        return null;
    }

    static CCPCountry getCountryForCodeFromEnglishList(String code) {
        List<CCPCountry> countries = CCPCountry.getLibraryMasterCountriesEnglish();
        for (CCPCountry ccpCountry : countries) {
            if (!ccpCountry.getPhoneCode().equals(code)) continue;
            return ccpCountry;
        }
        return null;
    }

    static List<CCPCountry> getCustomMasterCountryList(Context context, CountryCodePicker codePicker) {
        codePicker.refreshCustomMasterList();
        if (codePicker.customMasterCountriesList != null && codePicker.customMasterCountriesList.size() > 0) {
            return codePicker.getCustomMasterCountriesList();
        }
        return CCPCountry.getLibraryMasterCountryList(context, codePicker.getLanguageToApply());
    }

    static CCPCountry getCountryForNameCodeFromCustomMasterList(Context context, List<CCPCountry> customMasterCountriesList, CountryCodePicker.Language language, String nameCode) {
        if (customMasterCountriesList == null || customMasterCountriesList.size() == 0) {
            return CCPCountry.getCountryForNameCodeFromLibraryMasterList(context, language, nameCode);
        }
        for (CCPCountry ccpCountry : customMasterCountriesList) {
            if (!ccpCountry.getNameCode().equalsIgnoreCase(nameCode)) continue;
            return ccpCountry;
        }
        return null;
    }

    public static CCPCountry getCountryForNameCodeFromLibraryMasterList(Context context, CountryCodePicker.Language language, String nameCode) {
        List<CCPCountry> countries = CCPCountry.getLibraryMasterCountryList(context, language);
        for (CCPCountry ccpCountry : countries) {
            if (!ccpCountry.getNameCode().equalsIgnoreCase(nameCode)) continue;
            return ccpCountry;
        }
        return null;
    }

    static CCPCountry getCountryForNameCodeFromEnglishList(String nameCode) {
        List<CCPCountry> countries = CCPCountry.getLibraryMasterCountriesEnglish();
        for (CCPCountry CCPCountry2 : countries) {
            if (!CCPCountry2.getNameCode().equalsIgnoreCase(nameCode)) continue;
            return CCPCountry2;
        }
        return null;
    }

    static CCPCountry getCountryForCode(Context context, CountryCodePicker.Language language, List<CCPCountry> preferredCountries, int code) {
        return CCPCountry.getCountryForCode(context, language, preferredCountries, code + "");
    }

    static CCPCountry getCountryForNumber(Context context, CountryCodePicker.Language language, List<CCPCountry> preferredCountries, String fullNumber) {
        if (fullNumber == null) {
            return null;
        }
        if ((fullNumber = fullNumber.trim()).length() != 0) {
            int firstDigit = fullNumber.charAt(0) == '+' ? 1 : 0;
            CCPCountry ccpCountry = null;
            for (int i = firstDigit; i <= fullNumber.length(); ++i) {
                String code = fullNumber.substring(firstDigit, i);
                CCPCountryGroup countryGroup = null;
                try {
                    countryGroup = CCPCountryGroup.getCountryGroupForPhoneCode(Integer.parseInt(code));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (countryGroup != null) {
                    int areaCodeStartsAt = firstDigit + code.length();
                    if (fullNumber.length() >= areaCodeStartsAt + countryGroup.areaCodeLength) {
                        String areaCode = fullNumber.substring(areaCodeStartsAt, areaCodeStartsAt + countryGroup.areaCodeLength);
                        return countryGroup.getCountryForAreaCode(context, language, areaCode);
                    }
                    return CCPCountry.getCountryForNameCodeFromLibraryMasterList(context, language, countryGroup.defaultNameCode);
                }
                ccpCountry = CCPCountry.getCountryForCode(context, language, preferredCountries, code);
                if (ccpCountry == null) continue;
                return ccpCountry;
            }
        }
        return null;
    }

    public static CCPCountry getCountryForNumber(Context context, CountryCodePicker.Language language, String fullNumber) {
        return CCPCountry.getCountryForNumber(context, language, null, fullNumber);
    }

    static int getFlagMasterResID(CCPCountry CCPCountry2) {
        switch (CCPCountry2.getNameCode().toLowerCase()) {
            case "ad": {
                return R.drawable.flag_andorra;
            }
            case "ae": {
                return R.drawable.flag_uae;
            }
            case "af": {
                return R.drawable.flag_afghanistan;
            }
            case "ag": {
                return R.drawable.flag_antigua_and_barbuda;
            }
            case "ai": {
                return R.drawable.flag_anguilla;
            }
            case "al": {
                return R.drawable.flag_albania;
            }
            case "am": {
                return R.drawable.flag_armenia;
            }
            case "ao": {
                return R.drawable.flag_angola;
            }
            case "aq": {
                return R.drawable.flag_antarctica;
            }
            case "ar": {
                return R.drawable.flag_argentina;
            }
            case "as": {
                return R.drawable.flag_american_samoa;
            }
            case "at": {
                return R.drawable.flag_austria;
            }
            case "au": {
                return R.drawable.flag_australia;
            }
            case "aw": {
                return R.drawable.flag_aruba;
            }
            case "ax": {
                return R.drawable.flag_aland;
            }
            case "az": {
                return R.drawable.flag_azerbaijan;
            }
            case "ba": {
                return R.drawable.flag_bosnia;
            }
            case "bb": {
                return R.drawable.flag_barbados;
            }
            case "bd": {
                return R.drawable.flag_bangladesh;
            }
            case "be": {
                return R.drawable.flag_belgium;
            }
            case "bf": {
                return R.drawable.flag_burkina_faso;
            }
            case "bg": {
                return R.drawable.flag_bulgaria;
            }
            case "bh": {
                return R.drawable.flag_bahrain;
            }
            case "bi": {
                return R.drawable.flag_burundi;
            }
            case "bj": {
                return R.drawable.flag_benin;
            }
            case "bl": {
                return R.drawable.flag_saint_barthelemy;
            }
            case "bm": {
                return R.drawable.flag_bermuda;
            }
            case "bn": {
                return R.drawable.flag_brunei;
            }
            case "bo": {
                return R.drawable.flag_bolivia;
            }
            case "br": {
                return R.drawable.flag_brazil;
            }
            case "bs": {
                return R.drawable.flag_bahamas;
            }
            case "bt": {
                return R.drawable.flag_bhutan;
            }
            case "bw": {
                return R.drawable.flag_botswana;
            }
            case "by": {
                return R.drawable.flag_belarus;
            }
            case "bz": {
                return R.drawable.flag_belize;
            }
            case "ca": {
                return R.drawable.flag_canada;
            }
            case "cc": {
                return R.drawable.flag_cocos;
            }
            case "cd": {
                return R.drawable.flag_democratic_republic_of_the_congo;
            }
            case "cf": {
                return R.drawable.flag_central_african_republic;
            }
            case "cg": {
                return R.drawable.flag_republic_of_the_congo;
            }
            case "ch": {
                return R.drawable.flag_switzerland;
            }
            case "ci": {
                return R.drawable.flag_cote_divoire;
            }
            case "ck": {
                return R.drawable.flag_cook_islands;
            }
            case "cl": {
                return R.drawable.flag_chile;
            }
            case "cm": {
                return R.drawable.flag_cameroon;
            }
            case "cn": {
                return R.drawable.flag_china;
            }
            case "co": {
                return R.drawable.flag_colombia;
            }
            case "cr": {
                return R.drawable.flag_costa_rica;
            }
            case "cu": {
                return R.drawable.flag_cuba;
            }
            case "cv": {
                return R.drawable.flag_cape_verde;
            }
            case "cw": {
                return R.drawable.flag_curacao;
            }
            case "cx": {
                return R.drawable.flag_christmas_island;
            }
            case "cy": {
                return R.drawable.flag_cyprus;
            }
            case "cz": {
                return R.drawable.flag_czech_republic;
            }
            case "de": {
                return R.drawable.flag_germany;
            }
            case "dj": {
                return R.drawable.flag_djibouti;
            }
            case "dk": {
                return R.drawable.flag_denmark;
            }
            case "dm": {
                return R.drawable.flag_dominica;
            }
            case "do": {
                return R.drawable.flag_dominican_republic;
            }
            case "dz": {
                return R.drawable.flag_algeria;
            }
            case "ec": {
                return R.drawable.flag_ecuador;
            }
            case "ee": {
                return R.drawable.flag_estonia;
            }
            case "eg": {
                return R.drawable.flag_egypt;
            }
            case "er": {
                return R.drawable.flag_eritrea;
            }
            case "es": {
                return R.drawable.flag_spain;
            }
            case "et": {
                return R.drawable.flag_ethiopia;
            }
            case "fi": {
                return R.drawable.flag_finland;
            }
            case "fj": {
                return R.drawable.flag_fiji;
            }
            case "fk": {
                return R.drawable.flag_falkland_islands;
            }
            case "fm": {
                return R.drawable.flag_micronesia;
            }
            case "fo": {
                return R.drawable.flag_faroe_islands;
            }
            case "fr": {
                return R.drawable.flag_france;
            }
            case "ga": {
                return R.drawable.flag_gabon;
            }
            case "gb": {
                return R.drawable.flag_united_kingdom;
            }
            case "gd": {
                return R.drawable.flag_grenada;
            }
            case "ge": {
                return R.drawable.flag_georgia;
            }
            case "gf": {
                return R.drawable.flag_guyane;
            }
            case "gg": {
                return R.drawable.flag_guernsey;
            }
            case "gh": {
                return R.drawable.flag_ghana;
            }
            case "gi": {
                return R.drawable.flag_gibraltar;
            }
            case "gl": {
                return R.drawable.flag_greenland;
            }
            case "gm": {
                return R.drawable.flag_gambia;
            }
            case "gn": {
                return R.drawable.flag_guinea;
            }
            case "gp": {
                return R.drawable.flag_guadeloupe;
            }
            case "gq": {
                return R.drawable.flag_equatorial_guinea;
            }
            case "gr": {
                return R.drawable.flag_greece;
            }
            case "gt": {
                return R.drawable.flag_guatemala;
            }
            case "gu": {
                return R.drawable.flag_guam;
            }
            case "gw": {
                return R.drawable.flag_guinea_bissau;
            }
            case "gy": {
                return R.drawable.flag_guyana;
            }
            case "hk": {
                return R.drawable.flag_hong_kong;
            }
            case "hn": {
                return R.drawable.flag_honduras;
            }
            case "hr": {
                return R.drawable.flag_croatia;
            }
            case "ht": {
                return R.drawable.flag_haiti;
            }
            case "hu": {
                return R.drawable.flag_hungary;
            }
            case "id": {
                return R.drawable.flag_indonesia;
            }
            case "ie": {
                return R.drawable.flag_ireland;
            }
            case "il": {
                return R.drawable.flag_israel;
            }
            case "im": {
                return R.drawable.flag_isleof_man;
            }
            case "is": {
                return R.drawable.flag_iceland;
            }
            case "in": {
                return R.drawable.flag_india;
            }
            case "io": {
                return R.drawable.flag_british_indian_ocean_territory;
            }
            case "iq": {
                return R.drawable.flag_iraq_new;
            }
            case "ir": {
                return R.drawable.flag_iran;
            }
            case "it": {
                return R.drawable.flag_italy;
            }
            case "je": {
                return R.drawable.flag_jersey;
            }
            case "jm": {
                return R.drawable.flag_jamaica;
            }
            case "jo": {
                return R.drawable.flag_jordan;
            }
            case "jp": {
                return R.drawable.flag_japan;
            }
            case "ke": {
                return R.drawable.flag_kenya;
            }
            case "kg": {
                return R.drawable.flag_kyrgyzstan;
            }
            case "kh": {
                return R.drawable.flag_cambodia;
            }
            case "ki": {
                return R.drawable.flag_kiribati;
            }
            case "km": {
                return R.drawable.flag_comoros;
            }
            case "kn": {
                return R.drawable.flag_saint_kitts_and_nevis;
            }
            case "kp": {
                return R.drawable.flag_north_korea;
            }
            case "kr": {
                return R.drawable.flag_south_korea;
            }
            case "kw": {
                return R.drawable.flag_kuwait;
            }
            case "ky": {
                return R.drawable.flag_cayman_islands;
            }
            case "kz": {
                return R.drawable.flag_kazakhstan;
            }
            case "la": {
                return R.drawable.flag_laos;
            }
            case "lb": {
                return R.drawable.flag_lebanon;
            }
            case "lc": {
                return R.drawable.flag_saint_lucia;
            }
            case "li": {
                return R.drawable.flag_liechtenstein;
            }
            case "lk": {
                return R.drawable.flag_sri_lanka;
            }
            case "lr": {
                return R.drawable.flag_liberia;
            }
            case "ls": {
                return R.drawable.flag_lesotho;
            }
            case "lt": {
                return R.drawable.flag_lithuania;
            }
            case "lu": {
                return R.drawable.flag_luxembourg;
            }
            case "lv": {
                return R.drawable.flag_latvia;
            }
            case "ly": {
                return R.drawable.flag_libya;
            }
            case "ma": {
                return R.drawable.flag_morocco;
            }
            case "mc": {
                return R.drawable.flag_monaco;
            }
            case "md": {
                return R.drawable.flag_moldova;
            }
            case "me": {
                return R.drawable.flag_of_montenegro;
            }
            case "mf": {
                return R.drawable.flag_saint_martin;
            }
            case "mg": {
                return R.drawable.flag_madagascar;
            }
            case "mh": {
                return R.drawable.flag_marshall_islands;
            }
            case "mk": {
                return R.drawable.flag_macedonia;
            }
            case "ml": {
                return R.drawable.flag_mali;
            }
            case "mm": {
                return R.drawable.flag_myanmar;
            }
            case "mn": {
                return R.drawable.flag_mongolia;
            }
            case "mo": {
                return R.drawable.flag_macao;
            }
            case "mp": {
                return R.drawable.flag_northern_mariana_islands;
            }
            case "mq": {
                return R.drawable.flag_martinique;
            }
            case "mr": {
                return R.drawable.flag_mauritania;
            }
            case "ms": {
                return R.drawable.flag_montserrat;
            }
            case "mt": {
                return R.drawable.flag_malta;
            }
            case "mu": {
                return R.drawable.flag_mauritius;
            }
            case "mv": {
                return R.drawable.flag_maldives;
            }
            case "mw": {
                return R.drawable.flag_malawi;
            }
            case "mx": {
                return R.drawable.flag_mexico;
            }
            case "my": {
                return R.drawable.flag_malaysia;
            }
            case "mz": {
                return R.drawable.flag_mozambique;
            }
            case "na": {
                return R.drawable.flag_namibia;
            }
            case "nc": {
                return R.drawable.flag_new_caledonia;
            }
            case "ne": {
                return R.drawable.flag_niger;
            }
            case "nf": {
                return R.drawable.flag_norfolk_island;
            }
            case "ng": {
                return R.drawable.flag_nigeria;
            }
            case "ni": {
                return R.drawable.flag_nicaragua;
            }
            case "nl": {
                return R.drawable.flag_netherlands;
            }
            case "no": {
                return R.drawable.flag_norway;
            }
            case "np": {
                return R.drawable.flag_nepal;
            }
            case "nr": {
                return R.drawable.flag_nauru;
            }
            case "nu": {
                return R.drawable.flag_niue;
            }
            case "nz": {
                return R.drawable.flag_new_zealand;
            }
            case "om": {
                return R.drawable.flag_oman;
            }
            case "pa": {
                return R.drawable.flag_panama;
            }
            case "pe": {
                return R.drawable.flag_peru;
            }
            case "pf": {
                return R.drawable.flag_french_polynesia;
            }
            case "pg": {
                return R.drawable.flag_papua_new_guinea;
            }
            case "ph": {
                return R.drawable.flag_philippines;
            }
            case "pk": {
                return R.drawable.flag_pakistan;
            }
            case "pl": {
                return R.drawable.flag_poland;
            }
            case "pm": {
                return R.drawable.flag_saint_pierre;
            }
            case "pn": {
                return R.drawable.flag_pitcairn_islands;
            }
            case "pr": {
                return R.drawable.flag_puerto_rico;
            }
            case "ps": {
                return R.drawable.flag_palestine;
            }
            case "pt": {
                return R.drawable.flag_portugal;
            }
            case "pw": {
                return R.drawable.flag_palau;
            }
            case "py": {
                return R.drawable.flag_paraguay;
            }
            case "qa": {
                return R.drawable.flag_qatar;
            }
            case "re": {
                return R.drawable.flag_martinique;
            }
            case "ro": {
                return R.drawable.flag_romania;
            }
            case "rs": {
                return R.drawable.flag_serbia;
            }
            case "ru": {
                return R.drawable.flag_russian_federation;
            }
            case "rw": {
                return R.drawable.flag_rwanda;
            }
            case "sa": {
                return R.drawable.flag_saudi_arabia;
            }
            case "sb": {
                return R.drawable.flag_soloman_islands;
            }
            case "sc": {
                return R.drawable.flag_seychelles;
            }
            case "sd": {
                return R.drawable.flag_sudan;
            }
            case "se": {
                return R.drawable.flag_sweden;
            }
            case "sg": {
                return R.drawable.flag_singapore;
            }
            case "sh": {
                return R.drawable.flag_saint_helena;
            }
            case "si": {
                return R.drawable.flag_slovenia;
            }
            case "sk": {
                return R.drawable.flag_slovakia;
            }
            case "sl": {
                return R.drawable.flag_sierra_leone;
            }
            case "sm": {
                return R.drawable.flag_san_marino;
            }
            case "sn": {
                return R.drawable.flag_senegal;
            }
            case "so": {
                return R.drawable.flag_somalia;
            }
            case "sr": {
                return R.drawable.flag_suriname;
            }
            case "ss": {
                return R.drawable.flag_south_sudan;
            }
            case "st": {
                return R.drawable.flag_sao_tome_and_principe;
            }
            case "sv": {
                return R.drawable.flag_el_salvador;
            }
            case "sx": {
                return R.drawable.flag_sint_maarten;
            }
            case "sy": {
                return R.drawable.flag_syria;
            }
            case "sz": {
                return R.drawable.flag_swaziland;
            }
            case "tc": {
                return R.drawable.flag_turks_and_caicos_islands;
            }
            case "td": {
                return R.drawable.flag_chad;
            }
            case "tg": {
                return R.drawable.flag_togo;
            }
            case "th": {
                return R.drawable.flag_thailand;
            }
            case "tj": {
                return R.drawable.flag_tajikistan;
            }
            case "tk": {
                return R.drawable.flag_tokelau;
            }
            case "tl": {
                return R.drawable.flag_timor_leste;
            }
            case "tm": {
                return R.drawable.flag_turkmenistan;
            }
            case "tn": {
                return R.drawable.flag_tunisia;
            }
            case "to": {
                return R.drawable.flag_tonga;
            }
            case "tr": {
                return R.drawable.flag_turkey;
            }
            case "tt": {
                return R.drawable.flag_trinidad_and_tobago;
            }
            case "tv": {
                return R.drawable.flag_tuvalu;
            }
            case "tw": {
                return R.drawable.flag_taiwan;
            }
            case "tz": {
                return R.drawable.flag_tanzania;
            }
            case "ua": {
                return R.drawable.flag_ukraine;
            }
            case "ug": {
                return R.drawable.flag_uganda;
            }
            case "us": {
                return R.drawable.flag_united_states_of_america;
            }
            case "uy": {
                return R.drawable.flag_uruguay;
            }
            case "uz": {
                return R.drawable.flag_uzbekistan;
            }
            case "va": {
                return R.drawable.flag_vatican_city;
            }
            case "vc": {
                return R.drawable.flag_saint_vicent_and_the_grenadines;
            }
            case "ve": {
                return R.drawable.flag_venezuela;
            }
            case "vg": {
                return R.drawable.flag_british_virgin_islands;
            }
            case "vi": {
                return R.drawable.flag_us_virgin_islands;
            }
            case "vn": {
                return R.drawable.flag_vietnam;
            }
            case "vu": {
                return R.drawable.flag_vanuatu;
            }
            case "wf": {
                return R.drawable.flag_wallis_and_futuna;
            }
            case "ws": {
                return R.drawable.flag_samoa;
            }
            case "xk": {
                return R.drawable.flag_kosovo;
            }
            case "ye": {
                return R.drawable.flag_yemen;
            }
            case "yt": {
                return R.drawable.flag_martinique;
            }
            case "za": {
                return R.drawable.flag_south_africa;
            }
            case "zm": {
                return R.drawable.flag_zambia;
            }
            case "zw": {
                return R.drawable.flag_zimbabwe;
            }
        }
        return R.drawable.flag_transparent;
    }

    static String getFlagEmoji(CCPCountry CCPCountry2) {
        switch (CCPCountry2.getNameCode().toLowerCase()) {
            case "ad": {
                return "\ud83c\udde6\ud83c\udde9";
            }
            case "ae": {
                return "\ud83c\udde6\ud83c\uddea";
            }
            case "af": {
                return "\ud83c\udde6\ud83c\uddeb";
            }
            case "ag": {
                return "\ud83c\udde6\ud83c\uddec";
            }
            case "ai": {
                return "\ud83c\udde6\ud83c\uddee";
            }
            case "al": {
                return "\ud83c\udde6\ud83c\uddf1";
            }
            case "am": {
                return "\ud83c\udde6\ud83c\uddf2";
            }
            case "ao": {
                return "\ud83c\udde6\ud83c\uddf4";
            }
            case "aq": {
                return "\ud83c\udde6\ud83c\uddf6";
            }
            case "ar": {
                return "\ud83c\udde6\ud83c\uddf7";
            }
            case "as": {
                return "\ud83c\udde6\ud83c\uddf8";
            }
            case "at": {
                return "\ud83c\udde6\ud83c\uddf9";
            }
            case "au": {
                return "\ud83c\udde6\ud83c\uddfa";
            }
            case "aw": {
                return "\ud83c\udde6\ud83c\uddfc";
            }
            case "ax": {
                return "\ud83c\udde6\ud83c\uddfd";
            }
            case "az": {
                return "\ud83c\udde6\ud83c\uddff";
            }
            case "ba": {
                return "\ud83c\udde7\ud83c\udde6";
            }
            case "bb": {
                return "\ud83c\udde7\ud83c\udde7";
            }
            case "bd": {
                return "\ud83c\udde7\ud83c\udde9";
            }
            case "be": {
                return "\ud83c\udde7\ud83c\uddea";
            }
            case "bf": {
                return "\ud83c\udde7\ud83c\uddeb";
            }
            case "bg": {
                return "\ud83c\udde7\ud83c\uddec";
            }
            case "bh": {
                return "\ud83c\udde7\ud83c\udded";
            }
            case "bi": {
                return "\ud83c\udde7\ud83c\uddee";
            }
            case "bj": {
                return "\ud83c\udde7\ud83c\uddef";
            }
            case "bl": {
                return "\ud83c\udde7\ud83c\uddf1";
            }
            case "bm": {
                return "\ud83c\udde7\ud83c\uddf2";
            }
            case "bn": {
                return "\ud83c\udde7\ud83c\uddf3";
            }
            case "bo": {
                return "\ud83c\udde7\ud83c\uddf4";
            }
            case "bq": {
                return "\ud83c\udde7\ud83c\uddf6";
            }
            case "br": {
                return "\ud83c\udde7\ud83c\uddf7";
            }
            case "bs": {
                return "\ud83c\udde7\ud83c\uddf8";
            }
            case "bt": {
                return "\ud83c\udde7\ud83c\uddf9";
            }
            case "bv": {
                return "\ud83c\udde7\ud83c\uddfb";
            }
            case "bw": {
                return "\ud83c\udde7\ud83c\uddfc";
            }
            case "by": {
                return "\ud83c\udde7\ud83c\uddfe";
            }
            case "bz": {
                return "\ud83c\udde7\ud83c\uddff";
            }
            case "ca": {
                return "\ud83c\udde8\ud83c\udde6";
            }
            case "cc": {
                return "\ud83c\udde8\ud83c\udde8";
            }
            case "cd": {
                return "\ud83c\udde8\ud83c\udde9";
            }
            case "cf": {
                return "\ud83c\udde8\ud83c\uddeb";
            }
            case "cg": {
                return "\ud83c\udde8\ud83c\uddec";
            }
            case "ch": {
                return "\ud83c\udde8\ud83c\udded";
            }
            case "ci": {
                return "\ud83c\udde8\ud83c\uddee";
            }
            case "ck": {
                return "\ud83c\udde8\ud83c\uddf0";
            }
            case "cl": {
                return "\ud83c\udde8\ud83c\uddf1";
            }
            case "cm": {
                return "\ud83c\udde8\ud83c\uddf2";
            }
            case "cn": {
                return "\ud83c\udde8\ud83c\uddf3";
            }
            case "co": {
                return "\ud83c\udde8\ud83c\uddf4";
            }
            case "cr": {
                return "\ud83c\udde8\ud83c\uddf7";
            }
            case "cu": {
                return "\ud83c\udde8\ud83c\uddfa";
            }
            case "cv": {
                return "\ud83c\udde8\ud83c\uddfb";
            }
            case "cw": {
                return "\ud83c\udde8\ud83c\uddfc";
            }
            case "cx": {
                return "\ud83c\udde8\ud83c\uddfd";
            }
            case "cy": {
                return "\ud83c\udde8\ud83c\uddfe";
            }
            case "cz": {
                return "\ud83c\udde8\ud83c\uddff";
            }
            case "de": {
                return "\ud83c\udde9\ud83c\uddea";
            }
            case "dj": {
                return "\ud83c\udde9\ud83c\uddef";
            }
            case "dk": {
                return "\ud83c\udde9\ud83c\uddf0";
            }
            case "dm": {
                return "\ud83c\udde9\ud83c\uddf2";
            }
            case "do": {
                return "\ud83c\udde9\ud83c\uddf4";
            }
            case "dz": {
                return "\ud83c\udde9\ud83c\uddff";
            }
            case "ec": {
                return "\ud83c\uddea\ud83c\udde8";
            }
            case "ee": {
                return "\ud83c\uddea\ud83c\uddea";
            }
            case "eg": {
                return "\ud83c\uddea\ud83c\uddec";
            }
            case "eh": {
                return "\ud83c\uddea\ud83c\udded";
            }
            case "er": {
                return "\ud83c\uddea\ud83c\uddf7";
            }
            case "es": {
                return "\ud83c\uddea\ud83c\uddf8";
            }
            case "et": {
                return "\ud83c\uddea\ud83c\uddf9";
            }
            case "fi": {
                return "\ud83c\uddeb\ud83c\uddee";
            }
            case "fj": {
                return "\ud83c\uddeb\ud83c\uddef";
            }
            case "fk": {
                return "\ud83c\uddeb\ud83c\uddf0";
            }
            case "fm": {
                return "\ud83c\uddeb\ud83c\uddf2";
            }
            case "fo": {
                return "\ud83c\uddeb\ud83c\uddf4";
            }
            case "fr": {
                return "\ud83c\uddeb\ud83c\uddf7";
            }
            case "ga": {
                return "\ud83c\uddec\ud83c\udde6";
            }
            case "gb": {
                return "\ud83c\uddec\ud83c\udde7";
            }
            case "gd": {
                return "\ud83c\uddec\ud83c\udde9";
            }
            case "ge": {
                return "\ud83c\uddec\ud83c\uddea";
            }
            case "gf": {
                return "\ud83c\uddec\ud83c\uddeb";
            }
            case "gg": {
                return "\ud83c\uddec\ud83c\uddec";
            }
            case "gh": {
                return "\ud83c\uddec\ud83c\udded";
            }
            case "gi": {
                return "\ud83c\uddec\ud83c\uddee";
            }
            case "gl": {
                return "\ud83c\uddec\ud83c\uddf1";
            }
            case "gm": {
                return "\ud83c\uddec\ud83c\uddf2";
            }
            case "gn": {
                return "\ud83c\uddec\ud83c\uddf3";
            }
            case "gp": {
                return "\ud83c\uddec\ud83c\uddf5";
            }
            case "gq": {
                return "\ud83c\uddec\ud83c\uddf6";
            }
            case "gr": {
                return "\ud83c\uddec\ud83c\uddf7";
            }
            case "gs": {
                return "\ud83c\uddec\ud83c\uddf8";
            }
            case "gt": {
                return "\ud83c\uddec\ud83c\uddf9";
            }
            case "gu": {
                return "\ud83c\uddec\ud83c\uddfa";
            }
            case "gw": {
                return "\ud83c\uddec\ud83c\uddfc";
            }
            case "gy": {
                return "\ud83c\uddec\ud83c\uddfe";
            }
            case "hk": {
                return "\ud83c\udded\ud83c\uddf0";
            }
            case "hm": {
                return "\ud83c\udded\ud83c\uddf2";
            }
            case "hn": {
                return "\ud83c\udded\ud83c\uddf3";
            }
            case "hr": {
                return "\ud83c\udded\ud83c\uddf7";
            }
            case "ht": {
                return "\ud83c\udded\ud83c\uddf9";
            }
            case "hu": {
                return "\ud83c\udded\ud83c\uddfa";
            }
            case "id": {
                return "\ud83c\uddee\ud83c\udde9";
            }
            case "ie": {
                return "\ud83c\uddee\ud83c\uddea";
            }
            case "il": {
                return "\ud83c\uddee\ud83c\uddf1";
            }
            case "im": {
                return "\ud83c\uddee\ud83c\uddf2";
            }
            case "in": {
                return "\ud83c\uddee\ud83c\uddf3";
            }
            case "io": {
                return "\ud83c\uddee\ud83c\uddf4";
            }
            case "iq": {
                return "\ud83c\uddee\ud83c\uddf6";
            }
            case "ir": {
                return "\ud83c\uddee\ud83c\uddf7";
            }
            case "is": {
                return "\ud83c\uddee\ud83c\uddf8";
            }
            case "it": {
                return "\ud83c\uddee\ud83c\uddf9";
            }
            case "je": {
                return "\ud83c\uddef\ud83c\uddea";
            }
            case "jm": {
                return "\ud83c\uddef\ud83c\uddf2";
            }
            case "jo": {
                return "\ud83c\uddef\ud83c\uddf4";
            }
            case "jp": {
                return "\ud83c\uddef\ud83c\uddf5";
            }
            case "ke": {
                return "\ud83c\uddf0\ud83c\uddea";
            }
            case "kg": {
                return "\ud83c\uddf0\ud83c\uddec";
            }
            case "kh": {
                return "\ud83c\uddf0\ud83c\udded";
            }
            case "ki": {
                return "\ud83c\uddf0\ud83c\uddee";
            }
            case "km": {
                return "\ud83c\uddf0\ud83c\uddf2";
            }
            case "kn": {
                return "\ud83c\uddf0\ud83c\uddf3";
            }
            case "kp": {
                return "\ud83c\uddf0\ud83c\uddf5";
            }
            case "kr": {
                return "\ud83c\uddf0\ud83c\uddf7";
            }
            case "kw": {
                return "\ud83c\uddf0\ud83c\uddfc";
            }
            case "ky": {
                return "\ud83c\uddf0\ud83c\uddfe";
            }
            case "kz": {
                return "\ud83c\uddf0\ud83c\uddff";
            }
            case "la": {
                return "\ud83c\uddf1\ud83c\udde6";
            }
            case "lb": {
                return "\ud83c\uddf1\ud83c\udde7";
            }
            case "lc": {
                return "\ud83c\uddf1\ud83c\udde8";
            }
            case "li": {
                return "\ud83c\uddf1\ud83c\uddee";
            }
            case "lk": {
                return "\ud83c\uddf1\ud83c\uddf0";
            }
            case "lr": {
                return "\ud83c\uddf1\ud83c\uddf7";
            }
            case "ls": {
                return "\ud83c\uddf1\ud83c\uddf8";
            }
            case "lt": {
                return "\ud83c\uddf1\ud83c\uddf9";
            }
            case "lu": {
                return "\ud83c\uddf1\ud83c\uddfa";
            }
            case "lv": {
                return "\ud83c\uddf1\ud83c\uddfb";
            }
            case "ly": {
                return "\ud83c\uddf1\ud83c\uddfe";
            }
            case "ma": {
                return "\ud83c\uddf2\ud83c\udde6";
            }
            case "mc": {
                return "\ud83c\uddf2\ud83c\udde8";
            }
            case "md": {
                return "\ud83c\uddf2\ud83c\udde9";
            }
            case "me": {
                return "\ud83c\uddf2\ud83c\uddea";
            }
            case "mf": {
                return "\ud83c\uddf2\ud83c\uddeb";
            }
            case "mg": {
                return "\ud83c\uddf2\ud83c\uddec";
            }
            case "mh": {
                return "\ud83c\uddf2\ud83c\udded";
            }
            case "mk": {
                return "\ud83c\uddf2\ud83c\uddf0";
            }
            case "ml": {
                return "\ud83c\uddf2\ud83c\uddf1";
            }
            case "mm": {
                return "\ud83c\uddf2\ud83c\uddf2";
            }
            case "mn": {
                return "\ud83c\uddf2\ud83c\uddf3";
            }
            case "mo": {
                return "\ud83c\uddf2\ud83c\uddf4";
            }
            case "mp": {
                return "\ud83c\uddf2\ud83c\uddf5";
            }
            case "mq": {
                return "\ud83c\uddf2\ud83c\uddf6";
            }
            case "mr": {
                return "\ud83c\uddf2\ud83c\uddf7";
            }
            case "ms": {
                return "\ud83c\uddf2\ud83c\uddf8";
            }
            case "mt": {
                return "\ud83c\uddf2\ud83c\uddf9";
            }
            case "mu": {
                return "\ud83c\uddf2\ud83c\uddfa";
            }
            case "mv": {
                return "\ud83c\uddf2\ud83c\uddfb";
            }
            case "mw": {
                return "\ud83c\uddf2\ud83c\uddfc";
            }
            case "mx": {
                return "\ud83c\uddf2\ud83c\uddfd";
            }
            case "my": {
                return "\ud83c\uddf2\ud83c\uddfe";
            }
            case "mz": {
                return "\ud83c\uddf2\ud83c\uddff";
            }
            case "na": {
                return "\ud83c\uddf3\ud83c\udde6";
            }
            case "nc": {
                return "\ud83c\uddf3\ud83c\udde8";
            }
            case "ne": {
                return "\ud83c\uddf3\ud83c\uddea";
            }
            case "nf": {
                return "\ud83c\uddf3\ud83c\uddeb";
            }
            case "ng": {
                return "\ud83c\uddf3\ud83c\uddec";
            }
            case "ni": {
                return "\ud83c\uddf3\ud83c\uddee";
            }
            case "nl": {
                return "\ud83c\uddf3\ud83c\uddf1";
            }
            case "no": {
                return "\ud83c\uddf3\ud83c\uddf4";
            }
            case "np": {
                return "\ud83c\uddf3\ud83c\uddf5";
            }
            case "nr": {
                return "\ud83c\uddf3\ud83c\uddf7";
            }
            case "nu": {
                return "\ud83c\uddf3\ud83c\uddfa";
            }
            case "nz": {
                return "\ud83c\uddf3\ud83c\uddff";
            }
            case "om": {
                return "\ud83c\uddf4\ud83c\uddf2";
            }
            case "pa": {
                return "\ud83c\uddf5\ud83c\udde6";
            }
            case "pe": {
                return "\ud83c\uddf5\ud83c\uddea";
            }
            case "pf": {
                return "\ud83c\uddf5\ud83c\uddeb";
            }
            case "pg": {
                return "\ud83c\uddf5\ud83c\uddec";
            }
            case "ph": {
                return "\ud83c\uddf5\ud83c\udded";
            }
            case "pk": {
                return "\ud83c\uddf5\ud83c\uddf0";
            }
            case "pl": {
                return "\ud83c\uddf5\ud83c\uddf1";
            }
            case "pm": {
                return "\ud83c\uddf5\ud83c\uddf2";
            }
            case "pn": {
                return "\ud83c\uddf5\ud83c\uddf3";
            }
            case "pr": {
                return "\ud83c\uddf5\ud83c\uddf7";
            }
            case "ps": {
                return "\ud83c\uddf5\ud83c\uddf8";
            }
            case "pt": {
                return "\ud83c\uddf5\ud83c\uddf9";
            }
            case "pw": {
                return "\ud83c\uddf5\ud83c\uddfc";
            }
            case "py": {
                return "\ud83c\uddf5\ud83c\uddfe";
            }
            case "qa": {
                return "\ud83c\uddf6\ud83c\udde6";
            }
            case "re": {
                return "\ud83c\uddf7\ud83c\uddea";
            }
            case "ro": {
                return "\ud83c\uddf7\ud83c\uddf4";
            }
            case "rs": {
                return "\ud83c\uddf7\ud83c\uddf8";
            }
            case "ru": {
                return "\ud83c\uddf7\ud83c\uddfa";
            }
            case "rw": {
                return "\ud83c\uddf7\ud83c\uddfc";
            }
            case "sa": {
                return "\ud83c\uddf8\ud83c\udde6";
            }
            case "sb": {
                return "\ud83c\uddf8\ud83c\udde7";
            }
            case "sc": {
                return "\ud83c\uddf8\ud83c\udde8";
            }
            case "sd": {
                return "\ud83c\uddf8\ud83c\udde9";
            }
            case "se": {
                return "\ud83c\uddf8\ud83c\uddea";
            }
            case "sg": {
                return "\ud83c\uddf8\ud83c\uddec";
            }
            case "sh": {
                return "\ud83c\uddf8\ud83c\udded";
            }
            case "si": {
                return "\ud83c\uddf8\ud83c\uddee";
            }
            case "sj": {
                return "\ud83c\uddf8\ud83c\uddef";
            }
            case "sk": {
                return "\ud83c\uddf8\ud83c\uddf0";
            }
            case "sl": {
                return "\ud83c\uddf8\ud83c\uddf1";
            }
            case "sm": {
                return "\ud83c\uddf8\ud83c\uddf2";
            }
            case "sn": {
                return "\ud83c\uddf8\ud83c\uddf3";
            }
            case "so": {
                return "\ud83c\uddf8\ud83c\uddf4";
            }
            case "sr": {
                return "\ud83c\uddf8\ud83c\uddf7";
            }
            case "ss": {
                return "\ud83c\uddf8\ud83c\uddf8";
            }
            case "st": {
                return "\ud83c\uddf8\ud83c\uddf9";
            }
            case "sv": {
                return "\ud83c\uddf8\ud83c\uddfb";
            }
            case "sx": {
                return "\ud83c\uddf8\ud83c\uddfd";
            }
            case "sy": {
                return "\ud83c\uddf8\ud83c\uddfe";
            }
            case "sz": {
                return "\ud83c\uddf8\ud83c\uddff";
            }
            case "tc": {
                return "\ud83c\uddf9\ud83c\udde8";
            }
            case "td": {
                return "\ud83c\uddf9\ud83c\udde9";
            }
            case "tf": {
                return "\ud83c\uddf9\ud83c\uddeb";
            }
            case "tg": {
                return "\ud83c\uddf9\ud83c\uddec";
            }
            case "th": {
                return "\ud83c\uddf9\ud83c\udded";
            }
            case "tj": {
                return "\ud83c\uddf9\ud83c\uddef";
            }
            case "tk": {
                return "\ud83c\uddf9\ud83c\uddf0";
            }
            case "tl": {
                return "\ud83c\uddf9\ud83c\uddf1";
            }
            case "tm": {
                return "\ud83c\uddf9\ud83c\uddf2";
            }
            case "tn": {
                return "\ud83c\uddf9\ud83c\uddf3";
            }
            case "to": {
                return "\ud83c\uddf9\ud83c\uddf4";
            }
            case "tr": {
                return "\ud83c\uddf9\ud83c\uddf7";
            }
            case "tt": {
                return "\ud83c\uddf9\ud83c\uddf9";
            }
            case "tv": {
                return "\ud83c\uddf9\ud83c\uddfb";
            }
            case "tw": {
                return "\ud83c\uddf9\ud83c\uddfc";
            }
            case "tz": {
                return "\ud83c\uddf9\ud83c\uddff";
            }
            case "ua": {
                return "\ud83c\uddfa\ud83c\udde6";
            }
            case "ug": {
                return "\ud83c\uddfa\ud83c\uddec";
            }
            case "um": {
                return "\ud83c\uddfa\ud83c\uddf2";
            }
            case "us": {
                return "\ud83c\uddfa\ud83c\uddf8";
            }
            case "uy": {
                return "\ud83c\uddfa\ud83c\uddfe";
            }
            case "uz": {
                return "\ud83c\uddfa\ud83c\uddff";
            }
            case "va": {
                return "\ud83c\uddfb\ud83c\udde6";
            }
            case "vc": {
                return "\ud83c\uddfb\ud83c\udde8";
            }
            case "ve": {
                return "\ud83c\uddfb\ud83c\uddea";
            }
            case "vg": {
                return "\ud83c\uddfb\ud83c\uddec";
            }
            case "vi": {
                return "\ud83c\uddfb\ud83c\uddee";
            }
            case "vn": {
                return "\ud83c\uddfb\ud83c\uddf3";
            }
            case "vu": {
                return "\ud83c\uddfb\ud83c\uddfa";
            }
            case "wf": {
                return "\ud83c\uddfc\ud83c\uddeb";
            }
            case "ws": {
                return "\ud83c\uddfc\ud83c\uddf8";
            }
            case "xk": {
                return "\ud83c\uddfd\ud83c\uddf0";
            }
            case "ye": {
                return "\ud83c\uddfe\ud83c\uddea";
            }
            case "yt": {
                return "\ud83c\uddfe\ud83c\uddf9";
            }
            case "za": {
                return "\ud83c\uddff\ud83c\udde6";
            }
            case "zm": {
                return "\ud83c\uddff\ud83c\uddf2";
            }
            case "zw": {
                return "\ud83c\uddff\ud83c\uddfc";
            }
        }
        return " ";
    }

    public static List<CCPCountry> getLibraryMasterCountryList(Context context, CountryCodePicker.Language language) {
        if (loadedLibraryMasterListLanguage == null || language != loadedLibraryMasterListLanguage || loadedLibraryMaterList == null || loadedLibraryMaterList.size() == 0) {
            CCPCountry.loadDataFromXML(context, language);
        }
        return loadedLibraryMaterList;
    }

    public static List<CCPCountry> getLibraryMasterCountriesEnglish() {
        ArrayList<CCPCountry> countries = new ArrayList<CCPCountry>();
        countries.add(new CCPCountry("ad", "376", "Andorra", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ae", "971", "United Arab Emirates (UAE)", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("af", "93", "Afghanistan", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ag", "1", "Antigua and Barbuda", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ai", "1", "Anguilla", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("al", "355", "Albania", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("am", "374", "Armenia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ao", "244", "Angola", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("aq", "672", "Antarctica", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ar", "54", "Argentina", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("as", "1", "American Samoa", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("at", "43", "Austria", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("au", "61", "Australia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("aw", "297", "Aruba", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ax", "358", "\u00c5land Islands", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("az", "994", "Azerbaijan", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ba", "387", "Bosnia And Herzegovina", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("bb", "1", "Barbados", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("bd", "880", "Bangladesh", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("be", "32", "Belgium", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("bf", "226", "Burkina Faso", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("bg", "359", "Bulgaria", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("bh", "973", "Bahrain", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("bi", "257", "Burundi", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("bj", "229", "Benin", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("bl", "590", "Saint Barth\u00e9lemy", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("bm", "1", "Bermuda", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("bn", "673", "Brunei Darussalam", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("bo", "591", "Bolivia, Plurinational State Of", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("br", "55", "Brazil", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("bs", "1", "Bahamas", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("bt", "975", "Bhutan", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("bw", "267", "Botswana", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("by", "375", "Belarus", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("bz", "501", "Belize", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ca", "1", "Canada", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("cc", "61", "Cocos (keeling) Islands", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("cd", "243", "Congo, The Democratic Republic Of The", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("cf", "236", "Central African Republic", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("cg", BAHAMAS_AREA_CODES, "Congo", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ch", "41", "Switzerland", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ci", "225", "C\u00f4te D'ivoire", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ck", "682", "Cook Islands", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("cl", "56", "Chile", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("cm", "237", "Cameroon", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("cn", "86", "China", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("co", "57", "Colombia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("cr", "506", "Costa Rica", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("cu", "53", "Cuba", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("cv", "238", "Cape Verde", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("cw", "599", "Cura\u00e7ao", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("cx", "61", "Christmas Island", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("cy", "357", "Cyprus", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("cz", "420", "Czech Republic", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("de", "49", "Germany", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("dj", "253", "Djibouti", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("dk", "45", "Denmark", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("dm", "1", "Dominica", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("do", "1", "Dominican Republic", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("dz", "213", "Algeria", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ec", "593", "Ecuador", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ee", "372", "Estonia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("eg", "20", "Egypt", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("er", "291", "Eritrea", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("es", "34", "Spain", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("et", "251", "Ethiopia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("fi", "358", "Finland", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("fj", "679", "Fiji", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("fk", "500", "Falkland Islands (malvinas)", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("fm", "691", "Micronesia, Federated States Of", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("fo", "298", "Faroe Islands", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("fr", "33", "France", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ga", "241", "Gabon", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("gb", "44", "United Kingdom", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("gd", "1", "Grenada", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ge", "995", "Georgia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("gf", "594", "French Guyana", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("gh", "233", "Ghana", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("gi", "350", "Gibraltar", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("gl", "299", "Greenland", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("gm", "220", "Gambia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("gn", "224", "Guinea", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("gp", "450", "Guadeloupe", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("gq", "240", "Equatorial Guinea", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("gr", "30", "Greece", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("gt", "502", "Guatemala", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("gu", "1", "Guam", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("gw", "245", "Guinea-bissau", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("gy", "592", "Guyana", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("hk", "852", "Hong Kong", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("hn", "504", "Honduras", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("hr", "385", "Croatia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ht", "509", "Haiti", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("hu", "36", "Hungary", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("id", "62", "Indonesia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ie", "353", "Ireland", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("il", "972", "Israel", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("im", "44", "Isle Of Man", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("is", "354", "Iceland", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("in", "91", "India", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("io", BARBADOS_AREA_CODES, "British Indian Ocean Territory", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("iq", "964", "Iraq", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ir", "98", "Iran, Islamic Republic Of", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("it", "39", "Italy", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("je", "44", "Jersey ", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("jm", "1", "Jamaica", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("jo", "962", "Jordan", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("jp", "81", "Japan", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ke", "254", "Kenya", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("kg", "996", "Kyrgyzstan", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("kh", "855", "Cambodia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ki", "686", "Kiribati", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("km", "269", "Comoros", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("kn", "1", "Saint Kitts and Nevis", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("kp", "850", "North Korea", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("kr", "82", "South Korea", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("kw", "965", "Kuwait", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ky", "1", "Cayman Islands", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("kz", "7", "Kazakhstan", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("la", "856", "Lao People's Democratic Republic", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("lb", "961", "Lebanon", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("lc", "1", "Saint Lucia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("li", "423", "Liechtenstein", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("lk", "94", "Sri Lanka", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("lr", "231", "Liberia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ls", "266", "Lesotho", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("lt", "370", "Lithuania", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("lu", "352", "Luxembourg", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("lv", "371", "Latvia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ly", "218", "Libya", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ma", "212", "Morocco", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mc", "377", "Monaco", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("md", "373", "Moldova, Republic Of", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("me", "382", "Montenegro", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mf", "590", "Saint Martin", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mg", "261", "Madagascar", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mh", "692", "Marshall Islands", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mk", "389", "Macedonia (FYROM)", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ml", "223", "Mali", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mm", "95", "Myanmar", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mn", "976", "Mongolia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mo", "853", "Macau", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mp", "1", "Northern Mariana Islands", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mq", "596", "Martinique", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mr", "222", "Mauritania", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ms", "1", "Montserrat", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mt", "356", "Malta", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mu", "230", "Mauritius", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mv", "960", "Maldives", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mw", "265", "Malawi", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mx", "52", "Mexico", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("my", "60", "Malaysia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("mz", "258", "Mozambique", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("na", ANGUILLA_AREA_CODES, "Namibia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("nc", "687", "New Caledonia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ne", "227", "Niger", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("nf", "672", "Norfolk Islands", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ng", "234", "Nigeria", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ni", "505", "Nicaragua", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("nl", "31", "Netherlands", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("no", "47", "Norway", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("np", "977", "Nepal", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("nr", "674", "Nauru", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("nu", "683", "Niue", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("nz", "64", "New Zealand", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("om", "968", "Oman", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("pa", "507", "Panama", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("pe", "51", "Peru", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("pf", "689", "French Polynesia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("pg", "675", "Papua New Guinea", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ph", "63", "Philippines", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("pk", "92", "Pakistan", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("pl", "48", "Poland", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("pm", "508", "Saint Pierre And Miquelon", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("pn", "870", "Pitcairn Islands", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("pr", "1", "Puerto Rico", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ps", "970", "Palestine", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("pt", "351", "Portugal", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("pw", "680", "Palau", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("py", "595", "Paraguay", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("qa", "974", "Qatar", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("re", "262", "R\u00e9union", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ro", "40", "Romania", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("rs", "381", "Serbia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ru", "7", "Russian Federation", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("rw", "250", "Rwanda", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("sa", "966", "Saudi Arabia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("sb", "677", "Solomon Islands", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("sc", "248", "Seychelles", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("sd", "249", "Sudan", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("se", "46", "Sweden", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("sg", "65", "Singapore", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("sh", "290", "Saint Helena, Ascension And Tristan Da Cunha", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("si", "386", "Slovenia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("sk", "421", "Slovakia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("sl", "232", "Sierra Leone", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("sm", "378", "San Marino", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("sn", "221", "Senegal", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("so", "252", "Somalia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("sr", "597", "Suriname", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ss", "211", "South Sudan", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("st", "239", "Sao Tome And Principe", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("sv", "503", "El Salvador", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("sx", "1", "Sint Maarten", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("sy", "963", "Syrian Arab Republic", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("sz", ANTIGUA_AND_BARBUDA_AREA_CODES, "Swaziland", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("tc", "1", "Turks and Caicos Islands", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("td", "235", "Chad", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("tg", "228", "Togo", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("th", "66", "Thailand", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("tj", "992", "Tajikistan", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("tk", "690", "Tokelau", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("tl", "670", "Timor-leste", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("tm", "993", "Turkmenistan", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("tn", "216", "Tunisia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("to", "676", "Tonga", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("tr", "90", "Turkey", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("tt", "1", "Trinidad &amp; Tobago", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("tv", "688", "Tuvalu", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("tw", "886", "Taiwan", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("tz", "255", "Tanzania, United Republic Of", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ua", "380", "Ukraine", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ug", "256", "Uganda", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("us", "1", "United States", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("uy", "598", "Uruguay", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("uz", "998", "Uzbekistan", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("va", "379", "Holy See (vatican City State)", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("vc", "1", "Saint Vincent &amp; The Grenadines", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ve", "58", "Venezuela, Bolivarian Republic Of", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("vg", "1", "British Virgin Islands", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("vi", "1", "US Virgin Islands", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("vn", "84", "Vietnam", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("vu", "678", "Vanuatu", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("wf", "681", "Wallis And Futuna", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ws", "685", "Samoa", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("xk", "383", "Kosovo", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("ye", "967", "Yemen", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("yt", "262", "Mayotte", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("za", "27", "South Africa", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("zm", "260", "Zambia", DEFAULT_FLAG_RES));
        countries.add(new CCPCountry("zw", "263", "Zimbabwe", DEFAULT_FLAG_RES));
        return countries;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public void setEnglishName(String englishName) {
        this.englishName = englishName;
    }

    public int getFlagID() {
        if (this.flagResID == -99) {
            this.flagResID = CCPCountry.getFlagMasterResID(this);
        }
        return this.flagResID;
    }

    public String getNameCode() {
        return this.nameCode;
    }

    public void setNameCode(String nameCode) {
        this.nameCode = nameCode;
    }

    public String getPhoneCode() {
        return this.phoneCode;
    }

    public void setPhoneCode(String phoneCode) {
        this.phoneCode = phoneCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void log() {
        try {
            Log.d((String)TAG, (String)("Country->" + this.nameCode + ":" + this.phoneCode + ":" + this.name));
        }
        catch (NullPointerException ex) {
            Log.d((String)TAG, (String)"Null");
        }
    }

    String logString() {
        return this.nameCode.toUpperCase(Locale.US) + " +" + this.phoneCode + "(" + this.name + ")";
    }

    boolean isEligibleForQuery(String query) {
        query = query.toLowerCase();
        return this.containsQueryWord("Name", this.getName(), query) || this.containsQueryWord("NameCode", this.getNameCode(), query) || this.containsQueryWord("PhoneCode", this.getPhoneCode(), query) || this.containsQueryWord("EnglishName", this.getEnglishName(), query);
    }

    private boolean containsQueryWord(String fieldName, String fieldValue, String query) {
        try {
            if (fieldValue == null || query == null) {
                return false;
            }
            return fieldValue.toLowerCase(Locale.ROOT).contains(query);
        }
        catch (Exception e) {
            Log.w((String)"CCPCountry", (String)(fieldName + ":" + fieldValue + " failed to execute toLowerCase(Locale.ROOT).contains(query) for query:" + query));
            return false;
        }
    }

    @Override
    public int compareTo(@NonNull CCPCountry o) {
        return Collator.getInstance().compare(this.getName(), o.getName());
    }
}

