/*
 * Decompiled with CFR 0.152.
 */
package nashid.hbb20;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.lang.reflect.Field;
import java.util.List;
import nashid.futuremind.recyclerviewfastscroll.FastScroller;
import nashid.hbb20.CCPCountry;
import nashid.hbb20.CountryCodeAdapter;
import nashid.hbb20.CountryCodePicker;
import nashid.verify.sdk.R;

class CountryCodeDialog {
    private static final Field sEditorField;
    private static final Field sCursorDrawableField;
    private static final Field sCursorDrawableResourceField;
    static Dialog dialog;
    static Context context;

    CountryCodeDialog() {
    }

    public static void openCountryCodeDialog(CountryCodePicker codePicker) {
        CountryCodeDialog.openCountryCodeDialog(codePicker, null);
    }

    public static void openCountryCodeDialog(final CountryCodePicker codePicker, String countryNameCode) {
        context = codePicker.getContext();
        dialog = new Dialog(context);
        codePicker.refreshCustomMasterList();
        codePicker.refreshPreferredCountries();
        List<CCPCountry> masterCountries = CCPCountry.getCustomMasterCountryList(context, codePicker);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setContentView(R.layout.layout_picker_dialog);
        dialog.getWindow().setBackgroundDrawable(ContextCompat.getDrawable((Context)context, (int)17170445));
        RecyclerView recyclerView_countryDialog = (RecyclerView)dialog.findViewById(R.id.recycler_countryDialog);
        TextView textViewTitle = (TextView)dialog.findViewById(R.id.textView_title);
        RelativeLayout rlQueryHolder = (RelativeLayout)dialog.findViewById(R.id.rl_query_holder);
        ImageView imgClearQuery = (ImageView)dialog.findViewById(R.id.img_clear_query);
        EditText editText_search = (EditText)dialog.findViewById(R.id.editText_search);
        TextView textView_noResult = (TextView)dialog.findViewById(R.id.textView_noresult);
        CardView dialogRoot = (CardView)dialog.findViewById(R.id.cardViewRoot);
        ImageView imgDismiss = (ImageView)dialog.findViewById(R.id.img_dismiss);
        if (codePicker.isSearchAllowed() && codePicker.isDialogKeyboardAutoPopup()) {
            editText_search.requestFocus();
            dialog.getWindow().setSoftInputMode(5);
        } else {
            dialog.getWindow().setSoftInputMode(2);
        }
        try {
            if (codePicker.getDialogTypeFace() != null) {
                if (codePicker.getDialogTypeFaceStyle() != -99) {
                    textView_noResult.setTypeface(codePicker.getDialogTypeFace(), codePicker.getDialogTypeFaceStyle());
                    editText_search.setTypeface(codePicker.getDialogTypeFace(), codePicker.getDialogTypeFaceStyle());
                    textViewTitle.setTypeface(codePicker.getDialogTypeFace(), codePicker.getDialogTypeFaceStyle());
                } else {
                    textView_noResult.setTypeface(codePicker.getDialogTypeFace());
                    editText_search.setTypeface(codePicker.getDialogTypeFace());
                    textViewTitle.setTypeface(codePicker.getDialogTypeFace());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (codePicker.getDialogBackgroundColor() != 0) {
            dialogRoot.setCardBackgroundColor(codePicker.getDialogBackgroundColor());
        }
        if (codePicker.getDialogBackgroundResId() != 0) {
            dialogRoot.setBackgroundResource(codePicker.getDialogBackgroundResId());
        }
        dialogRoot.setRadius(codePicker.getDialogCornerRadius());
        if (codePicker.isShowCloseIcon()) {
            imgDismiss.setVisibility(0);
            imgDismiss.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    dialog.dismiss();
                }
            });
        } else {
            imgDismiss.setVisibility(8);
        }
        if (!codePicker.getCcpDialogShowTitle()) {
            textViewTitle.setVisibility(8);
        }
        if (codePicker.getDialogTextColor() != 0) {
            int textColor = codePicker.getDialogTextColor();
            imgClearQuery.setColorFilter(textColor);
            imgDismiss.setColorFilter(textColor);
            textViewTitle.setTextColor(textColor);
            textView_noResult.setTextColor(textColor);
            editText_search.setTextColor(textColor);
            editText_search.setHintTextColor(Color.argb((int)100, (int)Color.red((int)textColor), (int)Color.green((int)textColor), (int)Color.blue((int)textColor)));
        }
        if (codePicker.getDialogSearchEditTextTintColor() != 0 && Build.VERSION.SDK_INT >= 21) {
            editText_search.setBackgroundTintList(ColorStateList.valueOf((int)codePicker.getDialogSearchEditTextTintColor()));
            CountryCodeDialog.setCursorColor(editText_search, codePicker.getDialogSearchEditTextTintColor());
        }
        textViewTitle.setText((CharSequence)codePicker.getDialogTitle());
        editText_search.setHint((CharSequence)codePicker.getSearchHintText());
        textView_noResult.setText((CharSequence)codePicker.getNoResultACK());
        if (!codePicker.isSearchAllowed()) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)recyclerView_countryDialog.getLayoutParams();
            params.height = -2;
            recyclerView_countryDialog.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        CountryCodeAdapter cca = new CountryCodeAdapter(context, masterCountries, codePicker, rlQueryHolder, editText_search, textView_noResult, dialog, imgClearQuery);
        recyclerView_countryDialog.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        recyclerView_countryDialog.setAdapter((RecyclerView.Adapter)cca);
        FastScroller fastScroller = (FastScroller)dialog.findViewById(R.id.fastscroll);
        fastScroller.setRecyclerView(recyclerView_countryDialog);
        if (codePicker.isShowFastScroller()) {
            if (codePicker.getFastScrollerBubbleColor() != 0) {
                fastScroller.setBubbleColor(codePicker.getFastScrollerBubbleColor());
            }
            if (codePicker.getFastScrollerHandleColor() != 0) {
                fastScroller.setHandleColor(codePicker.getFastScrollerHandleColor());
            }
            if (codePicker.getFastScrollerBubbleTextAppearance() != 0) {
                try {
                    fastScroller.setBubbleTextAppearance(codePicker.getFastScrollerBubbleTextAppearance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            fastScroller.setVisibility(8);
        }
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                CountryCodeDialog.hideKeyboard(context);
                if (codePicker.getDialogEventsListener() != null) {
                    codePicker.getDialogEventsListener().onCcpDialogDismiss(dialogInterface);
                }
            }
        });
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                CountryCodeDialog.hideKeyboard(context);
                if (codePicker.getDialogEventsListener() != null) {
                    codePicker.getDialogEventsListener().onCcpDialogCancel(dialogInterface);
                }
            }
        });
        if (countryNameCode != null) {
            boolean isPreferredCountry = false;
            if (codePicker.preferredCountries != null) {
                for (CCPCountry preferredCountry : codePicker.preferredCountries) {
                    if (!preferredCountry.nameCode.equalsIgnoreCase(countryNameCode)) continue;
                    isPreferredCountry = true;
                    break;
                }
            }
            if (!isPreferredCountry) {
                int preferredCountriesOffset = 0;
                if (codePicker.preferredCountries != null && codePicker.preferredCountries.size() > 0) {
                    preferredCountriesOffset = codePicker.preferredCountries.size() + 1;
                }
                for (int i = 0; i < masterCountries.size(); ++i) {
                    if (!masterCountries.get((int)i).nameCode.equalsIgnoreCase(countryNameCode)) continue;
                    recyclerView_countryDialog.scrollToPosition(i + preferredCountriesOffset);
                    break;
                }
            }
        }
        dialog.show();
        if (codePicker.getDialogEventsListener() != null) {
            codePicker.getDialogEventsListener().onCcpDialogOpen(dialog);
        }
    }

    private static void hideKeyboard(Context context) {
        if (context instanceof Activity) {
            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
            View view = ((Activity)context).getCurrentFocus();
            if (view == null) {
                view = new View(context);
            }
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    static void setCursorColor(EditText editText, int color2) {
        if (sCursorDrawableField == null) {
            return;
        }
        try {
            Drawable drawable2 = CountryCodeDialog.getDrawable(editText.getContext(), sCursorDrawableResourceField.getInt(editText));
            drawable2.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            sCursorDrawableField.set(Build.VERSION.SDK_INT < 16 ? editText : sEditorField.get(editText), new Drawable[]{drawable2, drawable2});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void clear() {
        if (dialog != null) {
            dialog.dismiss();
        }
        dialog = null;
        context = null;
    }

    private static Drawable getDrawable(Context context, int id2) {
        if (Build.VERSION.SDK_INT < 21) {
            return context.getResources().getDrawable(id2);
        }
        return context.getDrawable(id2);
    }

    static {
        Field editorField = null;
        Field cursorDrawableField = null;
        Field cursorDrawableResourceField = null;
        boolean exceptionThrown = false;
        try {
            Class drawableFieldClass;
            cursorDrawableResourceField = TextView.class.getDeclaredField("mCursorDrawableRes");
            cursorDrawableResourceField.setAccessible(true);
            if (Build.VERSION.SDK_INT < 16) {
                drawableFieldClass = TextView.class;
            } else {
                editorField = TextView.class.getDeclaredField("mEditor");
                editorField.setAccessible(true);
                drawableFieldClass = editorField.getType();
            }
            cursorDrawableField = drawableFieldClass.getDeclaredField("mCursorDrawable");
            cursorDrawableField.setAccessible(true);
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        if (exceptionThrown) {
            sEditorField = null;
            sCursorDrawableField = null;
            sCursorDrawableResourceField = null;
        } else {
            sEditorField = editorField;
            sCursorDrawableField = cursorDrawableField;
            sCursorDrawableResourceField = cursorDrawableResourceField;
        }
    }
}

