/*
 * Decompiled with CFR 0.152.
 */
package nashid.mv;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import androidx.core.app.ActivityCompat;
import java.util.List;
import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nashid.mv.Camera2Helper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007*\u0002\u000e\u0019\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u001b\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!H\u0002\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u001cH\u0002J\u0006\u0010$\u001a\u00020\u001cJ\b\u0010%\u001a\u00020\u001cH\u0002J\u0006\u0010&\u001a\u00020\u001cJ\b\u0010'\u001a\u00020\u001cH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lnashid/mv/Camera2Helper;", "", "context", "Landroid/content/Context;", "surfaceView", "Landroid/view/SurfaceView;", "(Landroid/content/Context;Landroid/view/SurfaceView;)V", "backgroundHandler", "Landroid/os/Handler;", "backgroundThread", "Landroid/os/HandlerThread;", "cameraDevice", "Landroid/hardware/camera2/CameraDevice;", "cameraDeviceStateCallback", "nashid/mv/Camera2Helper$cameraDeviceStateCallback$1", "Lnashid/mv/Camera2Helper$cameraDeviceStateCallback$1;", "cameraOpenCloseLock", "Ljava/util/concurrent/Semaphore;", "captureRequestBuilder", "Landroid/hardware/camera2/CaptureRequest$Builder;", "captureSession", "Landroid/hardware/camera2/CameraCaptureSession;", "imageReader", "Landroid/media/ImageReader;", "surfaceHolderCallback", "nashid/mv/Camera2Helper$surfaceHolderCallback$1", "Lnashid/mv/Camera2Helper$surfaceHolderCallback$1;", "closeCamera", "", "createCameraPreviewSession", "getOptimalPreviewSize", "Landroid/util/Size;", "sizes", "", "([Landroid/util/Size;)Landroid/util/Size;", "openCamera", "start", "startBackgroundThread", "stop", "stopBackgroundThread", "IDV_release"})
public final class Camera2Helper {
    @NotNull
    private final Context context;
    @NotNull
    private final SurfaceView surfaceView;
    @Nullable
    private CameraDevice cameraDevice;
    private CameraCaptureSession captureSession;
    private CaptureRequest.Builder captureRequestBuilder;
    private ImageReader imageReader;
    private HandlerThread backgroundThread;
    private Handler backgroundHandler;
    @NotNull
    private final Semaphore cameraOpenCloseLock;
    @NotNull
    private final cameraDeviceStateCallback.1 cameraDeviceStateCallback;
    @NotNull
    private final surfaceHolderCallback.1 surfaceHolderCallback;

    public Camera2Helper(@NotNull Context context, @NotNull SurfaceView surfaceView) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
        this.context = context;
        this.surfaceView = surfaceView;
        this.cameraOpenCloseLock = new Semaphore(1);
        this.cameraDeviceStateCallback = new CameraDevice.StateCallback(this){
            final /* synthetic */ Camera2Helper this$0;
            {
                this.this$0 = $receiver;
            }

            public void onOpened(@NotNull CameraDevice camera) {
                Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
                Camera2Helper.access$setCameraDevice$p(this.this$0, camera);
                Camera2Helper.access$createCameraPreviewSession(this.this$0);
            }

            public void onDisconnected(@NotNull CameraDevice camera) {
                Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
                CameraDevice cameraDevice = Camera2Helper.access$getCameraDevice$p(this.this$0);
                if (cameraDevice != null) {
                    cameraDevice.close();
                }
                Camera2Helper.access$setCameraDevice$p(this.this$0, null);
            }

            public void onError(@NotNull CameraDevice camera, int error) {
                Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
                CameraDevice cameraDevice = Camera2Helper.access$getCameraDevice$p(this.this$0);
                if (cameraDevice != null) {
                    cameraDevice.close();
                }
                Camera2Helper.access$setCameraDevice$p(this.this$0, null);
            }
        };
        this.surfaceHolderCallback = new SurfaceHolder.Callback(this){
            final /* synthetic */ Camera2Helper this$0;
            {
                this.this$0 = $receiver;
            }

            public void surfaceCreated(@NotNull SurfaceHolder holder) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                Camera2Helper.access$openCamera(this.this$0);
            }

            public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            }

            public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                Camera2Helper.access$closeCamera(this.this$0);
            }
        };
    }

    public final void start() {
        this.surfaceView.getHolder().addCallback((SurfaceHolder.Callback)this.surfaceHolderCallback);
    }

    public final void stop() {
        this.surfaceView.getHolder().removeCallback((SurfaceHolder.Callback)this.surfaceHolderCallback);
        this.closeCamera();
        this.stopBackgroundThread();
    }

    private final void openCamera() {
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.CAMERA") != 0) {
            return;
        }
        Object object = this.context.getSystemService("camera");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        CameraManager cameraManager = (CameraManager)object;
        try {
            StreamConfigurationMap streamConfigurationMap;
            String cameraId = cameraManager.getCameraIdList()[0];
            CameraCharacteristics cameraCharacteristics = cameraManager.getCameraCharacteristics(cameraId);
            Intrinsics.checkNotNullExpressionValue((Object)cameraCharacteristics, (String)"getCameraCharacteristics(...)");
            CameraCharacteristics characteristics = cameraCharacteristics;
            StreamConfigurationMap streamConfigurationMap2 = streamConfigurationMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            Intrinsics.checkNotNull((Object)streamConfigurationMap2);
            Size[] sizeArray = streamConfigurationMap2.getOutputSizes(SurfaceHolder.class);
            Intrinsics.checkNotNullExpressionValue((Object)sizeArray, (String)"getOutputSizes(...)");
            Size previewSize = this.getOptimalPreviewSize(sizeArray);
            this.startBackgroundThread();
            ImageReader imageReader = ImageReader.newInstance((int)previewSize.getWidth(), (int)previewSize.getHeight(), (int)256, (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)imageReader, (String)"newInstance(...)");
            this.imageReader = imageReader;
            ImageReader imageReader2 = this.imageReader;
            if (imageReader2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageReader");
                imageReader2 = null;
            }
            ImageReader.OnImageAvailableListener onImageAvailableListener = Camera2Helper::openCamera$lambda$0;
            Handler handler = this.backgroundHandler;
            if (handler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundHandler");
                handler = null;
            }
            imageReader2.setOnImageAvailableListener(onImageAvailableListener, handler);
            CameraDevice.StateCallback stateCallback = this.cameraDeviceStateCallback;
            Handler handler2 = this.backgroundHandler;
            if (handler2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundHandler");
                handler2 = null;
            }
            cameraManager.openCamera(cameraId, stateCallback, handler2);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private final void createCameraPreviewSession() {
        try {
            Surface surface = this.surfaceView.getHolder().getSurface();
            CameraDevice cameraDevice = this.cameraDevice;
            Intrinsics.checkNotNull((Object)cameraDevice);
            CaptureRequest.Builder builder = cameraDevice.createCaptureRequest(1);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"createCaptureRequest(...)");
            this.captureRequestBuilder = builder;
            CaptureRequest.Builder builder2 = this.captureRequestBuilder;
            if (builder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"captureRequestBuilder");
                builder2 = null;
            }
            builder2.addTarget(surface);
            CaptureRequest.Builder builder3 = this.captureRequestBuilder;
            if (builder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"captureRequestBuilder");
                builder3 = null;
            }
            builder3.set(CaptureRequest.CONTROL_MODE, (Object)1);
            CameraDevice cameraDevice2 = this.cameraDevice;
            if (cameraDevice2 != null) {
                Object[] objectArray = new Surface[2];
                objectArray[0] = surface;
                ImageReader imageReader = this.imageReader;
                if (imageReader == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"imageReader");
                    imageReader = null;
                }
                objectArray[1] = imageReader.getSurface();
                List list = CollectionsKt.listOf((Object[])objectArray);
                CameraCaptureSession.StateCallback stateCallback = new CameraCaptureSession.StateCallback(this){
                    final /* synthetic */ Camera2Helper this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onConfigured(@NotNull CameraCaptureSession session) {
                        Handler handler;
                        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                        if (Camera2Helper.access$getCameraDevice$p(this.this$0) == null) {
                            return;
                        }
                        Camera2Helper.access$setCaptureSession$p(this.this$0, session);
                        CaptureRequest.Builder builder = Camera2Helper.access$getCaptureRequestBuilder$p(this.this$0);
                        if (builder == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"captureRequestBuilder");
                            builder = null;
                        }
                        builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                        CaptureRequest.Builder builder2 = Camera2Helper.access$getCaptureRequestBuilder$p(this.this$0);
                        if (builder2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"captureRequestBuilder");
                            builder2 = null;
                        }
                        CaptureRequest captureRequest = builder2.build();
                        Intrinsics.checkNotNullExpressionValue((Object)captureRequest, (String)"build(...)");
                        CaptureRequest captureRequest2 = captureRequest;
                        CameraCaptureSession cameraCaptureSession = Camera2Helper.access$getCaptureSession$p(this.this$0);
                        if (cameraCaptureSession == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"captureSession");
                            cameraCaptureSession = null;
                        }
                        if ((handler = Camera2Helper.access$getBackgroundHandler$p(this.this$0)) == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundHandler");
                            handler = null;
                        }
                        cameraCaptureSession.setRepeatingRequest(captureRequest2, null, handler);
                    }

                    public void onConfigureFailed(@NotNull CameraCaptureSession session) {
                        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    }
                };
                Handler handler = this.backgroundHandler;
                if (handler == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundHandler");
                    handler = null;
                }
                cameraDevice2.createCaptureSession(list, stateCallback, handler);
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeCamera() {
        try {
            ImageReader imageReader;
            this.cameraOpenCloseLock.acquire();
            CameraCaptureSession cameraCaptureSession = this.captureSession;
            if (cameraCaptureSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"captureSession");
                cameraCaptureSession = null;
            }
            cameraCaptureSession.close();
            CameraDevice cameraDevice = this.cameraDevice;
            if (cameraDevice != null) {
                cameraDevice.close();
            }
            if ((imageReader = this.imageReader) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageReader");
                imageReader = null;
            }
            imageReader.close();
            this.cameraDevice = null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera closing.", e);
        }
        finally {
            this.cameraOpenCloseLock.release();
        }
    }

    private final void startBackgroundThread() {
        this.backgroundThread = new HandlerThread("CameraBackground");
        HandlerThread handlerThread = this.backgroundThread;
        if (handlerThread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundThread");
            handlerThread = null;
        }
        handlerThread.start();
        HandlerThread handlerThread2 = this.backgroundThread;
        if (handlerThread2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundThread");
            handlerThread2 = null;
        }
        this.backgroundHandler = new Handler(handlerThread2.getLooper());
    }

    private final void stopBackgroundThread() {
        HandlerThread handlerThread = this.backgroundThread;
        if (handlerThread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundThread");
            handlerThread = null;
        }
        handlerThread.quitSafely();
        try {
            HandlerThread handlerThread2 = this.backgroundThread;
            if (handlerThread2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundThread");
                handlerThread2 = null;
            }
            handlerThread2.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private final Size getOptimalPreviewSize(Size[] sizes) {
        float targetRatio = (float)this.surfaceView.getWidth() / (float)this.surfaceView.getHeight();
        Size optimalSize = null;
        float minDiff = Float.MAX_VALUE;
        int n = sizes.length;
        for (int i = 0; i < n; ++i) {
            Size size = sizes[i];
            float ratio = (float)size.getWidth() / (float)size.getHeight();
            float diff = Math.abs(ratio - targetRatio);
            if (!(diff < minDiff)) continue;
            optimalSize = size;
            minDiff = diff;
        }
        Size size = optimalSize;
        if (size == null) {
            size = sizes[0];
        }
        return size;
    }

    private static final void openCamera$lambda$0(ImageReader reader) {
        block0: {
            Image image;
            Image image2 = image = reader.acquireLatestImage();
            if (image2 == null) break block0;
            image2.close();
        }
    }

    public static final /* synthetic */ CameraDevice access$getCameraDevice$p(Camera2Helper $this) {
        return $this.cameraDevice;
    }

    public static final /* synthetic */ void access$setCaptureSession$p(Camera2Helper $this, CameraCaptureSession cameraCaptureSession) {
        $this.captureSession = cameraCaptureSession;
    }

    public static final /* synthetic */ CaptureRequest.Builder access$getCaptureRequestBuilder$p(Camera2Helper $this) {
        return $this.captureRequestBuilder;
    }

    public static final /* synthetic */ CameraCaptureSession access$getCaptureSession$p(Camera2Helper $this) {
        return $this.captureSession;
    }

    public static final /* synthetic */ Handler access$getBackgroundHandler$p(Camera2Helper $this) {
        return $this.backgroundHandler;
    }

    public static final /* synthetic */ void access$setCameraDevice$p(Camera2Helper $this, CameraDevice cameraDevice) {
        $this.cameraDevice = cameraDevice;
    }

    public static final /* synthetic */ void access$createCameraPreviewSession(Camera2Helper $this) {
        $this.createCameraPreviewSession();
    }

    public static final /* synthetic */ void access$openCamera(Camera2Helper $this) {
        $this.openCamera();
    }

    public static final /* synthetic */ void access$closeCamera(Camera2Helper $this) {
        $this.closeCamera();
    }
}

