/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import nashid.verify.sdk.id_card.jmrtd.PACESecretKeySpec;
import nashid.verify.sdk.id_card.jmrtd.lds.PACEInfo;
import nashid.verify.sdk.id_card.jmrtd.lds.SecurityInfo;
import nashid.verify.sdk.id_card.jmrtd.lds.icao.MRZInfo;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVUtil;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.DHParameter;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;

public final class Util {
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final int ENC_MODE = 1;
    public static final int MAC_MODE = 2;
    public static final int PACE_MODE = 3;
    private static final Provider BC_PROVIDER = new BouncyCastleProvider();

    private Util() {
    }

    public static Provider getBouncyCastleProvider() {
        return BC_PROVIDER;
    }

    public static SecretKey deriveKey(byte[] keySeed, int mode) throws GeneralSecurityException {
        return Util.deriveKey(keySeed, "DESede", 128, mode);
    }

    public static SecretKey deriveKey(byte[] keySeed, String cipherAlgName, int keyLength, int mode) throws GeneralSecurityException {
        return Util.deriveKey(keySeed, cipherAlgName, keyLength, null, mode);
    }

    public static SecretKey deriveKey(byte[] keySeed, String cipherAlg, int keyLength, byte[] nonce, int mode) throws GeneralSecurityException {
        return Util.deriveKey(keySeed, cipherAlg, keyLength, nonce, mode, (byte)0);
    }

    public static SecretKey deriveKey(byte[] keySeed, String cipherAlg, int keyLength, byte[] nonce, int mode, byte paceKeyReference) throws GeneralSecurityException {
        byte[] keyBytes;
        block12: {
            byte[] hashResult;
            block11: {
                String digestAlg = Util.inferDigestAlgorithmFromCipherAlgorithmForKeyDerivation(cipherAlg, keyLength);
                MessageDigest digest = Util.getMessageDigest(digestAlg);
                digest.reset();
                digest.update(keySeed);
                if (nonce != null) {
                    digest.update(nonce);
                }
                digest.update(new byte[]{0, 0, 0, (byte)mode});
                hashResult = digest.digest();
                keyBytes = null;
                if (!"DESede".equalsIgnoreCase(cipherAlg) && !"3DES".equalsIgnoreCase(cipherAlg)) break block11;
                switch (keyLength) {
                    case 112: 
                    case 128: {
                        keyBytes = new byte[24];
                        System.arraycopy(hashResult, 0, keyBytes, 0, 8);
                        System.arraycopy(hashResult, 8, keyBytes, 8, 8);
                        System.arraycopy(hashResult, 0, keyBytes, 16, 8);
                        break block12;
                    }
                    default: {
                        throw new IllegalArgumentException("KDF can only use DESede with 128-bit key length");
                    }
                }
            }
            if ("AES".equalsIgnoreCase(cipherAlg) || cipherAlg.startsWith("AES")) {
                switch (keyLength) {
                    case 128: {
                        keyBytes = new byte[16];
                        System.arraycopy(hashResult, 0, keyBytes, 0, 16);
                        break;
                    }
                    case 192: {
                        keyBytes = new byte[24];
                        System.arraycopy(hashResult, 0, keyBytes, 0, 24);
                        break;
                    }
                    case 256: {
                        keyBytes = new byte[32];
                        System.arraycopy(hashResult, 0, keyBytes, 0, 32);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("KDF can only use AES with 128-bit, 192-bit key or 256-bit length, found: " + keyLength + "-bit key length");
                    }
                }
            }
        }
        if (paceKeyReference == 0) {
            return new SecretKeySpec(keyBytes, cipherAlg);
        }
        return new PACESecretKeySpec(keyBytes, cipherAlg, paceKeyReference);
    }

    public static byte[] computeKeySeed(String documentNumber, String dateOfBirth, String dateOfExpiry, String digestAlg, boolean doTruncate) throws GeneralSecurityException {
        String text = documentNumber + MRZInfo.checkDigit(documentNumber) + dateOfBirth + MRZInfo.checkDigit(dateOfBirth) + dateOfExpiry + MRZInfo.checkDigit(dateOfExpiry);
        return Util.computeKeySeed(text, digestAlg, doTruncate);
    }

    public static byte[] computeKeySeed(String cardAccessNumber, String digestAlg, boolean doTruncate) throws GeneralSecurityException {
        MessageDigest shaDigest = MessageDigest.getInstance(digestAlg);
        shaDigest.update(Util.getBytes(cardAccessNumber));
        byte[] hash = shaDigest.digest();
        if (doTruncate) {
            byte[] keySeed = new byte[16];
            System.arraycopy(hash, 0, keySeed, 0, 16);
            return keySeed;
        }
        return hash;
    }

    public static byte[] pad(byte[] in, int blockSize) {
        return Util.pad(in, 0, in.length, blockSize);
    }

    public static byte[] pad(byte[] bytes, int offset, int length, int blockSize) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(bytes, offset, length);
        outputStream.write(-128);
        while (outputStream.size() % blockSize != 0) {
            outputStream.write(0);
        }
        return outputStream.toByteArray();
    }

    public static byte[] unpad(byte[] bytes) throws BadPaddingException {
        int i;
        for (i = bytes.length - 1; i >= 0 && bytes[i] == 0; --i) {
        }
        if ((bytes[i] & 0xFF) != 128) {
            throw new BadPaddingException("Expected constant 0x80, found 0x" + Integer.toHexString(bytes[i] & 0xFF));
        }
        byte[] out = new byte[i];
        System.arraycopy(bytes, 0, out, 0, i);
        return out;
    }

    public static byte[] recoverMessage(int digestLength, byte[] decryptedResponse) {
        int paddingLength;
        if (decryptedResponse == null || decryptedResponse.length < 1) {
            throw new IllegalArgumentException("Plaintext is too short to recover message");
        }
        if ((decryptedResponse[decryptedResponse.length - 1] & 0xF ^ 0xC) != 0) {
            throw new NumberFormatException("Could not get M1, malformed trailer");
        }
        int trailerLength = 1;
        if ((decryptedResponse[decryptedResponse.length - 1] & 0xFF ^ 0xBC) == 0) {
            trailerLength = 1;
        } else if ((decryptedResponse[decryptedResponse.length - 1] & 0xFF ^ 0xCC) == 0) {
            trailerLength = 2;
        } else {
            throw new NumberFormatException("Not an ISO 9796-2 scheme 2 signature trailer");
        }
        if ((decryptedResponse[0] & 0xC0 ^ 0x40) != 0) {
            throw new NumberFormatException("Could not get M1");
        }
        if ((decryptedResponse[0] & 0x20) == 0) {
            throw new NumberFormatException("Could not get M1, first byte indicates partial recovery not enabled: " + Integer.toHexString(decryptedResponse[0]));
        }
        for (paddingLength = 0; paddingLength < decryptedResponse.length && (decryptedResponse[paddingLength] & 0xF ^ 0xA) != 0; ++paddingLength) {
        }
        int paddedMessageLength = decryptedResponse.length - trailerLength - digestLength;
        int messageOffset = paddingLength + 1;
        int messageLength = paddedMessageLength - messageOffset;
        if (messageLength <= 0) {
            throw new NumberFormatException("Could not get M1");
        }
        byte[] recoveredMessage = new byte[messageLength];
        System.arraycopy(decryptedResponse, messageOffset, recoveredMessage, 0, messageLength);
        return recoveredMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getRawECDSASignature(byte[] signedData, int keySize) throws IOException {
        ASN1InputStream asn1In = new ASN1InputStream(signedData);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ASN1Sequence obj = (ASN1Sequence)asn1In.readObject();
            Enumeration e = obj.getObjects();
            while (e.hasMoreElements()) {
                ASN1Integer i = (ASN1Integer)e.nextElement();
                byte[] t = i.getValue().toByteArray();
                t = Util.alignKeyDataToSize(t, keySize);
                out.write(t);
            }
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            asn1In.close();
            out.close();
        }
    }

    public static byte[] alignKeyDataToSize(byte[] keyData, int size) {
        byte[] result2 = new byte[size];
        if (keyData.length < size) {
            size = keyData.length;
        }
        System.arraycopy(keyData, keyData.length - size, result2, result2.length - size, size);
        return result2;
    }

    public static byte[] i2os(BigInteger val, int length) {
        BigInteger base = BigInteger.valueOf(256L);
        byte[] result2 = new byte[length];
        for (int i = 0; i < length; ++i) {
            BigInteger remainder = val.mod(base);
            val = val.divide(base);
            result2[length - 1 - i] = (byte)remainder.intValue();
        }
        return result2;
    }

    public static byte[] i2os(BigInteger val) {
        int sizeInNibbles = val.toString(16).length();
        if (sizeInNibbles % 2 != 0) {
            ++sizeInNibbles;
        }
        int length = sizeInNibbles / 2;
        return Util.i2os(val, length);
    }

    public static BigInteger os2i(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        return Util.os2i(bytes, 0, bytes.length);
    }

    public static BigInteger os2i(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        BigInteger result2 = BigInteger.ZERO;
        BigInteger base = BigInteger.valueOf(256L);
        for (int i = offset; i < offset + length; ++i) {
            result2 = result2.multiply(base);
            result2 = result2.add(BigInteger.valueOf(bytes[i] & 0xFF));
        }
        return result2;
    }

    public static BigInteger os2fe(byte[] bytes, BigInteger p) {
        return Util.os2i(bytes).mod(p);
    }

    public static String inferDigestAlgorithmFromSignatureAlgorithm(String signatureAlgorithm) {
        if (signatureAlgorithm == null) {
            throw new IllegalArgumentException();
        }
        String digestAlgorithm = null;
        String signatureAlgorithmToUppercase = signatureAlgorithm.toUpperCase();
        if (signatureAlgorithmToUppercase.contains("WITH")) {
            String[] components = signatureAlgorithmToUppercase.split("WITH");
            digestAlgorithm = components[0];
        }
        if ("SHA1".equalsIgnoreCase(digestAlgorithm)) {
            return "SHA-1";
        }
        if ("SHA224".equalsIgnoreCase(digestAlgorithm)) {
            return "SHA-224";
        }
        if ("SHA256".equalsIgnoreCase(digestAlgorithm)) {
            return "SHA-256";
        }
        if ("SHA384".equalsIgnoreCase(digestAlgorithm)) {
            return "SHA-384";
        }
        if ("SHA512".equalsIgnoreCase(digestAlgorithm)) {
            return "SHA-512";
        }
        return digestAlgorithm;
    }

    public static String inferDigestAlgorithmFromCipherAlgorithmForKeyDerivation(String cipherAlg, int keyLength) {
        if (cipherAlg == null) {
            throw new IllegalArgumentException();
        }
        if ("DESede".equals(cipherAlg) || "AES-128".equals(cipherAlg)) {
            return "SHA-1";
        }
        if ("AES".equals(cipherAlg) && keyLength == 128) {
            return "SHA-1";
        }
        if ("AES-256".equals(cipherAlg) || "AES-192".equals(cipherAlg)) {
            return "SHA-256";
        }
        if ("AES".equals(cipherAlg) && (keyLength == 192 || keyLength == 256)) {
            return "SHA-256";
        }
        throw new IllegalArgumentException("Unsupported cipher algorithm or key length \"" + cipherAlg + "\", " + keyLength);
    }

    public static DHParameterSpec toExplicitDHParameterSpec(DHParameters params) {
        BigInteger p = params.getP();
        BigInteger generator = params.getG();
        BigInteger q = params.getQ();
        int order = params.getL();
        if (q == null) {
            return new DHParameterSpec(p, generator, order);
        }
        return new PACEInfo.DHCParameterSpec(p, generator, q);
    }

    public static String getDetailedPublicKeyAlgorithm(PublicKey publicKey) {
        if (publicKey == null) {
            return "null";
        }
        String algorithm = publicKey.getAlgorithm();
        if (publicKey instanceof RSAPublicKey) {
            int bitLength = ((RSAPublicKey)publicKey).getModulus().bitLength();
            algorithm = algorithm + " [" + bitLength + " bit]";
        } else if (publicKey instanceof ECPublicKey) {
            ECParameterSpec ecParams = ((ECPublicKey)publicKey).getParams();
            String name = Util.getCurveName(ecParams);
            if (name != null) {
                algorithm = algorithm + " [" + name + "]";
            }
        } else if (publicKey instanceof DHPublicKey) {
            ((DHPublicKey)publicKey).getY();
            DHParameterSpec dhParamSpec = ((DHPublicKey)publicKey).getParams();
            BigInteger g = dhParamSpec.getG();
            int l = dhParamSpec.getL();
            BigInteger p = dhParamSpec.getP();
            algorithm = algorithm + " [p.length = " + p.bitLength() + ", g.length = " + g.bitLength() + ", l = " + l + "]";
        }
        return algorithm;
    }

    public static String getDetailedPrivateKeyAlgorithm(PrivateKey privateKey) {
        ECParameterSpec ecParams;
        String name;
        if (privateKey == null) {
            return "null";
        }
        String algorithm = privateKey.getAlgorithm();
        if (privateKey instanceof RSAPrivateKey) {
            int bitLength = ((RSAPrivateKey)privateKey).getModulus().bitLength();
            algorithm = algorithm + " [" + bitLength + " bit]";
        } else if (privateKey instanceof ECPrivateKey && (name = Util.getCurveName(ecParams = ((ECPrivateKey)privateKey).getParams())) != null) {
            algorithm = algorithm + " [" + name + "]";
        }
        return algorithm;
    }

    public static String getCurveName(ECParameterSpec params) {
        ECNamedCurveSpec namedECParams = Util.toNamedCurveSpec(params);
        if (namedECParams == null) {
            return null;
        }
        return namedECParams.getName();
    }

    public static ECParameterSpec toExplicitECParameterSpec(ECNamedCurveParameterSpec parameterSpec) {
        return Util.toExplicitECParameterSpec((ECParameterSpec)Util.toECNamedCurveSpec(parameterSpec));
    }

    public static ECParameterSpec toExplicitECParameterSpec(ECParameterSpec params) {
        try {
            ECPoint g = params.getGenerator();
            BigInteger n = params.getOrder();
            int h = params.getCofactor();
            EllipticCurve curve = params.getCurve();
            BigInteger a = curve.getA();
            BigInteger b = curve.getB();
            ECField field = curve.getField();
            if (field instanceof ECFieldFp) {
                BigInteger p = ((ECFieldFp)field).getP();
                ECFieldFp resultField = new ECFieldFp(p);
                EllipticCurve resultCurve = new EllipticCurve(resultField, a, b);
                return new ECParameterSpec(resultCurve, g, n, h);
            }
            if (field instanceof ECFieldF2m) {
                int m = ((ECFieldF2m)field).getM();
                ECFieldF2m resultField = new ECFieldF2m(m);
                EllipticCurve resultCurve = new EllipticCurve(resultField, a, b);
                return new ECParameterSpec(resultCurve, g, n, h);
            }
            LOGGER.warning("Could not make named EC param spec explicit");
            return params;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not make named EC param spec explicit", e);
            return params;
        }
    }

    private static ECNamedCurveSpec toNamedCurveSpec(ECParameterSpec ecParamSpec) {
        if (ecParamSpec == null) {
            return null;
        }
        if (ecParamSpec instanceof ECNamedCurveSpec) {
            return (ECNamedCurveSpec)ecParamSpec;
        }
        ArrayList<String> names = Collections.list(ECNamedCurveTable.getNames());
        ArrayList<ECNamedCurveSpec> namedSpecs = new ArrayList<ECNamedCurveSpec>();
        for (String name : names) {
            ECNamedCurveSpec namedSpec = Util.toECNamedCurveSpec(ECNamedCurveTable.getParameterSpec((String)name));
            if (!namedSpec.getCurve().equals(ecParamSpec.getCurve()) || !namedSpec.getGenerator().equals(ecParamSpec.getGenerator()) || !namedSpec.getOrder().equals(ecParamSpec.getOrder()) || namedSpec.getCofactor() != ecParamSpec.getCofactor()) continue;
            namedSpecs.add(namedSpec);
        }
        if (namedSpecs.isEmpty()) {
            return null;
        }
        if (namedSpecs.size() == 1) {
            return (ECNamedCurveSpec)namedSpecs.get(0);
        }
        return (ECNamedCurveSpec)namedSpecs.get(0);
    }

    public static ECNamedCurveSpec toECNamedCurveSpec(ECNamedCurveParameterSpec namedParamSpec) {
        String name = namedParamSpec.getName();
        ECCurve curve = namedParamSpec.getCurve();
        org.bouncycastle.math.ec.ECPoint generator = namedParamSpec.getG();
        BigInteger order = namedParamSpec.getN();
        BigInteger coFactor = namedParamSpec.getH();
        byte[] seed = namedParamSpec.getSeed();
        return new ECNamedCurveSpec(name, curve, generator, order, coFactor, seed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SubjectPublicKeyInfo toSubjectPublicKeyInfo(PublicKey publicKey) {
        try {
            String algorithm = publicKey.getAlgorithm();
            if ("EC".equals(algorithm) || "ECDH".equals(algorithm) || publicKey instanceof ECPublicKey) {
                try (ASN1InputStream asn1In = new ASN1InputStream(publicKey.getEncoded());){
                    SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)asn1In.readObject());
                    AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithm();
                    String algOID = algorithmIdentifier.getAlgorithm().getId();
                    if (!SecurityInfo.ID_EC_PUBLIC_KEY.equals(algOID)) {
                        throw new IllegalStateException("Was expecting id-ecPublicKey (" + SecurityInfo.ID_EC_PUBLIC_KEY_TYPE + "), found " + algOID);
                    }
                    ASN1Primitive derEncodedParams = algorithmIdentifier.getParameters().toASN1Primitive();
                    X9ECParameters params = null;
                    if (!(derEncodedParams instanceof ASN1ObjectIdentifier)) {
                        SubjectPublicKeyInfo generator = subjectPublicKeyInfo;
                        return generator;
                    }
                    params = X962NamedCurves.getByOID((ASN1ObjectIdentifier)((ASN1ObjectIdentifier)derEncodedParams));
                    if (params == null) {
                        // empty if block
                    }
                    org.bouncycastle.math.ec.ECPoint generator = params.getG();
                    ECCurve curve = generator.getCurve();
                    generator = curve.createPoint(generator.getAffineXCoord().toBigInteger(), generator.getAffineYCoord().toBigInteger());
                    params = new X9ECParameters(params.getCurve(), new X9ECPoint(generator, false), params.getN(), params.getH(), params.getSeed());
                    if (publicKey instanceof org.bouncycastle.jce.interfaces.ECPublicKey) {
                        AlgorithmIdentifier id2 = new AlgorithmIdentifier(subjectPublicKeyInfo.getAlgorithm().getAlgorithm(), (ASN1Encodable)params.toASN1Primitive());
                        org.bouncycastle.math.ec.ECPoint q = ((org.bouncycastle.jce.interfaces.ECPublicKey)publicKey).getQ();
                        SubjectPublicKeyInfo subjectPublicKeyInfo2 = subjectPublicKeyInfo = new SubjectPublicKeyInfo(id2, q.getEncoded(false));
                        return subjectPublicKeyInfo2;
                    }
                    SubjectPublicKeyInfo subjectPublicKeyInfo3 = subjectPublicKeyInfo;
                    return subjectPublicKeyInfo3;
                }
            }
            if (!"DH".equals(algorithm)) {
                if (!(publicKey instanceof DHPublicKey)) throw new IllegalArgumentException("Unrecognized key type, found " + publicKey.getAlgorithm() + ", should be DH or ECDH");
            }
            try (ASN1InputStream asn1In = new ASN1InputStream(publicKey.getEncoded());){
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)asn1In.readObject());
                AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithm();
                DHPublicKey dhPublicKey = (DHPublicKey)publicKey;
                DHParameterSpec dhSpec = dhPublicKey.getParams();
                SubjectPublicKeyInfo subjectPublicKeyInfo4 = new SubjectPublicKeyInfo(new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), (ASN1Encodable)new DHParameter(dhSpec.getP(), dhSpec.getG(), dhSpec.getL()).toASN1Primitive()), (ASN1Encodable)new ASN1Integer(dhPublicKey.getY()));
                return subjectPublicKeyInfo4;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception", e);
            return null;
        }
    }

    public static PublicKey toPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        try {
            byte[] encodedPublicKeyInfoBytes = subjectPublicKeyInfo.getEncoded("DER");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedPublicKeyInfoBytes);
            try {
                KeyFactory factory = KeyFactory.getInstance("DH");
                return factory.generatePublic(keySpec);
            }
            catch (GeneralSecurityException gse) {
                LOGGER.log(Level.FINE, "Not DH public key? Fine, let's try EC public key", gse);
                KeyFactory factory = KeyFactory.getInstance("EC", BC_PROVIDER);
                return factory.generatePublic(keySpec);
            }
        }
        catch (GeneralSecurityException gse2) {
            LOGGER.log(Level.WARNING, "Exception", gse2);
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception", e);
            return null;
        }
    }

    public static PublicKey reconstructPublicKey(PublicKey publicKey) {
        if (!(publicKey instanceof ECPublicKey)) {
            return publicKey;
        }
        try {
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            ECPoint w = ecPublicKey.getW();
            ECParameterSpec params = ecPublicKey.getParams();
            params = Util.toExplicitECParameterSpec(params);
            ECPublicKeySpec explicitPublicKeySpec = new ECPublicKeySpec(w, params);
            return KeyFactory.getInstance("EC", BC_PROVIDER).generatePublic(explicitPublicKeySpec);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not make public key param spec explicit", e);
            return publicKey;
        }
    }

    public static ECPoint os2ECPoint(byte[] encodedECPoint) {
        DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(encodedECPoint));
        try {
            int b = dataIn.read();
            if (b != 4) {
                throw new IllegalArgumentException("Expected encoded ECPoint to start with 0x04");
            }
            int length = (encodedECPoint.length - 1) / 2;
            byte[] xCoordBytes = new byte[length];
            byte[] yCoordBytes = new byte[length];
            dataIn.readFully(xCoordBytes);
            dataIn.readFully(yCoordBytes);
            dataIn.close();
            BigInteger x = Util.os2i(xCoordBytes);
            BigInteger y = Util.os2i(yCoordBytes);
            ECPoint eCPoint = new ECPoint(x, y);
            return eCPoint;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Exception", ioe);
        }
        finally {
            try {
                dataIn.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FINE, "Error closing stream", ioe);
            }
        }
    }

    public static byte[] ecPoint2OS(ECPoint point) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BigInteger x = point.getAffineX();
        BigInteger y = point.getAffineY();
        try {
            bOut.write(4);
            bOut.write(Util.i2os(x));
            bOut.write(Util.i2os(y));
            bOut.close();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Exception", ioe);
        }
        return bOut.toByteArray();
    }

    public static String inferProtocolIdentifier(PublicKey publicKey) {
        String algorithm = publicKey.getAlgorithm();
        if ("EC".equals(algorithm) || "ECDH".equals(algorithm)) {
            return SecurityInfo.ID_PK_ECDH;
        }
        if ("DH".equals(algorithm)) {
            return SecurityInfo.ID_PK_DH;
        }
        throw new IllegalArgumentException("Wrong key type. Was expecting ECDH or DH public key.");
    }

    public static ECPoint add(ECPoint x, ECPoint y, ECParameterSpec params) {
        org.bouncycastle.math.ec.ECPoint bcX = Util.toBouncyCastleECPoint(x, params);
        org.bouncycastle.math.ec.ECPoint bcY = Util.toBouncyCastleECPoint(y, params);
        org.bouncycastle.math.ec.ECPoint bcSum = bcX.add(bcY);
        return Util.fromBouncyCastleECPoint(bcSum);
    }

    public static ECPoint multiply(BigInteger s, ECPoint point, ECParameterSpec params) {
        org.bouncycastle.math.ec.ECPoint bcPoint = Util.toBouncyCastleECPoint(point, params);
        org.bouncycastle.math.ec.ECPoint bcProd = bcPoint.multiply(s);
        return Util.fromBouncyCastleECPoint(bcProd);
    }

    public static byte[] getBytes(String str) {
        byte[] bytes = str.getBytes();
        bytes = str.getBytes(StandardCharsets.UTF_8);
        return bytes;
    }

    public static BigInteger getPrime(AlgorithmParameterSpec params) {
        if (params == null) {
            throw new IllegalArgumentException("Parameters null");
        }
        if (params instanceof DHParameterSpec) {
            return ((DHParameterSpec)params).getP();
        }
        if (params instanceof ECParameterSpec) {
            EllipticCurve curve = ((ECParameterSpec)params).getCurve();
            ECField field = curve.getField();
            if (!(field instanceof ECFieldFp)) {
                throw new IllegalStateException("Was expecting prime field of type ECFieldFp, found " + field.getClass().getCanonicalName());
            }
            return ((ECFieldFp)field).getP();
        }
        throw new IllegalArgumentException("Unsupported agreement algorithm, was expecting DHParameterSpec or ECParameterSpec, found " + params.getClass().getCanonicalName());
    }

    public static String inferKeyAgreementAlgorithm(PublicKey publicKey) {
        if (publicKey instanceof ECPublicKey) {
            return "ECDH";
        }
        if (publicKey instanceof DHPublicKey) {
            return "DH";
        }
        throw new IllegalArgumentException("Unsupported public key: " + publicKey);
    }

    public static BigInteger computeAffineY(BigInteger affineX, ECParameterSpec params) {
        ECCurve bcCurve = Util.toBouncyCastleECCurve(params);
        ECFieldElement a = bcCurve.getA();
        ECFieldElement b = bcCurve.getB();
        ECFieldElement x = bcCurve.fromBigInteger(affineX);
        ECFieldElement y = x.multiply(x).add(a).multiply(x).add(b).sqrt();
        return y.toBigInteger();
    }

    public static org.bouncycastle.math.ec.ECPoint toBouncyCastleECPoint(ECPoint point, ECParameterSpec params) {
        ECCurve bcCurve = Util.toBouncyCastleECCurve(params);
        return bcCurve.createPoint(point.getAffineX(), point.getAffineY());
    }

    public static ECPoint fromBouncyCastleECPoint(org.bouncycastle.math.ec.ECPoint point) {
        if (!(point = point.normalize()).isValid()) {
            LOGGER.warning("point not valid");
        }
        return new ECPoint(point.getAffineXCoord().toBigInteger(), point.getAffineYCoord().toBigInteger());
    }

    public static boolean isValid(ECPoint ecPoint, ECParameterSpec params) {
        org.bouncycastle.math.ec.ECPoint bcPoint = Util.toBouncyCastleECPoint(ecPoint, params);
        return bcPoint.isValid();
    }

    public static ECPoint normalize(ECPoint ecPoint, ECParameterSpec params) {
        org.bouncycastle.math.ec.ECPoint bcPoint = Util.toBouncyCastleECPoint(ecPoint, params);
        bcPoint = bcPoint.normalize();
        return Util.fromBouncyCastleECPoint(bcPoint);
    }

    private static ECCurve toBouncyCastleECCurve(ECParameterSpec params) {
        EllipticCurve curve = params.getCurve();
        ECField field = curve.getField();
        if (!(field instanceof ECFieldFp)) {
            throw new IllegalArgumentException("Only prime field supported (for now), found " + field.getClass().getCanonicalName());
        }
        int coFactor = params.getCofactor();
        BigInteger order = params.getOrder();
        BigInteger a = curve.getA();
        BigInteger b = curve.getB();
        BigInteger p = Util.getPrime(params);
        return new ECCurve.Fp(p, a, b, order, BigInteger.valueOf(coFactor));
    }

    public static ECPublicKeyParameters toBouncyECPublicKeyParameters(ECPublicKey publicKey) {
        ECParameterSpec ecParams = publicKey.getParams();
        org.bouncycastle.math.ec.ECPoint q = Util.toBouncyCastleECPoint(publicKey.getW(), ecParams);
        return new ECPublicKeyParameters(q, Util.toBouncyECDomainParameters(ecParams));
    }

    public static ECPrivateKeyParameters toBouncyECPrivateKeyParameters(ECPrivateKey privateKey) {
        BigInteger d = privateKey.getS();
        ECDomainParameters ecParams = Util.toBouncyECDomainParameters(privateKey.getParams());
        return new ECPrivateKeyParameters(d, ecParams);
    }

    public static ECDomainParameters toBouncyECDomainParameters(ECParameterSpec params) {
        ECCurve curve = Util.toBouncyCastleECCurve(params);
        org.bouncycastle.math.ec.ECPoint g = Util.toBouncyCastleECPoint(params.getGenerator(), params);
        BigInteger n = params.getOrder();
        BigInteger h = BigInteger.valueOf(params.getCofactor());
        byte[] seed = params.getCurve().getSeed();
        return new ECDomainParameters(curve, g, n, h, seed);
    }

    public static Cipher getCipher(String algorithm) throws GeneralSecurityException {
        try {
            return Cipher.getInstance(algorithm);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Default provider could not provide this cipher, falling back to explicit BC", e);
            return Cipher.getInstance(algorithm, BC_PROVIDER);
        }
    }

    public static Cipher getCipher(String algorithm, int mode, Key key) throws GeneralSecurityException {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(mode, key);
            return cipher;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Cipher, falling back to explicit BC", e);
            Cipher cipher = Cipher.getInstance(algorithm, BC_PROVIDER);
            cipher.init(mode, key);
            return cipher;
        }
    }

    public static KeyAgreement getKeyAgreement(String algorithm) throws GeneralSecurityException {
        try {
            return KeyAgreement.getInstance(algorithm);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Key Agreement, falling back to explicit BC", e);
            return KeyAgreement.getInstance(algorithm, BC_PROVIDER);
        }
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) throws GeneralSecurityException {
        try {
            return KeyPairGenerator.getInstance(algorithm);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Key Pair Generator, falling back to explicit BC", e);
            return KeyPairGenerator.getInstance(algorithm, BC_PROVIDER);
        }
    }

    public static Mac getMac(String algorithm) throws GeneralSecurityException {
        try {
            return Mac.getInstance(algorithm);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Mac, falling back to explicit BC", e);
            return Mac.getInstance(algorithm, BC_PROVIDER);
        }
    }

    public static Mac getMac(String algorithm, Key key) throws GeneralSecurityException {
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(key);
            return mac;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Mac, falling back to explicit BC", e);
            Mac mac = Mac.getInstance(algorithm, BC_PROVIDER);
            mac.init(key);
            return mac;
        }
    }

    public static MessageDigest getMessageDigest(String algorithm) throws GeneralSecurityException {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Message Digest, falling back to explicit BC", e);
            return MessageDigest.getInstance(algorithm, BC_PROVIDER);
        }
    }

    public static PublicKey getPublicKey(String algorithm, KeySpec keySpec) throws GeneralSecurityException {
        try {
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            return kf.generatePublic(keySpec);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Key Factory or Public Key, falling back to explicit BC", e);
            KeyFactory kf = KeyFactory.getInstance(algorithm, BC_PROVIDER);
            return kf.generatePublic(keySpec);
        }
    }

    public static Signature getSignature(String algorithm) throws GeneralSecurityException {
        try {
            return Signature.getInstance(algorithm);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Signature, falling back to explicit BC", e);
            return Signature.getInstance(algorithm, BC_PROVIDER);
        }
    }

    public static CertificateFactory getCertificateFactory(String algorithm) throws GeneralSecurityException {
        try {
            return CertificateFactory.getInstance(algorithm);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Certificate Factory, falling back ot explicit BC", e);
            return CertificateFactory.getInstance(algorithm, BC_PROVIDER);
        }
    }

    public static byte[] toOIDBytes(String oid) {
        byte[] oidBytes = null;
        try {
            try (TLVInputStream oidTLVIn = new TLVInputStream((InputStream)new ByteArrayInputStream(new ASN1ObjectIdentifier(oid).getEncoded()));){
                oidTLVIn.readTag();
                oidTLVIn.readLength();
                oidBytes = oidTLVIn.readValue();
            }
            return TLVUtil.wrapDO((int)128, (byte[])oidBytes);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Illegal OID: \"" + oid, ioe);
        }
    }

    public static List<byte[]> partition(int segmentSize, byte[] data) {
        ArrayList<byte[]> segments = new ArrayList<byte[]>();
        if (data == null || segmentSize <= 0) {
            throw new IllegalArgumentException("Cannot partition");
        }
        segmentSize = Math.min(data.length, segmentSize);
        int segmentCount = data.length / segmentSize;
        int lastSegmentSize = data.length % segmentSize;
        int offset = 0;
        for (int i = 0; i < segmentCount; ++i) {
            byte[] segment = new byte[segmentSize];
            System.arraycopy(data, offset, segment, 0, segmentSize);
            segments.add(segment);
            offset += segmentSize;
        }
        if (lastSegmentSize != 0) {
            byte[] segment = new byte[lastSegmentSize];
            System.arraycopy(data, offset, segment, 0, lastSegmentSize);
            segments.add(segment);
        }
        return segments;
    }

    public static byte[] stripLeadingZeroes(byte[] bytes) {
        if (bytes == null || bytes.length <= 1) {
            return bytes;
        }
        while (bytes.length > 0 && bytes[0] == 0) {
            byte[] result2 = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, result2, 0, result2.length);
            bytes = result2;
        }
        return bytes;
    }
}

