/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.io;

import java.io.IOException;
import java.io.InputStream;
import nashid.verify.sdk.id_card.jmrtd.io.FragmentBuffer;
import nashid.verify.sdk.id_card.jmrtd.io.PositionInputStream;

public class InputStreamBuffer {
    private final PositionInputStream carrier;
    private final FragmentBuffer buffer;

    public InputStreamBuffer(InputStream inputStream, int length) {
        this.carrier = new PositionInputStream(inputStream);
        this.carrier.mark(length);
        this.buffer = new FragmentBuffer(length);
    }

    public void updateFrom(InputStreamBuffer other) {
        this.buffer.updateFrom(other.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubInputStream getInputStream() {
        PositionInputStream positionInputStream = this.carrier;
        synchronized (positionInputStream) {
            return new SubInputStream(this.carrier);
        }
    }

    public synchronized int getPosition() {
        return this.buffer.getPosition();
    }

    public synchronized int getBytesBuffered() {
        return this.buffer.getBytesBuffered();
    }

    public int getLength() {
        return this.buffer.getLength();
    }

    public String toString() {
        return "InputStreamBuffer [" + this.buffer + "]";
    }

    public class SubInputStream
    extends InputStream {
        private int position = 0;
        private int markedPosition = -1;
        private final Object syncObject;

        public SubInputStream(Object syncObject) {
            this.syncObject = syncObject;
        }

        public FragmentBuffer getBuffer() {
            return InputStreamBuffer.this.buffer;
        }

        @Override
        public int read() throws IOException {
            Object object = this.syncObject;
            synchronized (object) {
                if (this.position >= InputStreamBuffer.this.buffer.getLength()) {
                    return -1;
                }
                if (InputStreamBuffer.this.buffer.isCoveredByFragment(this.position)) {
                    return InputStreamBuffer.this.buffer.getBuffer()[this.position++] & 0xFF;
                }
                if (InputStreamBuffer.this.carrier.markSupported()) {
                    this.syncCarrierPosition(this.position);
                }
                int result2 = InputStreamBuffer.this.carrier.read();
                if (result2 < 0) {
                    return -1;
                }
                InputStreamBuffer.this.buffer.addFragment(this.position++, (byte)result2);
                return result2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b) throws IOException {
            Object object = this.syncObject;
            synchronized (object) {
                return this.read(b, 0, b.length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            Object object = this.syncObject;
            synchronized (object) {
                FragmentBuffer.Fragment fragment;
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || len < 0 || len > b.length - off) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return 0;
                }
                if (len > InputStreamBuffer.this.buffer.getLength() - this.position) {
                    len = InputStreamBuffer.this.buffer.getLength() - this.position;
                }
                if (this.position >= InputStreamBuffer.this.buffer.getLength()) {
                    return -1;
                }
                if (InputStreamBuffer.this.carrier.markSupported()) {
                    this.syncCarrierPosition(this.position);
                }
                if ((fragment = InputStreamBuffer.this.buffer.getSmallestUnbufferedFragment(this.position, len)).getLength() > 0) {
                    int alreadyBufferedPrefixLength = fragment.getOffset() - this.position;
                    int unbufferedPostfixLength = fragment.getLength();
                    System.arraycopy(InputStreamBuffer.this.buffer.getBuffer(), this.position, b, off, alreadyBufferedPrefixLength);
                    this.position += alreadyBufferedPrefixLength;
                    if (InputStreamBuffer.this.carrier.markSupported()) {
                        this.syncCarrierPosition(this.position);
                    }
                    int bytesReadFromCarrier = InputStreamBuffer.this.carrier.read(b, off + alreadyBufferedPrefixLength, unbufferedPostfixLength);
                    InputStreamBuffer.this.buffer.addFragment(fragment.getOffset(), b, off + alreadyBufferedPrefixLength, bytesReadFromCarrier);
                    this.position += bytesReadFromCarrier;
                    return alreadyBufferedPrefixLength + bytesReadFromCarrier;
                }
                int length = Math.min(len, InputStreamBuffer.this.buffer.getLength() - this.position);
                System.arraycopy(InputStreamBuffer.this.buffer.getBuffer(), this.position, b, off, length);
                this.position += length;
                return length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            Object object = this.syncObject;
            synchronized (object) {
                int leftInBuffer = InputStreamBuffer.this.buffer.getBufferedLength(this.position);
                if (n <= (long)leftInBuffer) {
                    this.position = (int)((long)this.position + n);
                    return n;
                }
                assert ((long)leftInBuffer < n);
                this.position += leftInBuffer;
                long skippedBytes = 0L;
                if (InputStreamBuffer.this.carrier.markSupported()) {
                    this.syncCarrierPosition(this.position);
                    skippedBytes = InputStreamBuffer.this.carrier.skip(n - (long)leftInBuffer);
                    this.position += (int)skippedBytes;
                } else {
                    skippedBytes = super.skip(n - (long)leftInBuffer);
                }
                return (long)leftInBuffer + skippedBytes;
            }
        }

        @Override
        public int available() throws IOException {
            return InputStreamBuffer.this.buffer.getBufferedLength(this.position);
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public synchronized void mark(int readLimit) {
            this.markedPosition = this.position;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.markedPosition < 0) {
                throw new IOException("Invalid reset, was mark() called?");
            }
            this.position = this.markedPosition;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        public int getPosition() {
            return this.position;
        }

        private void syncCarrierPosition(int position) throws IOException {
            if ((long)position == InputStreamBuffer.this.carrier.getPosition()) {
                return;
            }
            InputStreamBuffer.this.carrier.reset();
            int bytesSkipped = 0;
            while (bytesSkipped < position) {
                bytesSkipped = (int)((long)bytesSkipped + InputStreamBuffer.this.carrier.skip((long)position - (long)bytesSkipped));
            }
        }
    }
}

