/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.lds;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import nashid.verify.sdk.id_card.jmrtd.io.SplittableInputStream;
import nashid.verify.sdk.id_card.jmrtd.lds.ImageInfo;

public abstract class AbstractImageInfo
implements ImageInfo {
    private static final long serialVersionUID = 2870092217269116309L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private int type;
    private String mimeType;
    private byte[] imageBytes;
    private transient SplittableInputStream splittableInputStream;
    private int imagePositionInInputStream;
    private int imageLength;
    private int width;
    private int height;

    AbstractImageInfo() {
        this(-1, 0, 0, null);
    }

    protected AbstractImageInfo(int type) {
        this(type, 0, 0, null);
    }

    protected AbstractImageInfo(int type, String mimeType) {
        this(type, 0, 0, mimeType);
    }

    private AbstractImageInfo(int type, int width, int height, String mimeType) {
        this.type = type;
        this.mimeType = mimeType;
        this.width = width;
        this.height = height;
    }

    public AbstractImageInfo(int type, int width, int height, InputStream inputStream, long imageLength, String mimeType) throws IOException {
        this(type, width, height, mimeType);
        this.readImage(inputStream, imageLength);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getImageLength() {
        if (this.splittableInputStream != null) {
            return this.imageLength;
        }
        if (this.imageBytes == null) {
            throw new IllegalStateException("Cannot get length of null");
        }
        return this.imageBytes.length;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [type: " + AbstractImageInfo.typeToString(this.type) + ", size: " + this.getImageLength() + "]";
    }

    public int hashCode() {
        int result2 = 1234567891;
        result2 = 3 * result2 + 5 * this.type;
        result2 += 5 * (this.mimeType == null ? 1337 : this.mimeType.hashCode()) + 7;
        return result2 += 7 * this.getImageLength() + 11;
    }

    public boolean equals(Object other) {
        try {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!other.getClass().equals(this.getClass())) {
                return false;
            }
            AbstractImageInfo otherImageInfo = (AbstractImageInfo)other;
            return Arrays.equals(this.getImageBytes(), otherImageInfo.getImageBytes()) && (this.mimeType == null && otherImageInfo.mimeType == null || this.mimeType != null && this.mimeType.equals(otherImageInfo.mimeType)) && this.type == otherImageInfo.type;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception" + e);
            return false;
        }
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeObject(out);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Exception", ioe);
            return null;
        }
        return out.toByteArray();
    }

    @Override
    public InputStream getImageInputStream() {
        if (this.splittableInputStream != null) {
            return this.splittableInputStream.getInputStream(this.imagePositionInInputStream);
        }
        if (this.imageBytes != null) {
            return new ByteArrayInputStream(this.imageBytes);
        }
        throw new IllegalStateException("Both the byte buffer and the stream are null");
    }

    protected void readImage(InputStream inputStream, long imageLength) throws IOException {
        this.splittableInputStream = null;
        this.imageBytes = new byte[(int)imageLength];
        DataInputStream dataIn = new DataInputStream(inputStream);
        dataIn.readFully(this.imageBytes);
    }

    protected void writeImage(OutputStream outputStream) throws IOException {
        outputStream.write(this.getImageBytes());
    }

    protected final void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    protected final void setType(int type) {
        this.type = type;
    }

    protected final void setWidth(int width) {
        this.width = width;
    }

    protected final void setHeight(int height) {
        this.height = height;
    }

    protected final void setImageBytes(byte[] imageBytes) {
        if (imageBytes == null) {
            throw new IllegalArgumentException("Cannot set null image bytes");
        }
        try {
            this.readImage(new ByteArrayInputStream(imageBytes), imageBytes.length);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Exception", e);
        }
    }

    protected abstract void readObject(InputStream var1) throws IOException;

    protected abstract void writeObject(OutputStream var1) throws IOException;

    private byte[] getImageBytes() throws IOException {
        InputStream inputStream = null;
        int length = this.getImageLength();
        byte[] imageBytes = new byte[length];
        inputStream = this.getImageInputStream();
        DataInputStream imageInputStream = new DataInputStream(inputStream);
        imageInputStream.readFully(imageBytes);
        return imageBytes;
    }

    private static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "Portrait";
            }
            case 1: {
                return "Signature or usual mark";
            }
            case 2: {
                return "Finger";
            }
            case 3: {
                return "Iris";
            }
            case -1: {
                return "Unknown";
            }
        }
        throw new NumberFormatException("Unknown type: " + Integer.toHexString(type));
    }
}

