/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.lds;

import java.math.BigInteger;
import java.security.PublicKey;
import nashid.verify.sdk.id_card.jmrtd.Util;
import nashid.verify.sdk.id_card.jmrtd.lds.SecurityInfo;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DLSequence;

public class ChipAuthenticationPublicKeyInfo
extends SecurityInfo {
    private static final long serialVersionUID = 5687291829854501771L;
    private final String oid;
    private final BigInteger keyId;
    private final PublicKey publicKey;

    public ChipAuthenticationPublicKeyInfo(PublicKey publicKey) {
        this(publicKey, null);
    }

    public ChipAuthenticationPublicKeyInfo(PublicKey publicKey, BigInteger keyId) {
        this(Util.inferProtocolIdentifier(publicKey), publicKey, keyId);
    }

    public ChipAuthenticationPublicKeyInfo(String oid, PublicKey publicKey) {
        this(oid, publicKey, null);
    }

    public ChipAuthenticationPublicKeyInfo(String oid, PublicKey publicKey, BigInteger keyId) {
        this.oid = oid;
        this.publicKey = Util.reconstructPublicKey(publicKey);
        this.keyId = keyId;
        this.checkFields();
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new ASN1ObjectIdentifier(this.oid));
        vector.add((ASN1Encodable)Util.toSubjectPublicKeyInfo(this.publicKey).toASN1Primitive());
        if (this.keyId != null) {
            vector.add((ASN1Encodable)new ASN1Integer(this.keyId));
        }
        return new DLSequence(vector);
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    @Override
    public String getProtocolOIDString() {
        return ChipAuthenticationPublicKeyInfo.toProtocolOIDString(this.oid);
    }

    public BigInteger getKeyId() {
        return this.keyId;
    }

    public PublicKey getSubjectPublicKey() {
        return this.publicKey;
    }

    protected void checkFields() {
        try {
            if (!ChipAuthenticationPublicKeyInfo.checkRequiredIdentifier(this.oid)) {
                throw new IllegalArgumentException("Wrong identifier: " + this.oid);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed ChipAuthenticationInfo", e);
        }
    }

    public static boolean checkRequiredIdentifier(String oid) {
        return ID_PK_DH.equals(oid) || ID_PK_ECDH.equals(oid);
    }

    public String toString() {
        return "ChipAuthenticationPublicKeyInfo [protocol: " + ChipAuthenticationPublicKeyInfo.toProtocolOIDString(this.oid) + ", chipAuthenticationPublicKey: " + Util.getDetailedPublicKeyAlgorithm(this.getSubjectPublicKey()) + ", keyId: " + (this.keyId == null ? "-" : this.keyId.toString()) + "]";
    }

    public int hashCode() {
        return 123 + 1337 * (this.oid.hashCode() + (this.keyId == null ? 111 : this.keyId.hashCode()) + (this.publicKey == null ? 111 : this.publicKey.hashCode()));
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!ChipAuthenticationPublicKeyInfo.class.equals(other.getClass())) {
            return false;
        }
        ChipAuthenticationPublicKeyInfo otherInfo = (ChipAuthenticationPublicKeyInfo)other;
        return this.oid.equals(otherInfo.oid) && (this.keyId == null && otherInfo.keyId == null || this.keyId != null && this.keyId.equals(otherInfo.keyId)) && this.publicKey.equals(otherInfo.publicKey);
    }

    public static String toKeyAgreementAlgorithm(String oid) {
        if (oid == null) {
            throw new NumberFormatException("Unknown OID: null");
        }
        if (ID_PK_DH.equals(oid)) {
            return "DH";
        }
        if (ID_PK_ECDH.equals(oid)) {
            return "ECDH";
        }
        throw new NumberFormatException("Unknown OID: \"" + oid + "\"");
    }

    private static String toProtocolOIDString(String oid) {
        if (ID_PK_DH.equals(oid)) {
            return "id-PK-DH";
        }
        if (ID_PK_ECDH.equals(oid)) {
            return "id-PK-ECDH";
        }
        return oid;
    }
}

