/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.lds;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import nashid.verify.sdk.id_card.jmrtd.lds.AbstractLDSFile;
import nashid.verify.sdk.id_card.jmrtd.lds.CVCAFile;
import nashid.verify.sdk.id_card.jmrtd.lds.SODFile;
import nashid.verify.sdk.id_card.jmrtd.lds.icao.COMFile;
import nashid.verify.sdk.id_card.jmrtd.lds.icao.DG11File;
import nashid.verify.sdk.id_card.jmrtd.lds.icao.DG12File;
import nashid.verify.sdk.id_card.jmrtd.lds.icao.DG14File;
import nashid.verify.sdk.id_card.jmrtd.lds.icao.DG15File;
import nashid.verify.sdk.id_card.jmrtd.lds.icao.DG1File;
import nashid.verify.sdk.id_card.jmrtd.lds.icao.DG2File;
import nashid.verify.sdk.id_card.jmrtd.lds.icao.DG3File;
import nashid.verify.sdk.id_card.jmrtd.lds.icao.DG4File;
import nashid.verify.sdk.id_card.jmrtd.lds.icao.DG5File;
import nashid.verify.sdk.id_card.jmrtd.lds.icao.DG6File;
import nashid.verify.sdk.id_card.jmrtd.lds.icao.DG7File;

public final class LDSFileUtil {
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final Map<Short, Byte> FID_TO_SFI = LDSFileUtil.createFIDToSFIMap();

    private LDSFileUtil() {
    }

    public static AbstractLDSFile getLDSFile(short fid, InputStream inputStream) throws IOException {
        switch (fid) {
            case 286: {
                return new COMFile(inputStream);
            }
            case 257: {
                return new DG1File(inputStream);
            }
            case 258: {
                return new DG2File(inputStream);
            }
            case 259: {
                return new DG3File(inputStream);
            }
            case 260: {
                return new DG4File(inputStream);
            }
            case 261: {
                return new DG5File(inputStream);
            }
            case 262: {
                return new DG6File(inputStream);
            }
            case 263: {
                return new DG7File(inputStream);
            }
            case 264: {
                throw new IllegalArgumentException("DG8 files are not yet supported");
            }
            case 265: {
                throw new IllegalArgumentException("DG9 files are not yet supported");
            }
            case 266: {
                throw new IllegalArgumentException("DG10 files are not yet supported");
            }
            case 267: {
                return new DG11File(inputStream);
            }
            case 268: {
                return new DG12File(inputStream);
            }
            case 269: {
                throw new IllegalArgumentException("DG13 files are not yet supported");
            }
            case 270: {
                return new DG14File(inputStream);
            }
            case 271: {
                return new DG15File(inputStream);
            }
            case 272: {
                throw new IllegalArgumentException("DG16 files are not yet supported");
            }
            case 285: {
                return new SODFile(inputStream);
            }
            case 284: {
                return new CVCAFile(inputStream);
            }
        }
        BufferedInputStream bufferedIn = new BufferedInputStream(inputStream, 37);
        try {
            bufferedIn.mark(37);
            return new CVCAFile(fid, bufferedIn);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unknown file " + Integer.toHexString(fid), e);
            bufferedIn.reset();
            throw new NumberFormatException("Unknown file " + Integer.toHexString(fid));
        }
    }

    public static short lookupFIDByTag(int tag) {
        switch (tag) {
            case 96: {
                return 286;
            }
            case 97: {
                return 257;
            }
            case 117: {
                return 258;
            }
            case 99: {
                return 259;
            }
            case 118: {
                return 260;
            }
            case 101: {
                return 261;
            }
            case 102: {
                return 262;
            }
            case 103: {
                return 263;
            }
            case 104: {
                return 264;
            }
            case 105: {
                return 265;
            }
            case 106: {
                return 266;
            }
            case 107: {
                return 267;
            }
            case 108: {
                return 268;
            }
            case 109: {
                return 269;
            }
            case 110: {
                return 270;
            }
            case 111: {
                return 271;
            }
            case 112: {
                return 272;
            }
            case 119: {
                return 285;
            }
        }
        throw new NumberFormatException("Unknown tag " + Integer.toHexString(tag));
    }

    public static int lookupDataGroupNumberByTag(int tag) {
        switch (tag) {
            case 97: {
                return 1;
            }
            case 117: {
                return 2;
            }
            case 99: {
                return 3;
            }
            case 118: {
                return 4;
            }
            case 101: {
                return 5;
            }
            case 102: {
                return 6;
            }
            case 103: {
                return 7;
            }
            case 104: {
                return 8;
            }
            case 105: {
                return 9;
            }
            case 106: {
                return 10;
            }
            case 107: {
                return 11;
            }
            case 108: {
                return 12;
            }
            case 109: {
                return 13;
            }
            case 110: {
                return 14;
            }
            case 111: {
                return 15;
            }
            case 112: {
                return 16;
            }
        }
        throw new NumberFormatException("Unknown tag " + Integer.toHexString(tag));
    }

    public static int lookupTagByDataGroupNumber(int number) {
        switch (number) {
            case 1: {
                return 97;
            }
            case 2: {
                return 117;
            }
            case 3: {
                return 99;
            }
            case 4: {
                return 118;
            }
            case 5: {
                return 101;
            }
            case 6: {
                return 102;
            }
            case 7: {
                return 103;
            }
            case 8: {
                return 104;
            }
            case 9: {
                return 105;
            }
            case 10: {
                return 106;
            }
            case 11: {
                return 107;
            }
            case 12: {
                return 108;
            }
            case 13: {
                return 109;
            }
            case 14: {
                return 110;
            }
            case 15: {
                return 111;
            }
            case 16: {
                return 112;
            }
        }
        throw new NumberFormatException("Unknown number " + number);
    }

    public static short lookupFIDByDataGroupNumber(int number) {
        switch (number) {
            case 1: {
                return 257;
            }
            case 2: {
                return 258;
            }
            case 3: {
                return 259;
            }
            case 4: {
                return 260;
            }
            case 5: {
                return 261;
            }
            case 6: {
                return 262;
            }
            case 7: {
                return 263;
            }
            case 8: {
                return 264;
            }
            case 9: {
                return 265;
            }
            case 10: {
                return 266;
            }
            case 11: {
                return 267;
            }
            case 12: {
                return 268;
            }
            case 13: {
                return 269;
            }
            case 14: {
                return 270;
            }
            case 15: {
                return 271;
            }
            case 16: {
                return 272;
            }
        }
        throw new NumberFormatException("Unknown number " + number);
    }

    public static short lookupTagByFID(short fid) {
        switch (fid) {
            case 286: {
                return 96;
            }
            case 257: {
                return 97;
            }
            case 258: {
                return 117;
            }
            case 259: {
                return 99;
            }
            case 260: {
                return 118;
            }
            case 261: {
                return 101;
            }
            case 262: {
                return 102;
            }
            case 263: {
                return 103;
            }
            case 264: {
                return 104;
            }
            case 265: {
                return 105;
            }
            case 266: {
                return 106;
            }
            case 267: {
                return 107;
            }
            case 268: {
                return 108;
            }
            case 269: {
                return 109;
            }
            case 270: {
                return 110;
            }
            case 271: {
                return 111;
            }
            case 272: {
                return 112;
            }
            case 285: {
                return 119;
            }
        }
        throw new NumberFormatException("Unknown fid " + Integer.toHexString(fid));
    }

    public static int lookupDataGroupNumberByFID(short fid) {
        switch (fid) {
            case 257: {
                return 1;
            }
            case 258: {
                return 2;
            }
            case 259: {
                return 3;
            }
            case 260: {
                return 4;
            }
            case 261: {
                return 5;
            }
            case 262: {
                return 6;
            }
            case 263: {
                return 7;
            }
            case 264: {
                return 8;
            }
            case 265: {
                return 9;
            }
            case 266: {
                return 10;
            }
            case 267: {
                return 11;
            }
            case 268: {
                return 12;
            }
            case 269: {
                return 13;
            }
            case 270: {
                return 14;
            }
            case 271: {
                return 15;
            }
            case 272: {
                return 16;
            }
        }
        throw new NumberFormatException("Unknown fid " + Integer.toHexString(fid));
    }

    public static String lookupFileNameByTag(int tag) {
        switch (tag) {
            case 96: {
                return "EF_COM";
            }
            case 97: {
                return "EF_DG1";
            }
            case 117: {
                return "EF_DG2";
            }
            case 99: {
                return "EF_DG3";
            }
            case 118: {
                return "EF_DG4";
            }
            case 101: {
                return "EF_DG5";
            }
            case 102: {
                return "EF_DG6";
            }
            case 103: {
                return "EF_DG7";
            }
            case 104: {
                return "EF_DG8";
            }
            case 105: {
                return "EF_DG9";
            }
            case 106: {
                return "EF_DG10";
            }
            case 107: {
                return "EF_DG11";
            }
            case 108: {
                return "EF_DG12";
            }
            case 109: {
                return "EF_DG13";
            }
            case 110: {
                return "EF_DG14";
            }
            case 111: {
                return "EF_DG15";
            }
            case 112: {
                return "EF_DG16";
            }
            case 119: {
                return "EF_SOD";
            }
        }
        return "File with tag 0x" + Integer.toHexString(tag);
    }

    public static String lookupFileNameByFID(int fid) {
        switch (fid) {
            case 286: {
                return "EF_COM";
            }
            case 257: {
                return "EF_DG1";
            }
            case 258: {
                return "EF_DG2";
            }
            case 259: {
                return "EF_DG3";
            }
            case 260: {
                return "EF_DG4";
            }
            case 261: {
                return "EF_DG5";
            }
            case 262: {
                return "EF_DG6";
            }
            case 263: {
                return "EF_DG7";
            }
            case 264: {
                return "EF_DG8";
            }
            case 265: {
                return "EF_DG9";
            }
            case 266: {
                return "EF_DG10";
            }
            case 267: {
                return "EF_DG11";
            }
            case 268: {
                return "EF_DG12";
            }
            case 269: {
                return "EF_DG13";
            }
            case 270: {
                return "EF_DG14";
            }
            case 271: {
                return "EF_DG15";
            }
            case 272: {
                return "EF_DG16";
            }
            case 285: {
                return "EF_SOD";
            }
        }
        return "File with FID 0x" + Integer.toHexString(fid);
    }

    public static int lookupSFIByFID(short fid) {
        Byte sfiByte = FID_TO_SFI.get(fid);
        if (sfiByte == null) {
            throw new NumberFormatException("Unknown FID " + Integer.toHexString(fid));
        }
        return sfiByte & 0xFF;
    }

    public static short lookupFIDBySFI(byte sfi) {
        switch (sfi) {
            case 30: {
                return 286;
            }
            case 1: {
                return 257;
            }
            case 2: {
                return 258;
            }
            case 3: {
                return 259;
            }
            case 4: {
                return 260;
            }
            case 5: {
                return 261;
            }
            case 6: {
                return 262;
            }
            case 7: {
                return 263;
            }
            case 8: {
                return 264;
            }
            case 9: {
                return 265;
            }
            case 10: {
                return 266;
            }
            case 11: {
                return 267;
            }
            case 12: {
                return 268;
            }
            case 13: {
                return 269;
            }
            case 14: {
                return 270;
            }
            case 15: {
                return 271;
            }
            case 16: {
                return 272;
            }
            case 29: {
                return 285;
            }
            case 28: {
                return 284;
            }
        }
        throw new NumberFormatException("Unknown SFI " + Integer.toHexString(sfi));
    }

    public static List<Integer> getDataGroupNumbers(SODFile sodFile) {
        ArrayList<Integer> dgNumbers = new ArrayList<Integer>();
        if (sodFile == null) {
            return dgNumbers;
        }
        dgNumbers.addAll(sodFile.getDataGroupHashes().keySet());
        Collections.sort(dgNumbers);
        return dgNumbers;
    }

    public static List<Integer> getDataGroupNumbers(COMFile comFile) {
        ArrayList<Integer> dgNumbers = new ArrayList<Integer>();
        if (comFile == null) {
            return dgNumbers;
        }
        int[] tagList = comFile.getTagList();
        dgNumbers.addAll(LDSFileUtil.toDataGroupList(tagList));
        Collections.sort(dgNumbers);
        return dgNumbers;
    }

    private static List<Integer> toDataGroupList(int[] tagList) {
        if (tagList == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> dgNumberList = new ArrayList<Integer>(tagList.length);
        for (int tag : tagList) {
            try {
                int dgNumber = LDSFileUtil.lookupDataGroupNumberByTag(tag);
                dgNumberList.add(dgNumber);
            }
            catch (NumberFormatException nfe) {
                LOGGER.log(Level.WARNING, "Could not find DG number for tag: " + Integer.toHexString(tag), nfe);
            }
        }
        return dgNumberList;
    }

    private static Map<Short, Byte> createFIDToSFIMap() {
        HashMap<Short, Byte> fidToSFI = new HashMap<Short, Byte>(20);
        fidToSFI.put((short)286, (byte)30);
        fidToSFI.put((short)257, (byte)1);
        fidToSFI.put((short)258, (byte)2);
        fidToSFI.put((short)259, (byte)3);
        fidToSFI.put((short)260, (byte)4);
        fidToSFI.put((short)261, (byte)5);
        fidToSFI.put((short)262, (byte)6);
        fidToSFI.put((short)263, (byte)7);
        fidToSFI.put((short)264, (byte)8);
        fidToSFI.put((short)265, (byte)9);
        fidToSFI.put((short)266, (byte)10);
        fidToSFI.put((short)267, (byte)11);
        fidToSFI.put((short)268, (byte)12);
        fidToSFI.put((short)269, (byte)13);
        fidToSFI.put((short)270, (byte)14);
        fidToSFI.put((short)271, (byte)15);
        fidToSFI.put((short)272, (byte)16);
        fidToSFI.put((short)285, (byte)29);
        fidToSFI.put((short)284, (byte)28);
        return Collections.unmodifiableMap(fidToSFI);
    }
}

