/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.lds.icao;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import nashid.verify.sdk.id_card.jmrtd.lds.DataGroup;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;
import net.sf.scuba.tlv.TLVUtil;
import net.sf.scuba.util.Hex;

public class DG12File
extends DataGroup {
    private static final long serialVersionUID = -1979367459379125674L;
    private static final int TAG_LIST_TAG = 92;
    public static final int ISSUING_AUTHORITY_TAG = 24345;
    public static final int DATE_OF_ISSUE_TAG = 24358;
    public static final int NAME_OF_OTHER_PERSON_TAG = 24346;
    public static final int ENDORSEMENTS_AND_OBSERVATIONS_TAG = 24347;
    public static final int TAX_OR_EXIT_REQUIREMENTS_TAG = 24348;
    public static final int IMAGE_OF_FRONT_TAG = 24349;
    public static final int IMAGE_OF_REAR_TAG = 24350;
    public static final int DATE_AND_TIME_OF_PERSONALIZATION_TAG = 24405;
    public static final int PERSONALIZATION_SYSTEM_SERIAL_NUMBER_TAG = 24406;
    public static final int CONTENT_SPECIFIC_CONSTRUCTED_TAG = 160;
    public static final int COUNT_TAG = 2;
    private static final String SDF = "yyyyMMdd";
    private static final String SDTF = "yyyyMMddhhmmss";
    private String issuingAuthority;
    private String dateOfIssue;
    private List<String> namesOfOtherPersons;
    private String endorsementsAndObservations;
    private String taxOrExitRequirements;
    private byte[] imageOfFront;
    private byte[] imageOfRear;
    private String dateAndTimeOfPersonalization;
    private String personalizationSystemSerialNumber;
    private List<Integer> tagPresenceList;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");

    public DG12File(String issuingAuthority, Date dateOfIssue, List<String> namesOfOtherPersons, String endorsementsAndObservations, String taxOrExitRequirements, byte[] imageOfFront, byte[] imageOfRear, Date dateAndTimeOfPersonalization, String personalizationSystemSerialNumber) {
        this(issuingAuthority, new SimpleDateFormat(SDF).format(dateOfIssue), namesOfOtherPersons, endorsementsAndObservations, taxOrExitRequirements, imageOfFront, imageOfRear, new SimpleDateFormat(SDTF).format(dateAndTimeOfPersonalization), personalizationSystemSerialNumber);
    }

    public DG12File(String issuingAuthority, String dateOfIssue, List<String> namesOfOtherPersons, String endorsementsAndObservations, String taxOrExitRequirements, byte[] imageOfFront, byte[] imageOfRear, String dateAndTimeOfPersonalization, String personalizationSystemSerialNumber) {
        super(108);
        this.issuingAuthority = issuingAuthority;
        this.dateOfIssue = dateOfIssue;
        this.namesOfOtherPersons = namesOfOtherPersons == null ? new ArrayList<String>() : new ArrayList<String>(namesOfOtherPersons);
        this.endorsementsAndObservations = endorsementsAndObservations;
        this.taxOrExitRequirements = taxOrExitRequirements;
        this.imageOfFront = imageOfFront;
        this.imageOfRear = imageOfRear;
        this.dateAndTimeOfPersonalization = dateAndTimeOfPersonalization;
        this.personalizationSystemSerialNumber = personalizationSystemSerialNumber;
    }

    public DG12File(InputStream inputStream) throws IOException {
        super(108, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readContent(InputStream inputStream) throws IOException {
        TLVInputStream tlvInputStream = inputStream instanceof TLVInputStream ? (TLVInputStream)inputStream : new TLVInputStream(inputStream);
        int tagListTag = tlvInputStream.readTag();
        if (tagListTag != 92) {
            throw new IllegalArgumentException("Expected tag list in DG12");
        }
        int tagListLength = tlvInputStream.readLength();
        int expectedTagCount = tagListLength / 2;
        try (ByteArrayInputStream tagListBytesInputStream = new ByteArrayInputStream(tlvInputStream.readValue());){
            int tag;
            ArrayList<Integer> tagList = new ArrayList<Integer>(expectedTagCount + 1);
            for (int tagListBytesRead = 0; tagListBytesRead < tagListLength; tagListBytesRead += TLVUtil.getTagLength((int)tag)) {
                TLVInputStream anotherTLVInputStream = new TLVInputStream((InputStream)tagListBytesInputStream);
                tag = anotherTLVInputStream.readTag();
                tagList.add(tag);
            }
            Iterator iterator = tagList.iterator();
            while (iterator.hasNext()) {
                int t = (Integer)iterator.next();
                this.readField(t, tlvInputStream);
            }
        }
    }

    @Override
    protected void writeContent(OutputStream outputStream) throws IOException {
        TLVOutputStream tlvOut = outputStream instanceof TLVOutputStream ? (TLVOutputStream)outputStream : new TLVOutputStream(outputStream);
        tlvOut.writeTag(92);
        List<Integer> tags = this.getTagPresenceList();
        DataOutputStream dataOut = new DataOutputStream((OutputStream)tlvOut);
        for (int tag : tags) {
            dataOut.writeShort(tag);
        }
        dataOut.flush();
        tlvOut.writeValueEnd();
        block12: for (int tag : tags) {
            switch (tag) {
                case 24345: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.issuingAuthority.trim().getBytes(StandardCharsets.UTF_8));
                    continue block12;
                }
                case 24358: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.dateOfIssue.getBytes(StandardCharsets.UTF_8));
                    continue block12;
                }
                case 24346: {
                    if (this.namesOfOtherPersons == null) {
                        this.namesOfOtherPersons = new ArrayList<String>();
                    }
                    tlvOut.writeTag(160);
                    tlvOut.writeTag(2);
                    tlvOut.write(this.namesOfOtherPersons.size());
                    tlvOut.writeValueEnd();
                    for (String nameOfOtherPerson : this.namesOfOtherPersons) {
                        tlvOut.writeTag(24346);
                        tlvOut.writeValue(nameOfOtherPerson.trim().getBytes(StandardCharsets.UTF_8));
                    }
                    tlvOut.writeValueEnd();
                    continue block12;
                }
                case 24347: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.endorsementsAndObservations.trim().getBytes(StandardCharsets.UTF_8));
                    continue block12;
                }
                case 24348: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.taxOrExitRequirements.trim().getBytes(StandardCharsets.UTF_8));
                    continue block12;
                }
                case 24349: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.imageOfFront);
                    continue block12;
                }
                case 24350: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.imageOfRear);
                    continue block12;
                }
                case 24405: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.dateAndTimeOfPersonalization.getBytes(StandardCharsets.UTF_8));
                    continue block12;
                }
                case 24406: {
                    tlvOut.writeTag(tag);
                    tlvOut.writeValue(this.personalizationSystemSerialNumber.trim().getBytes(StandardCharsets.UTF_8));
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Unknown field tag in DG12: " + Integer.toHexString(tag));
        }
    }

    public List<Integer> getTagPresenceList() {
        if (this.tagPresenceList != null) {
            return this.tagPresenceList;
        }
        this.tagPresenceList = new ArrayList<Integer>(10);
        if (this.issuingAuthority != null) {
            this.tagPresenceList.add(24345);
        }
        if (this.dateOfIssue != null) {
            this.tagPresenceList.add(24358);
        }
        if (this.namesOfOtherPersons != null && !this.namesOfOtherPersons.isEmpty()) {
            this.tagPresenceList.add(24346);
        }
        if (this.endorsementsAndObservations != null) {
            this.tagPresenceList.add(24347);
        }
        if (this.taxOrExitRequirements != null) {
            this.tagPresenceList.add(24348);
        }
        if (this.imageOfFront != null) {
            this.tagPresenceList.add(24349);
        }
        if (this.imageOfRear != null) {
            this.tagPresenceList.add(24350);
        }
        if (this.dateAndTimeOfPersonalization != null) {
            this.tagPresenceList.add(24405);
        }
        if (this.personalizationSystemSerialNumber != null) {
            this.tagPresenceList.add(24406);
        }
        return this.tagPresenceList;
    }

    private void readField(int expectedFieldTag, TLVInputStream tlvInputStream) throws IOException {
        int tag = tlvInputStream.readTag();
        if (tag == 160) {
            tlvInputStream.readLength();
            int countTag = tlvInputStream.readTag();
            if (countTag != 2) {
                throw new IllegalArgumentException("Expected " + Integer.toHexString(2) + ", found " + Integer.toHexString(countTag));
            }
            int countLength = tlvInputStream.readLength();
            if (countLength != 1) {
                throw new IllegalArgumentException("Expected length 1 count length, found " + countLength);
            }
            byte[] countValue = tlvInputStream.readValue();
            if (countValue == null || countValue.length != 1) {
                throw new IllegalArgumentException("Number of content specific fields should be encoded in single byte, found " + Arrays.toString(countValue));
            }
            int count = countValue[0] & 0xFF;
            for (int i = 0; i < count; ++i) {
                tag = tlvInputStream.readTag();
                if (tag != 24346) {
                    throw new IllegalArgumentException("Expected " + Integer.toHexString(24346) + ", found " + Integer.toHexString(tag));
                }
                tlvInputStream.readLength();
                byte[] value = tlvInputStream.readValue();
                this.parseNameOfOtherPerson(value);
            }
        } else {
            if (tag != expectedFieldTag) {
                throw new IllegalArgumentException("Expected " + Integer.toHexString(expectedFieldTag) + ", but found " + Integer.toHexString(tag));
            }
            tlvInputStream.readLength();
            byte[] value = tlvInputStream.readValue();
            switch (tag) {
                case 24345: {
                    this.parseIssuingAuthority(value);
                    break;
                }
                case 24358: {
                    this.parseDateOfIssue(value);
                    break;
                }
                case 24346: {
                    this.parseNameOfOtherPerson(value);
                    break;
                }
                case 24347: {
                    this.parseEndorsementsAndObservations(value);
                    break;
                }
                case 24348: {
                    this.parseTaxOrExitRequirements(value);
                    break;
                }
                case 24349: {
                    this.parseImageOfFront(value);
                    break;
                }
                case 24350: {
                    this.parseImageOfRear(value);
                    break;
                }
                case 24405: {
                    this.parseDateAndTimeOfPersonalization(value);
                    break;
                }
                case 24406: {
                    this.parsePersonalizationSystemSerialNumber(value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown field tag in DG12: " + Integer.toHexString(tag));
                }
            }
        }
    }

    public String getIssuingAuthority() {
        return this.issuingAuthority;
    }

    public String getDateOfIssue() {
        return this.dateOfIssue;
    }

    public List<String> getNamesOfOtherPersons() {
        return this.namesOfOtherPersons;
    }

    public String getEndorsementsAndObservations() {
        return this.endorsementsAndObservations;
    }

    public String getTaxOrExitRequirements() {
        return this.taxOrExitRequirements;
    }

    public byte[] getImageOfFront() {
        return this.imageOfFront;
    }

    public byte[] getImageOfRear() {
        return this.imageOfRear;
    }

    public String getDateAndTimeOfPersonalization() {
        return this.dateAndTimeOfPersonalization;
    }

    public String getPersonalizationSystemSerialNumber() {
        return this.personalizationSystemSerialNumber;
    }

    @Override
    public int getTag() {
        return 108;
    }

    @Override
    public String toString() {
        return "DG12File [" + (this.issuingAuthority == null ? "" : this.issuingAuthority) + ", " + (this.dateOfIssue == null ? "" : this.dateOfIssue) + ", " + (this.namesOfOtherPersons == null || this.namesOfOtherPersons.isEmpty() ? "" : this.namesOfOtherPersons) + ", " + (this.endorsementsAndObservations == null ? "" : this.endorsementsAndObservations) + ", " + (this.taxOrExitRequirements == null ? "" : this.taxOrExitRequirements) + ", " + (this.imageOfFront == null ? "" : "image (" + this.imageOfFront.length + ")") + ", " + (this.imageOfRear == null ? "" : "image (" + this.imageOfRear.length + ")") + ", " + (this.dateAndTimeOfPersonalization == null ? "" : this.dateAndTimeOfPersonalization) + ", " + (this.personalizationSystemSerialNumber == null ? "" : this.personalizationSystemSerialNumber) + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        DG12File other = (DG12File)obj;
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return 13 * this.toString().hashCode() + 112;
    }

    private void parsePersonalizationSystemSerialNumber(byte[] value) {
        String field = new String(value, StandardCharsets.UTF_8);
        this.personalizationSystemSerialNumber = field.trim();
    }

    private void parseDateAndTimeOfPersonalization(byte[] value) {
        String field = new String(value, StandardCharsets.UTF_8);
        this.dateAndTimeOfPersonalization = field.trim();
    }

    private void parseImageOfFront(byte[] value) {
        this.imageOfFront = value;
    }

    private void parseImageOfRear(byte[] value) {
        this.imageOfRear = value;
    }

    private void parseTaxOrExitRequirements(byte[] value) {
        String field = new String(value, StandardCharsets.UTF_8);
        this.taxOrExitRequirements = field.trim();
    }

    private void parseEndorsementsAndObservations(byte[] value) {
        String field = new String(value, StandardCharsets.UTF_8);
        this.endorsementsAndObservations = field.trim();
    }

    private synchronized void parseNameOfOtherPerson(byte[] value) {
        if (this.namesOfOtherPersons == null) {
            this.namesOfOtherPersons = new ArrayList<String>();
        }
        String field = new String(value, StandardCharsets.UTF_8);
        this.namesOfOtherPersons.add(field.trim());
    }

    private void parseDateOfIssue(byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("Wrong date format");
        }
        if (value.length == 8) {
            String dateString = new String(value, StandardCharsets.UTF_8);
            this.dateOfIssue = dateString.trim();
            return;
        }
        LOGGER.warning("DG12 date of issue is not in expected ccyymmdd ASCII format");
        if (value.length == 4) {
            String dateString = Hex.bytesToHexString((byte[])value);
            this.dateOfIssue = dateString.trim();
            return;
        }
        throw new IllegalArgumentException("Wrong date format");
    }

    private void parseIssuingAuthority(byte[] value) {
        String field = new String(value, StandardCharsets.UTF_8);
        this.issuingAuthority = field.trim();
    }
}

