/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.protocol;

import java.io.Serializable;
import java.security.PublicKey;
import java.util.Arrays;
import nashid.verify.sdk.id_card.jmrtd.Util;
import net.sf.scuba.util.Hex;

public class AAResult
implements Serializable {
    private static final long serialVersionUID = 8800803919646625713L;
    private final PublicKey publicKey;
    private final String digestAlgorithm;
    private final String signatureAlgorithm;
    private final byte[] challenge;
    private final byte[] response;

    public AAResult(PublicKey publicKey, String digestAlgorithm, String signatureAlgorithm, byte[] challenge, byte[] response) {
        this.publicKey = publicKey;
        this.digestAlgorithm = digestAlgorithm;
        this.signatureAlgorithm = signatureAlgorithm;
        this.challenge = challenge;
        this.response = response;
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    public byte[] getResponse() {
        return this.response;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String toString() {
        return "AAResult [publicKey: " + Util.getDetailedPublicKeyAlgorithm(this.publicKey) + ", digestAlgorithm: " + this.digestAlgorithm + ", signatureAlgorithm: " + this.signatureAlgorithm + ", challenge: " + Hex.bytesToHexString((byte[])this.challenge) + ", response: " + Hex.bytesToHexString((byte[])this.response);
    }

    public int hashCode() {
        int prime = 1991;
        int result2 = 1234567891;
        result2 = 1991 * result2 + Arrays.hashCode(this.challenge);
        result2 = 1991 * result2 + (this.digestAlgorithm == null ? 0 : this.digestAlgorithm.hashCode());
        result2 = 1991 * result2 + (this.publicKey == null ? 0 : this.publicKey.hashCode());
        result2 = 1991 * result2 + Arrays.hashCode(this.response);
        result2 = 1991 * result2 + (this.signatureAlgorithm == null ? 0 : this.signatureAlgorithm.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AAResult other = (AAResult)obj;
        if (!Arrays.equals(this.challenge, other.challenge)) {
            return false;
        }
        if (this.digestAlgorithm == null ? other.digestAlgorithm != null : !this.digestAlgorithm.equals(other.digestAlgorithm)) {
            return false;
        }
        if (this.publicKey == null ? other.publicKey != null : !this.publicKey.equals(other.publicKey)) {
            return false;
        }
        if (!Arrays.equals(this.response, other.response)) {
            return false;
        }
        if (this.signatureAlgorithm == null) {
            return other.signatureAlgorithm == null;
        }
        return this.signatureAlgorithm.equals(other.signatureAlgorithm);
    }
}

