/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.protocol;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import nashid.verify.sdk.id_card.jmrtd.APDULevelEACCACapable;
import nashid.verify.sdk.id_card.jmrtd.Util;
import nashid.verify.sdk.id_card.jmrtd.lds.ChipAuthenticationInfo;
import nashid.verify.sdk.id_card.jmrtd.lds.SecurityInfo;
import nashid.verify.sdk.id_card.jmrtd.protocol.AESSecureMessagingWrapper;
import nashid.verify.sdk.id_card.jmrtd.protocol.DESedeSecureMessagingWrapper;
import nashid.verify.sdk.id_card.jmrtd.protocol.EACCAResult;
import nashid.verify.sdk.id_card.jmrtd.protocol.SecureMessagingWrapper;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.tlv.TLVUtil;

public class EACCAProtocol {
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private static final Provider BC_PROVIDER = Util.getBouncyCastleProvider();
    private static final int COMMAND_CHAINING_CHUNK_SIZE = 224;
    private final APDULevelEACCACapable service;
    private SecureMessagingWrapper wrapper;
    private final int maxTranceiveLength;
    private final boolean shouldCheckMAC;

    public EACCAProtocol(APDULevelEACCACapable service, SecureMessagingWrapper wrapper, int maxTranceiveLength, boolean shouldCheckMAC) {
        this.service = service;
        this.wrapper = wrapper;
        this.maxTranceiveLength = maxTranceiveLength;
        this.shouldCheckMAC = shouldCheckMAC;
    }

    public EACCAResult doCA(BigInteger keyId, String oid, String publicKeyOID, PublicKey piccPublicKey) throws CardServiceException {
        if (piccPublicKey == null) {
            throw new IllegalArgumentException("PICC public key is null");
        }
        String agreementAlg = ChipAuthenticationInfo.toKeyAgreementAlgorithm(oid);
        if (agreementAlg == null) {
            throw new IllegalArgumentException("Unknown agreement algorithm");
        }
        if (!"ECDH".equals(agreementAlg) && !"DH".equals(agreementAlg)) {
            throw new IllegalArgumentException("Unsupported agreement algorithm, expected ECDH or DH, found " + agreementAlg);
        }
        if (oid == null) {
            oid = EACCAProtocol.inferChipAuthenticationOIDfromPublicKeyOID(publicKeyOID);
        }
        try {
            AlgorithmParameterSpec params = null;
            if ("DH".equals(agreementAlg)) {
                DHPublicKey piccDHPublicKey = (DHPublicKey)piccPublicKey;
                params = piccDHPublicKey.getParams();
            } else if ("ECDH".equals(agreementAlg)) {
                ECPublicKey piccECPublicKey = (ECPublicKey)piccPublicKey;
                params = piccECPublicKey.getParams();
            }
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(agreementAlg, BC_PROVIDER);
            keyPairGenerator.initialize(params);
            KeyPair pcdKeyPair = keyPairGenerator.generateKeyPair();
            PublicKey pcdPublicKey = pcdKeyPair.getPublic();
            PrivateKey pcdPrivateKey = pcdKeyPair.getPrivate();
            EACCAProtocol.sendPublicKey(this.service, this.wrapper, oid, keyId, pcdPublicKey);
            byte[] keyHash = EACCAProtocol.getKeyHash(agreementAlg, pcdPublicKey);
            byte[] sharedSecret = EACCAProtocol.computeSharedSecret(agreementAlg, piccPublicKey, pcdPrivateKey);
            this.wrapper = EACCAProtocol.restartSecureMessaging(oid, sharedSecret, this.maxTranceiveLength, this.shouldCheckMAC);
            return new EACCAResult(keyId, piccPublicKey, keyHash, pcdPublicKey, pcdPrivateKey, this.wrapper);
        }
        catch (GeneralSecurityException e) {
            throw new CardServiceException("Security exception during Chip Authentication", (Throwable)e);
        }
    }

    public static void sendPublicKey(APDULevelEACCACapable service, SecureMessagingWrapper wrapper, String oid, BigInteger keyId, PublicKey pcdPublicKey) throws CardServiceException {
        String agreementAlg = ChipAuthenticationInfo.toKeyAgreementAlgorithm(oid);
        String cipherAlg = ChipAuthenticationInfo.toCipherAlgorithm(oid);
        byte[] keyData = EACCAProtocol.getKeyData(agreementAlg, pcdPublicKey);
        if (cipherAlg.startsWith("DESede")) {
            byte[] idData = null;
            if (keyId != null) {
                byte[] keyIdBytes = Util.i2os(keyId);
                idData = TLVUtil.wrapDO((int)132, (byte[])keyIdBytes);
            }
            service.sendMSEKAT(wrapper, TLVUtil.wrapDO((int)145, (byte[])keyData), idData);
        } else if (cipherAlg.startsWith("AES")) {
            service.sendMSESetATIntAuth(wrapper, oid, keyId);
            byte[] data = TLVUtil.wrapDO((int)128, (byte[])keyData);
            try {
                service.sendGeneralAuthenticate(wrapper, data, true);
            }
            catch (CardServiceException cse) {
                LOGGER.log(Level.WARNING, "Failed to send GENERAL AUTHENTICATE, falling back to command chaining", cse);
                List<byte[]> segments = Util.partition(224, data);
                int index = 0;
                for (byte[] segment : segments) {
                    service.sendGeneralAuthenticate(wrapper, segment, ++index >= segments.size());
                }
            }
        } else {
            throw new IllegalStateException("Cannot set up secure channel with cipher " + cipherAlg);
        }
    }

    public static byte[] computeSharedSecret(String agreementAlg, PublicKey piccPublicKey, PrivateKey pcdPrivateKey) throws NoSuchAlgorithmException, InvalidKeyException {
        KeyAgreement agreement = KeyAgreement.getInstance(agreementAlg, BC_PROVIDER);
        agreement.init(pcdPrivateKey);
        agreement.doPhase(piccPublicKey, true);
        return agreement.generateSecret();
    }

    public static SecureMessagingWrapper restartSecureMessaging(String oid, byte[] sharedSecret, int maxTranceiveLength, boolean shouldCheckMAC) throws GeneralSecurityException {
        String cipherAlg = ChipAuthenticationInfo.toCipherAlgorithm(oid);
        int keyLength = ChipAuthenticationInfo.toKeyLength(oid);
        SecretKey ksEnc = Util.deriveKey(sharedSecret, cipherAlg, keyLength, 1);
        SecretKey ksMac = Util.deriveKey(sharedSecret, cipherAlg, keyLength, 2);
        if (cipherAlg.startsWith("DESede")) {
            return new DESedeSecureMessagingWrapper(ksEnc, ksMac, maxTranceiveLength, shouldCheckMAC, 0L);
        }
        if (cipherAlg.startsWith("AES")) {
            return new AESSecureMessagingWrapper(ksEnc, ksMac, maxTranceiveLength, shouldCheckMAC, 0L);
        }
        throw new IllegalStateException("Unsupported cipher algorithm " + cipherAlg);
    }

    public SecureMessagingWrapper getWrapper() {
        return this.wrapper;
    }

    public static byte[] getKeyHash(String agreementAlg, PublicKey pcdPublicKey) throws NoSuchAlgorithmException {
        if ("DH".equals(agreementAlg)) {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(EACCAProtocol.getKeyData(agreementAlg, pcdPublicKey));
        }
        if ("ECDH".equals(agreementAlg)) {
            org.bouncycastle.jce.interfaces.ECPublicKey pcdECPublicKey = (org.bouncycastle.jce.interfaces.ECPublicKey)pcdPublicKey;
            byte[] t = Util.i2os(pcdECPublicKey.getQ().getAffineXCoord().toBigInteger());
            int keySize = (int)Math.ceil((double)pcdECPublicKey.getParameters().getCurve().getFieldSize() / 8.0);
            return Util.alignKeyDataToSize(t, keySize);
        }
        throw new IllegalArgumentException("Unsupported agreement algorithm " + agreementAlg);
    }

    private static byte[] getKeyData(String agreementAlg, PublicKey pcdPublicKey) {
        if ("DH".equals(agreementAlg)) {
            DHPublicKey pcdDHPublicKey = (DHPublicKey)pcdPublicKey;
            return Util.i2os(pcdDHPublicKey.getY());
        }
        if ("ECDH".equals(agreementAlg)) {
            org.bouncycastle.jce.interfaces.ECPublicKey pcdECPublicKey = (org.bouncycastle.jce.interfaces.ECPublicKey)pcdPublicKey;
            return pcdECPublicKey.getQ().getEncoded(false);
        }
        throw new IllegalArgumentException("Unsupported agreement algorithm " + agreementAlg);
    }

    private static String inferChipAuthenticationOIDfromPublicKeyOID(String publicKeyOID) {
        if (SecurityInfo.ID_PK_ECDH.equals(publicKeyOID)) {
            LOGGER.warning("Could not determine ChipAuthentication algorithm, defaulting to id-CA-ECDH-3DES-CBC-CBC");
            return SecurityInfo.ID_CA_ECDH_3DES_CBC_CBC;
        }
        if (SecurityInfo.ID_PK_DH.equals(publicKeyOID)) {
            LOGGER.warning("Could not determine ChipAuthentication algorithm, defaulting to id-CA-DH-3DES-CBC-CBC");
            return SecurityInfo.ID_CA_DH_3DES_CBC_CBC;
        }
        LOGGER.warning("No ChipAuthenticationInfo and unsupported ChipAuthenticationPublicKeyInfo public key OID " + publicKeyOID);
        return null;
    }
}

