/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.protocol;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.util.List;
import javax.crypto.interfaces.DHPublicKey;
import nashid.verify.sdk.id_card.jmrtd.APDULevelEACTACapable;
import nashid.verify.sdk.id_card.jmrtd.Util;
import nashid.verify.sdk.id_card.jmrtd.cert.CVCAuthorizationTemplate;
import nashid.verify.sdk.id_card.jmrtd.cert.CVCPrincipal;
import nashid.verify.sdk.id_card.jmrtd.cert.CardVerifiableCertificate;
import nashid.verify.sdk.id_card.jmrtd.lds.icao.MRZInfo;
import nashid.verify.sdk.id_card.jmrtd.protocol.EACCAResult;
import nashid.verify.sdk.id_card.jmrtd.protocol.EACTAResult;
import nashid.verify.sdk.id_card.jmrtd.protocol.PACEResult;
import nashid.verify.sdk.id_card.jmrtd.protocol.SecureMessagingWrapper;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.tlv.TLVOutputStream;
import net.sf.scuba.tlv.TLVUtil;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;

public class EACTAProtocol {
    private static final int TAG_CVCERTIFICATE_SIGNATURE = 24375;
    private static final Provider BC_PROVIDER = Util.getBouncyCastleProvider();
    private final APDULevelEACTACapable service;
    private final SecureMessagingWrapper wrapper;

    public EACTAProtocol(APDULevelEACTACapable service, SecureMessagingWrapper wrapper) {
        this.service = service;
        this.wrapper = wrapper;
    }

    public synchronized EACTAResult doEACTA(CVCPrincipal caReference, List<CardVerifiableCertificate> terminalCertificates, PrivateKey terminalKey, String taAlg, EACCAResult chipAuthenticationResult, String documentNumber) throws CardServiceException {
        byte[] idPICC = EACTAProtocol.deriveIdentifier(documentNumber);
        return this.doTA(caReference, terminalCertificates, terminalKey, taAlg, chipAuthenticationResult, idPICC);
    }

    public synchronized EACTAResult doTA(CVCPrincipal caReference, List<CardVerifiableCertificate> terminalCertificates, PrivateKey terminalKey, String taAlg, EACCAResult chipAuthenticationResult, PACEResult paceResult) throws CardServiceException {
        try {
            byte[] idPICC = EACTAProtocol.deriveIdentifier(paceResult);
            return this.doTA(caReference, terminalCertificates, terminalKey, taAlg, chipAuthenticationResult, idPICC);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CardServiceException("No such algorithm", (Throwable)e);
        }
    }

    public synchronized EACTAResult doTA(CVCPrincipal caReference, List<CardVerifiableCertificate> terminalCertificates, PrivateKey terminalKey, String taAlg, EACCAResult chipAuthenticationResult, byte[] idPICC) throws CardServiceException {
        try {
            CardVerifiableCertificate lastCert;
            CVCAuthorizationTemplate.Role lastCertRole;
            if (terminalCertificates == null || terminalCertificates.isEmpty()) {
                throw new IllegalArgumentException("Need at least 1 certificate to perform TA, found: " + terminalCertificates);
            }
            byte[] caKeyHash = chipAuthenticationResult.getKeyHash();
            if (caKeyHash == null) {
                throw new IllegalArgumentException("CA key hash is null");
            }
            CardVerifiableCertificate firstCert = terminalCertificates.get(0);
            CVCAuthorizationTemplate.Role firstCertRole = firstCert.getAuthorizationTemplate().getRole();
            if (CVCAuthorizationTemplate.Role.CVCA.equals((Object)firstCertRole)) {
                CVCPrincipal firstCertHolderReference = firstCert.getHolderReference();
                if (caReference != null && !caReference.equals(firstCertHolderReference)) {
                    throw new CardServiceException("First certificate holds wrong authority, found \"" + firstCertHolderReference.getName() + "\", expected \"" + caReference.getName() + "\"");
                }
                if (caReference == null) {
                    caReference = firstCertHolderReference;
                }
                terminalCertificates.remove(0);
            }
            CVCPrincipal firstCertAuthorityReference = firstCert.getAuthorityReference();
            if (caReference != null && !caReference.equals(firstCertAuthorityReference)) {
                throw new CardServiceException("First certificate not signed by expected CA, found " + firstCertAuthorityReference.getName() + ", expected " + caReference.getName());
            }
            if (caReference == null) {
                caReference = firstCertAuthorityReference;
            }
            if (!CVCAuthorizationTemplate.Role.IS.equals((Object)(lastCertRole = (lastCert = terminalCertificates.get(terminalCertificates.size() - 1)).getAuthorizationTemplate().getRole()))) {
                throw new CardServiceException("Last certificate in chain (" + lastCert.getHolderReference().getName() + ") does not have role IS, but has role " + (Object)((Object)lastCertRole));
            }
            CardVerifiableCertificate terminalCert = lastCert;
            for (CardVerifiableCertificate cert : terminalCertificates) {
                try {
                    CVCPrincipal authorityReference = cert.getAuthorityReference();
                    byte[] authorityRefBytes = TLVUtil.wrapDO((int)131, (byte[])authorityReference.getName().getBytes(StandardCharsets.ISO_8859_1));
                    this.service.sendMSESetDST(this.wrapper, authorityRefBytes);
                    byte[] body = cert.getCertBodyData();
                    byte[] signature = cert.getSignature();
                    ByteArrayOutputStream sigOut = new ByteArrayOutputStream();
                    TLVOutputStream tlvSigOut = new TLVOutputStream((OutputStream)sigOut);
                    tlvSigOut.writeTag(24375);
                    tlvSigOut.writeValue(signature);
                    tlvSigOut.close();
                    signature = sigOut.toByteArray();
                    this.service.sendPSOExtendedLengthMode(this.wrapper, body, signature);
                }
                catch (CardServiceException cse) {
                    throw cse;
                }
                catch (Exception e) {
                    throw new CardServiceException("Exception", (Throwable)e);
                }
            }
            if (terminalKey == null) {
                throw new CardServiceException("No terminal key");
            }
            CVCPrincipal holderRef = terminalCert.getHolderReference();
            byte[] holderRefBytes = TLVUtil.wrapDO((int)131, (byte[])holderRef.getName().getBytes(StandardCharsets.ISO_8859_1));
            this.service.sendMSESetATExtAuth(this.wrapper, holderRefBytes);
            byte[] rPICC = this.service.sendGetChallenge(this.wrapper);
            ByteArrayOutputStream dtbs = new ByteArrayOutputStream();
            dtbs.write(idPICC);
            dtbs.write(rPICC);
            dtbs.write(caKeyHash);
            dtbs.close();
            byte[] dtbsBytes = dtbs.toByteArray();
            String sigAlg = terminalCert.getSigAlgName();
            if (sigAlg == null) {
                throw new IllegalStateException("Could not determine signature algorithm for terminal certificate " + terminalCert.getHolderReference().getName());
            }
            Signature sig = Signature.getInstance(sigAlg, BC_PROVIDER);
            sig.initSign(terminalKey);
            sig.update(dtbsBytes);
            byte[] signedData = sig.sign();
            if (sigAlg.toUpperCase().endsWith("ECDSA")) {
                int keySize = (int)Math.ceil((double)((ECPrivateKey)terminalKey).getParameters().getCurve().getFieldSize() / 8.0);
                signedData = Util.getRawECDSASignature(signedData, keySize);
            }
            this.service.sendMutualAuthenticate(this.wrapper, signedData);
            return new EACTAResult(chipAuthenticationResult, caReference, terminalCertificates, terminalKey, null, rPICC);
        }
        catch (CardServiceException cse) {
            throw cse;
        }
        catch (Exception e) {
            throw new CardServiceException("Exception", (Throwable)e);
        }
    }

    private static byte[] deriveIdentifier(String documentNumber) {
        int documentNumberLength = documentNumber.length();
        byte[] idPICC = new byte[documentNumberLength + 1];
        System.arraycopy(documentNumber.getBytes(StandardCharsets.ISO_8859_1), 0, idPICC, 0, documentNumberLength);
        idPICC[documentNumberLength] = (byte)MRZInfo.checkDigit(documentNumber);
        return idPICC;
    }

    private static byte[] deriveIdentifier(PACEResult paceResult) throws NoSuchAlgorithmException {
        String agreementAlg = paceResult.getAgreementAlg();
        PublicKey pcdPublicKey = paceResult.getPICCPublicKey();
        if ("DH".equals(agreementAlg)) {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(EACTAProtocol.getKeyData(agreementAlg, pcdPublicKey));
        }
        if ("ECDH".equals(agreementAlg)) {
            ECPublicKey pcdECPublicKey = (ECPublicKey)pcdPublicKey;
            byte[] t = Util.i2os(pcdECPublicKey.getQ().getAffineXCoord().toBigInteger());
            return Util.alignKeyDataToSize(t, (int)Math.ceil((double)pcdECPublicKey.getParameters().getCurve().getFieldSize() / 8.0));
        }
        throw new NoSuchAlgorithmException("Unsupported agreement algorithm " + agreementAlg);
    }

    private static byte[] getKeyData(String agreementAlg, PublicKey pcdPublicKey) {
        if ("DH".equals(agreementAlg)) {
            DHPublicKey pcdDHPublicKey = (DHPublicKey)pcdPublicKey;
            return Util.i2os(pcdDHPublicKey.getY());
        }
        if ("ECDH".equals(agreementAlg)) {
            ECPublicKey pcdECPublicKey = (ECPublicKey)pcdPublicKey;
            return pcdECPublicKey.getQ().getEncoded(false);
        }
        throw new IllegalArgumentException("Unsupported agreement algorithm " + agreementAlg);
    }
}

