/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nashid.verify.sdk.id_card.jmrtd.Util;
import nashid.verify.sdk.id_card.jmrtd.WrappedAPDUEvent;
import net.sf.scuba.smartcards.APDUEvent;
import net.sf.scuba.smartcards.APDUListener;
import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;
import net.sf.scuba.util.Hex;

public class SecureMessagingAPDUSender {
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd.protocol");
    private final CardService service;
    private int apduCount;

    public SecureMessagingAPDUSender(CardService service) {
        this.service = service;
        this.apduCount = 0;
    }

    public ResponseAPDU transmit(APDUWrapper wrapper, CommandAPDU commandAPDU) throws CardServiceException {
        ResponseAPDU responseAPDU;
        CommandAPDU plainCapdu = commandAPDU;
        if (wrapper != null) {
            commandAPDU = wrapper.wrap(commandAPDU);
        }
        ResponseAPDU rawRapdu = responseAPDU = this.service.transmit(commandAPDU);
        short sw = (short)responseAPDU.getSW();
        if (wrapper == null) {
            this.notifyExchangedAPDU(new APDUEvent((Object)this, (Serializable)((Object)"PLAIN"), ++this.apduCount, commandAPDU, responseAPDU));
        } else {
            try {
                if (responseAPDU.getBytes().length <= 2) {
                    throw new CardServiceException("Exception during transmission of wrapped APDU, C=" + Hex.bytesToHexString((byte[])plainCapdu.getBytes()), (int)sw);
                }
                responseAPDU = wrapper.unwrap(responseAPDU);
            }
            catch (CardServiceException cse) {
                throw cse;
            }
            catch (Exception e) {
                throw new CardServiceException("Exception during transmission of wrapped APDU, C=" + Hex.bytesToHexString((byte[])plainCapdu.getBytes()), (Throwable)e, (int)sw);
            }
            finally {
                this.notifyExchangedAPDU(new WrappedAPDUEvent(this, (Serializable)((Object)wrapper.getType()), ++this.apduCount, plainCapdu, responseAPDU, commandAPDU, rawRapdu));
            }
        }
        return responseAPDU;
    }

    public boolean isExtendedAPDULengthSupported() {
        return this.service.isExtendedAPDULengthSupported();
    }

    public void addAPDUListener(APDUListener l) {
        this.service.addAPDUListener(l);
    }

    public void removeAPDUListener(APDUListener l) {
        this.service.removeAPDUListener(l);
    }

    protected void notifyExchangedAPDU(APDUEvent event) {
        Collection apduListeners = this.service.getAPDUListeners();
        if (apduListeners == null || apduListeners.isEmpty()) {
            return;
        }
        for (APDUListener listener : apduListeners) {
            listener.exchangedAPDU(event);
        }
    }

    private List<ResponseAPDU> sendUsingCommandChaining(CommandAPDU commandAPDU, int chunkSize) throws CardServiceException {
        byte[] data = commandAPDU.getData();
        List<byte[]> segments = Util.partition(chunkSize, data);
        ArrayList<ResponseAPDU> responseAPDUs = new ArrayList<ResponseAPDU>(segments.size());
        int index = 0;
        for (byte[] segment : segments) {
            boolean isLast = ++index >= segments.size();
            int cla = commandAPDU.getCLA();
            if (!isLast) {
                cla |= 0x10;
            }
            CommandAPDU partialCommandAPDU = new CommandAPDU(cla, commandAPDU.getINS(), commandAPDU.getP1(), commandAPDU.getP2(), segment, commandAPDU.getNe());
            ResponseAPDU responseAPDU = this.service.transmit(partialCommandAPDU);
            responseAPDUs.add(responseAPDU);
        }
        return responseAPDUs;
    }

    private byte[] continueSendingUsingResponseChaining(APDUWrapper wrapper, short sw, byte[] data) throws CardServiceException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            while ((sw & 0xFF00) == 24832) {
                byteArrayOutputStream.write(data);
                int remainingLength = sw & 0xFF;
                if (remainingLength <= 0) break;
                CommandAPDU capdu = new CommandAPDU(0, -64, 0, 0, remainingLength);
                ResponseAPDU rapdu = this.transmit(wrapper, capdu);
                data = rapdu.getData();
                sw = (short)rapdu.getSW();
            }
            byte[] remainingLength = byteArrayOutputStream.toByteArray();
            return remainingLength;
        }
        catch (IOException ioe) {
            throw new CardServiceException("Could not write to stream", (Throwable)ioe, (int)sw);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FINE, "Error closing stream", ioe);
            }
        }
    }
}

