/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.omn;

import android.app.Activity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import nashid.verify.sdk.id_card.jmrtd.AbstractMRTDCardService;
import nashid.verify.sdk.id_card.jmrtd.AccessKeySpec;
import nashid.verify.sdk.id_card.jmrtd.BACKeySpec;
import nashid.verify.sdk.id_card.jmrtd.DefaultFileSystem;
import nashid.verify.sdk.id_card.jmrtd.cert.CVCPrincipal;
import nashid.verify.sdk.id_card.jmrtd.cert.CardVerifiableCertificate;
import nashid.verify.sdk.id_card.jmrtd.protocol.AAAPDUSender;
import nashid.verify.sdk.id_card.jmrtd.protocol.AAProtocol;
import nashid.verify.sdk.id_card.jmrtd.protocol.AAResult;
import nashid.verify.sdk.id_card.jmrtd.protocol.BACAPDUSender;
import nashid.verify.sdk.id_card.jmrtd.protocol.BACProtocol;
import nashid.verify.sdk.id_card.jmrtd.protocol.BACResult;
import nashid.verify.sdk.id_card.jmrtd.protocol.EACCAAPDUSender;
import nashid.verify.sdk.id_card.jmrtd.protocol.EACCAProtocol;
import nashid.verify.sdk.id_card.jmrtd.protocol.EACCAResult;
import nashid.verify.sdk.id_card.jmrtd.protocol.EACTAAPDUSender;
import nashid.verify.sdk.id_card.jmrtd.protocol.EACTAProtocol;
import nashid.verify.sdk.id_card.jmrtd.protocol.EACTAResult;
import nashid.verify.sdk.id_card.jmrtd.protocol.PACEAPDUSender;
import nashid.verify.sdk.id_card.jmrtd.protocol.PACEProtocol;
import nashid.verify.sdk.id_card.jmrtd.protocol.PACEResult;
import nashid.verify.sdk.id_card.jmrtd.protocol.ReadBinaryAPDUSender;
import nashid.verify.sdk.id_card.jmrtd.protocol.SecureMessagingWrapper;
import net.sf.scuba.smartcards.APDUListener;
import net.sf.scuba.smartcards.CardFileInputStream;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.FileSystemStructured;
import net.sf.scuba.smartcards.ResponseAPDU;
import net.sf.scuba.util.Hex;

public class OmanCardService
extends AbstractMRTDCardService {
    private static final String TAG = "OmanCardService";
    public static final byte NO_PACE_KEY_REFERENCE = 0;
    public static final byte MRZ_PACE_KEY_REFERENCE = 1;
    public static final byte CAN_PACE_KEY_REFERENCE = 2;
    public static final byte PIN_PACE_KEY_REFERENCE = 3;
    public static final byte PUK_PACE_KEY_REFERENCE = 4;
    private static final Logger LOGGER = Logger.getLogger("org.nashident");
    public static final short EF_CARD_ACCESS = 284;
    public static final short EF_CARD_SECURITY = 285;
    public static final short EF_DG1 = 513;
    public static final short EF_DG2 = 514;
    public static final short EF_DG3 = 515;
    public static final short EF_DG4 = 516;
    public static final short EF_DG5 = 517;
    public static final short EF_DG6 = 518;
    public static final short EF_DG7 = 519;
    public static final short EF_DG8 = 520;
    public static final short EF_DG9 = 521;
    public static final short EF_DG10 = 522;
    public static final short EF_DG11 = 523;
    public static final short EF_DG12 = 524;
    public static final short EF_DG13 = 525;
    public static final short EF_DG14 = 526;
    public static final short EF_DG15 = 527;
    public static final short EF_DG16 = 528;
    public static final short EF_SOD = 541;
    public static final short EF_COM = 542;
    public static final short EF_CVCA = 284;
    public static final byte SFI_CARD_ACCESS = 28;
    public static final byte SFI_CARD_SECURITY = 29;
    public static final byte SFI_DG1 = 1;
    public static final byte SFI_DG2 = 2;
    public static final byte SFI_DG3 = 3;
    public static final byte SFI_DG4 = 4;
    public static final byte SFI_DG5 = 5;
    public static final byte SFI_DG6 = 6;
    public static final byte SFI_DG7 = 7;
    public static final byte SFI_DG8 = 8;
    public static final byte SFI_DG9 = 9;
    public static final byte SFI_DG10 = 10;
    public static final byte SFI_DG11 = 11;
    public static final byte SFI_DG12 = 12;
    public static final byte SFI_DG13 = 13;
    public static final byte SFI_DG14 = 14;
    public static final byte SFI_DG15 = 15;
    public static final byte SFI_DG16 = 16;
    public static final byte SFI_COM = 30;
    public static final byte SFI_SOD = 29;
    public static final byte SFI_CVCA = 28;
    public static final int DEFAULT_MAX_BLOCKSIZE = 224;
    public static final int NORMAL_MAX_TRANCEIVE_LENGTH = 256;
    public static final int EXTENDED_MAX_TRANCEIVE_LENGTH = 65536;
    protected static final byte[] APPLET_AID = new byte[]{-96, 0, 0, 0, 24, 82, 79, 80, 1, 1};
    private final int maxBlockSize;
    private boolean isOpen;
    private SecureMessagingWrapper wrapper;
    private final int maxTranceiveLength;
    private final boolean shouldCheckMAC;
    private boolean isAppletSelected;
    private final DefaultFileSystem appletFileSystem;
    private final BACAPDUSender bacSender;
    private final PACEAPDUSender paceSender;
    private final AAAPDUSender aaSender;
    private final EACCAAPDUSender eacCASender;
    private final EACTAAPDUSender eacTASender;
    private final ReadBinaryAPDUSender readBinarySender;
    private final CardService service;

    public OmanCardService(CardService service, int maxTranceiveLength, int maxBlockSize, boolean isSFIEnabled, boolean shouldCheckMAC) {
        this.service = service;
        this.bacSender = new BACAPDUSender(service);
        this.paceSender = new PACEAPDUSender(service);
        this.aaSender = new AAAPDUSender(service);
        this.eacCASender = new EACCAAPDUSender(service);
        this.eacTASender = new EACTAAPDUSender(service);
        this.readBinarySender = new ReadBinaryAPDUSender(service);
        this.maxTranceiveLength = maxTranceiveLength;
        this.maxBlockSize = maxBlockSize;
        this.shouldCheckMAC = shouldCheckMAC;
        this.isAppletSelected = false;
        this.isOpen = false;
        this.appletFileSystem = new DefaultFileSystem(this.readBinarySender, isSFIEnabled);
    }

    public OmanCardService(CardService service) {
        this.service = service;
        this.bacSender = new BACAPDUSender(service);
        this.paceSender = new PACEAPDUSender(service);
        this.aaSender = new AAAPDUSender(service);
        this.eacCASender = new EACCAAPDUSender(service);
        this.eacTASender = new EACTAAPDUSender(service);
        this.readBinarySender = new ReadBinaryAPDUSender(service);
        this.maxTranceiveLength = 256;
        this.maxBlockSize = 224;
        this.shouldCheckMAC = false;
        this.isAppletSelected = true;
        this.isOpen = false;
        this.appletFileSystem = new DefaultFileSystem(this.readBinarySender, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws CardServiceException {
        if (this.isOpen()) {
            return;
        }
        OmanCardService omanCardService = this;
        synchronized (omanCardService) {
            this.service.open();
            this.isOpen = true;
        }
    }

    public static String hex(byte[] bytes) {
        StringBuilder result2 = new StringBuilder();
        for (byte aByte : bytes) {
            result2.append(String.format("%02x", aByte));
        }
        return result2.toString();
    }

    @Override
    public void sendSelectApplet(boolean hasPACESucceeded) throws CardServiceException {
        if (this.isAppletSelected) {
            LOGGER.info("OmanCardService:Re-selecting ICAO applet");
        }
        if (hasPACESucceeded) {
            this.readBinarySender.sendSelectApplet(this.wrapper, APPLET_AID);
        } else {
            this.readBinarySender.sendSelectApplet(null, APPLET_AID);
        }
        this.isAppletSelected = true;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public synchronized BACResult doBAC(AccessKeySpec bacKey) throws CardServiceException {
        if (!(bacKey instanceof BACKeySpec)) {
            throw new IllegalArgumentException("Unsupported key type");
        }
        BACResult bacResult = new BACProtocol(this.bacSender, this.maxTranceiveLength, this.shouldCheckMAC).doBAC(bacKey);
        this.wrapper = bacResult.getWrapper();
        this.appletFileSystem.setWrapper(this.wrapper);
        return bacResult;
    }

    @Override
    public synchronized BACResult doBAC(SecretKey kEnc, SecretKey kMac) throws CardServiceException, GeneralSecurityException {
        BACResult bacResult = new BACProtocol(this.bacSender, this.maxTranceiveLength, this.shouldCheckMAC).doBAC(kEnc, kMac);
        this.wrapper = bacResult.getWrapper();
        this.appletFileSystem.setWrapper(this.wrapper);
        return bacResult;
    }

    @Override
    public synchronized PACEResult doPACE(AccessKeySpec keySpec, String oid, AlgorithmParameterSpec params) throws CardServiceException {
        PACEResult paceResult = new PACEProtocol(this.paceSender, this.wrapper, this.maxTranceiveLength, this.shouldCheckMAC).doPACE(keySpec, oid, params);
        this.wrapper = paceResult.getWrapper();
        this.appletFileSystem.setWrapper(this.wrapper);
        return paceResult;
    }

    @Override
    public synchronized EACCAResult doEACCA(BigInteger keyId, String oid, String publicKeyOID, PublicKey publicKey) throws CardServiceException {
        EACCAResult caResult = new EACCAProtocol(this.eacCASender, this.wrapper, this.maxTranceiveLength, this.shouldCheckMAC).doCA(keyId, oid, publicKeyOID, publicKey);
        this.wrapper = caResult.getWrapper();
        this.appletFileSystem.setWrapper(this.wrapper);
        return caResult;
    }

    @Override
    public synchronized EACTAResult doEACTA(CVCPrincipal caReference, List<CardVerifiableCertificate> terminalCertificates, PrivateKey terminalKey, String taAlg, EACCAResult chipAuthenticationResult, String documentNumber) throws CardServiceException {
        return new EACTAProtocol(this.eacTASender, this.wrapper).doEACTA(caReference, terminalCertificates, terminalKey, taAlg, chipAuthenticationResult, documentNumber);
    }

    @Override
    public synchronized EACTAResult doEACTA(CVCPrincipal caReference, List<CardVerifiableCertificate> terminalCertificates, PrivateKey terminalKey, String taAlg, EACCAResult chipAuthenticationResult, PACEResult paceResult) throws CardServiceException {
        return new EACTAProtocol(this.eacTASender, this.wrapper).doTA(caReference, terminalCertificates, terminalKey, taAlg, chipAuthenticationResult, paceResult);
    }

    @Override
    public AAResult doAA(PublicKey publicKey, String digestAlgorithm, String signatureAlgorithm, byte[] challenge) throws CardServiceException {
        return new AAProtocol(this.aaSender, this.wrapper).doAA(publicKey, digestAlgorithm, signatureAlgorithm, challenge);
    }

    public void close() {
        try {
            this.service.close();
            this.wrapper = null;
        }
        finally {
            this.isOpen = false;
        }
    }

    public int getMaxTranceiveLength() {
        return this.maxTranceiveLength;
    }

    @Override
    public SecureMessagingWrapper getWrapper() {
        return this.wrapper;
    }

    public ResponseAPDU transmit(CommandAPDU commandAPDU) throws CardServiceException {
        return this.service.transmit(commandAPDU);
    }

    public byte[] getATR() throws CardServiceException {
        return this.service.getATR();
    }

    public boolean isConnectionLost(Exception e) {
        return this.service.isConnectionLost(e);
    }

    public boolean shouldCheckMAC() {
        return this.shouldCheckMAC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CardFileInputStream getInputStream(short fid) throws CardServiceException {
        if (!this.isAppletSelected) {
            throw new CardServiceException("Applet is not selected");
        }
        DefaultFileSystem defaultFileSystem = this.appletFileSystem;
        synchronized (defaultFileSystem) {
            this.appletFileSystem.selectFile(fid);
            return new CardFileInputStream(this.maxBlockSize, (FileSystemStructured)this.appletFileSystem);
        }
    }

    public void addAPDUListener(APDUListener l) {
        this.service.addAPDUListener(l);
    }

    public void removeAPDUListener(APDUListener l) {
        this.service.removeAPDUListener(l);
    }

    public static int parseFileSize(byte[] param1ArrayOfbyte, int param1Int) {
        if (param1Int > 4) {
            return 0;
        }
        int i = 0;
        for (int b = 0; b < param1Int; b = (int)((byte)(b + 1))) {
            i = i << 8 | param1ArrayOfbyte[b] & 0xFF;
        }
        return i;
    }

    public byte[] readFile(short s) throws CardServiceException, IOException {
        int i = 4;
        CommandAPDU commandAPDU = new CommandAPDU(new byte[]{0, -92, 0, 0, 2, 2, (byte)s});
        ResponseAPDU transmit = this.service.transmit(commandAPDU);
        if (transmit != null) {
            byte[] data = transmit.getData();
            short sw = (short)transmit.getSW();
            String sb = "CAPDU = " + Hex.bytesToHexString((byte[])commandAPDU.getBytes()) + ", RAPDU = " + Hex.bytesToHexString((byte[])transmit.getBytes());
            if ((sw & 0x6700) == 26368 && data.length == 0) {
                throw new CardServiceException("Wrong length, " + sb, (int)sw);
            }
            if (sw != -28672) {
                if (sw != 25218) {
                    if (sw != 27010) {
                        if (sw == 27266) {
                            throw new CardServiceException("File not found, " + sb, (int)sw);
                        }
                        if (sw != 27013 && sw != 27014) {
                            throw new CardServiceException("Error occured, " + sb, (int)sw);
                        }
                    }
                    throw new CardServiceException("Access to file denied, " + sb, (int)sw);
                }
                if (data.length == 0) {
                    throw new CardServiceException("End of file, " + sb, (int)sw);
                }
            }
            int a = OmanCardService.parseFileSize(this.readBinarySender.sendReadBinary(this.wrapper, 0, 2, 2, false, false), 2) + 4;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (i < a) {
                int i2 = i + 230 > a ? a - i : 230;
                try {
                    byteArrayOutputStream.write(this.readBinarySender.sendReadBinary(this.wrapper, 0, i, i2, false, false));
                    i += i2;
                }
                catch (Throwable th) {
                    th.addSuppressed(th);
                }
            }
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byteArray;
        }
        throw new CardServiceException("No response APDU");
    }

    public byte[] readFile(Activity context, short s) throws CardServiceException, IOException {
        int i = 4;
        CommandAPDU commandAPDU = new CommandAPDU(new byte[]{0, -92, 0, 0, 2, 2, (byte)s});
        ResponseAPDU transmit = this.service.transmit(commandAPDU);
        if (transmit != null) {
            byte[] data = transmit.getData();
            short sw = (short)transmit.getSW();
            String sb = "CAPDU = " + Hex.bytesToHexString((byte[])commandAPDU.getBytes()) + ", RAPDU = " + Hex.bytesToHexString((byte[])transmit.getBytes());
            if ((sw & 0x6700) == 26368 && data.length == 0) {
                throw new CardServiceException("Wrong length, " + sb, (int)sw);
            }
            if (sw != -28672) {
                if (sw != 25218) {
                    if (sw != 27010) {
                        if (sw == 27266) {
                            throw new CardServiceException("File not found, " + sb, (int)sw);
                        }
                        if (sw != 27013 && sw != 27014) {
                            throw new CardServiceException("Error occured, " + sb, (int)sw);
                        }
                    }
                    throw new CardServiceException("Access to file denied, " + sb, (int)sw);
                }
                if (data.length == 0) {
                    throw new CardServiceException("End of file, " + sb, (int)sw);
                }
            }
            int a = OmanCardService.parseFileSize(this.readBinarySender.sendReadBinary(this.wrapper, 0, 2, 2, false, false), 2) + 4;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (i < a) {
                int i2 = i + 230 > a ? a - i : 230;
                try {
                    byteArrayOutputStream.write(this.readBinarySender.sendReadBinary(this.wrapper, 0, i, i2, false, false));
                    i += i2;
                }
                catch (Throwable th) {
                    th.addSuppressed(th);
                }
            }
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byteArray;
        }
        throw new CardServiceException("No response APDU");
    }
}

