/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.mrtd2.activity;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nashid.verify.sdk.internetutility.ErrorUtility;
import nashid.verify.sdk.mrtd2.locale.LocaleUtil;
import nashid.verify.sdk.mrtd2.locale.Storage;
import nashid.verify.sdk.utility.OnInternetAvailabilityListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0017J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\u0012\u0010\u001b\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u0015H\u0014J\b\u0010\u001f\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020\u0015H\u0014J\b\u0010!\u001a\u00020\u0015H\u0002J\b\u0010\"\u001a\u00020\u0015H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lnashid/verify/sdk/mrtd2/activity/BaseActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lnashid/verify/sdk/utility/OnInternetAvailabilityListener;", "()V", "isInternetAvailable", "", "()Z", "setInternetAvailable", "(Z)V", "oldPrefLocaleCode", "", "storage", "Lnashid/verify/sdk/mrtd2/locale/Storage;", "getStorage", "()Lnashid/verify/sdk/mrtd2/locale/Storage;", "setStorage", "(Lnashid/verify/sdk/mrtd2/locale/Storage;)V", "tag", "getTag", "()Ljava/lang/String;", "attachBaseContext", "", "newBase", "Landroid/content/Context;", "getPreferredLocale", "context", "onAvailable", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onLost", "onResume", "resetTitle", "updateLayoutDirection", "IDV_release"})
public class BaseActivity
extends AppCompatActivity
implements OnInternetAvailabilityListener {
    public Storage storage;
    private String oldPrefLocaleCode;
    private boolean isInternetAvailable = true;
    @NotNull
    private final String tag;

    public BaseActivity() {
        this.tag = "BaseActivity";
    }

    @NotNull
    public final Storage getStorage() {
        Storage storage = this.storage;
        if (storage != null) {
            return storage;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"storage");
        return null;
    }

    public final void setStorage(@NotNull Storage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"<set-?>");
        this.storage = storage;
    }

    public final boolean isInternetAvailable() {
        return this.isInternetAvailable;
    }

    public final void setInternetAvailable(boolean bl) {
        this.isInternetAvailable = bl;
    }

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    @NotNull
    public final String getPreferredLocale(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.storage == null) {
            this.setStorage(new Storage(context));
        }
        return this.getStorage().getPreferredLocale();
    }

    @Override
    public void onAvailable() {
        Log.d((String)this.tag, (String)"onAvailable: ");
        this.isInternetAvailable = true;
    }

    @Override
    public void onLost() {
        this.isInternetAvailable = false;
        ErrorUtility.getInstance().showNoInternetDialog((FragmentActivity)this, !this.isFinishing() && !this.isDestroyed());
    }

    protected void onDestroy() {
        super.onDestroy();
        ErrorUtility.getInstance().unregisterConnectivityManager((Activity)this);
    }

    private final void resetTitle() {
        try {
            int label = this.getPackageManager().getActivityInfo((ComponentName)this.getComponentName(), (int)128).labelRes;
            if (label != 0) {
                this.setTitle(label);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected void attachBaseContext(@NotNull Context newBase) {
        Intrinsics.checkNotNullParameter((Object)newBase, (String)"newBase");
        this.getPreferredLocale(newBase);
        this.oldPrefLocaleCode = new Storage(newBase).getPreferredLocale();
        String string2 = this.oldPrefLocaleCode;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"oldPrefLocaleCode");
            string2 = null;
        }
        this.applyOverrideConfiguration(LocaleUtil.Companion.getLocalizedConfiguration(string2));
        super.attachBaseContext(newBase);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.isInternetAvailable = ErrorUtility.getInstance().registerConnectivityManager((Activity)this, this);
        this.resetTitle();
        this.updateLayoutDirection();
    }

    private final void updateLayoutDirection() {
        Configuration config = this.getResources().getConfiguration();
        if (Build.VERSION.SDK_INT >= 17) {
            if (config.getLayoutDirection() == 1) {
                this.getWindow().getDecorView().setLayoutDirection(1);
            } else {
                this.getWindow().getDecorView().setLayoutDirection(0);
            }
        }
    }

    protected void onResume() {
        String currentLocaleCode = new Storage((Context)this).getPreferredLocale();
        String string2 = this.oldPrefLocaleCode;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"oldPrefLocaleCode");
            string2 = null;
        }
        if (!Intrinsics.areEqual((Object)string2, (Object)currentLocaleCode)) {
            this.recreate();
            this.oldPrefLocaleCode = currentLocaleCode;
        }
        super.onResume();
        this.isInternetAvailable = ErrorUtility.getInstance().registerConnectivityManager((Activity)this, this);
    }
}

