/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.mrtd2.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import java.util.List;
import nashid.verify.sdk.OtherConstant;
import nashid.verify.sdk.R;
import nashid.verify.sdk.Utility;
import nashid.verify.sdk.databinding.ActivityStartScanningBinding;
import nashid.verify.sdk.mrtd2.activity.BaseActivity;
import nashid.verify.sdk.mrtd2.activity.CameraXLivePreviewActivity;
import nashid.verify.sdk.mrtd2.activity.SDKSettingScreen;
import nashid.verify.sdk.mrtd2.activity.TextSizeConverter;
import nashid.verify.sdk.mrtd2.rooted.RootedCheck;
import nashid.verify.sdk.utility.PermissionHelper;
import nashid.verify.sdk.utility.SharePreferenceUtility;

public class StartScanningActivity
extends BaseActivity {
    private ActivityStartScanningBinding activityStartScanningBinding;
    private String selectedDoc;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.activityStartScanningBinding = ActivityStartScanningBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.activityStartScanningBinding.getRoot());
        RootedCheck.getInstance().setFlag((Activity)this);
        if (RootedCheck.getInstance().isRootedDevice(this.getApplicationContext())) {
            RootedCheck.getInstance().showRootedDeviceDialog((Activity)this, this.getString(R.string.root_dialog), this.getString(R.string.root_desc), this.getString(R.string.root_btn));
        } else {
            this.initView();
            this.initClick();
        }
    }

    private void initClick() {
        this.activityStartScanningBinding.layoutHeader.imgBack.setOnClickListener(view -> this.finish());
        this.activityStartScanningBinding.btnStartScanning.setOnClickListener(view -> PermissionHelper.INSTANCE.requestPermissions((FragmentActivity)this, new PermissionHelper.PermissionCallback(){

            @Override
            public void onResult(boolean allGranted, @NonNull List<String> grantedList, @NonNull List<String> deniedList) {
                if (allGranted && StartScanningActivity.this.isInternetAvailable()) {
                    Intent i = new Intent((Context)StartScanningActivity.this, CameraXLivePreviewActivity.class);
                    i.setFlags(0x10008000);
                    i.putExtra(StartScanningActivity.this.getResources().getString(R.string.doc_key), StartScanningActivity.this.selectedDoc);
                    StartScanningActivity.this.startActivity(i);
                    if (!OtherConstant.getInstance().getAppName().equalsIgnoreCase(StartScanningActivity.this.getString(R.string.overify))) {
                        Utility.Companion.getInstance().cleanup();
                    }
                    Utility.Companion.getInstance().setPassportNumber(null);
                    Utility.Companion.getInstance().setDateOfBirth(null);
                    Utility.Companion.getInstance().setExpiryDate(null);
                    StartScanningActivity.this.finish();
                    StartScanningActivity.this.overridePendingTransition(0x10A0000, 0x10A0001);
                }
            }
        }));
        this.activityStartScanningBinding.imgSetting.setOnClickListener(view -> {
            Intent i = new Intent((Context)this, SDKSettingScreen.class);
            this.startActivity(i);
            this.overridePendingTransition(0x10A0000, 0x10A0001);
        });
    }

    private void initView() {
        if (this.getIntent().hasExtra(this.getResources().getString(R.string.doc_key))) {
            this.selectedDoc = this.getIntent().getStringExtra(this.getResources().getString(R.string.doc_key));
        }
        try {
            SVG svg = SVG.getFromResource((Resources)this.getResources(), (int)R.raw.back);
            this.activityStartScanningBinding.layoutHeader.imgBack.setSVG(svg);
            if (this.storage.getPreferredLocale().equalsIgnoreCase("ar")) {
                this.activityStartScanningBinding.layoutHeader.imgBack.setRotation(180.0f);
            }
        }
        catch (SVGParseException e) {
            e.printStackTrace();
        }
        this.setLayoutAndTextSize();
        if (OtherConstant.getInstance().getNeedToShowSettingScreen()) {
            if (SharePreferenceUtility.getSavePreferenceData(this.getApplicationContext(), this.getString(R.string.sharepreference_verification_step))) {
                this.activityStartScanningBinding.imgSetting.setVisibility(8);
            } else {
                this.activityStartScanningBinding.imgSetting.setVisibility(0);
            }
        } else {
            this.activityStartScanningBinding.imgSetting.setVisibility(8);
        }
        if (this.selectedDoc.equalsIgnoreCase(this.getString(R.string.e_passport))) {
            this.activityStartScanningBinding.txtDesc.setText((CharSequence)this.getString(R.string.pass_scan_desc));
            this.activityStartScanningBinding.lottieAnimationView.setAnimation(R.raw.passportscan);
        } else {
            this.activityStartScanningBinding.txtDesc.setText((CharSequence)this.getString(R.string.doc_scan_desc));
            this.activityStartScanningBinding.lottieAnimationView.setAnimation(R.raw.idscan);
        }
    }

    private void setLayoutAndTextSize() {
        TextSizeConverter textSizeConverter = new TextSizeConverter(this.getApplicationContext());
        textSizeConverter.changeStatusBarColor((Activity)this);
        ViewGroup.LayoutParams layoutParams2 = this.activityStartScanningBinding.layoutHeader.imgBack.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        this.activityStartScanningBinding.layoutHeader.imgBack.setLayoutParams(layoutParams2);
        layoutParams2 = this.activityStartScanningBinding.imgSetting.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        this.activityStartScanningBinding.imgSetting.setLayoutParams(layoutParams2);
        LinearLayout.LayoutParams layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(4), 0, 0);
        this.activityStartScanningBinding.layoutHeader.lytHeaderMain.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.activityStartScanningBinding.layoutHeader.txtHelp.setText((CharSequence)this.getString(R.string.header_doc_scan));
        this.activityStartScanningBinding.layoutHeader.txtHelp.setTextSize(0, textSizeConverter.getTextSize(17));
        int padding = textSizeConverter.getPaddingORMarginValue(16);
        this.activityStartScanningBinding.layoutHeader.txtHelp.setPadding(padding, 0, 0, 0);
        this.activityStartScanningBinding.lytMainStartScanning.setPadding(padding, padding, padding, padding);
        padding = textSizeConverter.getPaddingORMarginValue(12);
        this.activityStartScanningBinding.txtBtnNext.setPadding(0, padding, 0, padding);
        this.activityStartScanningBinding.txtBtnNext.setText((CharSequence)this.getString(R.string.btn_start_verificaion));
        this.activityStartScanningBinding.txtBtnNext.setTextSize(0, textSizeConverter.getTextSize(16));
        this.activityStartScanningBinding.btnStartScanning.setRadius((float)textSizeConverter.calculateRadius(8));
        LinearLayout.LayoutParams marginLyoutParam = (LinearLayout.LayoutParams)this.activityStartScanningBinding.txtDesc.getLayoutParams();
        marginLyoutParam.setMargins(0, 0, 0, textSizeConverter.getPaddingORMarginValue(62));
        this.activityStartScanningBinding.txtDesc.setLayoutParams((ViewGroup.LayoutParams)marginLyoutParam);
        this.activityStartScanningBinding.txtDesc.setTextSize(0, textSizeConverter.getTextSize(16));
        this.activityStartScanningBinding.lottieAnimationView.playAnimation();
        this.activityStartScanningBinding.lottieAnimationView.setRepeatCount(-1);
    }
}

