/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.mrtd2.rooted;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import androidx.appcompat.app.AlertDialog;
import java.io.File;
import nashid.verify.sdk.mrtd2.rooted.EmulatorDetector;

public class RootedCheck {
    private static volatile RootedCheck INSTANCE = null;
    private static final String GOLDFISH = "goldfish";
    private static final String RANCHU = "ranchu";
    private static final String SDK = "sdk";

    private RootedCheck() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RootedCheck getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<RootedCheck> clazz = RootedCheck.class;
        synchronized (RootedCheck.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new RootedCheck();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void showRootedDeviceDialog(Activity activity, String title, String desc, String buttonName) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setTitle((CharSequence)title);
        builder.setMessage((CharSequence)desc);
        builder.setPositiveButton((CharSequence)buttonName, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                System.exit(0);
            }
        });
        builder.setCancelable(false);
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    public static boolean isEmulator() {
        return Build.PRODUCT.contains(SDK) || Build.HARDWARE.contains(GOLDFISH) || Build.HARDWARE.contains(RANCHU);
    }

    public boolean isRootedDevice(Context context) {
        boolean isEmulator = RootedCheck.isEmulator();
        String buildTags = Build.TAGS;
        if (!isEmulator && buildTags != null && buildTags.contains("test-keys")) {
            return true;
        }
        File file = new File("/system/app/Superuser.apk");
        if (file.exists()) {
            return true;
        }
        file = new File("/system/xbin/su");
        return !isEmulator && file.exists();
    }

    public boolean isEmulator(Context context) {
        return EmulatorDetector.isEmulator(context);
    }

    public void setFlag(Activity activity) {
        if ("release".equals("release")) {
            // empty if block
        }
    }
}

