/*
 * Decompiled with CFR 0.152.
 */
package colorspace.boxes;

import colorspace.ColorSpaceException;
import colorspace.boxes.JP2Box;
import icc.ICCProfile;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import jj2000.j2k.io.RandomAccessIO;

public final class ChannelDefinitionBox
extends JP2Box {
    private int ndefs;
    private Hashtable definitions = new Hashtable();

    public ChannelDefinitionBox(RandomAccessIO randomAccessIO, int n) throws IOException, ColorSpaceException {
        super(randomAccessIO, n);
        this.readBox();
    }

    private void readBox() throws IOException {
        byte[] byArray = new byte[8];
        this.in.seek(this.dataStart);
        this.in.readFully(byArray, 0, 2);
        this.ndefs = ICCProfile.getShort(byArray, 0) & 0xFFFF;
        int n = this.dataStart + 2;
        this.in.seek(n);
        for (int i = 0; i < this.ndefs; ++i) {
            this.in.readFully(byArray, 0, 6);
            short s = ICCProfile.getShort(byArray, 0);
            int[] nArray = new int[]{this.getCn(byArray), this.getTyp(byArray), this.getAsoc(byArray)};
            this.definitions.put(new Integer(nArray[0]), nArray);
        }
    }

    public int getNDefs() {
        return this.ndefs;
    }

    public int getCn(int n) {
        Enumeration enumeration = this.definitions.keys();
        while (enumeration.hasMoreElements()) {
            int[] nArray = (int[])this.definitions.get(enumeration.nextElement());
            if (n != this.getAsoc(nArray)) continue;
            return this.getCn(nArray);
        }
        return n;
    }

    public int getTyp(int n) {
        int[] nArray = (int[])this.definitions.get(new Integer(n));
        return this.getTyp(nArray);
    }

    public int getAsoc(int n) {
        int[] nArray = (int[])this.definitions.get(new Integer(n));
        return this.getAsoc(nArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ChannelDefinitionBox ").append(eol).append("  ");
        stringBuffer.append("ndefs= ").append(String.valueOf(this.ndefs));
        Enumeration enumeration = this.definitions.keys();
        while (enumeration.hasMoreElements()) {
            int[] nArray = (int[])this.definitions.get(enumeration.nextElement());
            stringBuffer.append(eol).append("  ").append("Cn= ").append(String.valueOf(this.getCn(nArray))).append(", ").append("Typ= ").append(String.valueOf(this.getTyp(nArray))).append(", ").append("Asoc= ").append(String.valueOf(this.getAsoc(nArray)));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private int getCn(byte[] byArray) {
        return ICCProfile.getShort(byArray, 0);
    }

    private int getTyp(byte[] byArray) {
        return ICCProfile.getShort(byArray, 2);
    }

    private int getAsoc(byte[] byArray) {
        return ICCProfile.getShort(byArray, 4);
    }

    private int getCn(int[] nArray) {
        return nArray[0];
    }

    private int getTyp(int[] nArray) {
        return nArray[1];
    }

    private int getAsoc(int[] nArray) {
        return nArray[2];
    }

    static {
        type = 1667523942;
    }
}

