/*
 * Decompiled with CFR 0.152.
 */
package colorspace.boxes;

import colorspace.ColorSpace;
import colorspace.ColorSpaceException;
import colorspace.boxes.JP2Box;
import icc.ICCProfile;
import java.io.IOException;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.util.FacilityManager;

public final class ColorSpecificationBox
extends JP2Box {
    private ColorSpace.MethodEnum method = null;
    private ColorSpace.CSEnum colorSpace = null;
    private byte[] iccProfile = null;

    public ColorSpecificationBox(RandomAccessIO randomAccessIO, int n) throws IOException, ColorSpaceException {
        super(randomAccessIO, n);
        this.readBox();
    }

    private void readBox() throws IOException, ColorSpaceException {
        byte[] byArray = new byte[256];
        this.in.seek(this.dataStart);
        this.in.readFully(byArray, 0, 11);
        block0 : switch (byArray[0]) {
            case 1: {
                this.method = ColorSpace.ENUMERATED;
                int n = ICCProfile.getInt(byArray, 3);
                switch (n) {
                    case 16: {
                        this.colorSpace = ColorSpace.sRGB;
                        break block0;
                    }
                    case 17: {
                        this.colorSpace = ColorSpace.GreyScale;
                        break block0;
                    }
                    case 18: {
                        this.colorSpace = ColorSpace.sYCC;
                        break block0;
                    }
                }
                FacilityManager.getMsgLogger().printmsg(2, "Unknown enumerated colorspace (" + n + ") in color specification box");
                this.colorSpace = ColorSpace.Unknown;
                break;
            }
            case 2: {
                this.method = ColorSpace.ICC_PROFILED;
                int n = ICCProfile.getInt(byArray, 3);
                this.iccProfile = new byte[n];
                this.in.seek(this.dataStart + 3);
                this.in.readFully(this.iccProfile, 0, n);
                break;
            }
            default: {
                throw new ColorSpaceException("Bad specification method (" + byArray[0] + ") in " + this);
            }
        }
    }

    public ColorSpace.MethodEnum getMethod() {
        return this.method;
    }

    public ColorSpace.CSEnum getColorSpace() {
        return this.colorSpace;
    }

    public String getColorSpaceString() {
        return this.colorSpace.value;
    }

    public String getMethodString() {
        return this.method.value;
    }

    public byte[] getICCProfile() {
        return this.iccProfile;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ColorSpecificationBox ");
        stringBuffer.append("method= ").append(String.valueOf(this.method)).append(", ");
        stringBuffer.append("colorspace= ").append(String.valueOf(this.colorSpace)).append("]");
        return stringBuffer.toString();
    }

    static {
        type = 1668246642;
    }
}

