/*
 * Decompiled with CFR 0.152.
 */
package colorspace.boxes;

import colorspace.ColorSpaceException;
import colorspace.boxes.JP2Box;
import icc.ICCProfile;
import java.io.IOException;
import jj2000.j2k.io.RandomAccessIO;

public final class PaletteBox
extends JP2Box {
    private int nentries;
    private int ncolumns;
    private short[] bitdepth;
    private int[][] entries;

    public PaletteBox(RandomAccessIO randomAccessIO, int n) throws IOException, ColorSpaceException {
        super(randomAccessIO, n);
        this.readBox();
    }

    void readBox() throws IOException, ColorSpaceException {
        int n;
        byte[] byArray = new byte[4];
        this.in.seek(this.dataStart);
        this.in.readFully(byArray, 0, 3);
        this.nentries = ICCProfile.getShort(byArray, 0) & 0xFFFF;
        this.ncolumns = byArray[2] & 0xFFFF;
        this.bitdepth = new short[this.ncolumns];
        byArray = new byte[this.ncolumns];
        this.in.readFully(byArray, 0, this.ncolumns);
        for (n = 0; n < this.ncolumns; ++n) {
            this.bitdepth[n] = (short)(byArray[n] & 0xFFF);
        }
        this.entries = new int[this.nentries * this.ncolumns][];
        byArray = new byte[2];
        for (n = 0; n < this.nentries; ++n) {
            this.entries[n] = new int[this.ncolumns];
            for (int i = 0; i < this.ncolumns; ++i) {
                int n2;
                short s;
                short s2 = this.getBitDepth(i);
                boolean bl = this.isSigned(i);
                switch (this.getEntrySize(i)) {
                    case 1: {
                        this.in.readFully(byArray, 0, 1);
                        s = byArray[0];
                        break;
                    }
                    case 2: {
                        this.in.readFully(byArray, 0, 2);
                        s = ICCProfile.getShort(byArray, 0);
                        break;
                    }
                    default: {
                        throw new ColorSpaceException("palettes greater than 16 bits deep not supported");
                    }
                }
                if (bl) {
                    if ((s & 1 << s2 - 1) == 0) {
                        n2 = (1 << s2) - 1;
                        this.entries[n][i] = n2 & s;
                        continue;
                    }
                    n2 = -1 << s2;
                    this.entries[n][i] = n2 | s;
                    continue;
                }
                n2 = (1 << s2) - 1;
                this.entries[n][i] = n2 & s;
            }
        }
    }

    public int getNumEntries() {
        return this.nentries;
    }

    public int getNumColumns() {
        return this.ncolumns;
    }

    public boolean isSigned(int n) {
        return (this.bitdepth[n] & 0x80) == 1;
    }

    public boolean isUnSigned(int n) {
        return !this.isSigned(n);
    }

    public short getBitDepth(int n) {
        return (short)((this.bitdepth[n] & 0x7F) + 1);
    }

    public int getEntry(int n, int n2) {
        return this.entries[n2][n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[PaletteBox ").append("nentries= ").append(String.valueOf(this.nentries)).append(", ncolumns= ").append(String.valueOf(this.ncolumns)).append(", bitdepth per column= (");
        for (int i = 0; i < this.ncolumns; ++i) {
            stringBuffer.append(this.getBitDepth(i)).append(this.isSigned(i) ? "S" : "U").append(i < this.ncolumns - 1 ? ", " : "");
        }
        return stringBuffer.append(")]").toString();
    }

    private int getEntrySize(int n) {
        short s = this.getBitDepth(n);
        return s / 8 + s % 8 == 0 ? 0 : 1;
    }

    static {
        type = 1885564018;
    }
}

