/*
 * Decompiled with CFR 0.152.
 */
package icc.tags;

import colorspace.ColorSpace;
import icc.ICCProfile;
import icc.tags.ICCTag;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ICCTagTable
extends Hashtable {
    private static final String eol = System.getProperty("line.separator");
    private static final int offTagCount = 128;
    private static final int offTags = 132;
    private final Vector trios = new Vector();
    private int tagCount;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ICCTagTable containing " + this.tagCount + " tags:");
        StringBuffer stringBuffer2 = new StringBuffer("  ");
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            ICCTag iCCTag = (ICCTag)this.get(n);
            stringBuffer2.append(eol).append(iCCTag.toString());
        }
        stringBuffer.append(ColorSpace.indent("  ", stringBuffer2));
        return stringBuffer.append("]").toString();
    }

    public static ICCTagTable createInstance(byte[] byArray) {
        ICCTagTable iCCTagTable = new ICCTagTable(byArray);
        return iCCTagTable;
    }

    protected ICCTagTable(byte[] byArray) {
        this.tagCount = ICCProfile.getInt(byArray, 128);
        int n = 132;
        for (int i = 0; i < this.tagCount; ++i) {
            int n2 = ICCProfile.getInt(byArray, n);
            int n3 = ICCProfile.getInt(byArray, n + 4);
            int n4 = ICCProfile.getInt(byArray, n + 8);
            this.trios.addElement(new Triplet(n2, n3, n4));
            n += 12;
        }
        Enumeration enumeration = this.trios.elements();
        while (enumeration.hasMoreElements()) {
            Triplet triplet = (Triplet)enumeration.nextElement();
            ICCTag iCCTag = ICCTag.createInstance(triplet.signature, byArray, triplet.offset, triplet.count);
            this.put(new Integer(iCCTag.signature), iCCTag);
        }
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        int n = this.trios.size();
        int n2 = 128;
        int n3 = n2 + 4;
        int n4 = n3 + 3 * n * 4;
        randomAccessFile.seek(n2);
        randomAccessFile.writeInt(n);
        int n5 = n3;
        int n6 = n4;
        Enumeration enumeration = this.trios.elements();
        while (enumeration.hasMoreElements()) {
            Triplet triplet = (Triplet)enumeration.nextElement();
            ICCTag iCCTag = (ICCTag)this.get(new Integer(triplet.signature));
            randomAccessFile.seek(n5);
            randomAccessFile.writeInt(iCCTag.signature);
            randomAccessFile.writeInt(n6);
            randomAccessFile.writeInt(iCCTag.count);
            n5 += 3 * 12;
            randomAccessFile.seek(n6);
            randomAccessFile.write(iCCTag.data, iCCTag.offset, iCCTag.count);
            n6 += iCCTag.count;
        }
    }

    private static class Triplet {
        private int signature;
        private int offset;
        private int count;
        public static final int size = 12;

        Triplet(int n, int n2, int n3) {
            this.signature = n;
            this.offset = n2;
            this.count = n3;
        }
    }
}

