/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import java.io.IOException;
import jj2000.j2k.codestream.reader.PktHeaderBitReader;
import jj2000.j2k.util.ArrayUtil;

public class TagTreeDecoder {
    protected int w;
    protected int h;
    protected int lvls;
    protected int[][] treeV;
    protected int[][] treeS;

    public TagTreeDecoder(int n, int n2) {
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException();
        }
        this.w = n2;
        this.h = n;
        if (n2 == 0 || n == 0) {
            this.lvls = 0;
        } else {
            this.lvls = 1;
            while (n != 1 || n2 != 1) {
                n2 = n2 + 1 >> 1;
                n = n + 1 >> 1;
                ++this.lvls;
            }
        }
        this.treeV = new int[this.lvls][];
        this.treeS = new int[this.lvls][];
        n2 = this.w;
        n = this.h;
        for (int i = 0; i < this.lvls; ++i) {
            this.treeV[i] = new int[n * n2];
            ArrayUtil.intArraySet(this.treeV[i], Integer.MAX_VALUE);
            this.treeS[i] = new int[n * n2];
            n2 = n2 + 1 >> 1;
            n = n + 1 >> 1;
        }
    }

    public final int getWidth() {
        return this.w;
    }

    public final int getHeight() {
        return this.h;
    }

    public int update(int n, int n2, int n3, PktHeaderBitReader pktHeaderBitReader) throws IOException {
        int n4;
        if (n >= this.h || n2 >= this.w || n3 < 0) {
            throw new IllegalArgumentException();
        }
        int n5 = this.lvls - 1;
        int n6 = this.treeS[n5][0];
        int n7 = (n >> n5) * (this.w + (1 << n5) - 1 >> n5) + (n2 >> n5);
        while (true) {
            int n8 = this.treeS[n5][n7];
            n4 = this.treeV[n5][n7];
            if (n8 < n6) {
                n8 = n6;
            }
            while (n3 > n8) {
                if (n4 >= n8) {
                    if (pktHeaderBitReader.readBit() == 0) {
                        ++n8;
                        continue;
                    }
                    n4 = n8++;
                    continue;
                }
                n8 = n3;
                break;
            }
            this.treeS[n5][n7] = n8;
            this.treeV[n5][n7] = n4;
            if (n5 <= 0) break;
            n6 = n8 < n4 ? n8 : n4;
            n7 = (n >> --n5) * (this.w + (1 << n5) - 1 >> n5) + (n2 >> n5);
        }
        return n4;
    }

    public int getValue(int n, int n2) {
        if (n >= this.h || n2 >= this.w) {
            throw new IllegalArgumentException();
        }
        return this.treeV[0][n * this.w + n2];
    }
}

