/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.decoder;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import jj2000.j2k.decoder.Decoder;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.util.StringFormatException;

public class CmdLnDecoder {
    private ParameterList pl;
    private ParameterList defpl = new ParameterList();
    private Decoder dec;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            FacilityManager.getMsgLogger().println("CmdLnDecoder: JJ2000's JPEG 2000 Decoder\n    use jj2000.j2k.decoder.CmdLnDecoder -u to get help\n", 0, 0);
            System.exit(1);
        }
        new CmdLnDecoder(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmdLnDecoder(String[] stringArray) {
        String[][] stringArray2 = Decoder.getAllParameters();
        for (int i = stringArray2.length - 1; i >= 0; --i) {
            if (stringArray2[i][3] == null) continue;
            this.defpl.put(stringArray2[i][0], stringArray2[i][3]);
        }
        this.pl = new ParameterList(this.defpl);
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("No arguments!");
        }
        try {
            this.pl.parseArgs(stringArray);
        }
        catch (StringFormatException stringFormatException) {
            System.err.println("An error occured while parsing the arguments:\n" + stringFormatException.getMessage());
            return;
        }
        if (this.pl.getParameter("pfile") != null) {
            InputStream inputStream;
            try {
                inputStream = new FileInputStream(this.pl.getParameter("pfile"));
                inputStream = new BufferedInputStream(inputStream);
                this.pl.load(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Could not load the argument file " + this.pl.getParameter("pfile"));
                return;
            }
            catch (IOException iOException) {
                System.err.println("An error ocurred while reading from the argument file " + this.pl.getParameter("pfile"));
                return;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("[WARNING]: Could not close the argument file after reading");
            }
            try {
                this.pl.parseArgs(stringArray);
            }
            catch (StringFormatException stringFormatException) {
                System.err.println("An error occured while re-parsing the arguments:\n" + stringFormatException.getMessage());
                return;
            }
        }
        this.dec = new Decoder(this.pl);
        if (this.dec.getExitCode() != 0) {
            System.exit(this.dec.getExitCode());
        }
        try {
            this.dec.run();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (this.dec.getExitCode() != 0) {
                System.exit(this.dec.getExitCode());
            }
        }
    }
}

