/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.decoder;

import colorspace.ColorSpace;
import colorspace.ColorSpaceException;
import icc.ICCProfiler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import jj2000.disp.BlkImgDataSrcImageProducer;
import jj2000.disp.ExitHandler;
import jj2000.disp.ImgKeyListener;
import jj2000.disp.ImgMouseListener;
import jj2000.disp.ImgScrollPane;
import jj2000.disp.TitleUpdater;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.entropy.decoder.EntropyDecoder;
import jj2000.j2k.fileformat.reader.FileFormatReader;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.ImgDataConverter;
import jj2000.j2k.image.invcomptransf.InvCompTransf;
import jj2000.j2k.image.output.ImgWriter;
import jj2000.j2k.image.output.ImgWriterPGM;
import jj2000.j2k.image.output.ImgWriterPGX;
import jj2000.j2k.image.output.ImgWriterPPM;
import jj2000.j2k.io.BEBufferedRandomAccessFile;
import jj2000.j2k.quantization.dequantizer.Dequantizer;
import jj2000.j2k.roi.ROIDeScaler;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.ISRandomAccessIO;
import jj2000.j2k.util.MsgLogger;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.util.StringFormatException;
import jj2000.j2k.wavelet.synthesis.InverseWT;

public class Decoder
implements Runnable {
    private ColorSpace csMap = null;
    TitleUpdater title = null;
    private boolean isChildProcess = false;
    private int exitCode;
    private ParameterList pl;
    private HeaderInfo hi;
    private ParameterList defpl;
    private static final char[] vprfxs = new char[]{'B', 'C', 'R', 'Q', 'M', 'H', 'I'};
    private Frame win = null;
    private ImgScrollPane isp;
    private static final String[][] pinfo = new String[][]{{"u", "[on|off]", "Prints usage information. If specified all other arguments (except 'v') are ignored", "off"}, {"v", "[on|off]", "Prints version and copyright information", "off"}, {"verbose", "[on|off]", "Prints information about the decoded codestream", "on"}, {"pfile", "<filename>", "Loads the arguments from the specified file. Arguments that are specified on the command line override the ones from the file.\nThe arguments file is a simple text file with one argument per line of the following form:\n  <argument name>=<argument value>\nIf the argument is of boolean type (i.e. its presence turns a feature on), then the 'on' value turns it on, while the 'off' value turns it off. The argument name does not include the '-' or '+' character. Long lines can be broken into several lines by terminating them with '\\'. Lines starting with '#' are considered as comments. This option is not recursive: any 'pfile' argument appearing in the file is ignored.", null}, {"res", "<resolution level index>", "The resolution level at which to reconstruct the image  (0 means the lowest available resolution whereas the maximum resolution level corresponds to the original image resolution). If the given index is greater than the number of available resolution levels of the compressed image, the image is reconstructed at its highest resolution (among all tile-components). Note that this option affects only the inverse wavelet transform and not the number  of bytes read by the codestream parser: this number of bytes depends only on options '-nbytes' or '-rate'.", null}, {"i", "<filename or url>", "The file containing the JPEG 2000 compressed data. This can be either a JPEG 2000 codestream or a JP2 file containing a JPEG 2000 codestream. In the latter case the first codestream in the file will be decoded. If an URL is specified (e.g., http://...) the data will be downloaded and cached in memory before decoding. This is intended for easy use in applets, but it is not a very efficient way of decoding network served data.", null}, {"o", "<filename>", "This is the name of the file to which the decompressed image is written. If no output filename is given, the image is displayed on the screen. Output file format is PGX by default. If the extension is '.pgm' then a PGM file is written as output, however this is only permitted if the component bitdepth does not exceed 8. If the extension is '.ppm' then a PPM file is written, however this is only permitted if there are 3 components and none of them has a bitdepth of more than 8. If there is more than 1 component, suffices '-1', '-2', '-3', ... are added to the file name, just before the extension, except for PPM files where all three components are written to the same file.", null}, {"rate", "<decoding rate in bpp>", "Specifies the decoding rate in bits per pixel (bpp) where the number of pixels is related to the image's original size (Note: this number is not affected by the '-res' option). If it is equalto -1, the whole codestream is decoded. The codestream is either parsed (default) or truncated depending the command line option '-parsing'. To specify the decoding rate in bytes, use '-nbytes' options instead.", "-1"}, {"nbytes", "<decoding rate in bytes>", "Specifies the decoding rate in bytes. The codestream is either parsed (default) or truncated depending the command line option '-parsing'. To specify the decoding rate in bits per pixel, use '-rate' options instead.", "-1"}, {"parsing", null, "Enable or not the parsing mode when decoding rate is specified ('-nbytes' or '-rate' options). If it is false, the codestream is decoded as if it were truncated to the given rate. If it is true, the decoder creates, truncates and decodes a virtual layer progressive codestream with the same truncation points in each code-block.", "on"}, {"ncb_quit", "<max number of code blocks>", "Use the ncb and lbody quit conditions. If state information is found for more code blocks than is indicated with this option, the decoder will decode using only information found before that point. Using this otion implies that the 'rate' or 'nbyte' parameter is used to indicate the lbody parameter which is the number of packet body bytes the decoder will decode.", "-1"}, {"l_quit", "<max number of layers>", "Specifies the maximum number of layers to decode for any code-block", "-1"}, {"m_quit", "<max number of bit planes>", "Specifies the maximum number of bit planes to decode for any code-block", "-1"}, {"poc_quit", null, "Specifies the whether the decoder should only decode code-blocks included in the first progression order.", "off"}, {"one_tp", null, "Specifies whether the decoder should only decode the first tile part of each tile.", "off"}, {"comp_transf", null, "Specifies whether the component transform indicated in the codestream should be used.", "on"}, {"debug", null, "Print debugging messages when an error is encountered.", "off"}, {"cdstr_info", null, "Display information about the codestream. This information is: \n- Marker segments value in main and tile-part headers,\n- Tile-part length and position within the code-stream.", "off"}, {"nocolorspace", null, "Ignore any colorspace information in the image.", "off"}, {"colorspace_debug", null, "Print debugging messages when an error is encountered in the colorspace module.", "off"}};

    public Decoder(ParameterList parameterList, ImgScrollPane imgScrollPane) {
        this.pl = parameterList;
        this.defpl = parameterList.getDefaultParameterList();
        this.isp = imgScrollPane;
    }

    public Decoder(ParameterList parameterList) {
        this(parameterList, null);
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run() {
        var6_1 = "";
        var7_2 = "";
        var8_3 = "";
        var9_4 = null;
        var17_5 = null;
        var19_6 = null;
        var28_7 = false;
        var29_8 = null;
        var32_9 = null;
        var33_10 = "";
        try {
            try {
                if (this.pl.getBooleanParameter("v")) {
                    this.printVersionAndCopyright();
                }
                if (this.pl.getParameter("u").equals("on")) {
                    this.printUsage();
                    return;
                }
                var1_11 = this.pl.getBooleanParameter("verbose");
            }
            catch (StringFormatException var34_12) {
                this.error("An error occured while parsing the arguments:\n" + var34_12.getMessage(), 1);
                if (this.pl.getParameter("debug").equals("on")) {
                    var34_12.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            catch (NumberFormatException var34_13) {
                this.error("An error occured while parsing the arguments:\n" + var34_13.getMessage(), 1);
                if (this.pl.getParameter("debug").equals("on")) {
                    var34_13.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                this.pl.checkList(Decoder.vprfxs, ParameterList.toNameArray(Decoder.pinfo));
            }
            catch (IllegalArgumentException var34_14) {
                this.error(var34_14.getMessage(), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    var34_14.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            var3_23 = this.pl.getParameter("i");
            if (var3_23 == null) {
                this.error("Input file ('-i' option) has not been specified", 1);
                return;
            }
            var6_1 = this.pl.getParameter("o");
            if (var6_1 == null) {
                var28_7 = true;
            } else if (var6_1.lastIndexOf(46) != -1) {
                var8_3 = var6_1.substring(var6_1.lastIndexOf(46), var6_1.length());
                var7_2 = var6_1.substring(0, var6_1.lastIndexOf(46));
            } else {
                var7_2 = var6_1;
                var8_3 = ".pgx";
            }
            if (var3_23.indexOf("/") >= 1 && var3_23.charAt(var3_23.indexOf("/") - 1) == ':') {
                try {
                    var34_15 = new URL(var3_23);
                }
                catch (MalformedURLException var38_24) {
                    this.error("Malformed URL for input file " + var3_23, 4);
                    if (this.pl.getParameter("debug").equals("on")) {
                        var38_24.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
                try {
                    var35_30 = var34_15.openConnection();
                    var35_30.connect();
                }
                catch (IOException var38_25) {
                    this.error("Cannot open connection to " + var3_23 + (var38_25.getMessage() != null ? ":\n" + var38_25.getMessage() : ""), 4);
                    if (this.pl.getParameter("debug").equals("on")) {
                        var38_25.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
                var36_32 = var35_30.getContentLength();
                try {
                    var37_43 = var35_30.getInputStream();
                }
                catch (IOException var38_26) {
                    this.error("Cannot get data from connection to " + var3_23 + (var38_26.getMessage() != null ? ":\n" + var38_26.getMessage() : ""), 4);
                    if (this.pl.getParameter("debug").equals("on")) {
                        var38_26.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
                var4_46 = var36_32 != -1 ? new ISRandomAccessIO(var37_43, var36_32, 1, var36_32) : new ISRandomAccessIO(var37_43);
                try {
                    var4_46.read();
                    var4_46.seek(0);
                }
                catch (IOException var38_27) {
                    this.error("Cannot get input data from " + var3_23 + " Invalid URL?", 4);
                    if (this.pl.getParameter("debug").equals("on")) {
                        var38_27.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
            }
            try {
                var4_46 = new BEBufferedRandomAccessFile(var3_23, "r");
            }
            catch (IOException var34_16) {
                this.error("Cannot open input file " + (var34_16.getMessage() != null ? ":\n" + var34_16.getMessage() : ""), 4);
                if (this.pl.getParameter("debug").equals("on")) {
                    var34_16.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            var5_47 = new FileFormatReader(var4_46);
            var5_47.readFileFormat();
            if (var5_47.JP2FFUsed) {
                var4_46.seek(var5_47.getFirstCodeStreamPos());
            }
            this.hi = new HeaderInfo();
            try {
                var11_48 = new HeaderDecoder(var4_46, this.pl, this.hi);
            }
            catch (EOFException var34_17) {
                this.error("Codestream too short or bad header, unable to decode.", 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    var34_17.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            var34_18 = var11_48.getNumComps();
            var35_31 = this.hi.siz.getNumTiles();
            var19_6 = var11_48.getDecoderSpecs();
            if (var1_11) {
                var36_33 = var34_18 + " component(s) in codestream, " + var35_31 + " tile(s)\n";
                var36_33 = var36_33 + "Image dimension: ";
                for (var37_44 = 0; var37_44 < var34_18; ++var37_44) {
                    var36_33 = var36_33 + this.hi.siz.getCompImgWidth(var37_44) + "x" + this.hi.siz.getCompImgHeight(var37_44) + " ";
                }
                if (var35_31 != 1) {
                    var36_33 = var36_33 + "\nNom. Tile dim. (in canvas): " + this.hi.siz.xtsiz + "x" + this.hi.siz.ytsiz;
                }
                FacilityManager.getMsgLogger().printmsg(1, var36_33);
            }
            if (this.pl.getBooleanParameter("cdstr_info")) {
                FacilityManager.getMsgLogger().printmsg(1, "Main header:\n" + this.hi.toStringMainHeader());
            }
            var25_49 = new int[var34_18];
            for (var24_50 = 0; var24_50 < var34_18; ++var24_50) {
                var25_49[var24_50] = var11_48.getOriginalBitDepth(var24_50);
            }
            try {
                var10_51 = BitstreamReaderAgent.createInstance(var4_46, var11_48, this.pl, var19_6, this.pl.getBooleanParameter("cdstr_info"), this.hi);
            }
            catch (IOException var36_34) {
                this.error("Error while reading bit stream header or parsing packets" + (var36_34.getMessage() != null ? ":\n" + var36_34.getMessage() : ""), 4);
                if (this.pl.getParameter("debug").equals("on")) {
                    var36_34.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            catch (IllegalArgumentException var36_35) {
                this.error("Cannot instantiate bit stream reader" + (var36_35.getMessage() != null ? ":\n" + var36_35.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    var36_35.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                var12_52 = var11_48.createEntropyDecoder(var10_51, this.pl);
            }
            catch (IllegalArgumentException var36_36) {
                this.error("Cannot instantiate entropy decoder" + (var36_36.getMessage() != null ? ":\n" + var36_36.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    var36_36.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                var13_53 = var11_48.createROIDeScaler(var12_52, this.pl, var19_6);
            }
            catch (IllegalArgumentException var36_37) {
                this.error("Cannot instantiate roi de-scaler." + (var36_37.getMessage() != null ? ":\n" + var36_37.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    var36_37.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                var14_54 = var11_48.createDequantizer(var13_53, var25_49, var19_6);
            }
            catch (IllegalArgumentException var36_38) {
                this.error("Cannot instantiate dequantizer" + (var36_38.getMessage() != null ? ":\n" + var36_38.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    var36_38.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                var15_55 = InverseWT.createInstance(var14_54, var19_6);
            }
            catch (IllegalArgumentException var36_39) {
                this.error("Cannot instantiate inverse wavelet transform" + (var36_39.getMessage() != null ? ":\n" + var36_39.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    var36_39.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            var2_56 = var10_51.getImgRes();
            var15_55.setImgResLevel(var2_56);
            var18_57 = new ImgDataConverter(var15_55, 0);
            var16_58 = new InvCompTransf(var18_57, var19_6, var25_49, this.pl);
            if (var5_47.JP2FFUsed && this.pl.getParameter("nocolorspace").equals("off")) {
                try {
                    this.csMap = new ColorSpace(var4_46, var11_48, this.pl);
                    var21_59 = var11_48.createChannelDefinitionMapper(var16_58, this.csMap);
                    var22_60 = var11_48.createResampler(var21_59, this.csMap);
                    var20_61 = var11_48.createPalettizedColorSpaceMapper(var22_60, this.csMap);
                    var23_62 /* !! */  = var11_48.createColorSpaceMapper(var20_61, this.csMap);
                    if (!this.csMap.debugging()) ** GOTO lbl230
                    FacilityManager.getMsgLogger().printmsg(3, "" + this.csMap);
                    FacilityManager.getMsgLogger().printmsg(3, "" + var21_59);
                    FacilityManager.getMsgLogger().printmsg(3, "" + var22_60);
                    FacilityManager.getMsgLogger().printmsg(3, "" + var20_61);
                    FacilityManager.getMsgLogger().printmsg(3, "" + var23_62 /* !! */ );
                }
                catch (IllegalArgumentException var36_40) {
                    this.error("Could not instantiate ICC profiler" + (var36_40.getMessage() != null ? ":\n" + var36_40.getMessage() : ""), 1, var36_40);
                    return;
                }
                catch (ColorSpaceException var36_41) {
                    this.error("error processing jp2 colorspace information" + (var36_41.getMessage() != null ? ": " + var36_41.getMessage() : "    "), 1, var36_41);
                    return;
                }
            } else {
                var23_62 /* !! */  = var16_58;
            }
lbl230:
            // 3 sources

            var36_42 = var23_62 /* !! */ ;
            if (var23_62 /* !! */  == null) {
                var36_42 = var16_58;
            }
            var37_45 = var36_42.getNumComps();
            if (var28_7) {
                var33_10 = "JJ2000: " + new File(var3_23).getName() + " " + var36_42.getImgWidth() + "x" + var36_42.getImgHeight();
                if (this.isp == null) {
                    this.win = new Frame(var33_10 + " @ (0,0) : 1");
                    this.win.setBackground(Color.white);
                    this.win.addWindowListener(new ExitHandler(this));
                    this.isp = new ImgScrollPane(0);
                    this.win.add((Component)this.isp, "Center");
                    this.isp.addKeyListener(new ImgKeyListener(this.isp, this));
                    this.win.addKeyListener(new ImgKeyListener(this.isp, this));
                } else {
                    this.win = null;
                }
                if (this.win != null) {
                    this.win.addNotify();
                    var32_9 = this.win.getInsets();
                    var38_28 = var36_42.getCompSubsX(0);
                    var39_63 = var36_42.getCompSubsY(0);
                    var40_69 = (var36_42.getImgWidth() + var38_28 - 1) / var38_28;
                    var41_72 = (var36_42.getImgHeight() + var39_63 - 1) / var39_63;
                    var30_73 = new Dimension(var40_69 + var32_9.left + var32_9.right, var41_72 + var32_9.top + var32_9.bottom);
                    var31_74 = this.win.getToolkit().getScreenSize();
                    if ((float)var30_73.width > (float)(var31_74.width * 8) / 10.0f) {
                        var30_73.width = (int)((float)(var31_74.width * 8) / 10.0f);
                    }
                    if ((float)var30_73.height > (float)(var31_74.height * 8) / 10.0f) {
                        var30_73.height = (int)((float)(var31_74.height * 8) / 10.0f);
                    }
                    this.win.setSize(var30_73);
                    this.win.validate();
                    this.win.setVisible(true);
                    this.title = new TitleUpdater(this.isp, this.win, var33_10);
                    var42_75 = new Thread(this.title);
                    var42_75.start();
                } else {
                    this.title = null;
                }
            } else {
                if (this.csMap != null) {
                    if (var8_3.equalsIgnoreCase(".PPM") && (var37_45 != 3 || var36_42.getNomRangeBits(0) > 8 || var36_42.getNomRangeBits(1) > 8 || var36_42.getNomRangeBits(2) > 8 || this.csMap.isOutputSigned(0) || this.csMap.isOutputSigned(1) || this.csMap.isOutputSigned(2))) {
                        this.error("Specified PPM output file but compressed image is not of the correct format for PPM or limited decoded components to less than 3.", 1);
                        return;
                    }
                } else if (var8_3.equalsIgnoreCase(".PPM") && (var37_45 != 3 || var36_42.getNomRangeBits(0) > 8 || var36_42.getNomRangeBits(1) > 8 || var36_42.getNomRangeBits(2) > 8 || var11_48.isOriginalSigned(0) || var11_48.isOriginalSigned(1) || var11_48.isOriginalSigned(2))) {
                    this.error("Specified PPM output file but compressed image is not of the correct format for PPM or limited decoded components to less than 3.", 1);
                    return;
                }
                var9_4 = new String[var37_45];
                for (var24_50 = 0; var24_50 < var37_45; ++var24_50) {
                    var9_4[var24_50] = "";
                }
                if (var37_45 > 1 && !var8_3.equalsIgnoreCase(".PPM")) {
                    if (var8_3.equalsIgnoreCase(".PGM")) {
                        for (var24_50 = 0; var24_50 < var37_45; ++var24_50) {
                            if (this.csMap != null) {
                                if (!this.csMap.isOutputSigned(var24_50)) continue;
                                this.error("Specified PGM output file but compressed image is not of the correct format for PGM.", 1);
                                return;
                            }
                            if (!var11_48.isOriginalSigned(var24_50)) continue;
                            this.error("Specified PGM output file but compressed image is not of the correct format for PGM.", 1);
                            return;
                        }
                    }
                    for (var24_50 = 0; var24_50 < var37_45; ++var24_50) {
                        var9_4[var24_50] = var7_2 + "-" + (var24_50 + 1) + var8_3;
                    }
                } else {
                    var9_4[0] = var7_2 + var8_3;
                }
                if (var8_3.equalsIgnoreCase(".PPM")) {
                    var17_5 = new ImgWriter[1];
                    try {
                        var17_5[0] = new ImgWriterPPM(var9_4[0], (BlkImgDataSrc)var36_42, 0, 1, 2);
                    }
                    catch (IOException var38_29) {
                        this.error("Cannot write PPM header or open output file" + var24_50 + (var38_29.getMessage() != null ? ":\n" + var38_29.getMessage() : ""), 2);
                        if (this.pl.getParameter("debug").equals("on")) {
                            var38_29.printStackTrace();
                        } else {
                            this.error("Use '-debug' option for more details", 2);
                        }
                        return;
                    }
                } else {
                    var17_5 = new ImgWriter[var37_45];
                }
                if (this.csMap != null) {
                    if (var17_5.length == 3 && var36_42.getNomRangeBits(0) <= 8 && var36_42.getNomRangeBits(1) <= 8 && var36_42.getNomRangeBits(2) <= 8 && !this.csMap.isOutputSigned(0) && !this.csMap.isOutputSigned(1) && !this.csMap.isOutputSigned(2) && var19_6.cts.isCompTransfUsed()) {
                        this.warning("JJ2000 is quicker with one PPM output file than with 3 PGM/PGX output files when a component transformation is applied.");
                    }
                } else if (var17_5.length == 3 && var36_42.getNomRangeBits(0) <= 8 && var36_42.getNomRangeBits(1) <= 8 && var36_42.getNomRangeBits(2) <= 8 && !var11_48.isOriginalSigned(0) && !var11_48.isOriginalSigned(1) && !var11_48.isOriginalSigned(2) && var19_6.cts.isCompTransfUsed()) {
                    this.warning("JJ2000 is quicker with one PPM output file than with 3 PGM/PGX output files when a component transformation is applied.");
                }
            }
            var38_28 = var19_6.dls.getMin();
            if (var1_11) {
                if (var38_28 != var2_56) {
                    FacilityManager.getMsgLogger().println("Reconstructing resolution " + var2_56 + " on " + var38_28 + " (" + var10_51.getImgWidth(var2_56) + "x" + var10_51.getImgHeight(var2_56) + ")", 8, 8);
                }
                if (this.pl.getFloatParameter("rate") != -1.0f) {
                    FacilityManager.getMsgLogger().println("Target rate = " + var10_51.getTargetRate() + " bpp (" + var10_51.getTargetNbytes() + " bytes)", 8, 8);
                }
            }
            if (var28_7) {
                Thread.currentThread().setPriority(2);
                var29_8 = BlkImgDataSrcImageProducer.createImage(var36_42, this.isp);
                this.isp.setCursor(Cursor.getPredefinedCursor(3));
                if (this.win != null) {
                    this.win.setCursor(Cursor.getPredefinedCursor(3));
                }
                this.isp.setImage(var29_8);
                this.isp.setCursor(Cursor.getPredefinedCursor(0));
                if (this.win != null) {
                    this.win.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (this.win != null) {
                    do {
                        if (((var39_63 = this.isp.checkImage(var29_8, null)) & 64) != 0) {
                            FacilityManager.getMsgLogger().printmsg(3, "An unknown error occurred while producing the image");
                            return;
                        }
                        if ((var39_63 & 128) != 0) {
                            FacilityManager.getMsgLogger().printmsg(3, "Image production was aborted for some unknown reason");
                            continue;
                        }
                        if ((var39_63 & 32) != 0) {
                            var40_70 = new ImgMouseListener(this.isp);
                            this.isp.addMouseListener(var40_70);
                            this.isp.addMouseMotionListener(var40_70);
                            continue;
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException var40_71) {
                            // empty catch block
                        }
                    } while ((var39_63 & 224) == 0);
                }
            } else {
                for (var24_50 = 0; var24_50 < var17_5.length; ++var24_50) {
                    if (var8_3.equalsIgnoreCase(".PGM")) {
                        try {
                            var17_5[var24_50] = new ImgWriterPGM(var9_4[var24_50], (BlkImgDataSrc)var36_42, var24_50);
                        }
                        catch (IOException var39_64) {
                            this.error("Cannot write PGM header or open output file for component " + var24_50 + (var39_64.getMessage() != null ? ":\n" + var39_64.getMessage() : ""), 2);
                            if (this.pl.getParameter("debug").equals("on")) {
                                var39_64.printStackTrace();
                            } else {
                                this.error("Use '-debug' option for more details", 2);
                            }
                            return;
                        }
                    }
                    if (var8_3.equalsIgnoreCase(".PGX")) {
                        try {
                            var17_5[var24_50] = this.csMap != null ? new ImgWriterPGX(var9_4[var24_50], (BlkImgDataSrc)var36_42, var24_50, this.csMap.isOutputSigned(var24_50)) : new ImgWriterPGX(var9_4[var24_50], (BlkImgDataSrc)var36_42, var24_50, var11_48.isOriginalSigned(var24_50));
                        }
                        catch (IOException var39_65) {
                            this.error("Cannot write PGX header or open output file for component " + var24_50 + (var39_65.getMessage() != null ? ":\n" + var39_65.getMessage() : ""), 2);
                            if (this.pl.getParameter("debug").equals("on")) {
                                var39_65.printStackTrace();
                            } else {
                                this.error("Use '-debug' option for more details", 2);
                            }
                            return;
                        }
                    }
                    try {
                        var17_5[var24_50].writeAll();
                    }
                    catch (IOException var39_66) {
                        this.error("I/O error while writing output file" + (var39_66.getMessage() != null ? ":\n" + var39_66.getMessage() : ""), 2);
                        if (this.pl.getParameter("debug").equals("on")) {
                            var39_66.printStackTrace();
                        } else {
                            this.error("Use '-debug' option for more details", 2);
                        }
                        return;
                    }
                    try {
                        var17_5[var24_50].close();
                        continue;
                    }
                    catch (IOException var39_67) {
                        this.error("I/O error while closing output file (data may be corrupted" + (var39_67.getMessage() != null ? ":\n" + var39_67.getMessage() : ""), 2);
                        if (this.pl.getParameter("debug").equals("on")) {
                            var39_67.printStackTrace();
                        } else {
                            this.error("Use '-debug' option for more details", 2);
                        }
                        return;
                    }
                }
            }
            if (var1_11) {
                var39_68 = var10_51.getActualRate();
                var40_69 = var10_51.getActualNbytes();
                if (var5_47.JP2FFUsed) {
                    var41_72 = (int)(8.0f * (float)var40_69 / var39_68);
                    var39_68 = (float)(var40_69 += var5_47.getFirstCodeStreamPos()) * 8.0f / (float)var41_72;
                }
                if (this.pl.getIntParameter("ncb_quit") == -1) {
                    FacilityManager.getMsgLogger().println("Actual bitrate = " + var39_68 + " bpp (i.e. " + var40_69 + " bytes)", 8, 8);
                } else {
                    FacilityManager.getMsgLogger().println("Number of packet body bytes read = " + var40_69, 8, 8);
                }
                FacilityManager.getMsgLogger().flush();
            }
        }
        catch (IllegalArgumentException var34_19) {
            this.error(var34_19.getMessage(), 2);
            if (this.pl.getParameter("debug").equals("on")) {
                var34_19.printStackTrace();
            }
            return;
        }
        catch (Error var34_20) {
            if (var34_20.getMessage() != null) {
                this.error(var34_20.getMessage(), 2);
            } else {
                this.error("An error has occured during decoding.", 2);
            }
            if (this.pl.getParameter("debug").equals("on")) {
                var34_20.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
            return;
        }
        catch (RuntimeException var34_21) {
            if (var34_21.getMessage() != null) {
                this.error("An uncaught runtime exception has occurred:\n" + var34_21.getMessage(), 2);
            } else {
                this.error("An uncaught runtime exception has occurred.", 2);
            }
            if (this.pl.getParameter("debug").equals("on")) {
                var34_21.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
            return;
        }
        catch (Throwable var34_22) {
            this.error("An uncaught exception has occurred.", 2);
            if (this.pl.getParameter("debug").equals("on")) {
                var34_22.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
            return;
        }
    }

    private void error(String string, int n) {
        this.exitCode = n;
        FacilityManager.getMsgLogger().printmsg(3, string);
    }

    private void error(String string, int n, Throwable throwable) {
        this.exitCode = n;
        FacilityManager.getMsgLogger().printmsg(3, string);
        if (this.pl.getParameter("debug").equals("on")) {
            throwable.printStackTrace();
        } else {
            this.error("Use '-debug' option for more details", 2);
        }
    }

    public String[] getCOMInfo() {
        if (this.hi == null) {
            return null;
        }
        int n = this.hi.getNumCOM();
        Enumeration enumeration = this.hi.com.elements();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = enumeration.nextElement().toString();
        }
        return stringArray;
    }

    public static String[][] getAllParameters() {
        int n;
        Vector<String[]> vector = new Vector<String[]>();
        String[][] stringArray = BitstreamReaderAgent.getParameterInfo();
        if (stringArray != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = EntropyDecoder.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = ROIDeScaler.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = Dequantizer.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = InvCompTransf.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = HeaderDecoder.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = ICCProfiler.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = Decoder.getParameterInfo()) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                vector.addElement(stringArray[n]);
            }
        }
        if ((stringArray = new String[vector.size()][4]) != null) {
            for (n = stringArray.length - 1; n >= 0; --n) {
                stringArray[n] = (String[])vector.elementAt(n);
            }
        }
        return stringArray;
    }

    private void warning(String string) {
        FacilityManager.getMsgLogger().printmsg(2, string);
    }

    private void printVersionAndCopyright() {
        FacilityManager.getMsgLogger().println("JJ2000's JPEG 2000 Decoder\n", 2, 4);
        FacilityManager.getMsgLogger().println("Version: 5.1\n", 2, 4);
        FacilityManager.getMsgLogger().println("Copyright:\n\nThis software module was originally developed by Rapha\u00ebl Grosbois and Diego Santa Cruz (Swiss Federal Institute of Technology-EPFL); Joel Askel\u00f6f (Ericsson Radio Systems AB); and Bertrand Berthelot, David Bouchard, F\u00e9lix Henry, Gerard Mozelle and Patrice Onno (Canon Research Centre France S.A) in the course of development of the JPEG 2000 standard as specified by ISO/IEC 15444 (JPEG 2000 Standard). This software module is an implementation of a part of the JPEG 2000 Standard. Swiss Federal Institute of Technology-EPFL, Ericsson Radio Systems AB and Canon Research Centre France S.A (collectively JJ2000 Partners) agree not to assert against ISO/IEC and users of the JPEG 2000 Standard (Users) any of their rights under the copyright, not including other intellectual property rights, for this software module with respect to the usage by ISO/IEC and Users of this software module or modifications thereof for use in hardware or software products claiming conformance to the JPEG 2000 Standard. Those intending to use this software module in hardware or software products are advised that their use may infringe existing patents. The original developers of this software module, JJ2000 Partners and ISO/IEC assume no liability for use of this software module or modifications thereof. No license or right to this software module is granted for non JPEG 2000 Standard conforming products. JJ2000 Partners have full right to use this software module for his/her own purpose, assign or donate this software module to any third party and to inhibit third parties from using this software module for non JPEG 2000 Standard conforming products. This copyright notice must be included in all copies or derivative works of this software module.\n\nCopyright (c) 1999/2000 JJ2000 Partners.\n", 2, 4);
        FacilityManager.getMsgLogger().println("Send bug reports to: jj2000-bugs@ltssg3.epfl.ch\n", 2, 4);
    }

    private void printUsage() {
        MsgLogger msgLogger = FacilityManager.getMsgLogger();
        msgLogger.println("Usage:", 0, 0);
        msgLogger.println("JJ2KDecoder args...\n", 10, 12);
        msgLogger.println("The exit code of the decoder is non-zero if an error occurs.", 2, 4);
        msgLogger.println("The following arguments are recongnized:\n", 2, 4);
        this.printParamInfo(msgLogger, Decoder.getAllParameters());
        FacilityManager.getMsgLogger().println("\n\n", 0, 0);
        FacilityManager.getMsgLogger().println("Send bug reports to: jj2000-bugs@ltssg3.epfl.ch\n", 2, 4);
    }

    private void printParamInfo(MsgLogger msgLogger, String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.defpl.getParameter(stringArray[i][0]);
            if (string != null) {
                msgLogger.println("-" + stringArray[i][0] + (stringArray[i][1] != null ? " " + stringArray[i][1] + " " : " ") + "(default = " + string + ")", 4, 8);
            } else {
                msgLogger.println("-" + stringArray[i][0] + (stringArray[i][1] != null ? " " + stringArray[i][1] : ""), 4, 8);
            }
            if (stringArray[i][2] == null) continue;
            msgLogger.println(stringArray[i][2], 6, 6);
        }
    }

    public void exit() {
        if (this.isChildProcess) {
            if (this.win != null) {
                this.win.dispose();
            }
            if (this.title != null) {
                this.title.done = true;
            }
            return;
        }
        System.exit(0);
    }

    public void setChildProcess(boolean bl) {
        this.isChildProcess = bl;
    }
}

