/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.encoder;

import java.util.Stack;
import jj2000.j2k.StringSpec;
import jj2000.j2k.entropy.CBlkSizeSpec;
import jj2000.j2k.entropy.PrecinctSizeSpec;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.encoder.BitToByteOutput;
import jj2000.j2k.entropy.encoder.ByteOutputBuffer;
import jj2000.j2k.entropy.encoder.CBlkRateDistStats;
import jj2000.j2k.entropy.encoder.EntropyCoder;
import jj2000.j2k.entropy.encoder.MQCoder;
import jj2000.j2k.image.Coord;
import jj2000.j2k.quantization.quantizer.CBlkQuantDataSrcEnc;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.ThreadPool;
import jj2000.j2k.wavelet.analysis.CBlkWTData;

public class StdEntropyCoder
extends EntropyCoder
implements StdEntropyCoderOptions {
    private static final boolean DO_TIMING = false;
    private long[] time;
    public static final String THREADS_PROP_NAME = "jj2000.j2k.entropy.encoder.StdEntropyCoder.nthreads";
    public static final String DEF_THREADS_NUM = "0";
    public static final int THREADS_PRIORITY_INC = 0;
    private ThreadPool tPool;
    private Stack idleComps;
    private Stack[] completedComps;
    private int[] nBusyComps;
    private boolean[] finishedTileComponent;
    private MQCoder[] mqT;
    private BitToByteOutput[] boutT;
    private ByteOutputBuffer[] outT;
    private CBlkSizeSpec cblks;
    private PrecinctSizeSpec pss;
    public StringSpec bms;
    public StringSpec mqrs;
    public StringSpec rts;
    public StringSpec css;
    public StringSpec sss;
    public StringSpec lcs;
    public StringSpec tts;
    private int[][] opts = null;
    private int[][] lenCalc = null;
    private int[][] tType = null;
    private static final int ZC_LUT_BITS = 8;
    private static final int[] ZC_LUT_LH;
    private static final int[] ZC_LUT_HL;
    private static final int[] ZC_LUT_HH;
    private static final int SC_LUT_BITS = 9;
    private static final int[] SC_LUT;
    private static final int SC_LUT_MASK = 15;
    private static final int SC_SPRED_SHIFT = 31;
    private static final int INT_SIGN_BIT = Integer.MIN_VALUE;
    private static final int MR_LUT_BITS = 9;
    private static final int[] MR_LUT;
    private static final int NUM_CTXTS = 19;
    private static final int RLC_CTXT = 1;
    private static final int UNIF_CTXT = 0;
    private static final int[] MQ_INIT;
    private static final int[] SEG_SYMBOLS;
    private static final int[] SEG_SYMB_CTXTS;
    private int[][] stateT;
    private static final int STATE_SEP = 16;
    private static final int STATE_SIG_R1 = 32768;
    private static final int STATE_VISITED_R1 = 16384;
    private static final int STATE_NZ_CTXT_R1 = 8192;
    private static final int STATE_H_L_SIGN_R1 = 4096;
    private static final int STATE_H_R_SIGN_R1 = 2048;
    private static final int STATE_V_U_SIGN_R1 = 1024;
    private static final int STATE_V_D_SIGN_R1 = 512;
    private static final int STATE_PREV_MR_R1 = 256;
    private static final int STATE_H_L_R1 = 128;
    private static final int STATE_H_R_R1 = 64;
    private static final int STATE_V_U_R1 = 32;
    private static final int STATE_V_D_R1 = 16;
    private static final int STATE_D_UL_R1 = 8;
    private static final int STATE_D_UR_R1 = 4;
    private static final int STATE_D_DL_R1 = 2;
    private static final int STATE_D_DR_R1 = 1;
    private static final int STATE_SIG_R2 = Integer.MIN_VALUE;
    private static final int STATE_VISITED_R2 = 0x40000000;
    private static final int STATE_NZ_CTXT_R2 = 0x20000000;
    private static final int STATE_H_L_SIGN_R2 = 0x10000000;
    private static final int STATE_H_R_SIGN_R2 = 0x8000000;
    private static final int STATE_V_U_SIGN_R2 = 0x4000000;
    private static final int STATE_V_D_SIGN_R2 = 0x2000000;
    private static final int STATE_PREV_MR_R2 = 0x1000000;
    private static final int STATE_H_L_R2 = 0x800000;
    private static final int STATE_H_R_R2 = 0x400000;
    private static final int STATE_V_U_R2 = 0x200000;
    private static final int STATE_V_D_R2 = 0x100000;
    private static final int STATE_D_UL_R2 = 524288;
    private static final int STATE_D_UR_R2 = 262144;
    private static final int STATE_D_DL_R2 = 131072;
    private static final int STATE_D_DR_R2 = 65536;
    private static final int SIG_MASK_R1R2 = -2147450880;
    private static final int VSTD_MASK_R1R2 = 0x40004000;
    private static final int RLC_MASK_R1R2 = -536813568;
    private static final int ZC_MASK = 255;
    private static final int SC_SHIFT_R1 = 4;
    private static final int SC_SHIFT_R2 = 20;
    private static final int SC_MASK = 511;
    private static final int MR_MASK = 511;
    private static final int MSE_LKP_BITS = 7;
    private static final int MSE_LKP_FRAC_BITS = 13;
    private static final int[] FS_LOSSY;
    private static final int[] FM_LOSSY;
    private static final int[] FS_LOSSLESS;
    private static final int[] FM_LOSSLESS;
    private double[][] distbufT;
    private int[][] ratebufT;
    private boolean[][] istermbufT;
    private CBlkWTData[] srcblkT;
    private int[][] symbufT;
    private int[][] ctxtbufT;
    private boolean[][] precinctPartition;

    public StdEntropyCoder(CBlkQuantDataSrcEnc cBlkQuantDataSrcEnc, CBlkSizeSpec cBlkSizeSpec, PrecinctSizeSpec precinctSizeSpec, StringSpec stringSpec, StringSpec stringSpec2, StringSpec stringSpec3, StringSpec stringSpec4, StringSpec stringSpec5, StringSpec stringSpec6, StringSpec stringSpec7) {
        super(cBlkQuantDataSrcEnc);
        int n;
        int n2;
        int n3;
        this.cblks = cBlkSizeSpec;
        this.pss = precinctSizeSpec;
        this.bms = stringSpec;
        this.mqrs = stringSpec2;
        this.rts = stringSpec3;
        this.css = stringSpec4;
        this.sss = stringSpec5;
        this.lcs = stringSpec6;
        this.tts = stringSpec7;
        int n4 = cBlkSizeSpec.getMaxCBlkWidth();
        int n5 = cBlkSizeSpec.getMaxCBlkHeight();
        try {
            n3 = Integer.parseInt(System.getProperty(THREADS_PROP_NAME, DEF_THREADS_NUM));
            if (n3 < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid number of threads for entropy coding in property jj2000.j2k.entropy.encoder.StdEntropyCoder.nthreads");
        }
        if (n3 > 0) {
            FacilityManager.getMsgLogger().printmsg(1, "Using multithreaded entropy coder with " + n3 + " compressor threads.");
            n2 = n3;
            this.tPool = new ThreadPool(n3, Thread.currentThread().getPriority() + 0, "StdEntropyCoder");
            this.idleComps = new Stack();
            this.completedComps = new Stack[cBlkQuantDataSrcEnc.getNumComps()];
            this.nBusyComps = new int[cBlkQuantDataSrcEnc.getNumComps()];
            this.finishedTileComponent = new boolean[cBlkQuantDataSrcEnc.getNumComps()];
            for (n = cBlkQuantDataSrcEnc.getNumComps() - 1; n >= 0; --n) {
                this.completedComps[n] = new Stack();
            }
            for (n = 0; n < n3; ++n) {
                this.idleComps.push(new Compressor(n));
            }
        } else {
            n2 = 1;
            this.tPool = null;
            this.idleComps = null;
            this.completedComps = null;
            this.nBusyComps = null;
            this.finishedTileComponent = null;
        }
        this.outT = new ByteOutputBuffer[n2];
        this.mqT = new MQCoder[n2];
        this.boutT = new BitToByteOutput[n2];
        this.stateT = new int[n2][(n4 + 2) * ((n5 + 1) / 2 + 2)];
        this.symbufT = new int[n2][n4 * 10];
        this.ctxtbufT = new int[n2][n4 * 10];
        this.distbufT = new double[n2][96];
        this.ratebufT = new int[n2][96];
        this.istermbufT = new boolean[n2][96];
        this.srcblkT = new CBlkWTData[n2];
        for (n = 0; n < n2; ++n) {
            this.outT[n] = new ByteOutputBuffer();
            this.mqT[n] = new MQCoder(this.outT[n], 19, MQ_INIT);
        }
        this.precinctPartition = new boolean[cBlkQuantDataSrcEnc.getNumComps()][cBlkQuantDataSrcEnc.getNumTiles()];
        Object var16_15 = null;
        Coord coord = null;
        int n6 = this.getNumComps();
        coord = cBlkQuantDataSrcEnc.getNumTiles(coord);
        this.initTileComp(this.getNumTiles(), n6);
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < coord.y; ++j) {
                for (int k = 0; k < coord.x; ++k) {
                    this.precinctPartition[i][this.tIdx] = false;
                }
            }
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public int getCBlkWidth(int n, int n2) {
        return this.cblks.getCBlkWidth((byte)3, n, n2);
    }

    public int getCBlkHeight(int n, int n2) {
        return this.cblks.getCBlkHeight((byte)3, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CBlkRateDistStats getNextCodeBlock(int n, CBlkRateDistStats cBlkRateDistStats) {
        int n2;
        Compressor compressor;
        long l = 0L;
        if (this.tPool == null) {
            this.srcblkT[0] = this.src.getNextInternCodeBlock(n, this.srcblkT[0]);
            if (this.srcblkT[0] == null) {
                return null;
            }
            if ((this.opts[this.tIdx][n] & 1) != 0 && this.boutT[0] == null) {
                this.boutT[0] = new BitToByteOutput(this.outT[0]);
            }
            if (cBlkRateDistStats == null) {
                cBlkRateDistStats = new CBlkRateDistStats();
            }
            StdEntropyCoder.compressCodeBlock(n, cBlkRateDistStats, this.srcblkT[0], this.mqT[0], this.boutT[0], this.outT[0], this.stateT[0], this.distbufT[0], this.ratebufT[0], this.istermbufT[0], this.symbufT[0], this.ctxtbufT[0], this.opts[this.tIdx][n], this.isReversible(this.tIdx, n), this.lenCalc[this.tIdx][n], this.tType[this.tIdx][n]);
            return cBlkRateDistStats;
        }
        while (!this.finishedTileComponent[n] && !this.idleComps.empty()) {
            compressor = (Compressor)this.idleComps.pop();
            n2 = compressor.getIdx();
            this.srcblkT[n2] = this.src.getNextInternCodeBlock(n, this.srcblkT[n2]);
            if (this.srcblkT[n2] != null) {
                if ((this.opts[this.tIdx][n] & 1) != 0 && this.boutT[n2] == null) {
                    this.boutT[n2] = new BitToByteOutput(this.outT[n2]);
                }
                if (cBlkRateDistStats == null) {
                    cBlkRateDistStats = new CBlkRateDistStats();
                }
                compressor.ccb = cBlkRateDistStats;
                compressor.c = n;
                compressor.options = this.opts[this.tIdx][n];
                compressor.rev = this.isReversible(this.tIdx, n);
                compressor.lcType = this.lenCalc[this.tIdx][n];
                compressor.tType = this.tType[this.tIdx][n];
                int n3 = n;
                this.nBusyComps[n3] = this.nBusyComps[n3] + 1;
                cBlkRateDistStats = null;
                this.tPool.runTarget(compressor, this.completedComps[n]);
                continue;
            }
            this.idleComps.push(compressor);
            this.finishedTileComponent[n] = true;
        }
        if (this.nBusyComps[n] > 0) {
            Stack stack = this.completedComps[n];
            synchronized (stack) {
                if (this.completedComps[n].empty()) {
                    try {
                        this.completedComps[n].wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                compressor = (Compressor)this.completedComps[n].pop();
                n2 = compressor.getIdx();
                int n4 = n;
                this.nBusyComps[n4] = this.nBusyComps[n4] - 1;
                this.idleComps.push(compressor);
                this.tPool.checkTargetErrors();
                return compressor.ccb;
            }
        }
        this.tPool.checkTargetErrors();
        return null;
    }

    public void setTile(int n, int n2) {
        super.setTile(n, n2);
        if (this.finishedTileComponent != null) {
            for (int i = this.src.getNumComps() - 1; i >= 0; --i) {
                this.finishedTileComponent[i] = false;
            }
        }
    }

    public void nextTile() {
        if (this.finishedTileComponent != null) {
            for (int i = this.src.getNumComps() - 1; i >= 0; --i) {
                this.finishedTileComponent[i] = false;
            }
        }
        super.nextTile();
    }

    private static void compressCodeBlock(int n, CBlkRateDistStats cBlkRateDistStats, CBlkWTData cBlkWTData, MQCoder mQCoder, BitToByteOutput bitToByteOutput, ByteOutputBuffer byteOutputBuffer, int[] nArray, double[] dArray, int[] nArray2, boolean[] blArray, int[] nArray3, int[] nArray4, int n2, boolean bl, int n3, int n4) {
        int[] nArray5;
        if ((n2 & 0x10) != 0 && n4 != 3) {
            throw new IllegalArgumentException("Embedded error-resilient info in MQ termination option specified but incorrect MQ termination policy specified");
        }
        mQCoder.setLenCalcType(n3);
        mQCoder.setTermType(n4);
        int n5 = 30 - cBlkWTData.magbits + 1;
        n5 = n5 < 0 ? 0 : n5;
        ArrayUtil.intArraySet(nArray, 0);
        int n6 = StdEntropyCoder.calcSkipMSBP(cBlkWTData, n5);
        cBlkRateDistStats.m = cBlkWTData.m;
        cBlkRateDistStats.n = cBlkWTData.n;
        cBlkRateDistStats.sb = cBlkWTData.sb;
        cBlkRateDistStats.nROIcoeff = cBlkWTData.nROIcoeff;
        cBlkRateDistStats.skipMSBP = n6;
        cBlkRateDistStats.nROIcp = cBlkRateDistStats.nROIcoeff != 0 ? 3 * (cBlkWTData.nROIbp - n6 - 1) + 1 : 0;
        switch (cBlkWTData.sb.orientation) {
            case 1: {
                nArray5 = ZC_LUT_HL;
                break;
            }
            case 0: 
            case 2: {
                nArray5 = ZC_LUT_LH;
                break;
            }
            case 3: {
                nArray5 = ZC_LUT_HH;
                break;
            }
            default: {
                throw new Error("JJ2000 internal error");
            }
        }
        int n7 = 30 - n6;
        int[] nArray6 = FS_LOSSY;
        int[] nArray7 = FM_LOSSY;
        double d = Math.pow(2.0, (n7 - n5 << 1) - 13) * (double)cBlkWTData.sb.stepWMSE * (double)cBlkWTData.wmseScaling;
        double d2 = 0.0;
        int n8 = 0;
        int n9 = -1;
        if (n7 >= n5) {
            if (bl && n7 == n5) {
                nArray6 = FM_LOSSLESS;
            }
            blArray[n8] = (n2 & 4) != 0 || n7 == n5 || (n2 & 1) != 0 && 27 - n6 >= n7;
            dArray[n8] = d2 += (double)StdEntropyCoder.cleanuppass(cBlkWTData, mQCoder, blArray[n8], n7, nArray, nArray6, nArray5, nArray3, nArray4, nArray2, n8, n9, n2) * d;
            if (blArray[n8]) {
                n9 = n8;
            }
            ++n8;
            d *= 0.25;
            --n7;
        }
        while (n7 >= n5) {
            if (bl && n7 == n5) {
                nArray6 = FS_LOSSLESS;
                nArray7 = FM_LOSSLESS;
            }
            boolean bl2 = blArray[n8] = (n2 & 4) != 0;
            if ((n2 & 1) == 0 || 27 - n6 <= n7) {
                d2 += (double)StdEntropyCoder.sigProgPass(cBlkWTData, mQCoder, blArray[n8], n7, nArray, nArray6, nArray5, nArray3, nArray4, nArray2, n8, n9, n2) * d;
            } else {
                bitToByteOutput.setPredTerm((n2 & 0x10) != 0);
                d2 += (double)StdEntropyCoder.rawSigProgPass(cBlkWTData, bitToByteOutput, blArray[n8], n7, nArray, nArray6, nArray2, n8, n9, n2) * d;
            }
            dArray[n8] = d2;
            if (blArray[n8]) {
                n9 = n8;
            }
            boolean bl3 = blArray[++n8] = (n2 & 4) != 0 || (n2 & 1) != 0 && 27 - n6 > n7;
            if ((n2 & 1) == 0 || 27 - n6 <= n7) {
                d2 += (double)StdEntropyCoder.magRefPass(cBlkWTData, mQCoder, blArray[n8], n7, nArray, nArray7, nArray3, nArray4, nArray2, n8, n9, n2) * d;
            } else {
                bitToByteOutput.setPredTerm((n2 & 0x10) != 0);
                d2 += (double)StdEntropyCoder.rawMagRefPass(cBlkWTData, bitToByteOutput, blArray[n8], n7, nArray, nArray7, nArray2, n8, n9, n2) * d;
            }
            dArray[n8] = d2;
            if (blArray[n8]) {
                n9 = n8;
            }
            blArray[++n8] = (n2 & 4) != 0 || n7 == n5 || (n2 & 1) != 0 && 27 - n6 >= n7;
            dArray[n8] = d2 += (double)StdEntropyCoder.cleanuppass(cBlkWTData, mQCoder, blArray[n8], n7, nArray, nArray6, nArray5, nArray3, nArray4, nArray2, n8, n9, n2) * d;
            if (blArray[n8]) {
                n9 = n8;
            }
            ++n8;
            d *= 0.25;
            --n7;
        }
        cBlkRateDistStats.data = new byte[byteOutputBuffer.size()];
        byteOutputBuffer.toByteArray(0, byteOutputBuffer.size(), cBlkRateDistStats.data, 0);
        StdEntropyCoder.checkEndOfPassFF(cBlkRateDistStats.data, nArray2, blArray, n8);
        cBlkRateDistStats.selectConvexHull(nArray2, dArray, (boolean[])((n2 & 5) != 0 ? blArray : null), n8, bl);
        mQCoder.reset();
        if (bitToByteOutput != null) {
            bitToByteOutput.reset();
        }
    }

    private static int calcSkipMSBP(CBlkWTData cBlkWTData, int n) {
        int[] nArray = (int[])cBlkWTData.getData();
        int n2 = cBlkWTData.w;
        int n3 = cBlkWTData.h;
        int n4 = 0;
        int n5 = Integer.MAX_VALUE & ~((1 << n) - 1);
        int n6 = cBlkWTData.offset;
        for (int i = n3 - 1; i >= 0; --i) {
            int n7 = n6 + n2;
            while (n6 < n7) {
                int n8 = nArray[n6] & n5;
                if (n8 > n4) {
                    n4 = n8;
                }
                ++n6;
            }
            n6 += cBlkWTData.scanw - n2;
        }
        int n9 = 30;
        while ((1 << n9 & n4) == 0 && --n9 >= n) {
        }
        return 30 - n9;
    }

    /*
     * Unable to fully structure code
     */
    private static int sigProgPass(CBlkWTData var0, MQCoder var1_1, boolean var2_2, int var3_3, int[] var4_4, int[] var5_5, int[] var6_6, int[] var7_7, int[] var8_8, int[] var9_9, int var10_10, int var11_11, int var12_12) {
        var17_13 = 0;
        var18_14 = var0.scanw;
        var19_15 = var0.w + 2;
        var20_16 = var19_15 * 4 / 2 - var0.w;
        var21_17 = var18_14 * 4 - var0.w;
        var24_18 = 1 << var3_3;
        var27_19 = (int[])var0.getData();
        var35_20 = (var0.h + 4 - 1) / 4;
        var28_21 = 0;
        var29_22 = var3_3 - 6;
        var30_23 = var29_22 >= 0 ? 0 : -var29_22;
        var31_24 = var29_22 <= 0 ? 0 : var29_22;
        var34_25 = (var12_12 & 8) != 0;
        var37_26 = -var19_15 - 1;
        var38_27 = -var19_15 + 1;
        var39_28 = var19_15 + 1;
        var40_29 = var19_15 - 1;
        var16_30 = var0.offset;
        var14_31 = var19_15 + 1;
        var33_32 = var35_20 - 1;
        while (var33_32 >= 0) {
            var36_40 = var33_32 != 0 ? 4 : var0.h - (var35_20 - 1) * 4;
            var22_35 = var16_30 + var0.w;
            var17_13 = 0;
            while (var16_30 < var22_35) {
                var13_33 = var14_31;
                var23_36 = var4_4[var13_33];
                if ((~var23_36 & var23_36 << 2 & -2147450880) == 0) ** GOTO lbl101
                var15_34 = var16_30;
                if ((var23_36 & 40960) == 8192) {
                    var8_8[var17_13] = var6_6[var23_36 & 255];
                    var7_7[var17_13++] = (var27_19[var15_34] & var24_18) >>> var3_3;
                    if (var7_7[var17_13++] != 0) {
                        var25_37 = var27_19[var15_34] >>> 31;
                        var26_38 = StdEntropyCoder.SC_LUT[var23_36 >>> 4 & 511];
                        var7_7[var17_13] = var25_37 ^ var26_38 >>> 31;
                        var8_8[var17_13++] = var26_38 & 15;
                        if (!var34_25) {
                            v0 = var13_33 + var37_26;
                            var4_4[v0] = var4_4[v0] | 0x20010000;
                            v1 = var13_33 + var38_27;
                            var4_4[v1] = var4_4[v1] | 0x20020000;
                        }
                        if (var25_37 != 0) {
                            var23_36 |= 606126080;
                            if (!var34_25) {
                                v2 = var13_33 - var19_15;
                                var4_4[v2] = var4_4[v2] | 0x22100000;
                            }
                            v3 = var13_33 + 1;
                            var4_4[v3] = var4_4[v3] | 537407616;
                            v4 = var13_33 - 1;
                            var4_4[v4] = var4_4[v4] | 537143360;
                        } else {
                            var23_36 |= 0x2020C000;
                            if (!var34_25) {
                                v5 = var13_33 - var19_15;
                                var4_4[v5] = var4_4[v5] | 0x20100000;
                            }
                            v6 = var13_33 + 1;
                            var4_4[v6] = var4_4[v6] | 0x20082080;
                            v7 = var13_33 - 1;
                            var4_4[v7] = var4_4[v7] | 0x20042040;
                        }
                        var32_39 = var27_19[var15_34] >> var31_24 << var30_23;
                        var28_21 += var5_5[var32_39 & 63];
                    } else {
                        var23_36 |= 16384;
                    }
                }
                if (var36_40 < 2) {
                    var4_4[var13_33] = var23_36;
                } else {
                    if ((var23_36 & -1610612736) == 0x20000000) {
                        var8_8[var17_13] = var6_6[var23_36 >>> 16 & 255];
                        var7_7[var17_13++] = (var27_19[var15_34 += var18_14] & var24_18) >>> var3_3;
                        if (var7_7[var17_13++] != 0) {
                            var25_37 = var27_19[var15_34] >>> 31;
                            var26_38 = StdEntropyCoder.SC_LUT[var23_36 >>> 20 & 511];
                            var7_7[var17_13] = var25_37 ^ var26_38 >>> 31;
                            var8_8[var17_13++] = var26_38 & 15;
                            v8 = var13_33 + var40_29;
                            var4_4[v8] = var4_4[v8] | 8196;
                            v9 = var13_33 + var39_28;
                            var4_4[v9] = var4_4[v9] | 8200;
                            if (var25_37 != 0) {
                                var23_36 |= -1073733104;
                                v10 = var13_33 + var19_15;
                                var4_4[v10] = var4_4[v10] | 9248;
                                v11 = var13_33 + 1;
                                var4_4[v11] = var4_4[v11] | 813703170;
                                v12 = var13_33 - 1;
                                var4_4[v12] = var4_4[v12] | 675291137;
                            } else {
                                var23_36 |= -1073733616;
                                v13 = var13_33 + var19_15;
                                var4_4[v13] = var4_4[v13] | 8224;
                                v14 = var13_33 + 1;
                                var4_4[v14] = var4_4[v14] | 0x20802002;
                                v15 = var13_33 - 1;
                                var4_4[v15] = var4_4[v15] | 541073409;
                            }
                            var32_39 = var27_19[var15_34] >> var31_24 << var30_23;
                            var28_21 += var5_5[var32_39 & 63];
                        } else {
                            var23_36 |= 0x40000000;
                        }
                    }
                    var4_4[var13_33] = var23_36;
lbl101:
                    // 2 sources

                    if (var36_40 >= 3 && (~(var23_36 = var4_4[var13_33 += var19_15]) & var23_36 << 2 & -2147450880) != 0) {
                        var15_34 = var16_30 + (var18_14 << 1);
                        if ((var23_36 & 40960) == 8192) {
                            var8_8[var17_13] = var6_6[var23_36 & 255];
                            var7_7[var17_13++] = (var27_19[var15_34] & var24_18) >>> var3_3;
                            if (var7_7[var17_13++] != 0) {
                                var25_37 = var27_19[var15_34] >>> 31;
                                var26_38 = StdEntropyCoder.SC_LUT[var23_36 >>> 4 & 511];
                                var7_7[var17_13] = var25_37 ^ var26_38 >>> 31;
                                var8_8[var17_13++] = var26_38 & 15;
                                v16 = var13_33 + var37_26;
                                var4_4[v16] = var4_4[v16] | 0x20010000;
                                v17 = var13_33 + var38_27;
                                var4_4[v17] = var4_4[v17] | 0x20020000;
                                if (var25_37 != 0) {
                                    var23_36 |= 606126080;
                                    v18 = var13_33 - var19_15;
                                    var4_4[v18] = var4_4[v18] | 0x22100000;
                                    v19 = var13_33 + 1;
                                    var4_4[v19] = var4_4[v19] | 537407616;
                                    v20 = var13_33 - 1;
                                    var4_4[v20] = var4_4[v20] | 537143360;
                                } else {
                                    var23_36 |= 0x2020C000;
                                    v21 = var13_33 - var19_15;
                                    var4_4[v21] = var4_4[v21] | 0x20100000;
                                    v22 = var13_33 + 1;
                                    var4_4[v22] = var4_4[v22] | 0x20082080;
                                    v23 = var13_33 - 1;
                                    var4_4[v23] = var4_4[v23] | 0x20042040;
                                }
                                var32_39 = var27_19[var15_34] >> var31_24 << var30_23;
                                var28_21 += var5_5[var32_39 & 63];
                            } else {
                                var23_36 |= 16384;
                            }
                        }
                        if (var36_40 < 4) {
                            var4_4[var13_33] = var23_36;
                        } else {
                            if ((var23_36 & -1610612736) == 0x20000000) {
                                var8_8[var17_13] = var6_6[var23_36 >>> 16 & 255];
                                var7_7[var17_13++] = (var27_19[var15_34 += var18_14] & var24_18) >>> var3_3;
                                if (var7_7[var17_13++] != 0) {
                                    var25_37 = var27_19[var15_34] >>> 31;
                                    var26_38 = StdEntropyCoder.SC_LUT[var23_36 >>> 20 & 511];
                                    var7_7[var17_13] = var25_37 ^ var26_38 >>> 31;
                                    var8_8[var17_13++] = var26_38 & 15;
                                    v24 = var13_33 + var40_29;
                                    var4_4[v24] = var4_4[v24] | 8196;
                                    v25 = var13_33 + var39_28;
                                    var4_4[v25] = var4_4[v25] | 8200;
                                    if (var25_37 != 0) {
                                        var23_36 |= -1073733104;
                                        v26 = var13_33 + var19_15;
                                        var4_4[v26] = var4_4[v26] | 9248;
                                        v27 = var13_33 + 1;
                                        var4_4[v27] = var4_4[v27] | 813703170;
                                        v28 = var13_33 - 1;
                                        var4_4[v28] = var4_4[v28] | 675291137;
                                    } else {
                                        var23_36 |= -1073733616;
                                        v29 = var13_33 + var19_15;
                                        var4_4[v29] = var4_4[v29] | 8224;
                                        v30 = var13_33 + 1;
                                        var4_4[v30] = var4_4[v30] | 0x20802002;
                                        v31 = var13_33 - 1;
                                        var4_4[v31] = var4_4[v31] | 541073409;
                                    }
                                    var32_39 = var27_19[var15_34] >> var31_24 << var30_23;
                                    var28_21 += var5_5[var32_39 & 63];
                                } else {
                                    var23_36 |= 0x40000000;
                                }
                            }
                            var4_4[var13_33] = var23_36;
                        }
                    }
                }
                ++var16_30;
                ++var14_31;
            }
            var1_1.codeSymbols(var7_7, var8_8, var17_13);
            --var33_32;
            var16_30 += var21_17;
            var14_31 += var20_16;
        }
        if ((var12_12 & 2) != 0) {
            var1_1.resetCtxts();
        }
        var9_9[var10_10] = var2_2 != false ? var1_1.terminate() : var1_1.getNumCodedBytes();
        if (var11_11 >= 0) {
            v32 = var10_10;
            var9_9[v32] = var9_9[v32] + var9_9[var11_11];
        }
        if (var2_2) {
            var1_1.finishLengthCalculation(var9_9, var10_10);
        }
        return var28_21;
    }

    /*
     * Unable to fully structure code
     */
    private static int rawSigProgPass(CBlkWTData var0, BitToByteOutput var1_1, boolean var2_2, int var3_3, int[] var4_4, int[] var5_5, int[] var6_6, int var7_7, int var8_8, int var9_9) {
        var21_10 = 0;
        var14_11 = var0.scanw;
        var15_12 = var0.w + 2;
        var16_13 = var15_12 * 4 / 2 - var0.w;
        var17_14 = var14_11 * 4 - var0.w;
        var20_15 = 1 << var3_3;
        var23_16 = (int[])var0.getData();
        var31_17 = (var0.h + 4 - 1) / 4;
        var24_18 = 0;
        var25_19 = var3_3 - 6;
        var26_20 = var25_19 >= 0 ? 0 : -var25_19;
        var27_21 = var25_19 <= 0 ? 0 : var25_19;
        var30_22 = (var9_9 & 8) != 0;
        var33_23 = -var15_12 - 1;
        var34_24 = -var15_12 + 1;
        var35_25 = var15_12 + 1;
        var36_26 = var15_12 - 1;
        var13_27 = var0.offset;
        var11_28 = var15_12 + 1;
        var29_29 = var31_17 - 1;
        while (var29_29 >= 0) {
            var32_36 = var29_29 != 0 ? 4 : var0.h - (var31_17 - 1) * 4;
            var18_32 = var13_27 + var0.w;
            while (var13_27 < var18_32) {
                var10_30 = var11_28;
                var19_33 = var4_4[var10_30];
                if ((~var19_33 & var19_33 << 2 & -2147450880) == 0) ** GOTO lbl100
                var12_31 = var13_27;
                if ((var19_33 & 40960) == 8192) {
                    var22_34 = (var23_16[var12_31] & var20_15) >>> var3_3;
                    var1_1.writeBit(var22_34);
                    ++var21_10;
                    if (var22_34 != 0) {
                        var22_34 = var23_16[var12_31] >>> 31;
                        var1_1.writeBit(var22_34);
                        ++var21_10;
                        if (!var30_22) {
                            v0 = var10_30 + var33_23;
                            var4_4[v0] = var4_4[v0] | 0x20010000;
                            v1 = var10_30 + var34_24;
                            var4_4[v1] = var4_4[v1] | 0x20020000;
                        }
                        if (var22_34 != 0) {
                            var19_33 |= 606126080;
                            if (!var30_22) {
                                v2 = var10_30 - var15_12;
                                var4_4[v2] = var4_4[v2] | 0x22100000;
                            }
                            v3 = var10_30 + 1;
                            var4_4[v3] = var4_4[v3] | 537407616;
                            v4 = var10_30 - 1;
                            var4_4[v4] = var4_4[v4] | 537143360;
                        } else {
                            var19_33 |= 0x2020C000;
                            if (!var30_22) {
                                v5 = var10_30 - var15_12;
                                var4_4[v5] = var4_4[v5] | 0x20100000;
                            }
                            v6 = var10_30 + 1;
                            var4_4[v6] = var4_4[v6] | 0x20082080;
                            v7 = var10_30 - 1;
                            var4_4[v7] = var4_4[v7] | 0x20042040;
                        }
                        var28_35 = var23_16[var12_31] >> var27_21 << var26_20;
                        var24_18 += var5_5[var28_35 & 63];
                    } else {
                        var19_33 |= 16384;
                    }
                }
                if (var32_36 < 2) {
                    var4_4[var10_30] = var19_33;
                } else {
                    if ((var19_33 & -1610612736) == 0x20000000) {
                        var22_34 = (var23_16[var12_31 += var14_11] & var20_15) >>> var3_3;
                        var1_1.writeBit(var22_34);
                        ++var21_10;
                        if (var22_34 != 0) {
                            var22_34 = var23_16[var12_31] >>> 31;
                            var1_1.writeBit(var22_34);
                            ++var21_10;
                            v8 = var10_30 + var36_26;
                            var4_4[v8] = var4_4[v8] | 8196;
                            v9 = var10_30 + var35_25;
                            var4_4[v9] = var4_4[v9] | 8200;
                            if (var22_34 != 0) {
                                var19_33 |= -1073733104;
                                v10 = var10_30 + var15_12;
                                var4_4[v10] = var4_4[v10] | 9248;
                                v11 = var10_30 + 1;
                                var4_4[v11] = var4_4[v11] | 813703170;
                                v12 = var10_30 - 1;
                                var4_4[v12] = var4_4[v12] | 675291137;
                            } else {
                                var19_33 |= -1073733616;
                                v13 = var10_30 + var15_12;
                                var4_4[v13] = var4_4[v13] | 8224;
                                v14 = var10_30 + 1;
                                var4_4[v14] = var4_4[v14] | 0x20802002;
                                v15 = var10_30 - 1;
                                var4_4[v15] = var4_4[v15] | 541073409;
                            }
                            var28_35 = var23_16[var12_31] >> var27_21 << var26_20;
                            var24_18 += var5_5[var28_35 & 63];
                        } else {
                            var19_33 |= 0x40000000;
                        }
                    }
                    var4_4[var10_30] = var19_33;
lbl100:
                    // 2 sources

                    if (var32_36 >= 3 && (~(var19_33 = var4_4[var10_30 += var15_12]) & var19_33 << 2 & -2147450880) != 0) {
                        var12_31 = var13_27 + (var14_11 << 1);
                        if ((var19_33 & 40960) == 8192) {
                            var22_34 = (var23_16[var12_31] & var20_15) >>> var3_3;
                            var1_1.writeBit(var22_34);
                            ++var21_10;
                            if (var22_34 != 0) {
                                var22_34 = var23_16[var12_31] >>> 31;
                                var1_1.writeBit(var22_34);
                                ++var21_10;
                                v16 = var10_30 + var33_23;
                                var4_4[v16] = var4_4[v16] | 0x20010000;
                                v17 = var10_30 + var34_24;
                                var4_4[v17] = var4_4[v17] | 0x20020000;
                                if (var22_34 != 0) {
                                    var19_33 |= 606126080;
                                    v18 = var10_30 - var15_12;
                                    var4_4[v18] = var4_4[v18] | 0x22100000;
                                    v19 = var10_30 + 1;
                                    var4_4[v19] = var4_4[v19] | 537407616;
                                    v20 = var10_30 - 1;
                                    var4_4[v20] = var4_4[v20] | 537143360;
                                } else {
                                    var19_33 |= 0x2020C000;
                                    v21 = var10_30 - var15_12;
                                    var4_4[v21] = var4_4[v21] | 0x20100000;
                                    v22 = var10_30 + 1;
                                    var4_4[v22] = var4_4[v22] | 0x20082080;
                                    v23 = var10_30 - 1;
                                    var4_4[v23] = var4_4[v23] | 0x20042040;
                                }
                                var28_35 = var23_16[var12_31] >> var27_21 << var26_20;
                                var24_18 += var5_5[var28_35 & 63];
                            } else {
                                var19_33 |= 16384;
                            }
                        }
                        if (var32_36 < 4) {
                            var4_4[var10_30] = var19_33;
                        } else {
                            if ((var19_33 & -1610612736) == 0x20000000) {
                                var22_34 = (var23_16[var12_31 += var14_11] & var20_15) >>> var3_3;
                                var1_1.writeBit(var22_34);
                                ++var21_10;
                                if (var22_34 != 0) {
                                    var22_34 = var23_16[var12_31] >>> 31;
                                    var1_1.writeBit(var22_34);
                                    ++var21_10;
                                    v24 = var10_30 + var36_26;
                                    var4_4[v24] = var4_4[v24] | 8196;
                                    v25 = var10_30 + var35_25;
                                    var4_4[v25] = var4_4[v25] | 8200;
                                    if (var22_34 != 0) {
                                        var19_33 |= -1073733104;
                                        v26 = var10_30 + var15_12;
                                        var4_4[v26] = var4_4[v26] | 9248;
                                        v27 = var10_30 + 1;
                                        var4_4[v27] = var4_4[v27] | 813703170;
                                        v28 = var10_30 - 1;
                                        var4_4[v28] = var4_4[v28] | 675291137;
                                    } else {
                                        var19_33 |= -1073733616;
                                        v29 = var10_30 + var15_12;
                                        var4_4[v29] = var4_4[v29] | 8224;
                                        v30 = var10_30 + 1;
                                        var4_4[v30] = var4_4[v30] | 0x20802002;
                                        v31 = var10_30 - 1;
                                        var4_4[v31] = var4_4[v31] | 541073409;
                                    }
                                    var28_35 = var23_16[var12_31] >> var27_21 << var26_20;
                                    var24_18 += var5_5[var28_35 & 63];
                                } else {
                                    var19_33 |= 0x40000000;
                                }
                            }
                            var4_4[var10_30] = var19_33;
                        }
                    }
                }
                ++var13_27;
                ++var11_28;
            }
            --var29_29;
            var13_27 += var17_14;
            var11_28 += var16_13;
        }
        var6_6[var7_7] = var2_2 != false ? var1_1.terminate() : var1_1.length();
        if (var8_8 >= 0) {
            v32 = var7_7;
            var6_6[v32] = var6_6[v32] + var6_6[var8_8];
        }
        return var24_18;
    }

    /*
     * Unable to fully structure code
     */
    private static int magRefPass(CBlkWTData var0, MQCoder var1_1, boolean var2_2, int var3_3, int[] var4_4, int[] var5_5, int[] var6_6, int[] var7_7, int[] var8_8, int var9_9, int var10_10, int var11_11) {
        var16_12 = 0;
        var17_13 = var0.scanw;
        var18_14 = var0.w + 2;
        var19_15 = var18_14 * 4 / 2 - var0.w;
        var20_16 = var17_13 * 4 - var0.w;
        var23_17 = 1 << var3_3;
        var24_18 = (int[])var0.getData();
        var31_19 = (var0.h + 4 - 1) / 4;
        var25_20 = 0;
        var26_21 = var3_3 - 6;
        var27_22 = var26_21 >= 0 ? 0 : -var26_21;
        var28_23 = var26_21 <= 0 ? 0 : var26_21;
        var15_24 = var0.offset;
        var13_25 = var18_14 + 1;
        var30_26 = var31_19 - 1;
        while (var30_26 >= 0) {
            var32_32 = var30_26 != 0 ? 4 : var0.h - (var31_19 - 1) * 4;
            var21_29 = var15_24 + var0.w;
            var16_12 = 0;
            while (var15_24 < var21_29) {
                var12_27 = var13_25;
                var22_30 = var4_4[var12_27];
                if ((var22_30 >>> 1 & ~var22_30 & 0x40004000) == 0) ** GOTO lbl41
                var14_28 = var15_24;
                if ((var22_30 & 49152) == 32768) {
                    var6_6[var16_12] = (var24_18[var14_28] & var23_17) >>> var3_3;
                    var7_7[var16_12++] = StdEntropyCoder.MR_LUT[var22_30 & 511];
                    var22_30 |= 256;
                    var29_31 = var24_18[var14_28] >> var28_23 << var27_22;
                    var25_20 += var5_5[var29_31 & 127];
                }
                if (var32_32 < 2) {
                    var4_4[var12_27] = var22_30;
                } else {
                    if ((var22_30 & -1073741824) == -2147483648) {
                        var6_6[var16_12] = (var24_18[var14_28 += var17_13] & var23_17) >>> var3_3;
                        var7_7[var16_12++] = StdEntropyCoder.MR_LUT[var22_30 >>> 16 & 511];
                        var22_30 |= 0x1000000;
                        var29_31 = var24_18[var14_28] >> var28_23 << var27_22;
                        var25_20 += var5_5[var29_31 & 127];
                    }
                    var4_4[var12_27] = var22_30;
lbl41:
                    // 2 sources

                    if (var32_32 >= 3 && ((var22_30 = var4_4[var12_27 += var18_14]) >>> 1 & ~var22_30 & 0x40004000) != 0) {
                        var14_28 = var15_24 + (var17_13 << 1);
                        if ((var22_30 & 49152) == 32768) {
                            var6_6[var16_12] = (var24_18[var14_28] & var23_17) >>> var3_3;
                            var7_7[var16_12++] = StdEntropyCoder.MR_LUT[var22_30 & 511];
                            var22_30 |= 256;
                            var29_31 = var24_18[var14_28] >> var28_23 << var27_22;
                            var25_20 += var5_5[var29_31 & 127];
                        }
                        if (var32_32 < 4) {
                            var4_4[var12_27] = var22_30;
                        } else {
                            if ((var4_4[var12_27] & -1073741824) == -2147483648) {
                                var6_6[var16_12] = (var24_18[var14_28 += var17_13] & var23_17) >>> var3_3;
                                var7_7[var16_12++] = StdEntropyCoder.MR_LUT[var22_30 >>> 16 & 511];
                                var22_30 |= 0x1000000;
                                var29_31 = var24_18[var14_28] >> var28_23 << var27_22;
                                var25_20 += var5_5[var29_31 & 127];
                            }
                            var4_4[var12_27] = var22_30;
                        }
                    }
                }
                ++var15_24;
                ++var13_25;
            }
            if (var16_12 > 0) {
                var1_1.codeSymbols(var6_6, var7_7, var16_12);
            }
            --var30_26;
            var15_24 += var20_16;
            var13_25 += var19_15;
        }
        if ((var11_11 & 2) != 0) {
            var1_1.resetCtxts();
        }
        var8_8[var9_9] = var2_2 != false ? var1_1.terminate() : var1_1.getNumCodedBytes();
        if (var10_10 >= 0) {
            v0 = var9_9;
            var8_8[v0] = var8_8[v0] + var8_8[var10_10];
        }
        if (var2_2) {
            var1_1.finishLengthCalculation(var8_8, var9_9);
        }
        return var25_20;
    }

    private static int rawMagRefPass(CBlkWTData cBlkWTData, BitToByteOutput bitToByteOutput, boolean bl, int n, int[] nArray, int[] nArray2, int[] nArray3, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = cBlkWTData.scanw;
        int n7 = cBlkWTData.w + 2;
        int n8 = n7 * 4 / 2 - cBlkWTData.w;
        int n9 = n6 * 4 - cBlkWTData.w;
        int n10 = 1 << n;
        int[] nArray4 = (int[])cBlkWTData.getData();
        int n11 = (cBlkWTData.h + 4 - 1) / 4;
        int n12 = 0;
        int n13 = n - 6;
        int n14 = n13 >= 0 ? 0 : -n13;
        int n15 = n13 <= 0 ? 0 : n13;
        int n16 = cBlkWTData.offset;
        int n17 = n7 + 1;
        int n18 = n11 - 1;
        while (n18 >= 0) {
            int n19 = n18 != 0 ? 4 : cBlkWTData.h - (n11 - 1) * 4;
            int n20 = n16 + cBlkWTData.w;
            while (n16 < n20) {
                block12: {
                    int n21;
                    int n22;
                    int n23;
                    int n24;
                    block11: {
                        n24 = n17;
                        n23 = nArray[n24];
                        if ((n23 >>> 1 & ~n23 & 0x40004000) == 0) break block11;
                        n22 = n16;
                        if ((n23 & 0xC000) == 32768) {
                            bitToByteOutput.writeBit((nArray4[n22] & n10) >>> n);
                            ++n5;
                            n21 = nArray4[n22] >> n15 << n14;
                            n12 += nArray2[n21 & 0x7F];
                        }
                        if (n19 < 2) break block12;
                        if ((n23 & 0xC0000000) == Integer.MIN_VALUE) {
                            bitToByteOutput.writeBit((nArray4[n22 += n6] & n10) >>> n);
                            ++n5;
                            n21 = nArray4[n22] >> n15 << n14;
                            n12 += nArray2[n21 & 0x7F];
                        }
                    }
                    if (n19 >= 3 && ((n23 = nArray[n24 += n7]) >>> 1 & ~n23 & 0x40004000) != 0) {
                        n22 = n16 + (n6 << 1);
                        if ((n23 & 0xC000) == 32768) {
                            bitToByteOutput.writeBit((nArray4[n22] & n10) >>> n);
                            ++n5;
                            n21 = nArray4[n22] >> n15 << n14;
                            n12 += nArray2[n21 & 0x7F];
                        }
                        if (n19 >= 4 && (nArray[n24] & 0xC0000000) == Integer.MIN_VALUE) {
                            bitToByteOutput.writeBit((nArray4[n22 += n6] & n10) >>> n);
                            ++n5;
                            n21 = nArray4[n22] >> n15 << n14;
                            n12 += nArray2[n21 & 0x7F];
                        }
                    }
                }
                ++n16;
                ++n17;
            }
            --n18;
            n16 += n9;
            n17 += n8;
        }
        nArray3[n2] = bl ? bitToByteOutput.terminate() : bitToByteOutput.length();
        if (n3 >= 0) {
            int n25 = n2;
            nArray3[n25] = nArray3[n25] + nArray3[n3];
        }
        return n12;
    }

    /*
     * Unable to fully structure code
     */
    private static int cleanuppass(CBlkWTData var0, MQCoder var1_1, boolean var2_2, int var3_3, int[] var4_4, int[] var5_5, int[] var6_6, int[] var7_7, int[] var8_8, int[] var9_9, int var10_10, int var11_11, int var12_12) {
        var17_13 = 0;
        var18_14 = var0.scanw;
        var19_15 = var0.w + 2;
        var20_16 = var19_15 * 4 / 2 - var0.w;
        var21_17 = var18_14 * 4 - var0.w;
        var24_18 = 1 << var3_3;
        var28_19 = (int[])var0.getData();
        var36_20 = (var0.h + 4 - 1) / 4;
        var29_21 = 0;
        var30_22 = var3_3 - 6;
        var31_23 = var30_22 >= 0 ? 0 : -var30_22;
        var32_24 = var30_22 <= 0 ? 0 : var30_22;
        var35_25 = (var12_12 & 8) != 0;
        var38_26 = -var19_15 - 1;
        var39_27 = -var19_15 + 1;
        var40_28 = var19_15 + 1;
        var41_29 = var19_15 - 1;
        var16_30 = var0.offset;
        var14_31 = var19_15 + 1;
        var34_32 = var36_20 - 1;
        while (var34_32 >= 0) {
            var37_41 = var34_32 != 0 ? 4 : var0.h - (var36_20 - 1) * 4;
            var22_35 = var16_30 + var0.w;
            var17_13 = 0;
            while (var16_30 < var22_35) {
                block41: {
                    block43: {
                        block44: {
                            block45: {
                                block35: {
                                    block42: {
                                        block37: {
                                            block40: {
                                                block39: {
                                                    block38: {
                                                        block36: {
                                                            var13_33 = var14_31;
                                                            var23_36 = var4_4[var13_33];
                                                            if (var23_36 != 0 || var4_4[var13_33 + var19_15] != 0 || var37_41 != 4) break block35;
                                                            var15_34 = var16_30;
                                                            if ((var28_19[var15_34] & var24_18) == 0) break block36;
                                                            var26_38 = 0;
                                                            break block37;
                                                        }
                                                        if ((var28_19[var15_34 += var18_14] & var24_18) == 0) break block38;
                                                        var26_38 = 1;
                                                        break block37;
                                                    }
                                                    if ((var28_19[var15_34 += var18_14] & var24_18) == 0) break block39;
                                                    var26_38 = 2;
                                                    var23_36 = var4_4[var13_33 += var19_15];
                                                    break block37;
                                                }
                                                if ((var28_19[var15_34 += var18_14] & var24_18) != 0) break block40;
                                                var7_7[var17_13] = 0;
                                                var8_8[var17_13++] = 1;
                                                break block41;
                                            }
                                            var26_38 = 3;
                                            var23_36 = var4_4[var13_33 += var19_15];
                                        }
                                        var7_7[var17_13] = 1;
                                        var8_8[var17_13++] = 1;
                                        var7_7[var17_13] = var26_38 >> 1;
                                        var8_8[var17_13++] = 0;
                                        var7_7[var17_13] = var26_38 & 1;
                                        var8_8[var17_13++] = 0;
                                        var33_40 = var28_19[var15_34] >> var32_24 << var31_23;
                                        var29_21 += var5_5[var33_40 & 63];
                                        var25_37 = var28_19[var15_34] >>> 31;
                                        if ((var26_38 & 1) != 0) break block42;
                                        var27_39 = StdEntropyCoder.SC_LUT[var23_36 >>> 4 & 511];
                                        var7_7[var17_13] = var25_37 ^ var27_39 >>> 31;
                                        var8_8[var17_13++] = var27_39 & 15;
                                        if (var26_38 != 0 || !var35_25) {
                                            v0 = var13_33 + var38_26;
                                            var4_4[v0] = var4_4[v0] | 0x20010000;
                                            v1 = var13_33 + var39_27;
                                            var4_4[v1] = var4_4[v1] | 0x20020000;
                                        }
                                        if (var25_37 != 0) {
                                            var23_36 |= 606126080;
                                            if (var26_38 != 0 || !var35_25) {
                                                v2 = var13_33 - var19_15;
                                                var4_4[v2] = var4_4[v2] | 0x22100000;
                                            }
                                            v3 = var13_33 + 1;
                                            var4_4[v3] = var4_4[v3] | 537407616;
                                            v4 = var13_33 - 1;
                                            var4_4[v4] = var4_4[v4] | 537143360;
                                        } else {
                                            var23_36 |= 0x2020C000;
                                            if (var26_38 != 0 || !var35_25) {
                                                v5 = var13_33 - var19_15;
                                                var4_4[v5] = var4_4[v5] | 0x20100000;
                                            }
                                            v6 = var13_33 + 1;
                                            var4_4[v6] = var4_4[v6] | 0x20082080;
                                            v7 = var13_33 - 1;
                                            var4_4[v7] = var4_4[v7] | 0x20042040;
                                        }
                                        if (var26_38 >> 1 == 0) break block35;
                                        break block43;
                                    }
                                    var27_39 = StdEntropyCoder.SC_LUT[var23_36 >>> 20 & 511];
                                    var7_7[var17_13] = var25_37 ^ var27_39 >>> 31;
                                    var8_8[var17_13++] = var27_39 & 15;
                                    v8 = var13_33 + var41_29;
                                    var4_4[v8] = var4_4[v8] | 8196;
                                    v9 = var13_33 + var40_28;
                                    var4_4[v9] = var4_4[v9] | 8200;
                                    if (var25_37 != 0) {
                                        var23_36 |= -2147474928;
                                        v10 = var13_33 + var19_15;
                                        var4_4[v10] = var4_4[v10] | 9248;
                                        v11 = var13_33 + 1;
                                        var4_4[v11] = var4_4[v11] | 813703170;
                                        v12 = var13_33 - 1;
                                        var4_4[v12] = var4_4[v12] | 675291137;
                                    } else {
                                        var23_36 |= -2147475440;
                                        v13 = var13_33 + var19_15;
                                        var4_4[v13] = var4_4[v13] | 8224;
                                        v14 = var13_33 + 1;
                                        var4_4[v14] = var4_4[v14] | 0x20802002;
                                        v15 = var13_33 - 1;
                                        var4_4[v15] = var4_4[v15] | 541073409;
                                    }
                                    var4_4[var13_33] = var23_36;
                                    if (var26_38 >> 1 != 0) break block41;
                                    var23_36 = var4_4[var13_33 += var19_15];
                                    break block43;
                                }
                                if (((var23_36 >> 1 | var23_36) & 0x40004000) == 0x40004000) break block44;
                                var15_34 = var16_30;
                                if ((var23_36 & 49152) == 0) {
                                    var8_8[var17_13] = var6_6[var23_36 & 255];
                                    var7_7[var17_13++] = (var28_19[var15_34] & var24_18) >>> var3_3;
                                    if (var7_7[var17_13++] != 0) {
                                        var25_37 = var28_19[var15_34] >>> 31;
                                        var27_39 = StdEntropyCoder.SC_LUT[var23_36 >>> 4 & 511];
                                        var7_7[var17_13] = var25_37 ^ var27_39 >>> 31;
                                        var8_8[var17_13++] = var27_39 & 15;
                                        if (!var35_25) {
                                            v16 = var13_33 + var38_26;
                                            var4_4[v16] = var4_4[v16] | 0x20010000;
                                            v17 = var13_33 + var39_27;
                                            var4_4[v17] = var4_4[v17] | 0x20020000;
                                        }
                                        if (var25_37 != 0) {
                                            var23_36 |= 606126080;
                                            if (!var35_25) {
                                                v18 = var13_33 - var19_15;
                                                var4_4[v18] = var4_4[v18] | 0x22100000;
                                            }
                                            v19 = var13_33 + 1;
                                            var4_4[v19] = var4_4[v19] | 537407616;
                                            v20 = var13_33 - 1;
                                            var4_4[v20] = var4_4[v20] | 537143360;
                                        } else {
                                            var23_36 |= 0x2020C000;
                                            if (!var35_25) {
                                                v21 = var13_33 - var19_15;
                                                var4_4[v21] = var4_4[v21] | 0x20100000;
                                            }
                                            v22 = var13_33 + 1;
                                            var4_4[v22] = var4_4[v22] | 0x20082080;
                                            v23 = var13_33 - 1;
                                            var4_4[v23] = var4_4[v23] | 0x20042040;
                                        }
                                        var33_40 = var28_19[var15_34] >> var32_24 << var31_23;
                                        var29_21 += var5_5[var33_40 & 63];
                                    }
                                }
                                if (var37_41 >= 2) break block45;
                                var4_4[var13_33] = var23_36 &= -1073758209;
                                break block41;
                            }
                            if ((var23_36 & -1073741824) == 0) {
                                var8_8[var17_13] = var6_6[var23_36 >>> 16 & 255];
                                var7_7[var17_13++] = (var28_19[var15_34 += var18_14] & var24_18) >>> var3_3;
                                if (var7_7[var17_13++] != 0) {
                                    var25_37 = var28_19[var15_34] >>> 31;
                                    var27_39 = StdEntropyCoder.SC_LUT[var23_36 >>> 20 & 511];
                                    var7_7[var17_13] = var25_37 ^ var27_39 >>> 31;
                                    var8_8[var17_13++] = var27_39 & 15;
                                    v24 = var13_33 + var41_29;
                                    var4_4[v24] = var4_4[v24] | 8196;
                                    v25 = var13_33 + var40_28;
                                    var4_4[v25] = var4_4[v25] | 8200;
                                    if (var25_37 != 0) {
                                        var23_36 |= -1073733104;
                                        v26 = var13_33 + var19_15;
                                        var4_4[v26] = var4_4[v26] | 9248;
                                        v27 = var13_33 + 1;
                                        var4_4[v27] = var4_4[v27] | 813703170;
                                        v28 = var13_33 - 1;
                                        var4_4[v28] = var4_4[v28] | 675291137;
                                    } else {
                                        var23_36 |= -1073733616;
                                        v29 = var13_33 + var19_15;
                                        var4_4[v29] = var4_4[v29] | 8224;
                                        v30 = var13_33 + 1;
                                        var4_4[v30] = var4_4[v30] | 0x20802002;
                                        v31 = var13_33 - 1;
                                        var4_4[v31] = var4_4[v31] | 541073409;
                                    }
                                    var33_40 = var28_19[var15_34] >> var32_24 << var31_23;
                                    var29_21 += var5_5[var33_40 & 63];
                                }
                            }
                        }
                        var4_4[var13_33] = var23_36 &= -1073758209;
                        if (var37_41 < 3) break block41;
                        var23_36 = var4_4[var13_33 += var19_15];
                    }
                    if (((var23_36 >> 1 | var23_36) & 0x40004000) == 0x40004000) ** GOTO lbl257
                    var15_34 = var16_30 + (var18_14 << 1);
                    if ((var23_36 & 49152) == 0) {
                        var8_8[var17_13] = var6_6[var23_36 & 255];
                        var7_7[var17_13++] = (var28_19[var15_34] & var24_18) >>> var3_3;
                        if (var7_7[var17_13++] != 0) {
                            var25_37 = var28_19[var15_34] >>> 31;
                            var27_39 = StdEntropyCoder.SC_LUT[var23_36 >>> 4 & 511];
                            var7_7[var17_13] = var25_37 ^ var27_39 >>> 31;
                            var8_8[var17_13++] = var27_39 & 15;
                            v32 = var13_33 + var38_26;
                            var4_4[v32] = var4_4[v32] | 0x20010000;
                            v33 = var13_33 + var39_27;
                            var4_4[v33] = var4_4[v33] | 0x20020000;
                            if (var25_37 != 0) {
                                var23_36 |= 606126080;
                                v34 = var13_33 - var19_15;
                                var4_4[v34] = var4_4[v34] | 0x22100000;
                                v35 = var13_33 + 1;
                                var4_4[v35] = var4_4[v35] | 537407616;
                                v36 = var13_33 - 1;
                                var4_4[v36] = var4_4[v36] | 537143360;
                            } else {
                                var23_36 |= 0x2020C000;
                                v37 = var13_33 - var19_15;
                                var4_4[v37] = var4_4[v37] | 0x20100000;
                                v38 = var13_33 + 1;
                                var4_4[v38] = var4_4[v38] | 0x20082080;
                                v39 = var13_33 - 1;
                                var4_4[v39] = var4_4[v39] | 0x20042040;
                            }
                            var33_40 = var28_19[var15_34] >> var32_24 << var31_23;
                            var29_21 += var5_5[var33_40 & 63];
                        }
                    }
                    if (var37_41 < 4) {
                        var4_4[var13_33] = var23_36 &= -1073758209;
                    } else {
                        if ((var23_36 & -1073741824) == 0) {
                            var8_8[var17_13] = var6_6[var23_36 >>> 16 & 255];
                            var7_7[var17_13++] = (var28_19[var15_34 += var18_14] & var24_18) >>> var3_3;
                            if (var7_7[var17_13++] != 0) {
                                var25_37 = var28_19[var15_34] >>> 31;
                                var27_39 = StdEntropyCoder.SC_LUT[var23_36 >>> 20 & 511];
                                var7_7[var17_13] = var25_37 ^ var27_39 >>> 31;
                                var8_8[var17_13++] = var27_39 & 15;
                                v40 = var13_33 + var41_29;
                                var4_4[v40] = var4_4[v40] | 8196;
                                v41 = var13_33 + var40_28;
                                var4_4[v41] = var4_4[v41] | 8200;
                                if (var25_37 != 0) {
                                    var23_36 |= -1073733104;
                                    v42 = var13_33 + var19_15;
                                    var4_4[v42] = var4_4[v42] | 9248;
                                    v43 = var13_33 + 1;
                                    var4_4[v43] = var4_4[v43] | 813703170;
                                    v44 = var13_33 - 1;
                                    var4_4[v44] = var4_4[v44] | 675291137;
                                } else {
                                    var23_36 |= -1073733616;
                                    v45 = var13_33 + var19_15;
                                    var4_4[v45] = var4_4[v45] | 8224;
                                    v46 = var13_33 + 1;
                                    var4_4[v46] = var4_4[v46] | 0x20802002;
                                    v47 = var13_33 - 1;
                                    var4_4[v47] = var4_4[v47] | 541073409;
                                }
                                var33_40 = var28_19[var15_34] >> var32_24 << var31_23;
                                var29_21 += var5_5[var33_40 & 63];
                            }
                        }
lbl257:
                        // 6 sources

                        var4_4[var13_33] = var23_36 &= -1073758209;
                    }
                }
                ++var16_30;
                ++var14_31;
            }
            if (var17_13 > 0) {
                var1_1.codeSymbols(var7_7, var8_8, var17_13);
            }
            --var34_32;
            var16_30 += var21_17;
            var14_31 += var20_16;
        }
        if ((var12_12 & 32) != 0) {
            var1_1.codeSymbols(StdEntropyCoder.SEG_SYMBOLS, StdEntropyCoder.SEG_SYMB_CTXTS, StdEntropyCoder.SEG_SYMBOLS.length);
        }
        if ((var12_12 & 2) != 0) {
            var1_1.resetCtxts();
        }
        var9_9[var10_10] = var2_2 != false ? var1_1.terminate() : var1_1.getNumCodedBytes();
        if (var11_11 >= 0) {
            v48 = var10_10;
            var9_9[v48] = var9_9[v48] + var9_9[var11_11];
        }
        if (var2_2) {
            var1_1.finishLengthCalculation(var9_9, var10_10);
        }
        return var29_21;
    }

    private static void checkEndOfPassFF(byte[] byArray, int[] nArray, boolean[] blArray, int n) {
        if (blArray == null) {
            --n;
            while (n >= 0) {
                int n2 = nArray[n] - 1;
                if (n2 >= 0 && byArray[n2] == -1) {
                    int n3 = n;
                    nArray[n3] = nArray[n3] - 1;
                }
                --n;
            }
        } else {
            --n;
            while (n >= 0) {
                int n4;
                if (!blArray[n] && (n4 = nArray[n] - 1) >= 0 && byArray[n4] == -1) {
                    int n5 = n;
                    nArray[n5] = nArray[n5] - 1;
                }
                --n;
            }
        }
    }

    public void initTileComp(int n, int n2) {
        this.opts = new int[n][n2];
        this.lenCalc = new int[n][n2];
        this.tType = new int[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                String string;
                this.opts[i][j] = 0;
                if (((String)this.bms.getTileCompVal(i, j)).equalsIgnoreCase("on")) {
                    int[] nArray = this.opts[i];
                    int n3 = j;
                    nArray[n3] = nArray[n3] | 1;
                }
                if (((String)this.mqrs.getTileCompVal(i, j)).equalsIgnoreCase("on")) {
                    int[] nArray = this.opts[i];
                    int n4 = j;
                    nArray[n4] = nArray[n4] | 2;
                }
                if (((String)this.rts.getTileCompVal(i, j)).equalsIgnoreCase("on")) {
                    int[] nArray = this.opts[i];
                    int n5 = j;
                    nArray[n5] = nArray[n5] | 4;
                }
                if (((String)this.css.getTileCompVal(i, j)).equalsIgnoreCase("on")) {
                    int[] nArray = this.opts[i];
                    int n6 = j;
                    nArray[n6] = nArray[n6] | 8;
                }
                if (((String)this.sss.getTileCompVal(i, j)).equalsIgnoreCase("on")) {
                    int[] nArray = this.opts[i];
                    int n7 = j;
                    nArray[n7] = nArray[n7] | 0x20;
                }
                if ((string = (String)this.lcs.getTileCompVal(i, j)).equals("near_opt")) {
                    this.lenCalc[i][j] = 2;
                } else if (string.equals("lazy_good")) {
                    this.lenCalc[i][j] = 1;
                } else if (string.equals("lazy")) {
                    this.lenCalc[i][j] = 0;
                } else {
                    throw new IllegalArgumentException("Unrecognized or unsupported MQ length calculation.");
                }
                String string2 = (String)this.tts.getTileCompVal(i, j);
                if (string2.equalsIgnoreCase("easy")) {
                    this.tType[i][j] = 2;
                    continue;
                }
                if (string2.equalsIgnoreCase("full")) {
                    this.tType[i][j] = 0;
                    continue;
                }
                if (string2.equalsIgnoreCase("near_opt")) {
                    this.tType[i][j] = 1;
                    continue;
                }
                if (string2.equalsIgnoreCase("predict")) {
                    this.tType[i][j] = 3;
                    int[] nArray = this.opts[i];
                    int n8 = j;
                    nArray[n8] = nArray[n8] | 0x10;
                    if ((this.opts[i][j] & 5) != 0) continue;
                    FacilityManager.getMsgLogger().printmsg(1, "Using error resilient MQ termination, but terminating only at the end of code-blocks. The error protection offered by this option will be very weak. Specify the 'Cterminate' and/or 'Cbypass' option for increased error resilience.");
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized or unsupported MQ coder termination.");
            }
        }
    }

    public int getPPX(int n, int n2, int n3) {
        return this.pss.getPPX(n, n2, n3);
    }

    public int getPPY(int n, int n2, int n3) {
        return this.pss.getPPY(n, n2, n3);
    }

    public boolean precinctPartitionUsed(int n, int n2) {
        return this.precinctPartition[n][n2];
    }

    static {
        double d;
        double d2;
        int n;
        int n2;
        ZC_LUT_LH = new int[256];
        ZC_LUT_HL = new int[256];
        ZC_LUT_HH = new int[256];
        SC_LUT = new int[512];
        MR_LUT = new int[512];
        MQ_INIT = new int[]{46, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        SEG_SYMBOLS = new int[]{1, 0, 1, 0};
        SEG_SYMB_CTXTS = new int[]{0, 0, 0, 0};
        FS_LOSSY = new int[64];
        FM_LOSSY = new int[128];
        FS_LOSSLESS = new int[64];
        FM_LOSSLESS = new int[128];
        StdEntropyCoder.ZC_LUT_LH[0] = 2;
        for (n2 = 1; n2 < 16; ++n2) {
            StdEntropyCoder.ZC_LUT_LH[n2] = 4;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            StdEntropyCoder.ZC_LUT_LH[1 << n2] = 3;
        }
        for (n2 = 0; n2 < 16; ++n2) {
            StdEntropyCoder.ZC_LUT_LH[0x20 | n2] = 5;
            StdEntropyCoder.ZC_LUT_LH[0x10 | n2] = 5;
            StdEntropyCoder.ZC_LUT_LH[0x30 | n2] = 6;
        }
        StdEntropyCoder.ZC_LUT_LH[128] = 7;
        StdEntropyCoder.ZC_LUT_LH[64] = 7;
        for (n2 = 1; n2 < 16; ++n2) {
            StdEntropyCoder.ZC_LUT_LH[0x80 | n2] = 8;
            StdEntropyCoder.ZC_LUT_LH[0x40 | n2] = 8;
        }
        for (n2 = 1; n2 < 4; ++n2) {
            for (n = 0; n < 16; ++n) {
                StdEntropyCoder.ZC_LUT_LH[0x80 | n2 << 4 | n] = 9;
                StdEntropyCoder.ZC_LUT_LH[0x40 | n2 << 4 | n] = 9;
            }
        }
        for (n2 = 0; n2 < 64; ++n2) {
            StdEntropyCoder.ZC_LUT_LH[0xC0 | n2] = 10;
        }
        StdEntropyCoder.ZC_LUT_HL[0] = 2;
        for (n2 = 1; n2 < 16; ++n2) {
            StdEntropyCoder.ZC_LUT_HL[n2] = 4;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            StdEntropyCoder.ZC_LUT_HL[1 << n2] = 3;
        }
        for (n2 = 0; n2 < 16; ++n2) {
            StdEntropyCoder.ZC_LUT_HL[0x80 | n2] = 5;
            StdEntropyCoder.ZC_LUT_HL[0x40 | n2] = 5;
            StdEntropyCoder.ZC_LUT_HL[0xC0 | n2] = 6;
        }
        StdEntropyCoder.ZC_LUT_HL[32] = 7;
        StdEntropyCoder.ZC_LUT_HL[16] = 7;
        for (n2 = 1; n2 < 16; ++n2) {
            StdEntropyCoder.ZC_LUT_HL[0x20 | n2] = 8;
            StdEntropyCoder.ZC_LUT_HL[0x10 | n2] = 8;
        }
        for (n2 = 1; n2 < 4; ++n2) {
            for (n = 0; n < 16; ++n) {
                StdEntropyCoder.ZC_LUT_HL[n2 << 6 | 0x20 | n] = 9;
                StdEntropyCoder.ZC_LUT_HL[n2 << 6 | 0x10 | n] = 9;
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 16; ++n) {
                StdEntropyCoder.ZC_LUT_HL[n2 << 6 | 0x20 | 0x10 | n] = 10;
            }
        }
        int[] nArray = new int[]{3, 5, 6, 9, 10, 12};
        int[] nArray2 = new int[]{1, 2, 4, 8};
        int[] nArray3 = new int[]{3, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15};
        int[] nArray4 = new int[]{7, 11, 13, 14, 15};
        StdEntropyCoder.ZC_LUT_HH[0] = 2;
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            StdEntropyCoder.ZC_LUT_HH[nArray2[n2] << 4] = 3;
        }
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            StdEntropyCoder.ZC_LUT_HH[nArray3[n2] << 4] = 4;
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            StdEntropyCoder.ZC_LUT_HH[nArray2[n2]] = 5;
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            for (n = 0; n < nArray2.length; ++n) {
                StdEntropyCoder.ZC_LUT_HH[nArray2[n2] << 4 | nArray2[n]] = 6;
            }
        }
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            for (n = 0; n < nArray2.length; ++n) {
                StdEntropyCoder.ZC_LUT_HH[nArray3[n2] << 4 | nArray2[n]] = 7;
            }
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            StdEntropyCoder.ZC_LUT_HH[nArray[n2]] = 8;
        }
        for (n = 0; n < nArray.length; ++n) {
            for (n2 = 1; n2 < 16; ++n2) {
                StdEntropyCoder.ZC_LUT_HH[n2 << 4 | nArray[n]] = 9;
            }
        }
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < nArray4.length; ++n) {
                StdEntropyCoder.ZC_LUT_HH[n2 << 4 | nArray4[n]] = 10;
            }
        }
        int[] nArray5 = new int[36];
        nArray5[18] = 15;
        nArray5[17] = 14;
        nArray5[16] = 13;
        nArray5[10] = 12;
        nArray5[9] = 11;
        nArray5[8] = -2147483636;
        nArray5[2] = -2147483635;
        nArray5[1] = -2147483634;
        nArray5[0] = -2147483633;
        for (n2 = 0; n2 < 511; ++n2) {
            int n3 = n2 & 1;
            int n4 = n2 >> 1 & 1;
            int n5 = n2 >> 2 & 1;
            int n6 = n2 >> 3 & 1;
            int n7 = n2 >> 5 & 1;
            int n8 = n2 >> 6 & 1;
            int n9 = n2 >> 8 & 1;
            int n10 = n2 >> 7 & 1;
            int n11 = n6 * (1 - 2 * n9) + n5 * (1 - 2 * n10);
            n11 = n11 >= -1 ? n11 : -1;
            n11 = n11 <= 1 ? n11 : 1;
            int n12 = n4 * (1 - 2 * n8) + n3 * (1 - 2 * n7);
            n12 = n12 >= -1 ? n12 : -1;
            n12 = n12 <= 1 ? n12 : 1;
            StdEntropyCoder.SC_LUT[n2] = nArray5[n11 + 1 << 3 | n12 + 1];
        }
        nArray5 = null;
        StdEntropyCoder.MR_LUT[0] = 16;
        for (n2 = 1; n2 < 256; ++n2) {
            StdEntropyCoder.MR_LUT[n2] = 17;
        }
        while (n2 < 512) {
            StdEntropyCoder.MR_LUT[n2] = 18;
            ++n2;
        }
        for (n2 = 0; n2 < 64; ++n2) {
            d2 = (double)n2 / 64.0 + 1.0;
            d = d2 * d2;
            StdEntropyCoder.FS_LOSSLESS[n2] = (int)Math.floor(d * 8192.0 + 0.5);
            StdEntropyCoder.FS_LOSSY[n2] = (int)Math.floor((d -= (d2 -= 1.5) * d2) * 8192.0 + 0.5);
        }
        for (n2 = 0; n2 < 128; ++n2) {
            d2 = (double)n2 / 64.0;
            d = (d2 - 1.0) * (d2 - 1.0);
            StdEntropyCoder.FM_LOSSLESS[n2] = (int)Math.floor(d * 8192.0 + 0.5);
            StdEntropyCoder.FM_LOSSY[n2] = (int)Math.floor((d -= (d2 -= n2 < 64 ? 0.5 : 1.5) * d2) * 8192.0 + 0.5);
        }
    }

    private class Compressor
    implements Runnable {
        private final int idx;
        CBlkRateDistStats ccb;
        int c;
        int options;
        boolean rev;
        int lcType;
        int tType;
        private long[] time;

        Compressor(int n) {
            this.idx = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                long l = 0L;
                StdEntropyCoder.compressCodeBlock(this.c, this.ccb, StdEntropyCoder.this.srcblkT[this.idx], StdEntropyCoder.this.mqT[this.idx], StdEntropyCoder.this.boutT[this.idx], StdEntropyCoder.this.outT[this.idx], StdEntropyCoder.this.stateT[this.idx], StdEntropyCoder.this.distbufT[this.idx], StdEntropyCoder.this.ratebufT[this.idx], StdEntropyCoder.this.istermbufT[this.idx], StdEntropyCoder.this.symbufT[this.idx], StdEntropyCoder.this.ctxtbufT[this.idx], this.options, this.rev, this.lcType, this.tType);
            }
            finally {
                StdEntropyCoder.this.completedComps[this.c].push(this);
            }
        }

        synchronized long getTiming(int n) {
            return 0L;
        }

        public int getIdx() {
            return this.idx;
        }
    }
}

