/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image;

import jj2000.j2k.NoNextElementException;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.DataBlk;

public class ImgDataJoiner
implements BlkImgDataSrc {
    private int w;
    private int h;
    private int nc;
    private BlkImgDataSrc[] imageData;
    private int[] compIdx;
    private int[] subsX;
    private int[] subsY;

    public ImgDataJoiner(BlkImgDataSrc[] blkImgDataSrcArray, int[] nArray) {
        int n;
        this.imageData = blkImgDataSrcArray;
        this.compIdx = nArray;
        if (this.imageData.length != this.compIdx.length) {
            throw new IllegalArgumentException("imD and cIdx must have the same length");
        }
        this.nc = blkImgDataSrcArray.length;
        this.subsX = new int[this.nc];
        this.subsY = new int[this.nc];
        for (n = 0; n < this.nc; ++n) {
            if (blkImgDataSrcArray[n].getNumTiles() == 1 && blkImgDataSrcArray[n].getCompULX(nArray[n]) == 0 && blkImgDataSrcArray[n].getCompULY(nArray[n]) == 0) continue;
            throw new IllegalArgumentException("All input components must, not use tiles and must have the origin at the canvas origin");
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.nc; ++n) {
            if (blkImgDataSrcArray[n].getCompImgWidth(nArray[n]) > n2) {
                n2 = blkImgDataSrcArray[n].getCompImgWidth(nArray[n]);
            }
            if (blkImgDataSrcArray[n].getCompImgHeight(nArray[n]) <= n3) continue;
            n3 = blkImgDataSrcArray[n].getCompImgHeight(nArray[n]);
        }
        this.w = n2;
        this.h = n3;
        for (n = 0; n < this.nc; ++n) {
            this.subsX[n] = (n2 + blkImgDataSrcArray[n].getCompImgWidth(nArray[n]) - 1) / blkImgDataSrcArray[n].getCompImgWidth(nArray[n]);
            this.subsY[n] = (n3 + blkImgDataSrcArray[n].getCompImgHeight(nArray[n]) - 1) / blkImgDataSrcArray[n].getCompImgHeight(nArray[n]);
            if ((n2 + this.subsX[n] - 1) / this.subsX[n] == blkImgDataSrcArray[n].getCompImgWidth(nArray[n]) && (n3 + this.subsY[n] - 1) / this.subsY[n] == blkImgDataSrcArray[n].getCompImgHeight(nArray[n])) continue;
            throw new Error("Can not compute component subsampling factors: strange subsampling.");
        }
    }

    public int getTileWidth() {
        return this.w;
    }

    public int getTileHeight() {
        return this.h;
    }

    public int getNomTileWidth() {
        return this.w;
    }

    public int getNomTileHeight() {
        return this.h;
    }

    public int getImgWidth() {
        return this.w;
    }

    public int getImgHeight() {
        return this.h;
    }

    public int getNumComps() {
        return this.nc;
    }

    public int getCompSubsX(int n) {
        return this.subsX[n];
    }

    public int getCompSubsY(int n) {
        return this.subsY[n];
    }

    public int getTileCompWidth(int n, int n2) {
        return this.imageData[n2].getTileCompWidth(n, this.compIdx[n2]);
    }

    public int getTileCompHeight(int n, int n2) {
        return this.imageData[n2].getTileCompHeight(n, this.compIdx[n2]);
    }

    public int getCompImgWidth(int n) {
        return this.imageData[n].getCompImgWidth(this.compIdx[n]);
    }

    public int getCompImgHeight(int n) {
        return this.imageData[n].getCompImgHeight(this.compIdx[n]);
    }

    public int getNomRangeBits(int n) {
        return this.imageData[n].getNomRangeBits(this.compIdx[n]);
    }

    public int getFixedPoint(int n) {
        return this.imageData[n].getFixedPoint(this.compIdx[n]);
    }

    public DataBlk getInternCompData(DataBlk dataBlk, int n) {
        return this.imageData[n].getInternCompData(dataBlk, this.compIdx[n]);
    }

    public DataBlk getCompData(DataBlk dataBlk, int n) {
        return this.imageData[n].getCompData(dataBlk, this.compIdx[n]);
    }

    public void setTile(int n, int n2) {
        if (n != 0 || n2 != 0) {
            throw new IllegalArgumentException();
        }
    }

    public void nextTile() {
        throw new NoNextElementException();
    }

    public Coord getTile(Coord coord) {
        if (coord != null) {
            coord.x = 0;
            coord.y = 0;
            return coord;
        }
        return new Coord(0, 0);
    }

    public int getTileIdx() {
        return 0;
    }

    public int getCompULX(int n) {
        return 0;
    }

    public int getCompULY(int n) {
        return 0;
    }

    public int getTilePartULX() {
        return 0;
    }

    public int getTilePartULY() {
        return 0;
    }

    public int getImgULX() {
        return 0;
    }

    public int getImgULY() {
        return 0;
    }

    public Coord getNumTiles(Coord coord) {
        if (coord != null) {
            coord.x = 1;
            coord.y = 1;
            return coord;
        }
        return new Coord(1, 1);
    }

    public int getNumTiles() {
        return 1;
    }

    public String toString() {
        String string = "ImgDataJoiner: WxH = " + this.w + "x" + this.h;
        for (int i = 0; i < this.nc; ++i) {
            string = string + "\n- Component " + i + " " + this.imageData[i];
        }
        return string;
    }
}

