/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.input;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import jj2000.j2k.JJ2KExceptionHandler;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.input.ImgReader;
import jj2000.j2k.io.EndianType;

public class ImgReaderPGX
extends ImgReader
implements EndianType {
    private int offset;
    private RandomAccessFile in;
    private int bitDepth;
    private boolean isSigned;
    private int packBytes;
    private int byteOrder;
    private byte[] buf;
    private DataBlkInt intBlk;

    public ImgReaderPGX(File file) throws IOException {
        String string;
        if (!file.exists()) {
            throw new IllegalArgumentException("PGX file " + file.getName() + " does not exist");
        }
        this.in = new RandomAccessFile(file, "r");
        try {
            string = this.in.readLine();
        }
        catch (IOException iOException) {
            throw new IOException(file.getName() + " is not a PGX file");
        }
        if (string == null) {
            throw new IOException(file.getName() + " is an empty file");
        }
        this.offset = string.length() + 1;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            int n = stringTokenizer.countTokens();
            if (!stringTokenizer.nextToken().equals("PG")) {
                throw new IOException(file.getName() + " is not a PGX file");
            }
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("LM")) {
                this.byteOrder = 1;
            } else if (string2.equals("ML")) {
                this.byteOrder = 0;
            } else {
                throw new IOException(file.getName() + " is not a PGX file");
            }
            if (n == 6) {
                string2 = stringTokenizer.nextToken();
                if (string2.equals("+")) {
                    this.isSigned = false;
                } else if (string2.equals("-")) {
                    this.isSigned = true;
                } else {
                    throw new IOException(file.getName() + " is not a PGX file");
                }
            }
            try {
                this.bitDepth = new Integer(stringTokenizer.nextToken());
                if (this.bitDepth <= 0 || this.bitDepth > 31) {
                    throw new IOException(file.getName() + " is not a valid PGX file");
                }
                this.w = new Integer(stringTokenizer.nextToken());
                this.h = new Integer(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(file.getName() + " is not a PGX file");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IOException(file.getName() + " is not a PGX file");
        }
        this.nc = 1;
        this.packBytes = this.bitDepth <= 8 ? 1 : (this.bitDepth <= 16 ? 2 : 4);
    }

    public ImgReaderPGX(String string) throws IOException {
        this(new File(string));
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.buf = null;
    }

    public int getNomRangeBits(int n) {
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        return this.bitDepth;
    }

    public int getFixedPoint(int n) {
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        return 0;
    }

    public DataBlk getInternCompData(DataBlk dataBlk, int n) {
        int[] nArray;
        int n2 = 1 << this.bitDepth - 1;
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        if (dataBlk.getDataType() != 3) {
            if (this.intBlk == null) {
                this.intBlk = new DataBlkInt(dataBlk.ulx, dataBlk.uly, dataBlk.w, dataBlk.h);
            } else {
                this.intBlk.ulx = dataBlk.ulx;
                this.intBlk.uly = dataBlk.uly;
                this.intBlk.w = dataBlk.w;
                this.intBlk.h = dataBlk.h;
            }
            dataBlk = this.intBlk;
        }
        if ((nArray = (int[])dataBlk.getData()) == null || nArray.length < dataBlk.w * dataBlk.h * this.packBytes) {
            nArray = new int[dataBlk.w * dataBlk.h];
            dataBlk.setData(nArray);
        }
        int n3 = 32 - this.bitDepth;
        if (this.buf == null || this.buf.length < this.packBytes * dataBlk.w) {
            this.buf = new byte[this.packBytes * dataBlk.w];
        }
        try {
            switch (this.packBytes) {
                case 1: {
                    int n4 = dataBlk.uly + dataBlk.h;
                    if (this.isSigned) {
                        for (int i = dataBlk.uly; i < n4; ++i) {
                            this.in.seek(this.offset + i * this.w + dataBlk.ulx);
                            this.in.read(this.buf, 0, dataBlk.w);
                            int n5 = (i - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                            int n6 = dataBlk.w - 1;
                            while (n6 >= 0) {
                                nArray[n5] = (this.buf[n6--] & 0xFF) << n3 >> n3;
                                --n5;
                            }
                        }
                    } else {
                        for (int i = dataBlk.uly; i < n4; ++i) {
                            this.in.seek(this.offset + i * this.w + dataBlk.ulx);
                            this.in.read(this.buf, 0, dataBlk.w);
                            int n7 = (i - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                            int n8 = dataBlk.w - 1;
                            while (n8 >= 0) {
                                nArray[n7] = ((this.buf[n8--] & 0xFF) << n3 >>> n3) - n2;
                                --n7;
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    int n9 = dataBlk.uly + dataBlk.h;
                    if (this.isSigned) {
                        block27: for (int i = dataBlk.uly; i < n9; ++i) {
                            this.in.seek(this.offset + 2 * (i * this.w + dataBlk.ulx));
                            this.in.read(this.buf, 0, dataBlk.w << 1);
                            switch (this.byteOrder) {
                                case 1: {
                                    int n10 = (i - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n11 = (dataBlk.w << 1) - 1;
                                    while (n11 >= 0) {
                                        nArray[n10] = ((this.buf[n11--] & 0xFF) << 8 | this.buf[n11--] & 0xFF) << n3 >> n3;
                                        --n10;
                                    }
                                    continue block27;
                                }
                                case 0: {
                                    int n10 = (i - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n11 = (dataBlk.w << 1) - 1;
                                    while (n11 >= 0) {
                                        nArray[n10] = (this.buf[n11--] & 0xFF | (this.buf[n11--] & 0xFF) << 8) << n3 >> n3;
                                        --n10;
                                    }
                                    continue block27;
                                }
                                default: {
                                    throw new Error("Internal JJ2000 bug");
                                }
                            }
                        }
                    } else {
                        block30: for (int i = dataBlk.uly; i < n9; ++i) {
                            this.in.seek(this.offset + 2 * (i * this.w + dataBlk.ulx));
                            this.in.read(this.buf, 0, dataBlk.w << 1);
                            switch (this.byteOrder) {
                                case 1: {
                                    int n12 = (i - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n13 = (dataBlk.w << 1) - 1;
                                    while (n13 >= 0) {
                                        nArray[n12] = (((this.buf[n13--] & 0xFF) << 8 | this.buf[n13--] & 0xFF) << n3 >>> n3) - n2;
                                        --n12;
                                    }
                                    continue block30;
                                }
                                case 0: {
                                    int n12 = (i - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n13 = (dataBlk.w << 1) - 1;
                                    while (n13 >= 0) {
                                        nArray[n12] = ((this.buf[n13--] & 0xFF | (this.buf[n13--] & 0xFF) << 8) << n3 >>> n3) - n2;
                                        --n12;
                                    }
                                    continue block30;
                                }
                                default: {
                                    throw new Error("Internal JJ2000 bug");
                                }
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    int n14 = dataBlk.uly + dataBlk.h;
                    if (this.isSigned) {
                        block33: for (int i = dataBlk.uly; i < n14; ++i) {
                            this.in.seek(this.offset + 4 * (i * this.w + dataBlk.ulx));
                            this.in.read(this.buf, 0, dataBlk.w << 2);
                            switch (this.byteOrder) {
                                case 1: {
                                    int n15 = (i - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n16 = (dataBlk.w << 2) - 1;
                                    while (n16 >= 0) {
                                        nArray[n15] = ((this.buf[n16--] & 0xFF) << 24 | (this.buf[n16--] & 0xFF) << 16 | (this.buf[n16--] & 0xFF) << 8 | this.buf[n16--] & 0xFF) << n3 >> n3;
                                        --n15;
                                    }
                                    continue block33;
                                }
                                case 0: {
                                    int n15 = (i - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n16 = (dataBlk.w << 2) - 1;
                                    while (n16 >= 0) {
                                        nArray[n15] = (this.buf[n16--] & 0xFF | (this.buf[n16--] & 0xFF) << 8 | (this.buf[n16--] & 0xFF) << 16 | (this.buf[n16--] & 0xFF) << 24) << n3 >> n3;
                                        --n15;
                                    }
                                    continue block33;
                                }
                                default: {
                                    throw new Error("Internal JJ2000 bug");
                                }
                            }
                        }
                    } else {
                        block36: for (int i = dataBlk.uly; i < n14; ++i) {
                            this.in.seek(this.offset + 4 * (i * this.w + dataBlk.ulx));
                            this.in.read(this.buf, 0, dataBlk.w << 2);
                            switch (this.byteOrder) {
                                case 1: {
                                    int n17 = (i - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n18 = (dataBlk.w << 2) - 1;
                                    while (n18 >= 0) {
                                        nArray[n17] = (((this.buf[n18--] & 0xFF) << 24 | (this.buf[n18--] & 0xFF) << 16 | (this.buf[n18--] & 0xFF) << 8 | this.buf[n18--] & 0xFF) << n3 >>> n3) - n2;
                                        --n17;
                                    }
                                    continue block36;
                                }
                                case 0: {
                                    int n17 = (i - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n18 = (dataBlk.w << 2) - 1;
                                    while (n18 >= 0) {
                                        nArray[n17] = ((this.buf[n18--] & 0xFF | (this.buf[n18--] & 0xFF) << 8 | (this.buf[n18--] & 0xFF) << 16 | (this.buf[n18--] & 0xFF) << 24) << n3 >>> n3) - n2;
                                        --n17;
                                    }
                                    continue block36;
                                }
                                default: {
                                    throw new Error("Internal JJ2000 bug");
                                }
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new IOException("PGX supports only bit-depth between 1 and 31");
                }
            }
        }
        catch (IOException iOException) {
            JJ2KExceptionHandler.handleException(iOException);
        }
        dataBlk.progressive = false;
        dataBlk.offset = 0;
        dataBlk.scanw = dataBlk.w;
        return dataBlk;
    }

    public DataBlk getCompData(DataBlk dataBlk, int n) {
        return this.getInternCompData(dataBlk, n);
    }

    public boolean isOrigSigned(int n) {
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        return this.isSigned;
    }

    public String toString() {
        return "ImgReaderPGX: WxH = " + this.w + "x" + this.h + ", Component = 0" + ", Bit-depth = " + this.bitDepth + ", signed = " + this.isSigned + "\nUnderlying RandomAccessIO:\n" + this.in.toString();
    }
}

