/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.jj2000;

import java.io.IOException;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.input.ImgReader;
import org.jmrtd.jj2000.Bitmap;
import org.jmrtd.jj2000.JJ2000Util;

class BitmapDataSrc
extends ImgReader {
    private Bitmap bitmap;
    private int nomRangeBits;

    public BitmapDataSrc(Bitmap bitmap) {
        this.bitmap = bitmap;
        this.w = bitmap.getWidth();
        this.h = bitmap.getHeight();
        this.nc = 3;
        this.nomRangeBits = 8;
    }

    @Override
    public int getFixedPoint(int c) {
        if (c < 0 || c >= this.nc) {
            throw new IllegalArgumentException();
        }
        return 0;
    }

    @Override
    public int getNomRangeBits(int c) {
        if (c < 0 || c >= this.nc) {
            throw new IllegalArgumentException();
        }
        return this.nomRangeBits;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOrigSigned(int c) {
        if (c < 0 || c >= this.nc) {
            throw new IllegalArgumentException();
        }
        return false;
    }

    @Override
    public DataBlk getInternCompData(DataBlk blk, int c) {
        return this.getCompData(blk, c);
    }

    @Override
    public DataBlk getCompData(DataBlk blk, int c) {
        if (c < 0 || c >= this.nc) {
            throw new IllegalArgumentException();
        }
        int[] pixels = this.bitmap.getPixels();
        if (blk == null) {
            blk = new DataBlkInt(0, 0, this.w, this.h);
        }
        int blkDataLength = (blk.h - blk.uly) * (blk.w - blk.ulx);
        int[] compData = (int[])blk.getData();
        if (compData == null) {
            compData = new int[blkDataLength];
        } else assert (compData.length == blkDataLength);
        int i = 0;
        int y = 0;
        while (y < blk.h) {
            int x = 0;
            while (x < blk.w) {
                int signedCompValue;
                int bitmapIndex = (blk.uly + y) * blk.w + (blk.ulx + x);
                compData[i] = signedCompValue = JJ2000Util.unsignedARGBToSignedComponent(pixels[bitmapIndex], c, this.nc, this.nomRangeBits);
                ++i;
                ++x;
            }
            ++y;
        }
        blk.setData(compData);
        return blk;
    }
}

