/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.jj2000;

import colorspace.ColorSpace;
import icc.ICCProfiler;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.decoder.EntropyDecoder;
import jj2000.j2k.fileformat.reader.FileFormatReader;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.ImgDataConverter;
import jj2000.j2k.image.invcomptransf.InvCompTransf;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.Dequantizer;
import jj2000.j2k.roi.ROIDeScaler;
import jj2000.j2k.util.ISRandomAccessIO;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.synthesis.InverseWT;
import org.jmrtd.jj2000.Bitmap;
import org.jmrtd.jj2000.JJ2000Util;

public class JJ2000Decoder {
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private static final String[][] DECODER_PINFO;

    static {
        String[][] stringArrayArray = new String[20][];
        stringArrayArray[0] = new String[]{"u", "[on|off]", "", "off"};
        stringArrayArray[1] = new String[]{"v", "[on|off]", "", "off"};
        stringArrayArray[2] = new String[]{"verbose", "[on|off]", "", "off"};
        String[] stringArray = new String[4];
        stringArray[0] = "pfile";
        stringArray[1] = "";
        stringArray[2] = "";
        stringArrayArray[3] = stringArray;
        String[] stringArray2 = new String[4];
        stringArray2[0] = "res";
        stringArray2[1] = "";
        stringArray2[2] = "";
        stringArrayArray[4] = stringArray2;
        String[] stringArray3 = new String[4];
        stringArray3[0] = "i";
        stringArray3[1] = "";
        stringArray3[2] = "";
        stringArrayArray[5] = stringArray3;
        String[] stringArray4 = new String[4];
        stringArray4[0] = "o";
        stringArray4[1] = "";
        stringArray4[2] = "";
        stringArrayArray[6] = stringArray4;
        stringArrayArray[7] = new String[]{"rate", "", "", "1.0"};
        stringArrayArray[8] = new String[]{"nbytes", "", "", "-1"};
        String[] stringArray5 = new String[4];
        stringArray5[0] = "parsing";
        stringArray5[2] = "";
        stringArray5[3] = "on";
        stringArrayArray[9] = stringArray5;
        stringArrayArray[10] = new String[]{"ncb_quit", "", "", "-1"};
        stringArrayArray[11] = new String[]{"l_quit", "", "", "-1"};
        stringArrayArray[12] = new String[]{"m_quit", "", "", "-1"};
        String[] stringArray6 = new String[4];
        stringArray6[0] = "poc_quit";
        stringArray6[2] = "";
        stringArray6[3] = "off";
        stringArrayArray[13] = stringArray6;
        String[] stringArray7 = new String[4];
        stringArray7[0] = "one_tp";
        stringArray7[2] = "";
        stringArray7[3] = "off";
        stringArrayArray[14] = stringArray7;
        String[] stringArray8 = new String[4];
        stringArray8[0] = "comp_transf";
        stringArray8[2] = "";
        stringArray8[3] = "on";
        stringArrayArray[15] = stringArray8;
        String[] stringArray9 = new String[4];
        stringArray9[0] = "debug";
        stringArray9[2] = "";
        stringArray9[3] = "off";
        stringArrayArray[16] = stringArray9;
        String[] stringArray10 = new String[4];
        stringArray10[0] = "cdstr_info";
        stringArray10[2] = "";
        stringArray10[3] = "off";
        stringArrayArray[17] = stringArray10;
        String[] stringArray11 = new String[4];
        stringArray11[0] = "nocolorspace";
        stringArray11[2] = "";
        stringArray11[3] = "off";
        stringArrayArray[18] = stringArray11;
        String[] stringArray12 = new String[4];
        stringArray12[0] = "colorspace_debug";
        stringArray12[2] = "";
        stringArray12[3] = "off";
        stringArrayArray[19] = stringArray12;
        DECODER_PINFO = stringArrayArray;
    }

    private JJ2000Decoder() {
    }

    public static Bitmap decode(InputStream in) throws IOException {
        return JJ2000Decoder.decode(in, -1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decode(InputStream inputStream, double bitRate) throws IOException {
        InputStream inputStream2 = inputStream;
        synchronized (inputStream2) {
            String[][] pinfo = JJ2000Decoder.getAllDecoderParameters();
            ParameterList defpl = new ParameterList();
            int i = pinfo.length - 1;
            while (i >= 0) {
                if (pinfo[i][3] != null) {
                    defpl.put(pinfo[i][0], pinfo[i][3]);
                }
                --i;
            }
            ParameterList pl = new ParameterList(defpl);
            if (bitRate >= 0.0) {
                pl.put("rate", Float.toString((float)bitRate));
            }
            return JJ2000Decoder.decode(new ISRandomAccessIO(inputStream), pl);
        }
    }

    private static Bitmap decode(RandomAccessIO randomAccessIO, ParameterList pl) throws IOException {
        double bitRate = pl.getFloatParameter("rate");
        FileFormatReader fileFormatReader = new FileFormatReader(randomAccessIO);
        fileFormatReader.readFileFormat();
        if (fileFormatReader.JP2FFUsed) {
            randomAccessIO.seek(fileFormatReader.getFirstCodeStreamPos());
        } else {
            LOGGER.warning("Assuming codestream not wrapped in JP2 format");
        }
        HeaderInfo headerInfo = new HeaderInfo();
        HeaderDecoder headerDecoder = null;
        try {
            headerDecoder = new HeaderDecoder(randomAccessIO, pl, headerInfo);
        }
        catch (EOFException e) {
            throw new IOException("Codestream too short or bad header, unable to decode");
        }
        int originalComponentCount = headerDecoder.getNumComps();
        headerInfo.siz.getNumTiles();
        DecoderSpecs decoderSpecs = headerDecoder.getDecoderSpecs();
        int[] originalBitDepths = new int[originalComponentCount];
        int i = 0;
        while (i < originalComponentCount) {
            originalBitDepths[i] = headerDecoder.getOriginalBitDepth(i);
            ++i;
        }
        BitstreamReaderAgent bitStreamReader = BitstreamReaderAgent.createInstance(randomAccessIO, headerDecoder, pl, decoderSpecs, pl.getBooleanParameter("cdstr_info"), headerInfo);
        EntropyDecoder entropyDecoder = headerDecoder.createEntropyDecoder(bitStreamReader, pl);
        ROIDeScaler roiDeScaler = headerDecoder.createROIDeScaler(entropyDecoder, pl, decoderSpecs);
        Dequantizer dequantizer = headerDecoder.createDequantizer(roiDeScaler, originalBitDepths, decoderSpecs);
        InverseWT inverseWT = InverseWT.createInstance(dequantizer, decoderSpecs);
        int imgRes = bitStreamReader.getImgRes();
        inverseWT.setImgResLevel(imgRes);
        ImgDataConverter imgDataConverter = new ImgDataConverter(inverseWT, 0);
        InvCompTransf invCompTransf = new InvCompTransf(imgDataConverter, decoderSpecs, originalBitDepths, pl);
        ColorSpace colorSpace = null;
        BlkImgDataSrc color = null;
        if (fileFormatReader.JP2FFUsed) {
            try {
                colorSpace = new ColorSpace(randomAccessIO, headerDecoder, pl);
                BlkImgDataSrc channels = headerDecoder.createChannelDefinitionMapper(invCompTransf, colorSpace);
                BlkImgDataSrc resampled = headerDecoder.createResampler(channels, colorSpace);
                BlkImgDataSrc palettized = headerDecoder.createPalettizedColorSpaceMapper(resampled, colorSpace);
                color = headerDecoder.createColorSpaceMapper(palettized, colorSpace);
            }
            catch (Exception e) {
                LOGGER.warning("DEBUG: Ignoring jp2 colorspace processing error");
            }
        } else {
            color = invCompTransf;
        }
        InvCompTransf decodedImage = color;
        if (color == null) {
            decodedImage = invCompTransf;
        }
        int imgComponentCount = decodedImage.getNumComps();
        DataBlkInt[] blk = new DataBlkInt[imgComponentCount];
        int[] imgBitDepths = new int[imgComponentCount];
        int imgWidth = decodedImage.getImgWidth();
        int imgHeight = decodedImage.getImgHeight();
        Coord nT = decodedImage.getNumTiles(null);
        int y = 0;
        while (y < nT.y) {
            int x = 0;
            while (x < nT.x) {
                try {
                    decodedImage.setTile(x, y);
                }
                catch (Exception eofe) {
                    LOGGER.info("DEBUG: Ignoring exception in JJ2000Decoder setTile(" + x + ", " + y + ")");
                }
                int width = decodedImage.getImgWidth();
                int height = decodedImage.getImgHeight();
                int ulx = decodedImage.getImgULX();
                int uly = decodedImage.getImgULY();
                int i2 = 0;
                while (i2 < imgComponentCount) {
                    blk[i2] = new DataBlkInt(ulx, uly, width, height);
                    blk[i2].data = null;
                    blk[i2] = (DataBlkInt)decodedImage.getInternCompData(blk[i2], i2);
                    imgBitDepths[i2] = decodedImage.getNomRangeBits(i2);
                    ++i2;
                }
                ++x;
            }
            ++y;
        }
        if (colorSpace == null) {
            LOGGER.warning("Could not determine color space type, assuming sRGB");
            return JJ2000Decoder.decodeSignedRGB(blk, imgWidth, imgHeight, imgBitDepths, bitRate);
        }
        ColorSpace.CSEnum colorSpaceType = colorSpace.getColorSpace();
        if (ColorSpace.GreyScale.equals(colorSpaceType)) {
            return JJ2000Decoder.decodeGrayScale(blk, imgWidth, imgHeight, imgBitDepths);
        }
        if (ColorSpace.sRGB.equals(colorSpaceType)) {
            return JJ2000Decoder.decodeSignedRGB(blk, imgWidth, imgHeight, imgBitDepths, bitRate);
        }
        LOGGER.warning("Unsupported color space type: " + colorSpaceType);
        return JJ2000Decoder.decodeSignedRGB(blk, imgWidth, imgHeight, imgBitDepths, bitRate);
    }

    private static Bitmap decodeSignedRGB(DataBlkInt[] blk, int width, int height, int[] depths, double bitRate) {
        if (blk == null || blk.length != 3) {
            throw new IllegalArgumentException("Was expecting 3 bands");
        }
        if (depths == null || depths.length != 3) {
            throw new IllegalArgumentException("Was expecting 3 bands");
        }
        if (depths[0] != depths[1] || depths[1] != depths[2] || depths[2] != depths[0]) {
            throw new IllegalArgumentException("Different depths for bands");
        }
        int depth = depths[0];
        int[] rData = blk[0].getDataInt();
        int[] gData = blk[1].getDataInt();
        int[] bData = blk[2].getDataInt();
        if (rData.length != gData.length || gData.length != bData.length || bData.length != rData.length) {
            throw new IllegalArgumentException("Different dimensions for bands");
        }
        int[] pixels = new int[rData.length];
        int j = 0;
        while (j < rData.length) {
            int r = rData[j];
            int g = gData[j];
            int b = bData[j];
            pixels[j] = JJ2000Util.signedComponentsToUnsignedARGB(r, g, b, depth);
            ++j;
        }
        Bitmap bitmap = new Bitmap(pixels, width, height, 24, -1, true, bitRate);
        return bitmap;
    }

    private static Bitmap decodeGrayScale(DataBlkInt[] blk, int width, int height, int[] depths) {
        if (blk.length != 1) {
            throw new IllegalArgumentException("Was expecting 1 band");
        }
        if (depths.length != 1) {
            throw new IllegalArgumentException("Was expecting 1 band");
        }
        int[] data = blk[0].getDataInt();
        int[] pixels = new int[data.length];
        int j = 0;
        while (j < data.length) {
            pixels[j] = JJ2000Util.signedGrayScaleIntToUnsignedARGB(data[j]);
            ++j;
        }
        Bitmap bitmap = new Bitmap(pixels, width, height, 24, -1, true, 3.0);
        return bitmap;
    }

    private static String[][] getAllDecoderParameters() {
        int i;
        ArrayList<String[]> pl = new ArrayList<String[]>();
        String[][] str = BitstreamReaderAgent.getParameterInfo();
        if (str != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = EntropyDecoder.getParameterInfo()) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = ROIDeScaler.getParameterInfo()) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = Dequantizer.getParameterInfo()) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = InvCompTransf.getParameterInfo()) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = HeaderDecoder.getParameterInfo()) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = ICCProfiler.getParameterInfo()) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = DECODER_PINFO) != null) {
            i = str.length - 1;
            while (i >= 0) {
                pl.add(str[i]);
                --i;
            }
        }
        if ((str = new String[pl.size()][4]) != null) {
            i = str.length - 1;
            while (i >= 0) {
                str[i] = (String[])pl.get(i);
                --i;
            }
        }
        return str;
    }

    public static interface ProgressListener {
        public void previewBitmapAvailable(int var1, Bitmap var2);
    }
}

