/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.jj2000;

class JJ2000Util {
    private JJ2000Util() {
    }

    public static int unsignedARGBToSignedComponent(int unsignedPixel, int c, int nc, int nomRangeBits) {
        if (c < 0 || c >= nc) {
            throw new IllegalArgumentException();
        }
        int unsignedCompValue = JJ2000Util.getUnsignedComponent(unsignedPixel, c, nc, nomRangeBits);
        assert (127 == 1 << nomRangeBits - 1);
        int signedCompValue = unsignedCompValue - (1 << nomRangeBits - 1);
        return signedCompValue;
    }

    public static int getUnsignedComponent(int unsignedPixel, int c, int nc, int nomRangeBits) {
        int byteIndex = nc - c - 1;
        int unsignedCompValue = (unsignedPixel & 255 << byteIndex * 8) >> byteIndex * 8 & 0xFF;
        return unsignedCompValue;
    }

    public static int signedGrayScaleIntToUnsignedARGB(int p) {
        if (p < -127) {
            return -16777216;
        }
        if (p > 127) {
            return -1;
        }
        p = p + 127 & 0xFF;
        return 0xFF000000 | p << 16 | p << 8 | p;
    }

    public static int signedComponentsToUnsignedARGB(int r, int g, int b, int nomRangeBits) {
        r = r < -(1 << nomRangeBits - 1) ? 0 : (r > (1 << nomRangeBits - 1) - 1 ? (1 << nomRangeBits) - 1 : (r += 1 << nomRangeBits - 1));
        g = g < -(1 << nomRangeBits - 1) ? 0 : (g > (1 << nomRangeBits - 1) - 1 ? (1 << nomRangeBits) - 1 : (g += 1 << nomRangeBits - 1));
        b = b < -(1 << nomRangeBits - 1) ? 0 : (b > (1 << nomRangeBits - 1) - 1 ? (1 << nomRangeBits) - 1 : (b += 1 << nomRangeBits - 1));
        return 0xFF000000 | (r & 0xFF) << 2 * nomRangeBits | (g & 0xFF) << nomRangeBits | b & 0xFF;
    }
}

