package nashid.verify.sdk.facematches

import android.graphics.Bitmap
import android.util.Log

class FaceDetectionUtil {
    companion object {
        fun cropFaceFromIDCard(idCardBitmap: Bitmap): Bitmap? {
            try {
                // Get the dimensions of the original ID card bitmap
                val width = idCardBitmap.width
                val height = idCardBitmap.height

                // Define the crop region (top-left corner of the ID card)
                // Adjust the width and height of the face region as per your requirement
                val cropWidth = width / 3
                val cropHeight = height / 2

                // Coordinates to start cropping for the face area only at the top-left corner
                val startX = cropWidth / 3
                val startY = cropHeight / 3
                Log.d("sizes: ", "$cropWidth, $cropHeight, $startX, $startY")

                // Crop the face from the ID card using Bitmap.createBitmap
                val croppedFaceBitmap = Bitmap.createBitmap(idCardBitmap, startX, startY, cropWidth, cropHeight)

                return croppedFaceBitmap
            } catch (e: Exception) {
                return null
            }
        }
    }
}
