package nashid.verify.sdk.mrtd2.activity;

import android.content.Context;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import nashid.verify.sdk.R;
import nashid.verify.sdk.databinding.ItemSelectDocumentBinding;

public class DocumentTypeListAdapter extends RecyclerView.Adapter<DocumentTypeListAdapter.ViewHolder> {

    private String[] list ;
    //            , "Driver licence", "Option#4", "option#5"};
    private final int[] images = new int[]{R.raw.epassport, R.raw.idcard};
    //        , R.raw.drivinglicenec, R.raw.other_option, R.raw.other_option};
    private int lastCheckedPosition = -1;
    private final Context context;
    private OnDocumentItemListener onDocumentItemListener;

    public void setListner(OnDocumentItemListener listener) {
        this.onDocumentItemListener = listener;
    }

    public DocumentTypeListAdapter(Context context,String[] listData) {
        this.context = context;
        list=listData;

    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater layoutInflater = LayoutInflater.from(parent.getContext());
        ItemSelectDocumentBinding binding = ItemSelectDocumentBinding.inflate(layoutInflater, parent, false);
        return new ViewHolder(binding);
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {

        SVG svg3 = null;
        try {
            svg3 = SVG.getFromResource(context.getResources(), images[position]);
            holder.itemSelectDocumentBinding.imgEpassport.setSVG(svg3);
        } catch (SVGParseException e) {

        }
        holder.itemSelectDocumentBinding.mainDocItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int copyOfLastCheckedPosition = lastCheckedPosition;
                lastCheckedPosition = position;
                notifyItemChanged(copyOfLastCheckedPosition);
                notifyItemChanged(lastCheckedPosition);
                if (onDocumentItemListener != null) {
                    onDocumentItemListener.onDocumentItemClick(list[lastCheckedPosition]);
                }
            }
        });
        Log.d("TAG", "DocumentTypeListAdapter: "+list[position]);
        if (position == lastCheckedPosition) {
            try {
                svg3 = SVG.getFromResource(context.getResources(), R.raw.select_cehckbix);
                holder.itemSelectDocumentBinding.itemCheck.setSVG(svg3);
            } catch (SVGParseException e) {

            }
            holder.itemSelectDocumentBinding.txtDocType.setText(list[position]);
            holder.itemSelectDocumentBinding.mainDocItem.setCardBackgroundColor(ContextCompat.getColor(context, R.color.selected_card_background));
            holder.itemSelectDocumentBinding.cardIconBack.setCardBackgroundColor(ContextCompat.getColor(context, R.color.selected_option_background));
        } else {
            try {
                svg3 = SVG.getFromResource(context.getResources(), R.raw.unselect_checkbox);
                holder.itemSelectDocumentBinding.itemCheck.setSVG(svg3);
            } catch (SVGParseException e) {

            }
            holder.itemSelectDocumentBinding.txtDocType.setText(list[position]);
            holder.itemSelectDocumentBinding.mainDocItem.setCardBackgroundColor(ContextCompat.getColor(context, R.color.card_background));
            holder.itemSelectDocumentBinding.cardIconBack.setCardBackgroundColor(ContextCompat.getColor(context, R.color.option_background));
        }
    }

    @Override
    public int getItemCount() {
        return list.length;
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private final ItemSelectDocumentBinding itemSelectDocumentBinding;

        public ViewHolder(ItemSelectDocumentBinding itemSelectDocumentBinding) {
            super(itemSelectDocumentBinding.getRoot());
            this.itemSelectDocumentBinding = itemSelectDocumentBinding;
            itemSelectDocumentBinding.txtDocType.setTextSize(TypedValue.COMPLEX_UNIT_PX, new TextSizeConverter(context).getTextSize(16));

            TextSizeConverter textSizeConverter=new TextSizeConverter(context);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(textSizeConverter.getWidth(50),textSizeConverter.getHeight(50));

            itemSelectDocumentBinding.cardIconBack.setLayoutParams(layoutParams);

            ViewGroup.LayoutParams layoutParams1 = itemSelectDocumentBinding.imgEpassport.getLayoutParams();
            layoutParams1.width = textSizeConverter.getWidth(24);
            layoutParams1.height = textSizeConverter.getHeight(24);
            itemSelectDocumentBinding.imgEpassport.setLayoutParams(layoutParams1);

            int padding = textSizeConverter.getPaddingORMarginValue(8);
            itemSelectDocumentBinding.itemLyout.setPadding(padding, padding, padding, padding);

            LinearLayout.LayoutParams cardLayoutParam = textSizeConverter.getLinearLayoutParam();
            cardLayoutParam.setMargins(0, textSizeConverter.getPaddingORMarginValue(8), 0, 0);
            itemSelectDocumentBinding.mainDocItem.setLayoutParams(cardLayoutParam);

        }
    }
}
