package nashid.verify.sdk.mrtd2.activity;

import android.Manifest;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Debug;
import android.provider.Settings;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import nashid.verify.sdk.NashidSDK;
import nashid.verify.sdk.OtherConstant;
import nashid.verify.sdk.R;
import nashid.verify.sdk.databinding.ActivitySelectDocumentBinding;
import nashid.verify.sdk.mrtd2.locale.LocaleUtil;
import nashid.verify.sdk.mrtd2.rooted.RootedCheck;
import nashid.verify.sdk.internetutility.ErrorUtility;
import nashid.verify.sdk.utility.PermissionHelper;
import nashid.verify.sdk.utility.SharePreferenceUtility;

import java.util.List;


public class SelectDocumentActivity extends BaseActivity implements AdapterView.OnItemSelectedListener {
    private String selectedDocType;
    private String[] docArray;
    private ActivitySelectDocumentBinding binding;
    private final String[] arr = new String[]{Manifest.permission.CAMERA};
    private final int REQUEST_CODE_ASK_PERMISSIONS = 100;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
//        updateLayoutDirection();
        RootedCheck.getInstance().setFlag(SelectDocumentActivity.this);

        binding = ActivitySelectDocumentBinding.inflate(getLayoutInflater());
        View view = binding.getRoot();
        setContentView(view);
        int adb = Settings.Secure.getInt(getContentResolver(), Settings.Global.ADB_ENABLED, 0);
//        if (RootedCheck.getInstance().isEmulator(getApplicationContext())) {
//            RootedCheck.getInstance().showRootedDeviceDialog(this,getString(R.string.emulator_dialog),getString(R.string.emulator_desc),getString(R.string.emulator_btn));
//        } else
//            if (adb == 1) {
//            RootedCheck.getInstance().showRootedDeviceDialog(this,getString(R.string.debug_dialog),getString(R.string.debug_desc),getString(R.string.debug_btn));
//        } else
        if (RootedCheck.getInstance().isRootedDevice(getApplicationContext())) {
            RootedCheck.getInstance().showRootedDeviceDialog(this, getString(R.string.root_dialog), getString(R.string.root_desc), getString(R.string.root_btn));
            SVG svg = null;
            try {
                svg = SVG.getFromResource(getResources(), R.raw.name_icon);
                binding.icon.setSVG(svg);
            } catch (SVGParseException e) {
            }

        } else {
            initView();
            initClickListner();
//            callAML();
        }

    }

    private void setTexViewTextSize() {

        TextSizeConverter textSizeConverter = new TextSizeConverter(getApplicationContext());
        textSizeConverter.changeStatusBarColor(SelectDocumentActivity.this);
        ViewGroup.LayoutParams layoutParams1 = binding.imgCurrentCountry.getLayoutParams();
        layoutParams1.width = textSizeConverter.getWidth(24);
        layoutParams1.height = textSizeConverter.getHeight(16);
        binding.imgCurrentCountry.setLayoutParams(layoutParams1);

        ViewGroup.LayoutParams layoutParams2 = binding.imgSetting.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        binding.imgSetting.setLayoutParams(layoutParams2);

        // Set the LayoutParams to the RelativeLayout``
        LinearLayout.LayoutParams layoutParams = textSizeConverter.getLinearLayoutParam();

        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(6), 0, 0);
        binding.lytCountry.setLayoutParams(layoutParams);

        int padding = textSizeConverter.getPaddingORMarginValue(16);
        binding.layoutMain.setPadding(padding, padding, padding, padding);

        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(30), 0, 0);
        binding.txtChooseDoc.setLayoutParams(layoutParams);

        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(16), 0, 0);
        binding.txtDesc.setLayoutParams(layoutParams);

        LinearLayout.LayoutParams recyclerviewRayoutParams = (LinearLayout.LayoutParams) binding.recyclerDocType.getLayoutParams();
        recyclerviewRayoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(24), 0, 0);
        binding.recyclerDocType.setLayoutParams(recyclerviewRayoutParams);

        binding.txtChooseDoc.setTextSize(TypedValue.COMPLEX_UNIT_PX, new TextSizeConverter(getApplicationContext()).getTextSize(32));
        binding.txtDesc.setTextSize(TypedValue.COMPLEX_UNIT_PX, new TextSizeConverter(getApplicationContext()).getTextSize(16));
        binding.txtLang.setTextSize(TypedValue.COMPLEX_UNIT_PX, new TextSizeConverter(getApplicationContext()).getTextSize(16));
        layoutParams2 = binding.imageArrow.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(16);
        layoutParams2.height = textSizeConverter.getHeight(16);
        binding.imageArrow.setLayoutParams(layoutParams2);

        recyclerviewRayoutParams = (LinearLayout.LayoutParams) binding.imageArrow.getLayoutParams();
        recyclerviewRayoutParams.setMargins(textSizeConverter.getPaddingORMarginValue(6), 0, 0, 0);
        binding.imageArrow.setLayoutParams(recyclerviewRayoutParams);


    }

    public static boolean isDebuggable(Context context) {
        return Debug.isDebuggerConnected();
    }

    /*private void updateLocale(String locale) {
        getStorage().setPreferredLocale(locale);
        LocaleUtil.Companion.applyLocalizedContext(getApplicationContext(), locale);
    }*/

    private void initClickListner() {

        binding.langPicker.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

//                Log.d("TAG", "onClick:dw,dklfjqwjl " + getStorage().getPreferredLocale() + "   " + LocaleUtil.OPTION_PHONE_LANGUAGE);
                openSelectLanguageDialog();
            }
        });
        binding.docDropdown.setOnItemSelectedListener(this);
        binding.imgSetting.setOnClickListener(view -> {
            Intent i = new Intent(SelectDocumentActivity.this, SettingScreenActivity.class);
            startActivity(i);
            overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
        });
        binding.verification.setOnClickListener(v -> {

            PermissionHelper.INSTANCE.requestPermissions(SelectDocumentActivity.this, new PermissionHelper.PermissionCallback() {
                @Override
                public void onResult(boolean allGranted, @NonNull List<String> grantedList, @NonNull List<String> deniedList) {
                    if (allGranted) {
                        openScanDocumentScreen();
                    } else {
                        Toast.makeText(getApplicationContext(), "These permissions are denied: $deniedList", Toast.LENGTH_LONG).show();
                    }
                }
            });
        });
    }

    private void openScanDocumentScreen() {
     /*   NashidSDK.getInstance().init(
                "E2RYikqKmUEJargY8GD5iZcOG5Okvea9UbrPDsc0FrVSxoeBUu",
                "9KMAQPJFK2MJSKR",
                "https://dashboard.devc2.projectnid.com/api/",
                "sotopo5208@ikumaru.com",
                new SDKIntListener() {
                    @Override
                    public void onInitSuccess() {
                    }

                    @Override
                    public void onInitFail() {

                    }
                }

        );
        NashidSDK.getInstance().setResultListener(new ResultListener() {
            @Override
            public void onResultData(JSONObject nfcData, String docType) {
                Log.d("TAG", "onResultData: "+nfcData);
            }

            @Override
            public void onFailure() {

            }
        });*/
        if (!isInternetAvailable()) {
            ErrorUtility.getInstance().showNoInternetDialog(this, (!this.isFinishing() && !this.isDestroyed()));
        } else {

           /* Intent i = new Intent(SelectDocumentActivity.this, CameraXLivePreviewActivity.class);
            i.putExtra(getResources().getString(R.string.doc_key), selectedDocType);
            startActivity(i);StartScanningActivity*/
           /* Intent i = new Intent(SelectDocumentActivity.this, InstructionScreenActivity.class);
            i.putExtra(getResources().getString(R.string.doc_key), selectedDocType);
            startActivity(i);*/
            if (SharePreferenceUtility.getSavePreferenceData(getApplicationContext(), getString(R.string.sharepreference_verification_step))) {
                Intent i = new Intent(SelectDocumentActivity.this, InstructionScreenActivity.class);
                i.putExtra(getResources().getString(R.string.doc_key), selectedDocType);
                startActivity(i);
            } else {
               /* Intent i = new Intent(SelectDocumentActivity.this, CameraXLivePreviewActivity.class);
                i.putExtra(getResources().getString(R.string.doc_key), selectedDocType);
                startActivity(i);*/
                Intent i = new Intent(SelectDocumentActivity.this, StartScanningActivity.class);
                i.putExtra(getResources().getString(R.string.doc_key), selectedDocType);
                startActivity(i);
            }

//            finish();
            overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
        }
    }

    private void initView() {

        setTexViewTextSize();
        if (OtherConstant.getInstance().getAppName().equalsIgnoreCase(getString(R.string.default_name))) {
//            NashidSDK.getInstance().getRegisterToken()="ajkks";
            if (!isInternetAvailable()) {
                ErrorUtility.getInstance().showNoInternetDialog(this, (!this.isFinishing() && !this.isDestroyed()));
            }
            docArray = getResources().getStringArray(R.array.docTypes);
            ArrayAdapter aa = new ArrayAdapter(this, android.R.layout.simple_spinner_item, docArray);
            aa.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
            binding.docDropdown.setAdapter(aa);

            try {
                SVG setting = SVG.getFromResource(getResources(), R.raw.img_setting);
                binding.imgSetting.setSVG(setting);
                SVG svg = SVG.getFromResource(getResources(), R.raw.name_icon);
                binding.icon.setSVG(svg);
                SVG one = SVG.getFromResource(getResources(), R.raw.dropbox);
                binding.dropbox.setSVG(one);
                SVG two = SVG.getFromResource(getResources(), R.raw.dropbox);
                binding.dropbox2.setSVG(two);
                SVG three = SVG.getFromResource(getResources(), R.raw.dropbox);
                binding.dropbox3.setSVG(three);
            } catch (Exception e) {
                e.printStackTrace();
            }
            try {
                loadAllIcon();
            } catch (SVGParseException e) {

            }
        }
//        compareTwoFaces();

//        try{
//            String filename="Logcat.txt";
//            File outputFile=new File(getExternalCacheDir(),filename);
//            Log.d("TAG", "initView: "+outputFile.getAbsolutePath()+"   "+outputFile.exists());
//            Runtime.getRuntime().exec("logcat -f "+"/storage/emulated/0/"+"Logging.txt");
//        }catch (Exception e){
//            Log.d("TAG", "initView: "+e.toString());
//        }

    }


    private void loadAllIcon() throws SVGParseException {

        SVG current_country = SVG.getFromResource(getResources(), R.raw.oman_flag);
        binding.imgCurrentCountry.setSVG(current_country);

        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(getApplicationContext(), RecyclerView.VERTICAL, false);
        binding.recyclerDocType.setLayoutManager(linearLayoutManager);
        DocumentTypeListAdapter documentTypeListAdapter = new DocumentTypeListAdapter(getBaseContext(), getResources().getStringArray(R.array.docTypes));
        binding.recyclerDocType.setAdapter(documentTypeListAdapter);
        documentTypeListAdapter.setListner(docType -> {
//                binding.btnContinue.setVisibility(View.VISIBLE);
            Log.d("TAG", "onDocumentItemClick: " + docType + "   " + getString(R.string.e_passport));
            selectedDocType = docType;
            if (selectedDocType.equalsIgnoreCase(getString(R.string.e_passport)) || selectedDocType.equalsIgnoreCase(getString(R.string.id_card))) {
                PermissionHelper.INSTANCE.requestPermissions(SelectDocumentActivity.this, new PermissionHelper.PermissionCallback() {
                    @Override
                    public void onResult(boolean allGranted, @NonNull List<String> grantedList, @NonNull List<String> deniedList) {
                        if (allGranted) {
                            openScanDocumentScreen();
                        } else {

                            Toast.makeText(getApplicationContext(), "These permissions are denied: $deniedList", Toast.LENGTH_LONG).show();
                        }
                    }
                });
            } else {
                Toast.makeText(getApplicationContext(), "Please select document either idcard or passport", Toast.LENGTH_SHORT).show();
            }
        });
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions,
                                           @NonNull int[] grantResults) {

        if (requestCode == REQUEST_CODE_ASK_PERMISSIONS) {
            if (grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                openScanDocumentScreen();
            } else {

                if (ContextCompat.checkSelfPermission(this, Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
                    ActivityCompat.requestPermissions(SelectDocumentActivity.this,
                            arr, REQUEST_CODE_ASK_PERMISSIONS);
                }
            }

        }

        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
        selectedDocType = docArray[position];
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {

    }


    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
//        Log.d("TAG", "onConfigurationChanged: " + newConfig.locale);
    }

    final int[] checkedItem = {0};

    private void openSelectLanguageDialog() {

        // AlertDialog builder instance to build the alert dialog
        AlertDialog.Builder alertDialog = new AlertDialog.Builder(SelectDocumentActivity.this);

        // title of the alert dialog
        alertDialog.setTitle("Language");

        // list of the items to be displayed to the user in the
        // form of list so that user can select the item from
        final String[] listItems = new String[]{"English", "Arabic"};
        if (getStorage().getPreferredLocale().equalsIgnoreCase("en") ||
                getStorage().getPreferredLocale().equalsIgnoreCase(LocaleUtil.OPTION_PHONE_LANGUAGE)) {
            checkedItem[0] = 0;
        } else {
            NashidSDK.getInstance().updateLocale(SelectDocumentActivity.this, "en");
//                    updateLocale("en");
            checkedItem[0] = 1;
        }

//        Log.d("TAG", "openSelectLanguageDialog: " + checkedItem[0]);
        // the function setSingleChoiceItems is the function which
        // builds the alert dialog with the single item selection
        alertDialog.setSingleChoiceItems(listItems, checkedItem[0], (dialog, which) -> {
            // update the selected item which is selected by the user so that it should be selected
            // when user opens the dialog next time and pass the instance to setSingleChoiceItems method
            checkedItem[0] = which;

//            Log.d("TAG", "openSelectLanguageDialog: " + which);
            if (which == 1) {
                NashidSDK.getInstance().updateLocale(SelectDocumentActivity.this, "ar");
            } else {
                NashidSDK.getInstance().updateLocale(SelectDocumentActivity.this, "en");
            }
//            if (getStorage().getPreferredLocale().equalsIgnoreCase("en") ||
//                    getStorage().getPreferredLocale().equalsIgnoreCase(LocaleUtil.OPTION_PHONE_LANGUAGE)) {
//
//            } else {
//                NashidSDK.getInstance().updateLocale(getApplicationContext(), "en");
////                    updateLocale("en");
//            }
            SelectDocumentActivity.this.recreate();
            dialog.dismiss();

        });

        // set the negative button if the user is not interested to select or change already selected item
        alertDialog.setNegativeButton("Cancel", (dialog, which) -> {

        });

        // create and build the AlertDialog instance with the AlertDialog builder instance
        AlertDialog customAlertDialog = alertDialog.create();

        // show the alert dialog when the button is clicked
        customAlertDialog.show();
    }

}
