package nashid.verify.sdk.utility;

import android.content.Context;
import android.graphics.Bitmap;

import nashid.verify.sdk.R;

public class ImageBrightnessDetector {

    // Function to determine if the image is too dark or too light
    public static String isImageTooDarkOrTooLight(Context context,Bitmap bitmap) {
        // Calculate average pixel intensity
        double averageIntensity = calculateAverageIntensity(bitmap);

        // Set dynamic thresholds for darkness and brightness
        double darkThreshold = 50; // Adjust as needed
        double lightThreshold = 200; // Adjust as needed

        // Compare with dynamic thresholds
        if (averageIntensity < darkThreshold) {
//            Log.d("ImageBrightnessDetector", "isImageTooDarkOrToo: dark ");
            // Image is too dark
            return context.getString(R.string.image_light_dark);
        } else if (averageIntensity > lightThreshold) {
//            Log.d("ImageBrightnessDetector", "isImageTooDarkOrTooLight:light ");
            // Image is too light
            return context.getString(R.string.image_light_light);
        } else {
//            Log.d("ImageBrightnessDetector", "isImageTooDarkOrToo:normal ");
            // Image brightness is acceptable
            return context.getString(R.string.image_light_normal);
        }
    }

    // Function to calculate the average pixel intensity of the image
    private static double calculateAverageIntensity(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        long totalIntensity = 0;

        // Iterate through each pixel and sum up the intensity values
        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {
                int pixel = bitmap.getPixel(x, y);
                int intensity = (pixel >> 16) & 0xFF; // Extract the red component (assuming grayscale image)
                totalIntensity += intensity;
            }
        }

        // Calculate the average intensity
        return totalIntensity / (double) (width * height);
    }
}
