package nashid.verify.sdk.utility;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.nfc.NfcAdapter;
import android.nfc.NfcManager;
import android.provider.Settings;

import nashid.verify.sdk.R;

public class NFCDialogUtility {
    public interface DialogClickListner{
        void OnClickNegativeButton();
        void OnClickPositiveButton();
    }
    public void openEnableNFCDialog(Activity activity,DialogClickListner dialogClickListner) {
        AlertDialog.Builder builder = new AlertDialog.Builder(activity);

        builder.setTitle(activity.getResources().getString(R.string.error_error))
                .setMessage(activity.getResources().getString(R.string.error_nfc_is_disabled))
                .setCancelable(true)
                .setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {
                        if (dialogClickListner!=null){
                            dialogClickListner.OnClickNegativeButton();
                        }
                    }
                })
                .setPositiveButton("enable", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        if (dialogClickListner!=null){
                            dialogClickListner.OnClickPositiveButton();
                        }
                        Intent intent = new Intent(Settings.ACTION_NFC_SETTINGS);
                        activity.startActivity(intent);
                    }
                }).create();
        builder.show();
    }
    public void openNotSupportedNFCDialog(Activity activity,DialogClickListner dialogClickListner) {
        AlertDialog.Builder builder = new AlertDialog.Builder(activity);

        builder.setTitle(activity.getResources().getString(R.string.error_error))
                .setMessage(activity.getResources().getString(R.string.error_nfc_not_supported))
                .setCancelable(true)
                .setPositiveButton("Okay", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        if (dialogClickListner!=null){
                            dialogClickListner.OnClickPositiveButton();
                        }
                        Intent intent = new Intent(Settings.ACTION_NFC_SETTINGS);
                        activity.startActivity(intent);
                    }
                }).create();
        builder.show();
    }
    public int isNFCAvailable(Activity activity){
        NfcManager manager = (NfcManager) activity.getSystemService(Context.NFC_SERVICE);
        NfcAdapter adapter = manager.getDefaultAdapter();
        NFCDialogUtility dialogUtility=new NFCDialogUtility();
        if (adapter != null && adapter.isEnabled()) {
//            Log.d("TAG", "initView:available ");
            return 1;
            //Yes NFC available
        }else if(adapter != null && !adapter.isEnabled()){

//            Log.d("TAG", "initView:not enable ");
            return 0;
            //NFC is not enabled.Need to enable by the user.
        }else{
//            Log.d("TAG", "initView:not supported ");
            //NFC is not supported
            return 2;
        }
    }
}
