/*
 * Decompiled with CFR 0.152.
 */
package icc.tags;

import icc.ICCProfile;
import icc.tags.ICCCurveType;
import icc.tags.ICCCurveTypeReverse;
import icc.tags.ICCTextDescriptionType;
import icc.tags.ICCTextType;
import icc.tags.ICCXYZType;
import icc.tags.ICCXYZTypeReverse;

public abstract class ICCTag {
    private static final String sdwCprtSignature = "cprt";
    private static final String sdwDescSignature = "desc";
    private static final String sdwWtPtSignature = "wtpt";
    private static final String sdwBkPtSignature = "bkpt";
    private static final String sdwRXYZSignature = "rXYZ";
    private static final String sdwGXYZSignature = "gXYZ";
    private static final String sdwBXYZSignature = "bXYZ";
    private static final String sdwKXYZSignature = "kXYZ";
    private static final String sdwRTRCSignature = "rTRC";
    private static final String sdwGTRCSignature = "gTRC";
    private static final String sdwBTRCSignature = "bTRC";
    private static final String sdwKTRCSignature = "kTRC";
    private static final String sdwDmndSignature = "dmnd";
    private static final String sdwDmddSignature = "dmdd";
    private static final int kdwCprtSignature = ICCProfile.getInt("cprt".getBytes(), 0);
    private static final int kdwDescSignature = ICCProfile.getInt("desc".getBytes(), 0);
    private static final int kdwWtPtSignature = ICCProfile.getInt("wtpt".getBytes(), 0);
    private static final int kdwBkPtSignature = ICCProfile.getInt("bkpt".getBytes(), 0);
    private static final int kdwRXYZSignature = ICCProfile.getInt("rXYZ".getBytes(), 0);
    private static final int kdwGXYZSignature = ICCProfile.getInt("gXYZ".getBytes(), 0);
    private static final int kdwBXYZSignature = ICCProfile.getInt("bXYZ".getBytes(), 0);
    private static final int kdwKXYZSignature = ICCProfile.getInt("kXYZ".getBytes(), 0);
    private static final int kdwRTRCSignature = ICCProfile.getInt("rTRC".getBytes(), 0);
    private static final int kdwGTRCSignature = ICCProfile.getInt("gTRC".getBytes(), 0);
    private static final int kdwBTRCSignature = ICCProfile.getInt("bTRC".getBytes(), 0);
    private static final int kdwKTRCSignature = ICCProfile.getInt("kTRC".getBytes(), 0);
    private static final int kdwDmndSignature = ICCProfile.getInt("dmnd".getBytes(), 0);
    private static final int kdwDmddSignature = ICCProfile.getInt("dmdd".getBytes(), 0);
    private static final String sdwTextDescType = "desc";
    private static final String sdwTextType = "text";
    private static final String sdwCurveType = "curv";
    private static final String sdwCurveTypeReverse = "vruc";
    private static final String sdwXYZType = "XYZ ";
    private static final String sdwXYZTypeReverse = " ZYX";
    private static final int kdwTextDescType = ICCProfile.getInt("desc".getBytes(), 0);
    private static final int kdwTextType = ICCProfile.getInt("text".getBytes(), 0);
    private static final int kdwCurveType = ICCProfile.getInt("curv".getBytes(), 0);
    private static final int kdwCurveTypeReverse = ICCProfile.getInt("vruc".getBytes(), 0);
    private static final int kdwXYZType = ICCProfile.getInt("XYZ ".getBytes(), 0);
    private static final int kdwXYZTypeReverse = ICCProfile.getInt(" ZYX".getBytes(), 0);
    public final int signature;
    public final int type;
    public final byte[] data;
    public final int offset;
    public final int count;

    public static String typeString(int n) {
        if (n == kdwTextDescType) {
            return "desc";
        }
        if (n == kdwTextType) {
            return "desc";
        }
        if (n == kdwCurveType) {
            return sdwCurveType;
        }
        if (n == kdwCurveTypeReverse) {
            return sdwCurveTypeReverse;
        }
        if (n == kdwXYZType) {
            return sdwXYZType;
        }
        if (n == kdwXYZTypeReverse) {
            return sdwXYZTypeReverse;
        }
        return "bad tag type";
    }

    public static String signatureString(int n) {
        if (n == kdwCprtSignature) {
            return sdwCprtSignature;
        }
        if (n == kdwDescSignature) {
            return "desc";
        }
        if (n == kdwWtPtSignature) {
            return sdwWtPtSignature;
        }
        if (n == kdwBkPtSignature) {
            return sdwBkPtSignature;
        }
        if (n == kdwRXYZSignature) {
            return sdwRXYZSignature;
        }
        if (n == kdwGXYZSignature) {
            return sdwGXYZSignature;
        }
        if (n == kdwBXYZSignature) {
            return sdwBXYZSignature;
        }
        if (n == kdwRTRCSignature) {
            return sdwRTRCSignature;
        }
        if (n == kdwGTRCSignature) {
            return sdwGTRCSignature;
        }
        if (n == kdwBTRCSignature) {
            return sdwBTRCSignature;
        }
        if (n == kdwKTRCSignature) {
            return sdwKTRCSignature;
        }
        if (n == kdwDmndSignature) {
            return sdwDmndSignature;
        }
        if (n == kdwDmddSignature) {
            return sdwDmddSignature;
        }
        return "bad tag signature";
    }

    public static ICCTag createInstance(int n, byte[] byArray, int n2, int n3) {
        int n4 = ICCProfile.getInt(byArray, n2);
        if (n4 == kdwTextDescType) {
            return new ICCTextDescriptionType(n, byArray, n2, n3);
        }
        if (n4 == kdwTextType) {
            return new ICCTextType(n, byArray, n2, n3);
        }
        if (n4 == kdwXYZType) {
            return new ICCXYZType(n, byArray, n2, n3);
        }
        if (n4 == kdwXYZTypeReverse) {
            return new ICCXYZTypeReverse(n, byArray, n2, n3);
        }
        if (n4 == kdwCurveType) {
            return new ICCCurveType(n, byArray, n2, n3);
        }
        if (n4 == kdwCurveTypeReverse) {
            return new ICCCurveTypeReverse(n, byArray, n2, n3);
        }
        throw new IllegalArgumentException("bad tag type");
    }

    protected ICCTag(int n, byte[] byArray, int n2, int n3) {
        this.signature = n;
        this.data = byArray;
        this.offset = n2;
        this.count = n3;
        this.type = ICCProfile.getInt(byArray, n2);
    }

    public String toString() {
        return ICCTag.signatureString(this.signature) + ":" + ICCTag.typeString(this.type);
    }
}

