/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import nashid.verify.sdk.Logger;
import nashid.verify.sdk.R;
import nashid.verify.sdk.mrtd2.locale.Storage;
import nashid.verify.sdk.mrtd2.rooted.RootedCheck;

public class MyApplication
extends Application
implements Application.ActivityLifecycleCallbacks {
    private final Logger logger = Logger.withTag("MyApplication");
    public Storage storage;

    private String getPreferredLocale(Context context) {
        if (this.storage == null) {
            this.storage = new Storage(context);
        }
        return this.storage.getPreferredLocale();
    }

    public void onCreate() {
        super.onCreate();
        this.registerActivityLifecycleCallbacks(this);
    }

    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle bundle) {
        RootedCheck.getInstance().setFlag(activity);
        if (RootedCheck.getInstance().isRootedDevice(this.getApplicationContext())) {
            RootedCheck.getInstance().showRootedDeviceDialog(activity, this.getString(R.string.root_dialog), this.getString(R.string.root_desc), this.getString(R.string.root_btn));
        }
    }

    public void onActivityStarted(@NonNull Activity activity) {
    }

    public void onActivityResumed(@NonNull Activity activity) {
    }

    public void onActivityPaused(@NonNull Activity activity) {
    }

    public void onActivityStopped(@NonNull Activity activity) {
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle bundle) {
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }
}

