/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.io;

import java.io.IOException;
import java.io.InputStream;
import nashid.verify.sdk.id_card.jmrtd.io.InputStreamBuffer;

public class SplittableInputStream
extends InputStream {
    private final InputStreamBuffer inputStreamBuffer;
    private final InputStreamBuffer.SubInputStream carrier;

    public SplittableInputStream(InputStream inputStream, int length) {
        this.inputStreamBuffer = new InputStreamBuffer(inputStream, length);
        this.carrier = this.inputStreamBuffer.getInputStream();
    }

    public void updateFrom(SplittableInputStream other) {
        this.inputStreamBuffer.updateFrom(other.inputStreamBuffer);
    }

    public InputStream getInputStream(int position) {
        try {
            InputStreamBuffer.SubInputStream inputStream = this.inputStreamBuffer.getInputStream();
            for (long skippedBytes = 0L; skippedBytes < (long)position; skippedBytes += ((InputStream)inputStream).skip((long)position - skippedBytes)) {
            }
            return inputStream;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public int getPosition() {
        return this.carrier.getPosition();
    }

    @Override
    public int read() throws IOException {
        return this.carrier.read();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.carrier.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.carrier.available();
    }

    @Override
    public void close() throws IOException {
        this.carrier.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.carrier.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.carrier.reset();
    }

    @Override
    public boolean markSupported() {
        return this.carrier.markSupported();
    }

    public int getLength() {
        return this.inputStreamBuffer.getLength();
    }

    public int getBytesBuffered() {
        return this.inputStreamBuffer.getBytesBuffered();
    }
}

