/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.lds;

import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import nashid.verify.sdk.id_card.jmrtd.Util;
import nashid.verify.sdk.id_card.jmrtd.lds.SecurityInfo;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;

public class PACEDomainParameterInfo
extends SecurityInfo {
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private static final long serialVersionUID = -5851251908152594728L;
    public static final String ID_PRIME_FIELD = "1.2.840.10045.1.1";
    public static final String ID_EC_PUBLIC_KEY = "1.2.840.10045.2.1";
    public static final String ID_DH_PUBLIC_NUMBER = "1.2.840.10046.2.1";
    private final String oid;
    private final transient AlgorithmIdentifier domainParameter;
    private final BigInteger parameterId;

    public PACEDomainParameterInfo(String protocolOID, AlgorithmIdentifier domainParameter) {
        this(protocolOID, domainParameter, null);
    }

    public PACEDomainParameterInfo(String protocolOID, AlgorithmIdentifier domainParameter, BigInteger parameterId) {
        if (!PACEDomainParameterInfo.checkRequiredIdentifier(protocolOID)) {
            throw new IllegalArgumentException("Invalid protocol id: " + protocolOID);
        }
        this.oid = protocolOID;
        this.domainParameter = domainParameter;
        this.parameterId = parameterId;
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    @Override
    public String getProtocolOIDString() {
        return PACEDomainParameterInfo.toProtocolOIDString(this.oid);
    }

    public BigInteger getParameterId() {
        return this.parameterId;
    }

    public AlgorithmParameterSpec getParameters() {
        if (ID_DH_PUBLIC_NUMBER.equals(this.oid)) {
            throw new IllegalStateException("DH PACEDomainParameterInfo not yet implemented");
        }
        if (ID_EC_PUBLIC_KEY.equals(this.oid)) {
            return PACEDomainParameterInfo.toECParameterSpec(this.domainParameter);
        }
        throw new IllegalStateException("Unsupported PACEDomainParameterInfo type " + this.oid);
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new ASN1ObjectIdentifier(this.oid));
        vector.add((ASN1Encodable)this.domainParameter);
        if (this.parameterId != null) {
            vector.add((ASN1Encodable)new ASN1Integer(this.parameterId));
        }
        return new DLSequence(vector);
    }

    public String toString() {
        return "PACEDomainParameterInfo[protocol: " + PACEDomainParameterInfo.toProtocolOIDString(this.oid) + ", domainParameter: [algorithm: " + this.domainParameter.getAlgorithm().getId() + ", parameters: " + this.domainParameter.getParameters() + (this.parameterId == null ? "" : ", parameterId: " + this.parameterId) + "]";
    }

    public int hashCode() {
        return 111111111 + 7 * this.oid.hashCode() + 5 * this.domainParameter.hashCode() + 3 * (this.parameterId == null ? 333 : this.parameterId.hashCode());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!PACEDomainParameterInfo.class.equals(other.getClass())) {
            return false;
        }
        PACEDomainParameterInfo otherPACEDomainParameterInfo = (PACEDomainParameterInfo)other;
        return this.getDERObject().equals(otherPACEDomainParameterInfo.getDERObject());
    }

    public static boolean checkRequiredIdentifier(String oid) {
        return "0.4.0.127.0.7.2.2.4.1".equals(oid) || "0.4.0.127.0.7.2.2.4.2".equals(oid) || "0.4.0.127.0.7.2.2.4.3".equals(oid) || "0.4.0.127.0.7.2.2.4.4".equals(oid) || "0.4.0.127.0.7.2.2.4.6".equals(oid);
    }

    @Deprecated
    public static AlgorithmIdentifier toAlgorithmIdentifier(ECParameterSpec ecParameterSpec) {
        ArrayList<Object> paramSequenceList = new ArrayList<Object>();
        ASN1Integer versionObject = new ASN1Integer(BigInteger.ONE);
        paramSequenceList.add(versionObject);
        ASN1ObjectIdentifier fieldIdOID = new ASN1ObjectIdentifier(ID_PRIME_FIELD);
        EllipticCurve curve = ecParameterSpec.getCurve();
        ECFieldFp field = (ECFieldFp)curve.getField();
        ASN1Integer p = new ASN1Integer(field.getP());
        DLSequence fieldIdObject = new DLSequence(new ASN1Encodable[]{fieldIdOID, p});
        paramSequenceList.add(fieldIdObject);
        DEROctetString aObject = new DEROctetString(Util.i2os(curve.getA()));
        DEROctetString bObject = new DEROctetString(Util.i2os(curve.getB()));
        DLSequence curveObject = new DLSequence(new ASN1Encodable[]{aObject, bObject});
        paramSequenceList.add(curveObject);
        DEROctetString basePointObject = new DEROctetString(Util.ecPoint2OS(ecParameterSpec.getGenerator()));
        paramSequenceList.add(basePointObject);
        ASN1Integer orderObject = new ASN1Integer(ecParameterSpec.getOrder());
        paramSequenceList.add(orderObject);
        ASN1Integer coFactorObject = new ASN1Integer((long)ecParameterSpec.getCofactor());
        paramSequenceList.add(coFactorObject);
        ASN1Encodable[] paramSequenceArray = new ASN1Encodable[paramSequenceList.size()];
        paramSequenceList.toArray(paramSequenceArray);
        DLSequence paramSequence = new DLSequence(paramSequenceArray);
        return new AlgorithmIdentifier(new ASN1ObjectIdentifier(ID_EC_PUBLIC_KEY), (ASN1Encodable)paramSequence);
    }

    @Deprecated
    public static ECParameterSpec toECParameterSpec(AlgorithmIdentifier domainParameter) {
        ASN1Encodable parameters = domainParameter.getParameters();
        if (!(parameters instanceof ASN1Sequence)) {
            throw new IllegalArgumentException("Was expecting an ASN.1 sequence");
        }
        try {
            X962Parameters x962params = X962Parameters.getInstance((Object)parameters);
            if (x962params.isNamedCurve()) {
                ASN1ObjectIdentifier x96ParamsOID = (ASN1ObjectIdentifier)x962params.getParameters();
                X9ECParameters x9ECParams = X962NamedCurves.getByOID((ASN1ObjectIdentifier)x96ParamsOID);
                ECNamedCurveParameterSpec bcECNamedCurveParams = new ECNamedCurveParameterSpec(X962NamedCurves.getName((ASN1ObjectIdentifier)x96ParamsOID), x9ECParams.getCurve(), x9ECParams.getG(), x9ECParams.getN(), x9ECParams.getH(), x9ECParams.getSeed());
                return Util.toECNamedCurveSpec(bcECNamedCurveParams);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception", e);
        }
        if (((ASN1Sequence)parameters).size() < 5) {
            throw new IllegalArgumentException("Was expecting an ASN.1 sequence of length 5 or longer");
        }
        try {
            ASN1Integer versionObject = (ASN1Integer)((ASN1Sequence)parameters).getObjectAt(0);
            versionObject.getValue();
            ASN1Sequence fieldIdObject = (ASN1Sequence)((ASN1Sequence)parameters).getObjectAt(1);
            ((ASN1ObjectIdentifier)fieldIdObject.getObjectAt(0)).getId();
            BigInteger p = ((ASN1Integer)fieldIdObject.getObjectAt(1)).getPositiveValue();
            ASN1Sequence curveObject = (ASN1Sequence)((ASN1Sequence)parameters).getObjectAt(2);
            ASN1OctetString aObject = (ASN1OctetString)curveObject.getObjectAt(0);
            ASN1OctetString bObject = (ASN1OctetString)curveObject.getObjectAt(1);
            BigInteger a = Util.os2i(aObject.getOctets());
            BigInteger b = Util.os2i(bObject.getOctets());
            ASN1OctetString basePointObject = (ASN1OctetString)((ASN1Sequence)parameters).getObjectAt(3);
            ECPoint g = Util.os2ECPoint(basePointObject.getOctets());
            BigInteger x = g.getAffineX();
            BigInteger y = g.getAffineY();
            BigInteger lhs = y.pow(2).mod(p);
            BigInteger xPow3 = x.pow(3);
            BigInteger rhs = xPow3.add(a.multiply(x)).add(b).mod(p);
            EllipticCurve curve = new EllipticCurve(new ECFieldFp(p), a, b);
            ASN1Integer orderObject = (ASN1Integer)((ASN1Sequence)parameters).getObjectAt(4);
            BigInteger n = orderObject.getPositiveValue();
            if (((ASN1Sequence)parameters).size() <= 5) {
                return new ECParameterSpec(curve, g, n, 1);
            }
            ASN1Integer coFactorObject = (ASN1Integer)((ASN1Sequence)parameters).getObjectAt(5);
            BigInteger coFactor = coFactorObject.getValue();
            return new ECParameterSpec(curve, g, n, coFactor.intValue());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception", e);
            throw new IllegalArgumentException("Could not get EC parameters from explicit parameters");
        }
    }

    private static AlgorithmIdentifier toAlgorithmIdentifier(String protocolOID, ASN1Encodable parameters) {
        if ("0.4.0.127.0.7.2.2.4.1".equals(protocolOID) || "0.4.0.127.0.7.2.2.4.3".equals(protocolOID)) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier(ID_DH_PUBLIC_NUMBER), parameters);
        }
        if ("0.4.0.127.0.7.2.2.4.2".equals(protocolOID) || "0.4.0.127.0.7.2.2.4.4".equals(protocolOID) || "0.4.0.127.0.7.2.2.4.6".equals(protocolOID)) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier(ID_EC_PUBLIC_KEY), parameters);
        }
        throw new IllegalArgumentException("Cannot infer algorithm OID from protocol OID: " + protocolOID);
    }

    private static String toProtocolOIDString(String oid) {
        if ("0.4.0.127.0.7.2.2.4.1".equals(oid)) {
            return "id-PACE-DH-GM";
        }
        if ("0.4.0.127.0.7.2.2.4.2".equals(oid)) {
            return "id-PACE-ECDH-GM";
        }
        if ("0.4.0.127.0.7.2.2.4.3".equals(oid)) {
            return "id-PACE-DH-IM";
        }
        if ("0.4.0.127.0.7.2.2.4.4".equals(oid)) {
            return "id-PACE-ECDH-IM";
        }
        if ("0.4.0.127.0.7.2.2.4.6".equals(oid)) {
            return "id-PACE-ECDH-CAM";
        }
        return oid;
    }
}

