/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.lds.icao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nashid.verify.sdk.id_card.jmrtd.lds.DataGroup;
import nashid.verify.sdk.id_card.jmrtd.lds.icao.MRZInfo;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;

public class DG1File
extends DataGroup {
    private static final long serialVersionUID = 5091606125728809058L;
    private static final short MRZ_INFO_TAG = 24351;
    private MRZInfo mrzInfo;

    public DG1File(MRZInfo mrzInfo) {
        super(97);
        this.mrzInfo = mrzInfo;
    }

    public DG1File(InputStream inputStream) throws IOException {
        super(97, inputStream);
    }

    @Override
    protected void readContent(InputStream inputStream) throws IOException {
        TLVInputStream tlvIn = inputStream instanceof TLVInputStream ? (TLVInputStream)inputStream : new TLVInputStream(inputStream);
        tlvIn.skipToTag(24351);
        int length = tlvIn.readLength();
        this.mrzInfo = new MRZInfo((InputStream)tlvIn, length);
    }

    public MRZInfo getMRZInfo() {
        return this.mrzInfo;
    }

    @Override
    public String toString() {
        return "DG1File " + this.mrzInfo.toString().replaceAll("\n", "").trim();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        DG1File other = (DG1File)obj;
        return this.mrzInfo.equals(other.mrzInfo);
    }

    public int hashCode() {
        return 3 * this.mrzInfo.hashCode() + 57;
    }

    @Override
    protected void writeContent(OutputStream out) throws IOException {
        TLVOutputStream tlvOut = out instanceof TLVOutputStream ? (TLVOutputStream)out : new TLVOutputStream(out);
        tlvOut.writeTag(24351);
        byte[] value = this.mrzInfo.getEncoded();
        tlvOut.writeValue(value);
    }
}

