/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.id_card.jmrtd.protocol;

import java.io.Serializable;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public abstract class PACEMappingResult
implements Serializable {
    private static final long serialVersionUID = 2773111318950631118L;
    private final transient AlgorithmParameterSpec staticParameters;
    private final transient AlgorithmParameterSpec ephemeralParameters;
    private byte[] piccNonce;

    public PACEMappingResult(AlgorithmParameterSpec staticParameters, byte[] piccNonce, AlgorithmParameterSpec ephemeralParameters) {
        this.staticParameters = staticParameters;
        this.ephemeralParameters = ephemeralParameters;
        this.piccNonce = null;
        if (piccNonce != null) {
            this.piccNonce = new byte[piccNonce.length];
            System.arraycopy(piccNonce, 0, this.piccNonce, 0, piccNonce.length);
        }
    }

    public AlgorithmParameterSpec getStaticParameters() {
        return this.staticParameters;
    }

    public AlgorithmParameterSpec getEphemeralParameters() {
        return this.ephemeralParameters;
    }

    public byte[] getPICCNonce() {
        return this.piccNonce;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.ephemeralParameters == null ? 0 : this.ephemeralParameters.hashCode());
        result2 = 31 * result2 + Arrays.hashCode(this.piccNonce);
        result2 = 31 * result2 + (this.staticParameters == null ? 0 : this.staticParameters.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PACEMappingResult other = (PACEMappingResult)obj;
        if (this.ephemeralParameters == null ? other.ephemeralParameters != null : !this.ephemeralParameters.equals(other.ephemeralParameters)) {
            return false;
        }
        if (!Arrays.equals(this.piccNonce, other.piccNonce)) {
            return false;
        }
        if (this.staticParameters == null) {
            return other.staticParameters == null;
        }
        return this.staticParameters.equals(other.staticParameters);
    }
}

