/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.mrtd2.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import nashid.verify.sdk.OtherConstant;
import nashid.verify.sdk.R;
import nashid.verify.sdk.databinding.ActivityInstructionBinding;
import nashid.verify.sdk.mrtd2.activity.BaseActivity;
import nashid.verify.sdk.mrtd2.activity.SDKSettingScreen;
import nashid.verify.sdk.mrtd2.activity.StartScanningActivity;
import nashid.verify.sdk.mrtd2.activity.TextSizeConverter;
import nashid.verify.sdk.mrtd2.rooted.RootedCheck;

public class InstructionScreenActivity
extends BaseActivity {
    private ActivityInstructionBinding helpBinding;
    private String selectedDocType;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.helpBinding = ActivityInstructionBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.helpBinding.getRoot());
        RootedCheck.getInstance().setFlag((Activity)this);
        if (RootedCheck.getInstance().isRootedDevice(this.getApplicationContext())) {
            RootedCheck.getInstance().showRootedDeviceDialog((Activity)this, this.getString(R.string.root_dialog), this.getString(R.string.root_desc), this.getString(R.string.root_btn));
        } else {
            this.intView();
            this.initClick();
        }
    }

    private void initClick() {
        this.helpBinding.layoutHeader.imgBack.setOnClickListener(view -> this.onBackPressed());
        this.helpBinding.btnNext.setOnClickListener(view -> {
            Intent i = new Intent((Context)this, StartScanningActivity.class);
            i.putExtra(this.getResources().getString(R.string.doc_key), this.selectedDocType);
            this.startActivity(i);
            this.finish();
            this.overridePendingTransition(0x10A0000, 0x10A0001);
        });
        this.helpBinding.imgSetting.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent i = new Intent((Context)InstructionScreenActivity.this, SDKSettingScreen.class);
                InstructionScreenActivity.this.startActivity(i);
                InstructionScreenActivity.this.overridePendingTransition(0x10A0000, 0x10A0001);
            }
        });
    }

    private void intView() {
        if (this.getIntent().hasExtra(this.getResources().getString(R.string.doc_key))) {
            this.selectedDocType = this.getIntent().getStringExtra(this.getResources().getString(R.string.doc_key));
        }
        try {
            SVG back = SVG.getFromResource((Resources)this.getResources(), (int)R.raw.back);
            this.helpBinding.layoutHeader.imgBack.setSVG(back);
            SVG svg1 = SVG.getFromResource((Resources)this.getResources(), (int)R.raw.step1);
            this.helpBinding.imgStep1.setSVG(svg1);
            SVG svg2 = SVG.getFromResource((Resources)this.getResources(), (int)R.raw.step2);
            this.helpBinding.imagStep2.setSVG(svg2);
            SVG svg3 = SVG.getFromResource((Resources)this.getResources(), (int)R.raw.step3);
            this.helpBinding.imgStep3.setSVG(svg3);
        }
        catch (SVGParseException sVGParseException) {
            // empty catch block
        }
        this.setLayoutAndTextSize();
        Log.d((String)"TAG", (String)("intView: " + OtherConstant.getInstance().getNeedToShowSettingScreen()));
        if (OtherConstant.getInstance().getNeedToShowSettingScreen()) {
            this.helpBinding.imgSetting.setVisibility(0);
        } else {
            this.helpBinding.imgSetting.setVisibility(8);
        }
    }

    private void setLayoutAndTextSize() {
        if (this.getStorage().getPreferredLocale().equalsIgnoreCase("ar")) {
            this.helpBinding.layoutHeader.imgBack.setRotation(180.0f);
        }
        TextSizeConverter textSizeConverter = new TextSizeConverter(this.getApplicationContext());
        textSizeConverter.changeStatusBarColor((Activity)this);
        int padding = textSizeConverter.getPaddingORMarginValue(16);
        this.helpBinding.lytInstructionMain.setPadding(padding, padding, padding, padding);
        padding = textSizeConverter.getPaddingORMarginValue(4);
        this.helpBinding.imgStep1.setPadding(padding, padding, padding, padding);
        this.helpBinding.imagStep2.setPadding(padding, padding, padding, padding);
        this.helpBinding.imgStep3.setPadding(padding, padding, padding, padding);
        LinearLayout.LayoutParams layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(4), 0, 0);
        this.helpBinding.layoutHeader.lytHeaderMain.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        ViewGroup.LayoutParams layoutParams2 = this.helpBinding.layoutHeader.imgBack.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        this.helpBinding.layoutHeader.imgBack.setLayoutParams(layoutParams2);
        layoutParams2 = this.helpBinding.imgSetting.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        this.helpBinding.imgSetting.setLayoutParams(layoutParams2);
        this.helpBinding.layoutHeader.txtHelp.setText((CharSequence)this.getString(R.string.instruction));
        this.helpBinding.layoutHeader.txtHelp.setTextSize(0, textSizeConverter.getTextSize(17));
        LinearLayout.LayoutParams marginLyoutParam = (LinearLayout.LayoutParams)this.helpBinding.nestedScrollview.getLayoutParams();
        marginLyoutParam.setMargins(0, textSizeConverter.getPaddingORMarginValue(44), 0, 0);
        this.helpBinding.nestedScrollview.setLayoutParams((ViewGroup.LayoutParams)marginLyoutParam);
        ViewGroup.LayoutParams imageLayoutParams = this.helpBinding.imgLytStep1.getLayoutParams();
        imageLayoutParams.width = textSizeConverter.getWidth(80);
        imageLayoutParams.height = textSizeConverter.getHeight(80);
        this.helpBinding.imgLytStep1.setLayoutParams(imageLayoutParams);
        this.helpBinding.imgLytStep1.setRadius((float)textSizeConverter.calculateRadius(7));
        imageLayoutParams = this.helpBinding.imgLytStep2.getLayoutParams();
        imageLayoutParams.width = textSizeConverter.getWidth(80);
        imageLayoutParams.height = textSizeConverter.getHeight(80);
        this.helpBinding.imgLytStep2.setLayoutParams(imageLayoutParams);
        this.helpBinding.imgLytStep2.setRadius((float)textSizeConverter.calculateRadius(7));
        imageLayoutParams = this.helpBinding.imgLytStep3.getLayoutParams();
        imageLayoutParams.width = textSizeConverter.getWidth(80);
        imageLayoutParams.height = textSizeConverter.getHeight(80);
        this.helpBinding.imgLytStep3.setLayoutParams(imageLayoutParams);
        this.helpBinding.imgLytStep3.setRadius((float)textSizeConverter.calculateRadius(7));
        marginLyoutParam = (LinearLayout.LayoutParams)this.helpBinding.lyouStep2.getLayoutParams();
        marginLyoutParam.setMargins(0, textSizeConverter.getPaddingORMarginValue(20), 0, 0);
        this.helpBinding.lyouStep2.setLayoutParams((ViewGroup.LayoutParams)marginLyoutParam);
        marginLyoutParam = (LinearLayout.LayoutParams)this.helpBinding.lyouStep3.getLayoutParams();
        marginLyoutParam.setMargins(0, textSizeConverter.getPaddingORMarginValue(20), 0, 0);
        this.helpBinding.lyouStep3.setLayoutParams((ViewGroup.LayoutParams)marginLyoutParam);
        marginLyoutParam = (LinearLayout.LayoutParams)this.helpBinding.lytTxtStep1.getLayoutParams();
        marginLyoutParam.setMargins(textSizeConverter.getPaddingORMarginValue(16), 0, textSizeConverter.getPaddingORMarginValue(16), 0);
        this.helpBinding.lytTxtStep1.setLayoutParams((ViewGroup.LayoutParams)marginLyoutParam);
        marginLyoutParam = (LinearLayout.LayoutParams)this.helpBinding.lytTxtStep2.getLayoutParams();
        marginLyoutParam.setMargins(textSizeConverter.getPaddingORMarginValue(16), 0, textSizeConverter.getPaddingORMarginValue(16), 0);
        this.helpBinding.lytTxtStep2.setLayoutParams((ViewGroup.LayoutParams)marginLyoutParam);
        marginLyoutParam = (LinearLayout.LayoutParams)this.helpBinding.lytTxtStep3.getLayoutParams();
        marginLyoutParam.setMargins(textSizeConverter.getPaddingORMarginValue(16), 0, textSizeConverter.getPaddingORMarginValue(16), 0);
        this.helpBinding.lytTxtStep3.setLayoutParams((ViewGroup.LayoutParams)marginLyoutParam);
        padding = textSizeConverter.getPaddingORMarginValue(12);
        this.helpBinding.txtBtnNext.setPadding(0, padding, 0, padding);
        this.helpBinding.btnNext.setRadius((float)textSizeConverter.calculateRadius(8));
        this.helpBinding.txtBtnNext.setTextSize(0, textSizeConverter.getTextSize(16));
        this.helpBinding.txtStep1.setTextSize(0, textSizeConverter.getTextSize(14));
        this.helpBinding.txtStep2.setTextSize(0, textSizeConverter.getTextSize(14));
        this.helpBinding.txtStep3.setTextSize(0, textSizeConverter.getTextSize(14));
        this.helpBinding.txtStep1Desc.setTextSize(0, textSizeConverter.getTextSize(16));
        this.helpBinding.txtStep2Desc.setTextSize(0, textSizeConverter.getTextSize(16));
        this.helpBinding.txtStep3Desc.setTextSize(0, textSizeConverter.getTextSize(16));
    }
}

