/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.mrtd2.activity;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import nashid.verify.sdk.R;

public class TextSizeConverter {
    private final Context context;
    private final float scale;

    public TextSizeConverter(Context context) {
        this.context = context;
        this.scale = context.getResources().getDisplayMetrics().scaledDensity;
    }

    public float pxToSp(float px) {
        return px / this.context.getResources().getDisplayMetrics().scaledDensity;
    }

    public float spToPx(float sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
    }

    public float convertPixelsToSp(float textSize) {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        return textSize / displayMetrics.scaledDensity;
    }

    public int getWidth(int width) {
        int desiredWidthInPixels = (int)((float)width * this.scale + 0.5f);
        return desiredWidthInPixels;
    }

    public int getHeight(int height) {
        int desiredHeightInPixels = (int)((float)height * this.scale + 0.5f);
        return desiredHeightInPixels;
    }

    public int getPaddingORMarginValue(int padding) {
        int desiredPaddingInPixels = (int)((float)padding * this.scale + 0.5f);
        return desiredPaddingInPixels;
    }

    public int calculateRadius(int radius) {
        int desiredRadiusInPixels = (int)((float)radius * this.scale + 0.5f);
        return desiredRadiusInPixels;
    }

    public LinearLayout.LayoutParams getLinearLayoutParam() {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        return layoutParams;
    }

    public LinearLayout.LayoutParams getMatchParentLinearLayoutParam() {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
        return layoutParams;
    }

    public FrameLayout.LayoutParams getCardLayoutParam() {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        return layoutParams;
    }

    public float getTextSize(int textSize) {
        int desiredTextSizeInPixels = (int)((float)textSize * this.scale + 0.5f);
        return desiredTextSizeInPixels;
    }

    public void changeStatusBarColor(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(activity.getResources().getColor(17170443));
        }
        if (Build.VERSION.SDK_INT >= 23) {
            View decorView = activity.getWindow().getDecorView();
            int flags = decorView.getSystemUiVisibility();
            decorView.setSystemUiVisibility(flags |= 0x2000);
        }
    }

    public void changeProgressStatusBarColor(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(activity.getResources().getColor(R.color.loader_back));
        }
        if (Build.VERSION.SDK_INT >= 23) {
            View decorView = activity.getWindow().getDecorView();
            int flags = decorView.getSystemUiVisibility();
            decorView.setSystemUiVisibility(flags |= 0x2000);
        }
    }
}

