/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.mrtd2.activity.passportNFC.jmrtd.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nashid.verify.sdk.mrtd2.activity.passportNFC.jmrtd.cert.KeyStoreCertStoreParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\n\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnashid/verify/sdk/mrtd2/activity/passportNFC/jmrtd/cert/KeyStoreCertStoreSpi;", "Ljava/security/cert/CertStoreSpi;", "params", "Ljava/security/cert/CertStoreParameters;", "(Ljava/security/cert/CertStoreParameters;)V", "keyStore", "Ljava/security/KeyStore;", "engineGetCRLs", "", "Ljava/security/cert/CRL;", "selector", "Ljava/security/cert/CRLSelector;", "engineGetCertificates", "Ljava/security/cert/Certificate;", "Ljava/security/cert/CertSelector;", "IDV_release"})
public final class KeyStoreCertStoreSpi
extends CertStoreSpi {
    @NotNull
    private final KeyStore keyStore;

    public KeyStoreCertStoreSpi(@NotNull CertStoreParameters params) throws InvalidAlgorithmParameterException {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        super(params);
        this.keyStore = ((KeyStoreCertStoreParameters)params).getKeyStore();
    }

    @NotNull
    public Collection<Certificate> engineGetCertificates(@NotNull CertSelector selector) throws CertStoreException {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        try {
            ArrayList<Certificate> certificates = new ArrayList<Certificate>(this.keyStore.size());
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate certificate;
                String alias;
                Intrinsics.checkNotNull((Object)aliases.nextElement(), (String)"null cannot be cast to non-null type kotlin.String");
                if (!this.keyStore.isCertificateEntry(alias) || !selector.match(certificate = this.keyStore.getCertificate(alias))) continue;
                certificates.add(certificate);
            }
            return certificates;
        }
        catch (KeyStoreException kse) {
            throw new CertStoreException(kse.getMessage());
        }
    }

    @NotNull
    public Collection<CRL> engineGetCRLs(@NotNull CRLSelector selector) throws CertStoreException {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        return new ArrayList(0);
    }
}

