/*
 * Decompiled with CFR 0.152.
 */
package nashid.verify.sdk.mrtd2.locale;

import android.content.Context;
import android.content.res.Configuration;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nashid.verify.sdk.utility.SharePreferenceUtility;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004J\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0004J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnashid/verify/sdk/mrtd2/locale/LocaleHelper;", "", "()V", "PREF_LOCALE", "", "getDefaultLocale", "Ljava/util/Locale;", "getPersistedLocale", "context", "Landroid/content/Context;", "onAttach", "persistLocale", "", "locale", "setLocale", "localeSpec", "updateResources", "IDV_release"})
public final class LocaleHelper {
    @NotNull
    public static final LocaleHelper INSTANCE = new LocaleHelper();
    @NotNull
    private static final String PREF_LOCALE = "pref_locale";

    private LocaleHelper() {
    }

    @NotNull
    public final Context onAttach(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String locale = this.getPersistedLocale(context);
        return this.setLocale(context, locale);
    }

    @NotNull
    public final String getPersistedLocale(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = SharePreferenceUtility.getLocalSavePreferenceData(context);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocalSavePreferenceData(...)");
        return string2;
    }

    @NotNull
    public final Context setLocale(@NotNull Context context, @NotNull String localeSpec) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)localeSpec, (String)"localeSpec");
        Locale locale = ((CharSequence)localeSpec).length() == 0 ? this.getDefaultLocale() : new Locale(localeSpec);
        Locale.setDefault(locale);
        return this.updateResources(context, locale);
    }

    private final Locale getDefaultLocale() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        return locale;
    }

    private final Context updateResources(Context context, Locale locale) {
        Configuration configuration = context.getResources().getConfiguration();
        configuration.setLocale(locale);
        Context context2 = context.createConfigurationContext(configuration);
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"createConfigurationContext(...)");
        return context2;
    }

    public final void persistLocale(@NotNull Context context, @NotNull String locale) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        SharePreferenceUtility.saveLocalPreferenceValue(context, locale);
    }
}

